/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H


#include <QMainWindow>
#include <QApplication>
#include <QSettings>
#include <QMenuBar>
#include <QStatusBar>
#include <QSystemTrayIcon>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QToolBox>
#include <QTabWidget>
#include <QLabel>
#include <QCloseEvent>
#include <QByteArray>
#include <QPixmap>
#include <QMessageBox>
#include <QDir>
#include <QTimer>
#include <QScrollArea>
#include <QScrollBar>
#include <QVariantList>
#include <QDesktopServices>
#if QT_VERSION >= QT_VERSION_CHECK(5, 0, 0)
#include <QStandardPaths>
#endif
#include <QTime>
#include <QSplitter>
#include <QPainter>

#include <QDebug>

#include "accountdialog.h"
#include "configdialog.h"
#include "pumpcontroller.h"
#include "notifications.h"
#include "publisher.h"
#include "timeline.h"
#include "post.h"
#include "contactlist.h"
#include "minorfeed.h"
#include "profileeditor.h"


class MainWindow : public QMainWindow
{
    Q_OBJECT


public:    
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

    void prepareDataDirectory();
    void createMenus();
    void createTrayIcon();
    void setTrayIconPixmap(int count = 0);

    void loadSettings();
    void saveSettings();


public slots:
    void updateUserID(QString newUserID);
    void updateSettings(int newUpdateInterval,
                        int newPostsPerPage,
                        int newTabsPosition,
                        bool newTabsMovable,
                        int newPublisherType,
                        bool newPublicPosts,
                        int newShowNotifications);

    void trayControl(QSystemTrayIcon::ActivationReason reason);
    void showTrayFallbackMessage(QString message);

    void updateProfileData(QString avatarURL, QString fullName,
                           QString hometown, QString bio);

    void updateAllTimelines();
    void updateMainDirectMinorTimelines();
    void updateMainActivityMinorTimelines();

    void scrollMainTimelineToTop();
    void scrollDirectTimelineToTop();
    void scrollActivityTimelineToTop();
    void scrollFavoritesTimelineToTop();
    void notifyTimelineUpdate(int timelineType, int newPostCount);
    void setTimelineTabTitle(int timelineType, int newPostCount);

    void setTitleAndTrayInfo(int currentTab);

    void storeAvatar(QByteArray avatarData, QUrl avatarURL);
    void storeImage(QByteArray imageData, QUrl imageURL);

    void setStatusBarMessage(QString message);


    void toggleSidePanel(bool shown);
    void toggleStatusBar(bool shown);


    void visitWebSite();
    void aboutDianara();
    void quitProgram();


protected:
    virtual void closeEvent(QCloseEvent *event);


private:
    // Menus
    QMenu *sessionMenu;
    QMenu *viewMenu;
    QMenu *settingsMenu;
    QMenu *helpMenu;

    QMenu *trayContextMenu;

    QAction *sessionUpdateMainTimeline;
    QAction *sessionUpdateDirectTimeline;
    QAction *sessionUpdateActivityTimeline;
    QAction *sessionUpdateFavoritesTimeline;
    QAction *sessionUpdateMinorFeed;
    QAction *sessionUpdateAllTimelines;
    QAction *sessionPostNote;
    QAction *sessionQuit;

    QAction *viewSidePanel;
    QAction *viewStatusBar;

    QAction *settingsEditProfile;
    QAction *settingsAccount;
    QAction *settingsConfigure;

    QAction *helpVisitWebsite;
    QAction *helpAbout;


    QSplitter *mainSplitter;

    QWidget *leftSideWidget;
    QVBoxLayout *leftLayout;
    QToolBox *leftPanel;

    QWidget *rightSideWidget;
    QVBoxLayout *rightLayout;
    QTabWidget *tabWidget;
    int tabsPosition;
    bool tabsMovable;

    QLabel *avatarIconLabel;
    QString avatarURL;
    QLabel *fullNameLabel;
    QLabel *userIdLabel;
    QLabel *userHometownLabel;


    QSystemTrayIcon *trayIcon;
    bool trayIconAvailable;



    AccountDialog *accountDialog;
    ProfileEditor *profileEditor;
    ConfigDialog *configDialog;
    PumpController *pumpController;
    FDNotifications *fdNotifier;

    MinorFeed *meanwhileFeed;

    int postsPerPage;
    TimeLine *mainTimeline;
    QScrollArea *mainTimelineScrollArea;

    TimeLine *directTimeline;
    QScrollArea *directTimelineScrollArea;

    TimeLine *activityTimeline;
    QScrollArea *activityTimelineScrollArea;

    TimeLine *favoritesTimeline;
    QScrollArea *favoritesTimelineScrollArea;


    ContactList *contactList;

    Publisher *publisher;
    int publisherType;


    bool firstRun;
    QString dataDirectory; // will have /images and /avatars
    bool reallyQuitProgram;

    int updateInterval;
    QTimer *updateTimer;

    bool publicPosts;

    int showNotifications;

    // user account-related data
    QString userID;


};

#endif // MAINWINDOW_H
