/*
 * Unit tests for DiaCanvasItem.
 */
#include <gtk/gtk.h>

#define TEST_INITIALIZATION gtk_init (&argc, &argv)

#include "unit-test.h"
#include "test-item.c"
#include <diacanvas/dia-canvas-view.h>
#include <diacanvas/dia-handle-layer.h>


DiaCanvas *canvas = NULL;
void
setup (void)
{
	canvas = dia_canvas_new ();
}

void
teardown (void)
{
	if (canvas)
		g_object_unref (canvas);
	canvas = NULL;
}

TEST_BEGIN (DiaCanvasView, setup, teardown)


TEST_NEW (dia_canvas_view_new)
{
	DiaCanvasView *view = NULL;

	view = (DiaCanvasView*) dia_canvas_view_new (canvas, 1);
	TEST (view->canvas == canvas);
	TEST (G_OBJECT (view)->ref_count == 1);
	TEST (G_OBJECT (canvas)->ref_count == 2);
	TEST (view->root_item->item == canvas->root);
	TEST (view->tool == NULL);
	TEST (DIA_IS_HANDLE_LAYER (view->handle_layer));
	TEST (g_list_length (GNOME_CANVAS_GROUP (GNOME_CANVAS (view)->root)->item_list) == 2);
	TEST (view->focus_item == NULL);
	TEST (view->selected_items == NULL);

	g_object_unref (view);
	TEST (G_OBJECT (canvas)->ref_count == 1);
}

TEST_NEW (add_item_before_creation)
{
	DiaCanvasView *view = NULL;
	DiaCanvasViewItem *vti1 = NULL, *vti2 = NULL;
	DiaCanvasItem *ti1 = NULL, *ti2 = NULL;

	ti1 = dia_canvas_item_create (TYPE_TEST_ITEM, "parent", canvas->root, NULL);
	ti2 = dia_canvas_item_create (TYPE_TEST_ITEM, "parent", ti1, NULL);
	
	view = (DiaCanvasView*) dia_canvas_view_new (canvas, 1);
	/* canvas->root->ti1 */
	TEST (g_list_length (GNOME_CANVAS_GROUP (view->root_item)->item_list) == 1);

	vti1 = GNOME_CANVAS_GROUP (view->root_item)->item_list->data;
	TEST (vti1->item == ti1);
	/* canvas->root->ti1->ti2 */
	TEST (g_list_length (GNOME_CANVAS_GROUP (vti1)->item_list) == 1);
	vti2 = GNOME_CANVAS_GROUP (vti1)->item_list->data;
	TEST (vti2->item == ti2);

	g_object_unref (view);
}

TEST_NEW (add_item_after_creation)
{
	DiaCanvasView *view = NULL;
	DiaCanvasViewItem *vti1 = NULL, *vti2 = NULL;
	DiaCanvasItem *ti1 = NULL, *ti2 = NULL;

	view = (DiaCanvasView*) dia_canvas_view_new (canvas, 1);

	ti1 = dia_canvas_item_create (TYPE_TEST_ITEM, "parent", canvas->root, NULL);
	ti2 = dia_canvas_item_create (TYPE_TEST_ITEM, "parent", ti1, NULL);
	
	/* canvas->root->ti1 */
	TEST (g_list_length (GNOME_CANVAS_GROUP (view->root_item)->item_list) == 1);

	vti1 = GNOME_CANVAS_GROUP (view->root_item)->item_list->data;
	TEST (vti1->item == ti1);
	/* canvas->root->ti1->ti2 */
	TEST (g_list_length (GNOME_CANVAS_GROUP (vti1)->item_list) == 1);
	vti2 = GNOME_CANVAS_GROUP (vti1)->item_list->data;
	TEST (vti2->item == ti2);
	gtk_object_sink (GTK_OBJECT (view));
}

TEST_NEW (DIA_COMPOSITE)
{
	DiaCanvasView *view = NULL;
	DiaCanvasViewItem *vti1 = NULL, *vti2 = NULL;
	DiaCanvasItem *ti1 = NULL, *ti2 = NULL;

	ti1 = dia_canvas_item_create (TYPE_TEST_ITEM, "parent", canvas->root, NULL);
	ti2 = dia_canvas_item_create (TYPE_TEST_ITEM, "parent", ti1, NULL);
	DIA_CANVAS_ITEM_FLAGS (ti2) |= DIA_COMPOSITE;

	view = (DiaCanvasView*) dia_canvas_view_new (canvas, 1);
	/* canvas->root->ti1 */
	vti1 = GNOME_CANVAS_GROUP (view->root_item)->item_list->data;
	TEST (vti1->item == ti1);
	/* canvas->root->ti1->ti2 */
	vti2 = GNOME_CANVAS_GROUP (vti1)->item_list->data;
	TEST (vti2->item == ti2);

	dia_canvas_view_select (view, vti2);
	TEST (view->focus_item == NULL);
	TEST (g_list_length (view->selected_items) == 1);
	TEST (DIA_CANVAS_VIEW_ITEM_SELECT (vti1));
	TEST (DIA_CANVAS_VIEW_ITEM_SELECT (vti2));
	/* vti2 is part of vti1 (composition), so only vti1 is selected. */
	TEST (g_list_index (view->selected_items, vti1) >= 0);
	TEST (g_list_index (view->selected_items, vti2) < 0);

	dia_canvas_view_unselect (view, vti2);
	TEST (view->focus_item == NULL);
	TEST (g_list_length (view->selected_items) == 0);

	dia_canvas_view_focus (view, vti2);
	TEST (view->focus_item == vti2);
	TEST (DIA_CANVAS_VIEW_ITEM_FOCUS (vti2));
	TEST (DIA_CANVAS_VIEW_ITEM_FOCUS (vti1));
	TEST (g_list_length (view->selected_items) == 1);
	TEST (DIA_CANVAS_VIEW_ITEM_SELECT (vti1));
	TEST (DIA_CANVAS_VIEW_ITEM_SELECT (vti2));
	/* owner of the composite object is selected instead. */
	TEST (g_list_index (view->selected_items, vti1) >= 0);
	TEST (g_list_index (view->selected_items, vti2) < 0);

	dia_canvas_view_focus (view, NULL);
	TEST (view->focus_item == NULL);
	TEST (!DIA_CANVAS_VIEW_ITEM_FOCUS (vti2));
	TEST (!DIA_CANVAS_VIEW_ITEM_FOCUS (vti1));
	TEST (g_list_length (view->selected_items) == 1);
	TEST (DIA_CANVAS_VIEW_ITEM_SELECT (vti1));
	TEST (DIA_CANVAS_VIEW_ITEM_SELECT (vti2));
	TEST (g_list_index (view->selected_items, vti1) >= 0);
	TEST (g_list_index (view->selected_items, vti2) < 0);

	dia_canvas_view_unselect (view, vti2);
	TEST (view->focus_item == NULL);
	TEST (g_list_length (view->selected_items) == 0);

	gtk_object_sink (GTK_OBJECT (view));
}

TEST_NEW (moving_canvas_items)
{
	GtkWidget *view;
	DiaCanvasItem *item;
	DiaCanvasViewItem *view_item;

	view = dia_canvas_view_new (canvas, TRUE);
	item = dia_canvas_item_create (TYPE_TEST_ITEM, NULL);

	dia_canvas_groupable_add (DIA_CANVAS_GROUPABLE (canvas->root), item);

	view_item = dia_canvas_view_find_view_item (DIA_CANVAS_VIEW (view), item);

	dia_canvas_view_select (DIA_CANVAS_VIEW (view), view_item);
	dia_canvas_view_move (DIA_CANVAS_VIEW (view), 23, 42, view_item);

	TESTFL (item->affine[4], 0.0);
	TESTFL (item->affine[5], 0.0);

	view_item = dia_canvas_view_find_view_item (DIA_CANVAS_VIEW (view), item->parent);
	dia_canvas_view_move (DIA_CANVAS_VIEW (view), 23, 42, view_item);

	TESTFL (item->affine[4], 23.0);
	TESTFL (item->affine[5], 42.0);
}

TEST_END ();
