/* lyric.cpp
 *
 * Functions for the manipulations of lyrics
 *
 * for Denemo, a gtk+ frontend for GNU Lilypond
 * (c) 2002 Adam Tee
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <denemo/denemo.h>
#include "chordops.h"
#include "calculatepositions.h"
#include "commandfuncs.h"
#include "contexts.h"
#include "dialogs.h"
#include "draw.h"
#include "objops.h"
#include "staffops.h"
#include "utils.h"


mudelaobject *
newlyric (gint baseduration, gint numdots, gchar *lys)
{
  mudelaobject *thelyric = newchord(baseduration, numdots);
  ((chord*)thelyric->object)->lyric = g_string_new(lys);
  ((chord*)thelyric->object)->is_syllable = TRUE; /* FIXME */
  set_basic_numticks (thelyric);
  return thelyric;
}


struct callbackdata {
  struct scoreinfo * si;
  GtkWidget *entry;
  GtkWidget *extender;
  GtkWidget *center;
};

void insertlyric(GtkWidget *widget, gpointer data)
{
  struct callbackdata *cbdata = (struct callbackdata *)data;
  struct scoreinfo *si = (struct scoreinfo *) cbdata->si;
  mudelaobject *curObj = (mudelaobject *)(si->currentobject ? 
    si->currentobject->data : NULL);
  gchar *lyric = (gchar*)gtk_entry_get_text(GTK_ENTRY(cbdata->entry));
  if(curObj && curObj->type == CHORD) {
    if(!((chord *)curObj->object)->lyric)
      ((chord *)curObj->object)->lyric = g_string_new(lyric);
    else
      g_string_assign(((chord *)curObj->object)->lyric,lyric);

    ((chord *)curObj->object)->is_syllable = 
      gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cbdata->extender));
    ((chord *)curObj->object)->center_lyric = 
        gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cbdata->center));
  }

  si->haschanged = TRUE;
  gtk_widget_draw (si->scorearea, NULL);
}

void lyric_insert(gpointer callback_data, guint callback_action, 
    		  GtkWidget *widget)
{
  GtkWidget *dialog;
  GtkWidget *entry;
  GtkWidget *label;
  GtkWidget *extender;
  GtkWidget *center;
  GtkWidget *okbutton;
  GtkWidget *cancelbutton;
  
  static struct callbackdata cbdata;
  struct scoreinfo *si = (struct scoreinfo *)callback_data;
  mudelaobject *curObj = (mudelaobject *) 
    (si->currentobject ? si->currentobject->data : NULL);
  if (si->lily_file)
    return;/* no code for this yet - just edit textually */
  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), _("Insert Lyric"));
  

  label = gtk_label_new (_("Insert Lyric:"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), label,
	                        TRUE, TRUE, 0);
  gtk_widget_show (label);
	
  entry = gtk_entry_new();
  if(curObj && curObj->type == CHORD && ((chord *)curObj->object)->lyric)
    gtk_entry_set_text(GTK_ENTRY(entry),((chord *)curObj->object)->lyric->str);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), entry,
                                      TRUE, TRUE, 0);      
  gtk_widget_show (entry);

  label = gtk_label_new(_("Extend Syllable"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), label,
      TRUE, TRUE, 0);
  gtk_widget_show (label);
  
  extender = gtk_check_button_new();
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), extender,
      TRUE, TRUE, 0);
  gtk_widget_show (extender);

  label = gtk_label_new(_("Center"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), label,
		      TRUE, TRUE, 0);
  gtk_widget_show (label);
  
  center = gtk_check_button_new();
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), center,
		     TRUE, TRUE, 0);
  gtk_widget_show(center);

  okbutton = gtk_button_new_with_label (_("OK"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), okbutton,
		      TRUE, TRUE, 0);
  cbdata.si = si;
  cbdata.entry = entry;
  cbdata.extender = extender;
  cbdata.center = center;
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (insertlyric), &cbdata);
  gtk_signal_connect_object (GTK_OBJECT (okbutton), "clicked",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy),
			     GTK_OBJECT (dialog));
  gtk_widget_show (okbutton);
  
  cancelbutton = gtk_button_new_with_label (_("Cancel"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      cancelbutton, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancelbutton), "clicked",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy),
			     GTK_OBJECT (dialog));
  gtk_widget_show (cancelbutton);
  gtk_widget_grab_focus (entry);
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_widget_show (dialog);
  
}

	  
      
  
