/* drawlyric.cpp 
 *
 * function to display Lyrics on score
 * for Denemo, a gtk+ frontend to GNU Lilypond 
 * 
 * (c) 2002 Adam Tee <eenajt@leeds.ac.uk>
 */

#include "utils.h"
#include <denemo/denemo.h>
#include <string.h>

void draw_lyric(GdkPixmap *pixmap, GdkGC *gc, GdkFont *font,
    		gint xx, gint y, mudelaobject *theobj)
{
  static GdkFont *lyricfont = NULL;
  gchar *text=NULL;
  gint length = 0;
  if(theobj->type == LYRIC) {
    text = ((lyric *)theobj->object)->lyrics->str;
    length = ((lyric *)theobj->object)->lyrics->len;
  }else if(theobj->type == CHORD) {
    text = ((chord *)theobj->object)->lyric->str;
    length = ((chord *)theobj->object)->lyric->len;
  }
#ifdef DEBUG
  g_print("%s, %d\n", text, length);
#endif
  
  if(!lyricfont) {
    lyricfont = gdk_fontset_load
      ("-*-helvetica-medium-r-normal-*-12-*-*-*-*-*-iso8859-*");
    if (lyricfont)
      lyricfont = font;
  }
  gdk_draw_text(pixmap, lyricfont, gc, xx, y, text, length);

}
	  
   
