/* articulations.c
 * Implements articulation markings which are not notes 
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * A Tee  (c) 2000, 2001, 2002
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "chordops.h"
#include "calculatepositions.h"
#include "commandfuncs.h"
#include "contexts.h"
#include "dialogs.h"
#include "draw.h"
#include "objops.h"
#include "staffops.h"
#include "utils.h"
#include "articulations.h"


struct callbackdata
{
  struct scoreinfo *si;
  GtkWidget *combobox;
};

/**
 *  Three arrays of articulation types
 *  One general list and two instrument specific 
 *  lists
 *  TODO :  Brass and Woodwind Specific articulations
 */
static gchar *gen_articulations[10] =
  { "staccato", "staccatissimo", "marcato", "accent", "fermata",
  "tenuto", "turn", "reverse turn",
  "trill", "mordent"
};

static gchar *string_articulations[2] = { "up bow", "down bow" };

static gchar *organ_articulations[4] = { "rheel", "lheel", "ltoe", "rtoe" };

/**
 * Set Articulation Flag on the current chord
 */
static void
insert_artic (GtkWidget * widget, gpointer data)
{
  mudelaobject *mudelaobj;
  struct callbackdata *cbdata = (struct callbackdata *)data;
  struct scoreinfo *si = cbdata->si;
  gchar* articulationstring =
    (gchar*)gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (cbdata->combobox)->entry));

  mudelaobj = (mudelaobject *) 
    (si->currentobject ? si->currentobject->data : NULL);

  if (mudelaobj)
    set_articulation (articulationstring, mudelaobj);


  /*object_insert (si, dynamic_new (directivestring)); */
  gtk_widget_draw (si->scorearea, NULL);
}



/**
 *  Insert Articulation Insertion Dialog
 *  Displays the relevant articulation strings in a 
 *  combobox
 *
 *  Callback - insert_artic
 */
void
insert_articulation (gpointer callback_data, guint callback_action,
		     GtkWidget * widget)
{
  int i;
  struct scoreinfo *si = (struct scoreinfo *) callback_data;
  static struct callbackdata cbdata;
  GtkWidget *dialog;
  GtkWidget *combo;
  GtkWidget *okbutton;
  GtkWidget *cancelbutton;
  GtkWidget *label;
  GList *articulationlist = NULL;


  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), _("Insert Articulation"));


  label = gtk_label_new (_("Insert Articulation"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), label,
		      TRUE, TRUE, 0);
  gtk_widget_show (label);

  combo = gtk_combo_new ();
  if (callback_action == GENERAL)
    {

      if (!articulationlist)
	for (i = 0; i < 10; i++)
	  {
	    articulationlist = g_list_append (articulationlist,
					      gen_articulations[i]);
	  }
    }
  else if (callback_action == STRING)
    {
      if (!articulationlist)
	for (i = 0; i < 2; i++)
	  {
	    articulationlist = g_list_append (articulationlist,
					      string_articulations[i]);
	  }
    }
  else if (callback_action == ORGAN)
    {
      if (!articulationlist)
	for (i = 0; i < 4; i++)
	  {
	    articulationlist = g_list_append (articulationlist,
					      organ_articulations[i]);
	  }
    }
  gtk_combo_set_popdown_strings (GTK_COMBO (combo), articulationlist);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo)->entry), "");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), combo,
		      TRUE, TRUE, 0);
  gtk_widget_show (combo);



  okbutton = gtk_button_new_with_label (_("OK"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), okbutton,
		      TRUE, TRUE, 0);
  cbdata.si = si;
  cbdata.combobox = combo;
  processenter (GTK_COMBO (combo)->entry, insert_artic, cbdata, dialog);
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (insert_artic), &cbdata);
  gtk_signal_connect_object (GTK_OBJECT (okbutton), "clicked",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy), 
			     GTK_OBJECT (dialog));
  gtk_widget_show (okbutton);

  cancelbutton = gtk_button_new_with_label (_("Cancel"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
		      cancelbutton, TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (cancelbutton), "clicked",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy), 
			     GTK_OBJECT (dialog));
  gtk_widget_show (cancelbutton);
  gtk_widget_grab_focus (combo);
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_widget_show (dialog);
}

/**
 * Set the relevant articulation flag on the 
 * current mudelaobject.
 *
 */
int
set_articulation (gchar * string, mudelaobject * obj)
{
  if (obj->type == CHORD && ((chord *)obj->object)->tones)
    {
      if (!strcmp (string, "staccato"))
	((chord *)obj->object)->has_stacatto_p = 
	  !((chord *)obj->object)->has_stacatto_p;
      else if (!strcmp (string, "tenuto"))
	((chord *)obj->object)->has_tenuto_p = 
	  !((chord *)obj->object)->has_tenuto_p;
      else if (!strcmp (string, "staccatissimo"))
	((chord *)obj->object)->has_staccatissimo_p =
	  !((chord *)obj->object)->has_staccatissimo_p;
      else if (!strcmp (string, "accent"))
	((chord *)obj->object)->is_accented_p = 
	  !((chord *)obj->object)->is_accented_p;
      else if (!strcmp (string, "marcato"))
	((chord *)obj->object)->has_marcato_p = 
	  !((chord *)obj->object)->has_marcato_p;
      else if (!strcmp (string, "fermata"))
	((chord *)obj->object)->has_fermata_p = 
	  !((chord *)obj->object)->has_fermata_p;
      else if (!strcmp (string, "trill"))
	((chord *)obj->object)->has_trill_p = 
	  !((chord *)obj->object)->has_trill_p;
      else if (!strcmp (string, "turn"))
	((chord *)obj->object)->has_turn_p = 
	  !((chord *)obj->object)->has_turn_p;
      else if (!strcmp (string, "mordent"))
	((chord *)obj->object)->has_mordent_p = 
	  !((chord *)obj->object)->has_mordent_p;
      else if (!strcmp (string, "reverse turn"))
	((chord *)obj->object)->has_turn_p = 
	  !((chord *)obj->object)->has_turn_p;
      /* String specific articulations */
      else if (!strcmp (string, "up bow"))
	((chord *)obj->object)->has_ubow_p = 
	  !((chord *)obj->object)->has_ubow_p;
      else if (!strcmp (string, "down bow"))
	((chord *)obj->object)->has_dbow_p = 
	  !((chord *)obj->object)->has_dbow_p;
      /*organ articulations */
      else if (!strcmp (string, "rheel"))
	((chord *)obj->object)->has_rheel_p = 
	  !((chord *)obj->object)->has_rheel_p;
      else if (!strcmp (string, "lheel"))
	((chord *)obj->object)->has_lheel_p = 
	  !((chord *)obj->object)->has_lheel_p;
      else if (!strcmp (string, "rtoe"))
	((chord *)obj->object)->has_rtoe_p = 
	  !((chord *)obj->object)->has_rtoe_p;
      else if (!strcmp (string, "ltoe"))
	((chord *)obj->object)->has_ltoe_p = 
	  !((chord *)obj->object)->has_ltoe_p;
    }
  else
    return -1;

  return 0;
}
