// +build ignore

package main

import (
	"os"
	"strconv"
	"time"

	"github.com/go-delve/delve/cmd/dlv/cmds"
	"github.com/spf13/cobra/doc"
)

func main() {
	outputDir := os.Getenv("MAN_OUTPUT")
	header := &doc.GenManHeader{
		Manual:  "General Commands Manual",
		Section: "1",
	}
	// https://reproducible-builds.org/specs/source-date-epoch/
	sourceDateEpoch, err := strconv.ParseInt(os.Getenv("SOURCE_DATE_EPOCH"), 10, 64)
	if err == nil {
		date := time.Unix(sourceDateEpoch, 0)
		header.Date = &date
	}
	root := cmds.New(true)
	doc.GenManTree(root, header, outputDir)
	for _, cmd := range root.Commands() {
		if cmd.Run == nil {
			doc.GenManTree(cmd, header, outputDir)
		}
	}
}
