#!/usr/bin/python
#
# deluge.py
# Copyright (C) Zach Tibbitts 2006 <zach@collegegeek.org>
# Copyright (C) Alon Zakai    2006 <kripkensteiner@gmail.com>
# 
# Deluge is free software.
# 
# You may redistribute this file and/or modify it under the terms of the
# GNU General Public License, as published by the Free Software
# Foundation; either version 2 of the License, or (at your option)
# any later version.
# 
# This file is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this file.  If not, write to:
# 	The Free Software Foundation, Inc.,
# 	51 Franklin Street, Fifth Floor
# 	Boston, MA  02110-1301, USA.

# Popup Notifier plugin

class plugin_PopupNotifier:
	def __init__(self, parent, location):
#		print "PopupNotifierI being created now"
		self.parent = parent
		self.location = location

		try:
			import pynotify
			self.pynotify = pynotify # We must save this, because as a plugin, our globals will die
		except:
			dc.ShowPopupWarning(self. parent.window, _("PopupNotifier: not all necessary dependencies are installed. To install them, on Ubuntu run: apt-get python-notify notification-daemon"))
			return

		if not self.pynotify.init("Deluge"):
			dc.ShowPopupWarning(self. parent.window, _("PopupNotifier: Cannot initialize pynotify, no notifications will be shown."))

		self.severities = { "I": 1, "W": 2, "C": 3, "F": 4 }

		self.severityTexts = {
				self.severities["I"]: _("Informative - can be easily ignored"),
				self.severities["W"]: _("Warning - may be of interest"),
				self.severities["C"]: _("Critical - should never be ignored"),
				self.severities["F"]: _("Fatal - normal operation will probably not continue") }

		self.severityToUrgency = { "I": pynotify.URGENCY_LOW,
											"W": pynotify.URGENCY_NORMAL,
											"C": pynotify.URGENCY_NORMAL,
											"F": pynotify.URGENCY_CRITICAL }

		userSeverity = self.parent.preferences.get('plugin_popupnotifier_severity')
		if userSeverity is None:
			userSeverity = self.severities["W"]

		self.minSeverity = int(userSeverity)

		if self.minSeverity is None:
			self.minSeverity = self.severities['I']

		self.icon = "file://" + dc.get_icon("deluge-32.png")

		# Connect signal in the parent
		self.handlerID = self.parent.messageList.connect("insert-text", self.signal)

	def shutdown(self):
#		print "PopupNotifierI is shutting down now"
		self.parent.messageList.disconnect(self.handlerID)

	def update(self):
#		print "PopupNotifier Updating..."
		pass

	def signal(self, textbuffer, iter, text, length):
#		print "Signal occured, need to show: ", text
		severity = text[0]
		if self.severities[severity] >= self.minSeverity:
			startIndex = text.find("] ")+2
			note = self.pynotify.Notification("Deluge", text[startIndex:], self.icon)
			note.set_urgency(self.severityToUrgency[severity])
			if not note.show():
				debugmsg("Failed to send notification: " + text)

	def configure(self):
		dc.debugmsg("Showing popupnotifier config Dialog")
		self.gladefile = self.location + "/" + "PopupNotifierConfig.glade"
		self.wTree = gtk.glade.XML(self.gladefile, "PopupNotifierConfig")
		self.dlg = self.wTree.get_widget("PopupNotifierConfig")

		self.severitySelector   = self.wTree.get_widget("severity_selector")
		self.severitySelector.set_value(self.minSeverity)
		self.severitySelector.connect("change-value", self.dlgChangeValue)

		self.severityDescriptor = self.wTree.get_widget("severity_descriptor")
#		self.descriptorTextBuffer = gtk.TextBuffer()
#		self.severityDescriptor.set_buffer(self.descriptorTextBuffer)

		self.dlgShowText()

		# Show and run

		self.dlg.show_all()

		if self.dlg.run() == 1:
			self.minSeverity = int(self.severitySelector.get_value())
			self.parent.preferences.set('plugin_popupnotifier_severity', self.minSeverity)
			self.parent.preferences.save_to_file(dc.CONFIG_XML)
#		else:
#			print "Cancelled"

		self.dlg.destroy()

	def dlgChangeValue(self, range, scroll, value):
		self.severitySelector.set_value(round(value))
		self.dlgShowText()
		return True

	def dlgShowText(self):
		severity = int(self.severitySelector.get_value())
		self.severityDescriptor.set_text(self.severityTexts[severity])


### MAIN

PLUGINregister("Popup Notifier", plugin_PopupNotifier, True, True,
					"Popup Notifier plugin v0.1\n\nWritten by Kripkenstein")
