/* WidgetUtils.c generated by valac 0.12.0, the Vala compiler
 * generated from WidgetUtils.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008–2010 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <whacks.h>
#include <config.h>
#include <common.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))



void deja_dup_show_uri (GtkWindow* parent, const gchar* link);
void deja_dup_show_about (GObject* owner, GtkWindow* parent);
static void _lambda4_ (GtkDialog* dlg, gint resp);
static void __lambda4__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
gboolean deja_dup_init_duplicity (GtkWindow* parent);

const gchar* DEJA_DUP_authors[5] = {"Andrew Fister <temposs@gmail.com>", "Michael Terry <mike@mterry.name>", "Michael Vogt <michael.vogt@ubuntu.com>", "Urban Skudnik <urban.skudnik@gmail.com>", NULL};
const gchar* DEJA_DUP_artists[5] = {"Andreas Nilsson <nisses.mail@home.se>", "Jakub Steiner <jimmac@novell.com>", "Lapo Calamandrei <calamandrei@gmail.com>", "Michael Terry <mike@mterry.name>", NULL};
const gchar* DEJA_DUP_documenters[2] = {"Michael Terry <mike@mterry.name>", NULL};

static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void deja_dup_show_uri (GtkWindow* parent, const gchar* link) {
	GdkScreen* _tmp0_ = NULL;
	GdkScreen* _tmp1_;
	GdkScreen* screen;
	guint32 _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (parent != NULL);
	g_return_if_fail (link != NULL);
	_tmp0_ = gtk_window_get_screen (parent);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	screen = _tmp1_;
	_tmp2_ = gtk_get_current_event_time ();
	gtk_show_uri (screen, link, _tmp2_, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (screen);
		goto __catch5_g_error;
	}
	_g_object_unref0 (screen);
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		const gchar* _tmp3_ = NULL;
		GtkMessageDialog* _tmp4_ = NULL;
		GtkMessageDialog* dlg;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _ ("Could not display %s");
		_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new (parent, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp3_, link);
		dlg = g_object_ref_sink (_tmp4_);
		gtk_message_dialog_format_secondary_text (dlg, "%s", e->message, NULL);
		gtk_dialog_run ((GtkDialog*) dlg);
		hacks_widget_destroy ((GtkWidget*) dlg);
		_g_object_unref0 (dlg);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _lambda4_ (GtkDialog* dlg, gint resp) {
	gconstpointer _tmp0_ = NULL;
	GObject* _tmp1_;
	GObject* about_owner;
	g_return_if_fail (dlg != NULL);
	_tmp0_ = g_object_get_data ((GObject*) dlg, "owner");
	_tmp1_ = _g_object_ref0 (G_OBJECT ((GObject*) _tmp0_));
	about_owner = _tmp1_;
	g_object_set_data_full (about_owner, "about-dlg", NULL, NULL);
	hacks_widget_destroy ((GtkWidget*) dlg);
	_g_object_unref0 (about_owner);
}


static void __lambda4__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	_lambda4_ (_sender, response_id);
}


void deja_dup_show_about (GObject* owner, GtkWindow* parent) {
	gconstpointer _tmp0_ = NULL;
	GtkAboutDialog* _tmp1_;
	GtkAboutDialog* about;
	GtkAboutDialog* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GtkAboutDialog* _tmp10_;
	GObject* _tmp11_;
	g_return_if_fail (owner != NULL);
	_tmp0_ = g_object_get_data (owner, "about-dlg");
	_tmp1_ = _g_object_ref0 (GTK_ABOUT_DIALOG ((GtkAboutDialog*) _tmp0_));
	about = _tmp1_;
	if (about != NULL) {
		gtk_window_present ((GtkWindow*) about);
		_g_object_unref0 (about);
		return;
	}
	_tmp2_ = (GtkAboutDialog*) gtk_about_dialog_new ();
	_g_object_unref0 (about);
	about = g_object_ref_sink (_tmp2_);
	_tmp3_ = _ ("About Déjà Dup");
	gtk_window_set_title ((GtkWindow*) about, _tmp3_);
	gtk_about_dialog_set_authors (about, DEJA_DUP_authors);
	gtk_about_dialog_set_artists (about, DEJA_DUP_artists);
	gtk_about_dialog_set_documenters (about, DEJA_DUP_documenters);
	_tmp4_ = _ ("translator-credits");
	gtk_about_dialog_set_translator_credits (about, _tmp4_);
	gtk_about_dialog_set_logo_icon_name (about, PACKAGE);
	gtk_about_dialog_set_version (about, VERSION);
	gtk_about_dialog_set_website (about, "https://launchpad.net/deja-dup");
	_tmp5_ = _ ("This program is free software; you can redistribute it and/or modify i" \
"t under the terms of the GNU General Public License as published by th" \
"e Free Software Foundation; either version 3 of the License, or (at yo" \
"ur option) any later version.");
	_tmp6_ = _ ("This program is distributed in the hope that it will be useful, but WI" \
"THOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILI" \
"TY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public Li" \
"cense for more details.");
	_tmp7_ = _ ("You should have received a copy of the GNU General Public License alon" \
"g with this program.  If not, see http://www.gnu.org/licenses/.");
	_tmp8_ = g_strdup_printf ("%s\n\n%s\n\n%s", _tmp5_, _tmp6_, _tmp7_);
	_tmp9_ = _tmp8_;
	gtk_about_dialog_set_license (about, _tmp9_);
	_g_free0 (_tmp9_);
	gtk_about_dialog_set_wrap_license (about, TRUE);
	_tmp10_ = _g_object_ref0 (about);
	g_object_set_data_full (owner, "about-dlg", _tmp10_, g_object_unref);
	_tmp11_ = _g_object_ref0 (owner);
	g_object_set_data_full ((GObject*) about, "owner", _tmp11_, g_object_unref);
	gtk_window_set_transient_for ((GtkWindow*) about, parent);
	gtk_window_set_modal ((GtkWindow*) about, TRUE);
	g_signal_connect ((GtkDialog*) about, "response", (GCallback) __lambda4__gtk_dialog_response, NULL);
	gtk_widget_show ((GtkWidget*) about);
	_g_object_unref0 (about);
}


gboolean deja_dup_init_duplicity (GtkWindow* parent) {
	gboolean result = FALSE;
	gchar* header = NULL;
	gchar* msg = NULL;
	DejaDupDuplicityInfo* _tmp0_ = NULL;
	DejaDupDuplicityInfo* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean rv;
	_tmp0_ = deja_dup_duplicity_info_get_default ();
	_tmp1_ = _tmp0_;
	_tmp4_ = deja_dup_duplicity_info_check_duplicity_version (_tmp1_, &_tmp2_, &_tmp3_);
	_g_free0 (header);
	header = _tmp2_;
	_g_free0 (msg);
	msg = _tmp3_;
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp1_);
	rv = _tmp5_;
	if (!rv) {
		GtkMessageDialog* _tmp6_ = NULL;
		GtkMessageDialog* dlg;
		_tmp6_ = (GtkMessageDialog*) gtk_message_dialog_new (parent, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", header);
		dlg = g_object_ref_sink (_tmp6_);
		gtk_message_dialog_format_secondary_text (dlg, "%s", msg, NULL);
		gtk_dialog_run ((GtkDialog*) dlg);
		hacks_widget_destroy ((GtkWidget*) dlg);
		_g_object_unref0 (dlg);
	}
	result = rv;
	_g_free0 (msg);
	_g_free0 (header);
	return result;
}



