/* PreferencesDialog.c generated by valac 0.12.0, the Vala compiler
 * generated from PreferencesDialog.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008–2010 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <widgets.h>
#include <glib/gi18n-lib.h>
#include <common.h>
#include <whacks.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;
typedef struct _PreferencesDialogPrivate PreferencesDialogPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _PreferencesDialog {
	GtkDialog parent_instance;
	PreferencesDialogPrivate * priv;
};

struct _PreferencesDialogClass {
	GtkDialogClass parent_class;
};

struct _PreferencesDialogPrivate {
	GtkSizeGroup* label_sizes;
	GtkSizeGroup* button_sizes;
	DejaDupToggleGroup* periodic_toggle;
};


static gpointer preferences_dialog_parent_class = NULL;

GType preferences_dialog_get_type (void) G_GNUC_CONST;
#define PREFERENCES_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PREFERENCES_DIALOG, PreferencesDialogPrivate))
enum  {
	PREFERENCES_DIALOG_DUMMY_PROPERTY
};
PreferencesDialog* preferences_dialog_new (GtkWindow* parent);
PreferencesDialog* preferences_dialog_construct (GType object_type, GtkWindow* parent);
static void preferences_dialog_handle_response (PreferencesDialog* self, GtkDialog* dlg, gint response);
static GObject * preferences_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _preferences_dialog_handle_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void preferences_dialog_finalize (GObject* obj);


PreferencesDialog* preferences_dialog_construct (GType object_type, GtkWindow* parent) {
	PreferencesDialog * self = NULL;
	self = (PreferencesDialog*) g_object_new (object_type, NULL);
	gtk_window_set_transient_for ((GtkWindow*) self, parent);
	return self;
}


PreferencesDialog* preferences_dialog_new (GtkWindow* parent) {
	return preferences_dialog_construct (TYPE_PREFERENCES_DIALOG, parent);
}


static void preferences_dialog_handle_response (PreferencesDialog* self, GtkDialog* dlg, gint response) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (dlg != NULL);
	switch (response) {
		case GTK_RESPONSE_HELP:
		{
			deja_dup_show_uri ((GtkWindow*) dlg, "ghelp:deja-dup#prefs");
			break;
		}
		default:
		{
			gtk_main_quit ();
			break;
		}
	}
}


static void _preferences_dialog_handle_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	preferences_dialog_handle_response (self, _sender, response_id);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GObject * preferences_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	PreferencesDialog * self;
	const gchar* _tmp0_ = NULL;
	GtkNotebook* _tmp1_ = NULL;
	GtkNotebook* notebook;
	GtkWidget* w = NULL;
	GtkVBox* page_box = NULL;
	GtkHBox* hbox = NULL;
	GtkLabel* label = NULL;
	GtkTable* table = NULL;
	gint row = 0;
	GtkVBox* _tmp2_ = NULL;
	GtkTable* _tmp3_ = NULL;
	GtkSizeGroup* _tmp4_ = NULL;
	GtkSizeGroup* _tmp5_ = NULL;
	DejaDupConfigLocation* _tmp6_ = NULL;
	DejaDupConfigLocation* location;
	const gchar* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkEventBox* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	DejaDupConfigBool* _tmp11_ = NULL;
	DejaDupConfigLabelPolicy* _tmp12_ = NULL;
	GtkHBox* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GtkRequisition req = {0};
	GtkRequisition hidden = {0};
	GtkRequisition _tmp15_ = {0};
	GtkRequisition _tmp16_ = {0};
	GtkRequisition _tmp17_ = {0};
	GtkVBox* _tmp18_ = NULL;
	GtkTable* _tmp19_ = NULL;
	GtkSizeGroup* _tmp20_ = NULL;
	GtkSizeGroup* _tmp21_ = NULL;
	DejaDupConfigList* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	DejaDupConfigList* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	GtkLabel* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	GtkVBox* _tmp29_ = NULL;
	GtkTable* _tmp30_ = NULL;
	GtkSizeGroup* _tmp31_ = NULL;
	GtkSizeGroup* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	DejaDupConfigBool* _tmp34_ = NULL;
	DejaDupConfigBool* periodic_check;
	DejaDupConfigPeriod* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_;
	GtkLabel* _tmp39_ = NULL;
	DejaDupToggleGroup* _tmp40_ = NULL;
	DejaDupConfigDelete* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_;
	GtkLabel* _tmp45_ = NULL;
	DejaDupConfigLabelPolicy* _tmp46_ = NULL;
	GtkHBox* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	GtkWidget* _tmp49_ = NULL;
	GtkBox* _tmp50_;
	GtkBox* area;
	parent_class = G_OBJECT_CLASS (preferences_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = PREFERENCES_DIALOG (obj);
	_tmp0_ = _ ("Déjà Dup Preferences");
	g_object_set ((GObject*) self, "title", _tmp0_, "has-separator", FALSE, NULL);
	gtk_dialog_add_buttons ((GtkDialog*) self, GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, GTK_STOCK_HELP, GTK_RESPONSE_HELP, NULL);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) _preferences_dialog_handle_response_gtk_dialog_response, self, 0);
	_tmp1_ = (GtkNotebook*) gtk_notebook_new ();
	notebook = g_object_ref_sink (_tmp1_);
	_tmp2_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	_g_object_unref0 (page_box);
	page_box = g_object_ref_sink (_tmp2_);
	gtk_container_set_border_width ((GtkContainer*) page_box, (guint) 6);
	_tmp3_ = (GtkTable*) gtk_table_new ((guint) 0, (guint) 0, FALSE);
	_g_object_unref0 (table);
	table = g_object_ref_sink (_tmp3_);
	g_object_set (table, "row-spacing", (guint) 6, NULL);
	g_object_set (table, "column-spacing", (guint) 6, NULL);
	row = 0;
	_tmp4_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_g_object_unref0 (self->priv->label_sizes);
	self->priv->label_sizes = _tmp4_;
	_tmp5_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_g_object_unref0 (self->priv->button_sizes);
	self->priv->button_sizes = _tmp5_;
	_tmp6_ = deja_dup_config_location_new (self->priv->label_sizes);
	location = g_object_ref_sink (_tmp6_);
	_tmp7_ = _ ("_Backup location:");
	_tmp8_ = (GtkLabel*) gtk_label_new (_tmp7_);
	_g_object_unref0 (label);
	label = g_object_ref_sink (_tmp8_);
	g_object_set ((GObject*) label, "mnemonic-widget", location, "use-underline", TRUE, "xalign", 0.0f, NULL);
	gtk_size_group_add_widget (self->priv->label_sizes, (GtkWidget*) label);
	gtk_table_attach (table, (GtkWidget*) label, (guint) 0, (guint) 1, (guint) row, (guint) (row + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	gtk_table_attach (table, (GtkWidget*) location, (guint) 1, (guint) 2, (guint) row, (guint) (row + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
	row = row + 1;
	_tmp9_ = deja_dup_config_location_get_extras (location);
	gtk_table_attach (table, (GtkWidget*) _tmp9_, (guint) 0, (guint) 2, (guint) row, (guint) (row + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
	row = row + 1;
	_tmp10_ = _ ("_Encrypt backup files");
	_tmp11_ = deja_dup_config_bool_new (DEJA_DUP_ENCRYPT_KEY, _tmp10_, "");
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp11_);
	gtk_table_attach (table, w, (guint) 0, (guint) 3, (guint) row, (guint) (row + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
	row = row + 1;
	_tmp12_ = deja_dup_config_label_policy_new ();
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp12_);
	_tmp13_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	_g_object_unref0 (hbox);
	hbox = g_object_ref_sink (_tmp13_);
	gtk_container_set_border_width ((GtkContainer*) hbox, (guint) 3);
	gtk_container_add ((GtkContainer*) hbox, w);
	gtk_box_pack_start ((GtkBox*) page_box, (GtkWidget*) table, TRUE, TRUE, (guint) 0);
	gtk_box_pack_end ((GtkBox*) page_box, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
	gtk_notebook_append_page (notebook, (GtkWidget*) page_box, NULL);
	_tmp14_ = _ ("Storage");
	gtk_notebook_set_tab_label_text (notebook, (GtkWidget*) page_box, _tmp14_);
	gtk_widget_show_all ((GtkWidget*) page_box);
	hacks_get_natural_size ((GtkWidget*) page_box, &_tmp15_);
	req = _tmp15_;
	deja_dup_config_location_hidden_size (location, &_tmp16_);
	_tmp17_ = _tmp16_;
	hidden = _tmp17_;
	req.width = req.width + hidden.width;
	req.height = req.height + hidden.height;
	gtk_widget_set_size_request ((GtkWidget*) page_box, req.width, req.height);
	_tmp18_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	_g_object_unref0 (page_box);
	page_box = g_object_ref_sink (_tmp18_);
	g_object_set ((GObject*) page_box, "border-width", 3, NULL);
	_tmp19_ = (GtkTable*) gtk_table_new ((guint) 0, (guint) 3, FALSE);
	_g_object_unref0 (table);
	table = g_object_ref_sink (_tmp19_);
	row = 0;
	_tmp20_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_g_object_unref0 (self->priv->label_sizes);
	self->priv->label_sizes = _tmp20_;
	_tmp21_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_g_object_unref0 (self->priv->button_sizes);
	self->priv->button_sizes = _tmp21_;
	_tmp22_ = deja_dup_config_list_new (DEJA_DUP_INCLUDE_LIST_KEY, self->priv->button_sizes, "");
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp22_);
	gtk_widget_set_size_request (w, 300, 80);
	_tmp23_ = _ ("I_nclude files in folders:");
	_tmp24_ = (GtkLabel*) gtk_label_new (_tmp23_);
	_g_object_unref0 (label);
	label = g_object_ref_sink (_tmp24_);
	g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "wrap", TRUE, "width-request", 150, "xalign", 0.0f, "yalign", 0.0f, NULL);
	gtk_size_group_add_widget (self->priv->label_sizes, (GtkWidget*) label);
	gtk_table_attach (table, (GtkWidget*) label, (guint) 0, (guint) 1, (guint) row, (guint) (row + 1), GTK_FILL, GTK_FILL, (guint) 3, (guint) 3);
	gtk_table_attach (table, w, (guint) 1, (guint) 3, (guint) row, (guint) (row + 1), GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, (guint) 3, (guint) 3);
	row = row + 1;
	_tmp25_ = deja_dup_config_list_new (DEJA_DUP_EXCLUDE_LIST_KEY, self->priv->button_sizes, "");
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp25_);
	gtk_widget_set_size_request (w, 300, 120);
	_tmp26_ = _ ("E_xcept files in folders:");
	_tmp27_ = (GtkLabel*) gtk_label_new (_tmp26_);
	_g_object_unref0 (label);
	label = g_object_ref_sink (_tmp27_);
	g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "wrap", TRUE, "width-request", 150, "xalign", 0.0f, "yalign", 0.0f, NULL);
	gtk_size_group_add_widget (self->priv->label_sizes, (GtkWidget*) label);
	gtk_table_attach (table, (GtkWidget*) label, (guint) 0, (guint) 1, (guint) row, (guint) (row + 1), GTK_FILL, GTK_FILL, (guint) 3, (guint) 3);
	gtk_table_attach (table, w, (guint) 1, (guint) 3, (guint) row, (guint) (row + 1), GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, (guint) 3, (guint) 3);
	row = row + 1;
	gtk_box_pack_start ((GtkBox*) page_box, (GtkWidget*) table, TRUE, TRUE, (guint) 0);
	gtk_notebook_append_page (notebook, (GtkWidget*) page_box, NULL);
	_tmp28_ = _ ("Files");
	gtk_notebook_set_tab_label_text (notebook, (GtkWidget*) page_box, _tmp28_);
	_tmp29_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	_g_object_unref0 (page_box);
	page_box = g_object_ref_sink (_tmp29_);
	g_object_set ((GObject*) page_box, "border-width", 3, NULL);
	_tmp30_ = (GtkTable*) gtk_table_new ((guint) 0, (guint) 3, FALSE);
	_g_object_unref0 (table);
	table = g_object_ref_sink (_tmp30_);
	row = 0;
	_tmp31_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_g_object_unref0 (self->priv->label_sizes);
	self->priv->label_sizes = _tmp31_;
	_tmp32_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_g_object_unref0 (self->priv->button_sizes);
	self->priv->button_sizes = _tmp32_;
	_tmp33_ = _ ("_Automatically back up on a regular schedule");
	_tmp34_ = deja_dup_config_bool_new (DEJA_DUP_PERIODIC_KEY, _tmp33_, "");
	periodic_check = g_object_ref_sink (_tmp34_);
	gtk_table_attach (table, (GtkWidget*) periodic_check, (guint) 0, (guint) 3, (guint) row, (guint) (row + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 3, (guint) 3);
	row = row + 1;
	_tmp35_ = deja_dup_config_period_new (DEJA_DUP_PERIODIC_PERIOD_KEY, "");
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp35_);
	_tmp36_ = _ ("How _often to back up:");
	_tmp37_ = g_strdup_printf ("    %s", _tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = (GtkLabel*) gtk_label_new (_tmp38_);
	_g_object_unref0 (label);
	label = g_object_ref_sink (_tmp39_);
	_g_free0 (_tmp38_);
	g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "xalign", 0.0f, NULL);
	gtk_size_group_add_widget (self->priv->label_sizes, (GtkWidget*) label);
	gtk_table_attach (table, (GtkWidget*) label, (guint) 0, (guint) 1, (guint) row, (guint) (row + 1), GTK_FILL, GTK_FILL, (guint) 3, (guint) 3);
	gtk_table_attach (table, w, (guint) 1, (guint) 3, (guint) row, (guint) (row + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 3, (guint) 3);
	_tmp40_ = deja_dup_toggle_group_new ((DejaDupTogglable*) periodic_check);
	_g_object_unref0 (self->priv->periodic_toggle);
	self->priv->periodic_toggle = _tmp40_;
	deja_dup_toggle_group_add_dependent (self->priv->periodic_toggle, (GtkWidget*) label);
	deja_dup_toggle_group_add_dependent (self->priv->periodic_toggle, w);
	deja_dup_toggle_group_check (self->priv->periodic_toggle);
	row = row + 1;
	_tmp41_ = deja_dup_config_delete_new (DEJA_DUP_DELETE_AFTER_KEY, "");
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp41_);
	_tmp42_ = _ ("_Keep backups:");
	_tmp43_ = g_strdup_printf ("%s", _tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = (GtkLabel*) gtk_label_new (_tmp44_);
	_g_object_unref0 (label);
	label = g_object_ref_sink (_tmp45_);
	_g_free0 (_tmp44_);
	g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "xalign", 0.0f, NULL);
	gtk_size_group_add_widget (self->priv->label_sizes, (GtkWidget*) label);
	gtk_table_attach (table, (GtkWidget*) label, (guint) 0, (guint) 1, (guint) row, (guint) (row + 1), GTK_FILL, GTK_FILL, (guint) 3, (guint) 3);
	gtk_table_attach (table, w, (guint) 1, (guint) 3, (guint) row, (guint) (row + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 3, (guint) 3);
	row = row + 1;
	_tmp46_ = deja_dup_config_label_policy_new ();
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp46_);
	_tmp47_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	_g_object_unref0 (hbox);
	hbox = g_object_ref_sink (_tmp47_);
	gtk_container_set_border_width ((GtkContainer*) hbox, (guint) 3);
	gtk_container_add ((GtkContainer*) hbox, w);
	gtk_box_pack_start ((GtkBox*) page_box, (GtkWidget*) table, TRUE, TRUE, (guint) 0);
	gtk_box_pack_end ((GtkBox*) page_box, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
	gtk_notebook_append_page (notebook, (GtkWidget*) page_box, NULL);
	_tmp48_ = _ ("Schedule");
	gtk_notebook_set_tab_label_text (notebook, (GtkWidget*) page_box, _tmp48_);
	_tmp49_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp50_ = _g_object_ref0 (GTK_BOX (_tmp49_));
	area = _tmp50_;
	gtk_container_add ((GtkContainer*) area, (GtkWidget*) notebook);
	_g_object_unref0 (area);
	_g_object_unref0 (periodic_check);
	_g_object_unref0 (location);
	_g_object_unref0 (table);
	_g_object_unref0 (label);
	_g_object_unref0 (hbox);
	_g_object_unref0 (page_box);
	_g_object_unref0 (w);
	_g_object_unref0 (notebook);
	return obj;
}


static void preferences_dialog_class_init (PreferencesDialogClass * klass) {
	preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PreferencesDialogPrivate));
	G_OBJECT_CLASS (klass)->constructor = preferences_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = preferences_dialog_finalize;
}


static void preferences_dialog_instance_init (PreferencesDialog * self) {
	self->priv = PREFERENCES_DIALOG_GET_PRIVATE (self);
}


static void preferences_dialog_finalize (GObject* obj) {
	PreferencesDialog * self;
	self = PREFERENCES_DIALOG (obj);
	_g_object_unref0 (self->priv->label_sizes);
	_g_object_unref0 (self->priv->button_sizes);
	_g_object_unref0 (self->priv->periodic_toggle);
	G_OBJECT_CLASS (preferences_dialog_parent_class)->finalize (obj);
}


GType preferences_dialog_get_type (void) {
	static volatile gsize preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialog), 0, (GInstanceInitFunc) preferences_dialog_instance_init, NULL };
		GType preferences_dialog_type_id;
		preferences_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "PreferencesDialog", &g_define_type_info, 0);
		g_once_init_leave (&preferences_dialog_type_id__volatile, preferences_dialog_type_id);
	}
	return preferences_dialog_type_id__volatile;
}



