/* ConfigList.c generated by valac 0.10.0, the Vala compiler
 * generated from ConfigList.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008–2010 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gconf/gconf-client.h>
#include <stdlib.h>
#include <string.h>
#include <gconf/gconf.h>
#include <common.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define DEJA_DUP_TYPE_CONFIG_WIDGET (deja_dup_config_widget_get_type ())
#define DEJA_DUP_CONFIG_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidget))
#define DEJA_DUP_CONFIG_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidgetClass))
#define DEJA_DUP_IS_CONFIG_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET))
#define DEJA_DUP_IS_CONFIG_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_WIDGET))
#define DEJA_DUP_CONFIG_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_WIDGET, DejaDupConfigWidgetClass))

typedef struct _DejaDupConfigWidget DejaDupConfigWidget;
typedef struct _DejaDupConfigWidgetClass DejaDupConfigWidgetClass;
typedef struct _DejaDupConfigWidgetPrivate DejaDupConfigWidgetPrivate;

#define DEJA_DUP_TYPE_CONFIG_LIST (deja_dup_config_list_get_type ())
#define DEJA_DUP_CONFIG_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CONFIG_LIST, DejaDupConfigList))
#define DEJA_DUP_CONFIG_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CONFIG_LIST, DejaDupConfigListClass))
#define DEJA_DUP_IS_CONFIG_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CONFIG_LIST))
#define DEJA_DUP_IS_CONFIG_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CONFIG_LIST))
#define DEJA_DUP_CONFIG_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CONFIG_LIST, DejaDupConfigListClass))

typedef struct _DejaDupConfigList DejaDupConfigList;
typedef struct _DejaDupConfigListClass DejaDupConfigListClass;
typedef struct _DejaDupConfigListPrivate DejaDupConfigListPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_slist_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DejaDupConfigListSetFromConfigData DejaDupConfigListSetFromConfigData;
#define __g_list_free_gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_gtk_tree_path_free (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

struct _DejaDupConfigWidget {
	GtkEventBox parent_instance;
	DejaDupConfigWidgetPrivate * priv;
	GConfClient* client;
};

struct _DejaDupConfigWidgetClass {
	GtkEventBoxClass parent_class;
	void (*set_from_config) (DejaDupConfigWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_from_config_finish) (DejaDupConfigWidget* self, GAsyncResult* _res_);
};

struct _DejaDupConfigList {
	DejaDupConfigWidget parent_instance;
	DejaDupConfigListPrivate * priv;
};

struct _DejaDupConfigListClass {
	DejaDupConfigWidgetClass parent_class;
};

struct _DejaDupConfigListPrivate {
	GtkSizeGroup* _size_group;
	GtkTreeView* tree;
	GtkButton* add_button;
	GtkButton* remove_button;
};

struct _DejaDupConfigListSetFromConfigData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupConfigList* self;
	GSList* slist;
	GSList* _tmp0_;
	GSList* _tmp1_;
	GError * e;
	GFile** list;
	gint _tmp2_;
	gint list_length1;
	gint _list_size_;
	GFile** _tmp3_;
	GtkListStore* model;
	gint i;
	GFile* home;
	GFile* trash;
	char* _tmp4_;
	GFile* _tmp5_;
	char* s;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	GtkTreeIter iter;
	char* _tmp10_;
	GIcon* icon;
	GIcon* _tmp11_;
	GFileInfo* info;
	GIcon* _tmp12_;
	GError * err;
	GFile** f_collection;
	int f_collection_length1;
	int f_it;
	GFile* f;
	GError * _inner_error_;
};


static gpointer deja_dup_config_list_parent_class = NULL;

GType deja_dup_config_widget_get_type (void) G_GNUC_CONST;
GType deja_dup_config_list_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_CONFIG_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_CONFIG_LIST, DejaDupConfigListPrivate))
enum  {
	DEJA_DUP_CONFIG_LIST_DUMMY_PROPERTY,
	DEJA_DUP_CONFIG_LIST_SIZE_GROUP
};
DejaDupConfigList* deja_dup_config_list_new (const char* key, GtkSizeGroup* sg);
DejaDupConfigList* deja_dup_config_list_construct (GType object_type, const char* key, GtkSizeGroup* sg);
static void deja_dup_config_list_real_set_from_config_data_free (gpointer _data);
static void deja_dup_config_list_real_set_from_config (DejaDupConfigWidget* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_config_list_set_from_config_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean deja_dup_config_list_real_set_from_config_co (DejaDupConfigListSetFromConfigData* data);
const char* deja_dup_config_widget_get_key (DejaDupConfigWidget* self);
static void _g_slist_free_g_free (GSList* self);
static void deja_dup_config_list_handle_selection_change (DejaDupConfigList* self, GtkTreeSelection* sel);
static void deja_dup_config_list_handle_add (DejaDupConfigList* self);
static void deja_dup_config_list_handle_remove (DejaDupConfigList* self);
static void _g_list_free_gtk_tree_path_free (GList* self);
GtkSizeGroup* deja_dup_config_list_get_size_group (DejaDupConfigList* self);
static void deja_dup_config_list_set_size_group (DejaDupConfigList* self, GtkSizeGroup* value);
static void _deja_dup_config_list_handle_add_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _deja_dup_config_list_handle_remove_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean _lambda2_ (GtkWidget* w, gboolean g, DejaDupConfigList* self);
static gboolean __lambda2__gtk_widget_mnemonic_activate (GtkWidget* _sender, gboolean group_cycling, gpointer self);
static gboolean _lambda3_ (GtkWidget* w, GdkEventKey* e, DejaDupConfigList* self);
static gboolean __lambda3__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
void deja_dup_config_widget_set_from_config (DejaDupConfigWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_config_widget_set_from_config_finish (DejaDupConfigWidget* self, GAsyncResult* _res_);
static void _deja_dup_config_list_handle_selection_change_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static GObject * deja_dup_config_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void deja_dup_config_list_finalize (GObject* obj);
static void deja_dup_config_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void deja_dup_config_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



DejaDupConfigList* deja_dup_config_list_construct (GType object_type, const char* key, GtkSizeGroup* sg) {
	DejaDupConfigList * self;
	g_return_val_if_fail (key != NULL, NULL);
	self = (DejaDupConfigList*) g_object_new (object_type, "size-group", sg, "key", key, NULL);
	return self;
}


DejaDupConfigList* deja_dup_config_list_new (const char* key, GtkSizeGroup* sg) {
	return deja_dup_config_list_construct (DEJA_DUP_TYPE_CONFIG_LIST, key, sg);
}


static void deja_dup_config_list_real_set_from_config_data_free (gpointer _data) {
	DejaDupConfigListSetFromConfigData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (DejaDupConfigListSetFromConfigData, data);
}


static void deja_dup_config_list_real_set_from_config (DejaDupConfigWidget* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupConfigList * self;
	DejaDupConfigListSetFromConfigData* _data_;
	self = (DejaDupConfigList*) base;
	_data_ = g_slice_new0 (DejaDupConfigListSetFromConfigData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_config_list_real_set_from_config);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_config_list_real_set_from_config_data_free);
	_data_->self = g_object_ref (self);
	deja_dup_config_list_real_set_from_config_co (_data_);
}


static void deja_dup_config_list_real_set_from_config_finish (DejaDupConfigWidget* base, GAsyncResult* _res_) {
	DejaDupConfigListSetFromConfigData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_config_list_set_from_config_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupConfigListSetFromConfigData* data;
	data = _user_data_;
	data->_res_ = _res_;
	deja_dup_config_list_real_set_from_config_co (data);
}


static void _g_slist_free_g_free (GSList* self) {
	g_slist_foreach (self, (GFunc) g_free, NULL);
	g_slist_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean deja_dup_config_list_real_set_from_config_co (DejaDupConfigListSetFromConfigData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_tmp0_ = gconf_client_get_list (((DejaDupConfigWidget*) data->self)->client, deja_dup_config_widget_get_key ((DejaDupConfigWidget*) data->self), GCONF_VALUE_STRING, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		data->slist = (data->_tmp1_ = data->_tmp0_, __g_slist_free_g_free0 (data->slist), data->_tmp1_);
	}
	goto __finally15;
	__catch15_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			g_warning ("ConfigList.vala:102: %s\n", data->e->message);
			_g_error_free0 (data->e);
			__g_slist_free_g_free0 (data->slist);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_error_free0 (data->e);
		}
	}
	__finally15:
	if (data->_inner_error_ != NULL) {
		__g_slist_free_g_free0 (data->slist);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->list = (data->_tmp3_ = deja_dup_parse_dir_list (data->slist, &data->_tmp2_), data->list_length1 = data->_tmp2_, data->_list_size_ = data->list_length1, data->_tmp3_);
	g_object_get ((GObject*) data->self->priv->tree, "model", &data->model, NULL);
	gtk_list_store_clear (data->model);
	data->i = 0;
	data->home = g_file_new_for_path (g_get_home_dir ());
	data->trash = (data->_tmp5_ = g_file_new_for_path (data->_tmp4_ = deja_dup_get_trash_path ()), _g_free0 (data->_tmp4_), data->_tmp5_);
	{
		data->f_collection = data->list;
		data->f_collection_length1 = data->list_length1;
		for (data->f_it = 0; data->f_it < data->list_length1; data->f_it = data->f_it + 1) {
			data->f = _g_object_ref0 (data->f_collection[data->f_it]);
			{
				if (g_file_equal (data->f, data->home)) {
					data->s = (data->_tmp6_ = g_strdup (_ ("Home Folder")), _g_free0 (data->s), data->_tmp6_);
				} else {
					if (g_file_equal (data->f, data->trash)) {
						data->s = (data->_tmp7_ = g_strdup (_ ("Trash")), _g_free0 (data->s), data->_tmp7_);
					} else {
						if (g_file_has_prefix (data->f, data->home)) {
							data->s = (data->_tmp8_ = g_file_get_relative_path (data->home, data->f), _g_free0 (data->s), data->_tmp8_);
						} else {
							data->s = (data->_tmp9_ = g_file_get_path (data->f), _g_free0 (data->s), data->_tmp9_);
						}
					}
				}
				gtk_list_store_insert_with_values (data->model, &data->iter, data->i++, 0, data->_tmp10_ = g_file_get_path (data->f), 1, data->s, -1);
				_g_free0 (data->_tmp10_);
				data->icon = NULL;
				if (g_file_equal (data->f, data->trash)) {
					data->icon = (data->_tmp11_ = (GIcon*) ((GThemedIcon*) g_themed_icon_new ("user-trash")), _g_object_unref0 (data->icon), data->_tmp11_);
					g_themed_icon_append_name (G_THEMED_ICON (data->icon), "folder");
				} else {
					{
						data->info = g_file_query_info (data->f, G_FILE_ATTRIBUTE_STANDARD_ICON, G_FILE_QUERY_INFO_NONE, NULL, &data->_inner_error_);
						if (data->_inner_error_ != NULL) {
							goto __catch16_g_error;
						}
						data->icon = (data->_tmp12_ = _g_object_ref0 (g_file_info_get_icon (data->info)), _g_object_unref0 (data->icon), data->_tmp12_);
						_g_object_unref0 (data->info);
					}
					goto __finally16;
					__catch16_g_error:
					{
						data->err = data->_inner_error_;
						data->_inner_error_ = NULL;
						{
							g_warning ("ConfigList.vala:142: %s\n", data->err->message);
							_g_error_free0 (data->err);
						}
					}
					__finally16:
					if (data->_inner_error_ != NULL) {
						_g_object_unref0 (data->icon);
						_g_free0 (data->s);
						_g_object_unref0 (data->f);
						_g_object_unref0 (data->trash);
						_g_object_unref0 (data->home);
						_g_object_unref0 (data->model);
						data->list = (_vala_array_free (data->list, data->list_length1, (GDestroyNotify) g_object_unref), NULL);
						__g_slist_free_g_free0 (data->slist);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
						g_clear_error (&data->_inner_error_);
						return FALSE;
					}
				}
				if (data->icon != NULL) {
					gtk_list_store_set (data->model, &data->iter, 2, data->icon, -1);
				}
				_g_object_unref0 (data->icon);
				_g_free0 (data->s);
				_g_object_unref0 (data->f);
			}
		}
	}
	_g_object_unref0 (data->trash);
	_g_object_unref0 (data->home);
	_g_object_unref0 (data->model);
	data->list = (_vala_array_free (data->list, data->list_length1, (GDestroyNotify) g_object_unref), NULL);
	__g_slist_free_g_free0 (data->slist);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void deja_dup_config_list_handle_selection_change (DejaDupConfigList* self, GtkTreeSelection* sel) {
	gboolean empty;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sel != NULL);
	empty = gtk_tree_selection_count_selected_rows (sel) == 0;
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->remove_button, !empty);
}


static void deja_dup_config_list_handle_add (DejaDupConfigList* self) {
	GtkFileChooserDialog* dlg;
	GSList* files;
	GSList* slist;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	dlg = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Choose folders"), GTK_WINDOW (gtk_widget_get_toplevel ((GtkWidget*) self)), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL));
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) dlg, TRUE);
	if (gtk_dialog_run ((GtkDialog*) dlg) != GTK_RESPONSE_ACCEPT) {
		gtk_object_destroy ((GtkObject*) dlg);
		_g_object_unref0 (dlg);
		return;
	}
	files = gtk_file_chooser_get_filenames ((GtkFileChooser*) dlg);
	gtk_object_destroy ((GtkObject*) dlg);
	slist = NULL;
	{
		GSList* _tmp0_;
		GSList* _tmp1_;
		_tmp0_ = gconf_client_get_list (((DejaDupConfigWidget*) self)->client, deja_dup_config_widget_get_key ((DejaDupConfigWidget*) self), GCONF_VALUE_STRING, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch17_g_error;
		}
		slist = (_tmp1_ = _tmp0_, __g_slist_free_g_free0 (slist), _tmp1_);
		{
			GSList* file_collection;
			GSList* file_it;
			file_collection = files;
			for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
				char* file;
				file = g_strdup ((const char*) file_it->data);
				{
					GFile* folder;
					gboolean found;
					folder = g_file_new_for_path (file);
					found = FALSE;
					{
						GSList* s_collection;
						GSList* s_it;
						s_collection = slist;
						for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
							char* s;
							s = g_strdup ((const char*) s_it->data);
							{
								GFile* sfile;
								sfile = g_file_new_for_path (s);
								if (g_file_equal (sfile, folder)) {
									found = TRUE;
									_g_object_unref0 (sfile);
									_g_free0 (s);
									break;
								}
								_g_object_unref0 (sfile);
								_g_free0 (s);
							}
						}
					}
					if (!found) {
						slist = g_slist_append (slist, g_strdup (file));
					}
					_g_object_unref0 (folder);
					_g_free0 (file);
				}
			}
		}
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GSList* _tmp2_;
			g_warning ("ConfigList.vala:192: %s\n", e->message);
			slist = (_tmp2_ = g_slist_copy (files), __g_slist_free_g_free0 (slist), _tmp2_);
			_g_error_free0 (e);
		}
	}
	__finally17:
	if (_inner_error_ != NULL) {
		__g_slist_free_g_free0 (slist);
		__g_slist_free_g_free0 (files);
		_g_object_unref0 (dlg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gconf_client_set_list (((DejaDupConfigWidget*) self)->client, deja_dup_config_widget_get_key ((DejaDupConfigWidget*) self), GCONF_VALUE_STRING, slist, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("ConfigList.vala:199: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally18:
	if (_inner_error_ != NULL) {
		__g_slist_free_g_free0 (slist);
		__g_slist_free_g_free0 (files);
		_g_object_unref0 (dlg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	__g_slist_free_g_free0 (slist);
	__g_slist_free_g_free0 (files);
	_g_object_unref0 (dlg);
}


static void _g_list_free_gtk_tree_path_free (GList* self) {
	g_list_foreach (self, (GFunc) gtk_tree_path_free, NULL);
	g_list_free (self);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void deja_dup_config_list_handle_remove (DejaDupConfigList* self) {
	GtkTreeSelection* sel;
	GtkTreeModel* model;
	GList* paths;
	GSList* slist;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	sel = _g_object_ref0 (gtk_tree_view_get_selection (self->priv->tree));
	model = NULL;
	paths = gtk_tree_selection_get_selected_rows (sel, &model);
	if (paths == NULL) {
		__g_list_free_gtk_tree_path_free0 (paths);
		_g_object_unref0 (sel);
		return;
	}
	slist = NULL;
	{
		GSList* _tmp0_;
		GSList* _tmp1_;
		_tmp0_ = gconf_client_get_list (((DejaDupConfigWidget*) self)->client, deja_dup_config_widget_get_key ((DejaDupConfigWidget*) self), GCONF_VALUE_STRING, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
		slist = (_tmp1_ = _tmp0_, __g_slist_free_g_free0 (slist), _tmp1_);
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("ConfigList.vala:216: %s\n", e->message);
			_g_error_free0 (e);
			__g_slist_free_g_free0 (slist);
			__g_list_free_gtk_tree_path_free0 (paths);
			_g_object_unref0 (sel);
			return;
		}
	}
	__finally19:
	if (_inner_error_ != NULL) {
		__g_slist_free_g_free0 (slist);
		__g_list_free_gtk_tree_path_free0 (paths);
		_g_object_unref0 (sel);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GList* path_collection;
		GList* path_it;
		path_collection = paths;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			GtkTreePath* path;
			path = _gtk_tree_path_copy0 ((GtkTreePath*) path_it->data);
			{
				GtkTreeIter iter = {0};
				char* current;
				GFile* current_file;
				GSList* siter;
				GSList* snext;
				if (!gtk_tree_model_get_iter (model, &iter, path)) {
					_gtk_tree_path_free0 (path);
					continue;
				}
				current = NULL;
				gtk_tree_model_get (model, &iter, 0, &current, -1);
				current_file = g_file_new_for_path (current);
				siter = slist;
				snext = NULL;
				while (TRUE) {
					GFile* sfile;
					if (!(siter != NULL)) {
						break;
					}
					snext = siter->next;
					sfile = deja_dup_parse_dir ((const char*) siter->data);
					if (g_file_equal (sfile, current_file)) {
						slist = g_slist_remove_link (slist, siter);
						_g_object_unref0 (sfile);
						break;
					}
					siter = snext;
					_g_object_unref0 (sfile);
				}
				_g_object_unref0 (current_file);
				_g_free0 (current);
				_gtk_tree_path_free0 (path);
			}
		}
	}
	{
		gconf_client_set_list (((DejaDupConfigWidget*) self)->client, deja_dup_config_widget_get_key ((DejaDupConfigWidget*) self), GCONF_VALUE_STRING, slist, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch20_g_error;
		}
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("ConfigList.vala:245: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally20:
	if (_inner_error_ != NULL) {
		__g_slist_free_g_free0 (slist);
		__g_list_free_gtk_tree_path_free0 (paths);
		_g_object_unref0 (sel);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	__g_slist_free_g_free0 (slist);
	__g_list_free_gtk_tree_path_free0 (paths);
	_g_object_unref0 (sel);
}


GtkSizeGroup* deja_dup_config_list_get_size_group (DejaDupConfigList* self) {
	GtkSizeGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_size_group;
	return result;
}


static void deja_dup_config_list_set_size_group (DejaDupConfigList* self, GtkSizeGroup* value) {
	GtkSizeGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_size_group = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_size_group), _tmp0_);
	g_object_notify ((GObject *) self, "size-group");
}


static void _deja_dup_config_list_handle_add_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	deja_dup_config_list_handle_add (self);
}


static void _deja_dup_config_list_handle_remove_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	deja_dup_config_list_handle_remove (self);
}


static gboolean _lambda2_ (GtkWidget* w, gboolean g, DejaDupConfigList* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (w != NULL, FALSE);
	result = gtk_widget_mnemonic_activate ((GtkWidget*) self->priv->tree, g);
	return result;
}


static gboolean __lambda2__gtk_widget_mnemonic_activate (GtkWidget* _sender, gboolean group_cycling, gpointer self) {
	gboolean result;
	result = _lambda2_ (_sender, group_cycling, self);
	return result;
}


static gboolean _lambda3_ (GtkWidget* w, GdkEventKey* e, DejaDupConfigList* self) {
	gboolean result = FALSE;
	guint modifiers;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (w != NULL, FALSE);
	modifiers = gtk_accelerator_get_default_mod_mask ();
	if ((*e).keyval == 0xffff) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*e).keyval == 0xff9f;
	}
	if (_tmp1_) {
		_tmp0_ = modifiers == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		deja_dup_config_list_handle_remove (self);
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean __lambda3__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = _lambda3_ (_sender, event, self);
	return result;
}


static void _deja_dup_config_list_handle_selection_change_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	deja_dup_config_list_handle_selection_change (self, _sender);
}


static GObject * deja_dup_config_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupConfigList * self;
	parent_class = G_OBJECT_CLASS (deja_dup_config_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DEJA_DUP_CONFIG_LIST (obj);
	{
		GtkListStore* model;
		GtkTreeView* _tmp0_;
		GtkCellRendererPixbuf* _tmp1_;
		GtkCellRendererText* renderer;
		GtkButton* _tmp2_;
		GtkButton* _tmp3_;
		GtkScrolledWindow* scroll;
		GtkHBox* hbox;
		GtkVBox* vbox;
		GtkTreeSelection* selection;
		model = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_ICON);
		self->priv->tree = (_tmp0_ = g_object_ref_sink ((GtkTreeView*) gtk_tree_view_new ()), _g_object_unref0 (self->priv->tree), _tmp0_);
		g_object_set ((GObject*) self->priv->tree, "model", model, "headers-visible", FALSE, NULL);
		gtk_tree_view_insert_column_with_attributes (self->priv->tree, -1, NULL, (GtkCellRenderer*) (_tmp1_ = g_object_ref_sink ((GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ())), "gicon", 2, NULL);
		_g_object_unref0 (_tmp1_);
		renderer = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ());
		gtk_tree_view_insert_column_with_attributes (self->priv->tree, -1, NULL, (GtkCellRenderer*) renderer, "text", 1, NULL);
		self->priv->add_button = (_tmp2_ = g_object_ref_sink ((GtkButton*) gtk_button_new_from_stock (GTK_STOCK_ADD)), _g_object_unref0 (self->priv->add_button), _tmp2_);
		g_signal_connect_object (self->priv->add_button, "clicked", (GCallback) _deja_dup_config_list_handle_add_gtk_button_clicked, self, 0);
		self->priv->remove_button = (_tmp3_ = g_object_ref_sink ((GtkButton*) gtk_button_new_from_stock (GTK_STOCK_REMOVE)), _g_object_unref0 (self->priv->remove_button), _tmp3_);
		g_signal_connect_object (self->priv->remove_button, "clicked", (GCallback) _deja_dup_config_list_handle_remove_gtk_button_clicked, self, 0);
		if (self->priv->_size_group != NULL) {
			gtk_size_group_add_widget (self->priv->_size_group, (GtkWidget*) self->priv->add_button);
			gtk_size_group_add_widget (self->priv->_size_group, (GtkWidget*) self->priv->remove_button);
		}
		scroll = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL));
		g_object_set (scroll, "hscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
		g_object_set (scroll, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
		hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
		vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
		gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->add_button, FALSE, FALSE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->remove_button, FALSE, FALSE, (guint) 0);
		gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) self->priv->tree);
		gtk_container_add ((GtkContainer*) hbox, (GtkWidget*) scroll);
		gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) vbox, FALSE, FALSE, (guint) 0);
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) hbox);
		selection = _g_object_ref0 (gtk_tree_view_get_selection (self->priv->tree));
		gtk_tree_selection_set_mode (selection, GTK_SELECTION_MULTIPLE);
		g_signal_connect_object ((GtkWidget*) self, "mnemonic-activate", (GCallback) __lambda2__gtk_widget_mnemonic_activate, self, 0);
		g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) __lambda3__gtk_widget_key_press_event, self, 0);
		deja_dup_config_widget_set_from_config ((DejaDupConfigWidget*) self, NULL, NULL);
		deja_dup_config_list_handle_selection_change (self, selection);
		g_signal_connect_object (selection, "changed", (GCallback) _deja_dup_config_list_handle_selection_change_gtk_tree_selection_changed, self, 0);
		_g_object_unref0 (selection);
		_g_object_unref0 (vbox);
		_g_object_unref0 (hbox);
		_g_object_unref0 (scroll);
		_g_object_unref0 (renderer);
		_g_object_unref0 (model);
	}
	return obj;
}


static void deja_dup_config_list_class_init (DejaDupConfigListClass * klass) {
	deja_dup_config_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupConfigListPrivate));
	DEJA_DUP_CONFIG_WIDGET_CLASS (klass)->set_from_config = deja_dup_config_list_real_set_from_config;
	DEJA_DUP_CONFIG_WIDGET_CLASS (klass)->set_from_config_finish = deja_dup_config_list_real_set_from_config_finish;
	G_OBJECT_CLASS (klass)->get_property = deja_dup_config_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = deja_dup_config_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_config_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_config_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_CONFIG_LIST_SIZE_GROUP, g_param_spec_object ("size-group", "size-group", "size-group", GTK_TYPE_SIZE_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void deja_dup_config_list_instance_init (DejaDupConfigList * self) {
	self->priv = DEJA_DUP_CONFIG_LIST_GET_PRIVATE (self);
}


static void deja_dup_config_list_finalize (GObject* obj) {
	DejaDupConfigList * self;
	self = DEJA_DUP_CONFIG_LIST (obj);
	_g_object_unref0 (self->priv->_size_group);
	_g_object_unref0 (self->priv->tree);
	_g_object_unref0 (self->priv->add_button);
	_g_object_unref0 (self->priv->remove_button);
	G_OBJECT_CLASS (deja_dup_config_list_parent_class)->finalize (obj);
}


GType deja_dup_config_list_get_type (void) {
	static volatile gsize deja_dup_config_list_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_config_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupConfigListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_config_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupConfigList), 0, (GInstanceInitFunc) deja_dup_config_list_instance_init, NULL };
		GType deja_dup_config_list_type_id;
		deja_dup_config_list_type_id = g_type_register_static (DEJA_DUP_TYPE_CONFIG_WIDGET, "DejaDupConfigList", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_config_list_type_id__volatile, deja_dup_config_list_type_id);
	}
	return deja_dup_config_list_type_id__volatile;
}


static void deja_dup_config_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupConfigList * self;
	self = DEJA_DUP_CONFIG_LIST (object);
	switch (property_id) {
		case DEJA_DUP_CONFIG_LIST_SIZE_GROUP:
		g_value_set_object (value, deja_dup_config_list_get_size_group (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_config_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupConfigList * self;
	self = DEJA_DUP_CONFIG_LIST (object);
	switch (property_id) {
		case DEJA_DUP_CONFIG_LIST_SIZE_GROUP:
		deja_dup_config_list_set_size_group (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




