/* BackendS3.c generated by valac 0.10.0, the Vala compiler
 * generated from BackendS3.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008–2010 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gconf/gconf-client.h>
#include <gnome-keyring.h>


#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;
typedef struct _DejaDupBackendPrivate DejaDupBackendPrivate;

#define DEJA_DUP_OPERATION_TYPE_MODE (deja_dup_operation_mode_get_type ())

#define DEJA_DUP_TYPE_BACKEND_S3 (deja_dup_backend_s3_get_type ())
#define DEJA_DUP_BACKEND_S3(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3))
#define DEJA_DUP_BACKEND_S3_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3Class))
#define DEJA_DUP_IS_BACKEND_S3(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_S3))
#define DEJA_DUP_IS_BACKEND_S3_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_S3))
#define DEJA_DUP_BACKEND_S3_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3Class))

typedef struct _DejaDupBackendS3 DejaDupBackendS3;
typedef struct _DejaDupBackendS3Class DejaDupBackendS3Class;
typedef struct _DejaDupBackendS3Private DejaDupBackendS3Private;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DEJA_DUP_TYPE_NETWORK (deja_dup_network_get_type ())
#define DEJA_DUP_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetwork))
#define DEJA_DUP_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))
#define DEJA_DUP_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))

typedef struct _DejaDupNetwork DejaDupNetwork;
typedef struct _DejaDupNetworkClass DejaDupNetworkClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DejaDupBackendS3GetEnvpData DejaDupBackendS3GetEnvpData;
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))

typedef enum  {
	DEJA_DUP_OPERATION_MODE_INVALID,
	DEJA_DUP_OPERATION_MODE_BACKUP,
	DEJA_DUP_OPERATION_MODE_RESTORE,
	DEJA_DUP_OPERATION_MODE_STATUS,
	DEJA_DUP_OPERATION_MODE_LIST
} DejaDupOperationMode;

struct _DejaDupBackend {
	GObject parent_instance;
	DejaDupBackendPrivate * priv;
};

struct _DejaDupBackendClass {
	GObjectClass parent_class;
	gboolean (*is_native) (DejaDupBackend* self);
	GIcon* (*get_icon) (DejaDupBackend* self);
	char* (*get_location) (DejaDupBackend* self, GError** error);
	char* (*get_location_pretty) (DejaDupBackend* self, GError** error);
	gboolean (*is_ready) (DejaDupBackend* self, char** when);
	void (*get_envp) (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_envp_finish) (DejaDupBackend* self, GAsyncResult* _res_, GError** error);
	void (*get_space) (DejaDupBackend* self, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint64 (*get_space_finish) (DejaDupBackend* self, GAsyncResult* _res_);
	void (*add_argv) (DejaDupBackend* self, DejaDupOperationMode mode, GList** argv);
	DejaDupBackend* (*clone) (DejaDupBackend* self);
};

struct _DejaDupBackendS3 {
	DejaDupBackend parent_instance;
	DejaDupBackendS3Private * priv;
};

struct _DejaDupBackendS3Class {
	DejaDupBackendClass parent_class;
};

struct _DejaDupBackendS3Private {
	char* gconf_id;
	char* id;
	char* secret_key;
};

struct _DejaDupBackendS3GetEnvpData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendS3* self;
	GConfClient* client;
	char* _tmp0_;
	char* _tmp1_;
	const char* _tmp2_;
	char* _tmp3_;
	gboolean _tmp4_;
	char* _tmp5_;
	GError * _inner_error_;
};


static gpointer deja_dup_backend_s3_parent_class = NULL;

#define DEJA_DUP_S3_ROOT_KEY "/apps/deja-dup/s3"
#define DEJA_DUP_S3_ID_KEY "/apps/deja-dup/s3/id"
#define DEJA_DUP_S3_BUCKET_KEY "/apps/deja-dup/s3/bucket"
#define DEJA_DUP_S3_FOLDER_KEY "/apps/deja-dup/s3/folder"
#define DEJA_DUP_S3_SERVER "s3.amazonaws.com"
GType deja_dup_backend_get_type (void) G_GNUC_CONST;
GType deja_dup_operation_mode_get_type (void) G_GNUC_CONST;
GType deja_dup_backend_s3_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_BACKEND_S3_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3Private))
enum  {
	DEJA_DUP_BACKEND_S3_DUMMY_PROPERTY
};
static DejaDupBackend* deja_dup_backend_s3_real_clone (DejaDupBackend* base);
DejaDupBackendS3* deja_dup_backend_s3_new (void);
DejaDupBackendS3* deja_dup_backend_s3_construct (GType object_type);
static void deja_dup_backend_s3_real_add_argv (DejaDupBackend* base, DejaDupOperationMode mode, GList** argv);
static char* deja_dup_backend_s3_get_default_bucket (DejaDupBackendS3* self);
static gboolean deja_dup_backend_s3_real_is_native (DejaDupBackend* base);
static gboolean deja_dup_backend_s3_real_is_ready (DejaDupBackend* base, char** when);
GType deja_dup_network_get_type (void) G_GNUC_CONST;
DejaDupNetwork* deja_dup_network_get (void);
gboolean deja_dup_network_get_connected (DejaDupNetwork* self);
static char* deja_dup_backend_s3_real_get_location (DejaDupBackend* base, GError** error);
GConfClient* deja_dup_get_gconf_client (void);
gboolean deja_dup_backend_s3_bump_bucket (DejaDupBackendS3* self);
static char* deja_dup_backend_s3_real_get_location_pretty (DejaDupBackend* base, GError** error);
static void deja_dup_backend_s3_real_get_envp_data_free (gpointer _data);
static void deja_dup_backend_s3_real_get_envp (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_backend_s3_get_envp_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean deja_dup_backend_s3_real_get_envp_co (DejaDupBackendS3GetEnvpData* data);
static void deja_dup_backend_s3_got_secret_key (DejaDupBackendS3* self);
static void deja_dup_backend_s3_found_password (DejaDupBackendS3* self, GnomeKeyringResult _result_, GList* list);
static void _deja_dup_backend_s3_found_password_gnome_keyring_operation_get_list_callback (GnomeKeyringResult _result_, GList* list, gpointer self);
static void deja_dup_backend_s3_ask_password (DejaDupBackendS3* self);
static void deja_dup_backend_s3_save_password_callback (DejaDupBackendS3* self, GnomeKeyringResult _result_, guint32 val);
static void deja_dup_backend_s3_got_password_reply (DejaDupBackendS3* self, GMountOperation* mount_op, GMountOperationResult _result_);
static void _g_list_free_g_free (GList* self);
static void _deja_dup_backend_s3_save_password_callback_gnome_keyring_operation_get_int_callback (GnomeKeyringResult _result_, guint32 val, gpointer self);
GMountOperation* deja_dup_backend_get_mount_op (DejaDupBackend* self);
static void _deja_dup_backend_s3_got_password_reply_g_mount_operation_reply (GMountOperation* _sender, GMountOperationResult _result_, gpointer self);
DejaDupBackend* deja_dup_backend_construct (GType object_type);
static void deja_dup_backend_s3_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static DejaDupBackend* deja_dup_backend_s3_real_clone (DejaDupBackend* base) {
	DejaDupBackendS3 * self;
	DejaDupBackend* result = NULL;
	self = (DejaDupBackendS3*) base;
	result = (DejaDupBackend*) deja_dup_backend_s3_new ();
	return result;
}


static void deja_dup_backend_s3_real_add_argv (DejaDupBackend* base, DejaDupOperationMode mode, GList** argv) {
	DejaDupBackendS3 * self;
	self = (DejaDupBackendS3*) base;
	if (mode == DEJA_DUP_OPERATION_MODE_INVALID) {
		*argv = g_list_append (*argv, g_strdup ("--s3-use-new-style"));
	}
}


static char* deja_dup_backend_s3_get_default_bucket (DejaDupBackendS3* self) {
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp1_ = g_strdup_printf ("deja-dup-auto-%s", _tmp0_ = g_utf8_strdown (self->priv->id, -1)), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static gboolean deja_dup_backend_s3_real_is_native (DejaDupBackend* base) {
	DejaDupBackendS3 * self;
	gboolean result = FALSE;
	self = (DejaDupBackendS3*) base;
	result = FALSE;
	return result;
}


static gboolean deja_dup_backend_s3_real_is_ready (DejaDupBackend* base, char** when) {
	DejaDupBackendS3 * self;
	gboolean result = FALSE;
	char* _tmp0_;
	DejaDupNetwork* _tmp1_;
	gboolean _tmp2_;
	self = (DejaDupBackendS3*) base;
	if (when != NULL) {
		*when = NULL;
	}
	*when = (_tmp0_ = g_strdup (_ ("Backup will begin when a network connection becomes available.")), _g_free0 (*when), _tmp0_);
	result = (_tmp2_ = deja_dup_network_get_connected (_tmp1_ = deja_dup_network_get ()), _g_object_unref0 (_tmp1_), _tmp2_);
	return result;
}


static char* deja_dup_backend_s3_real_get_location (DejaDupBackend* base, GError** error) {
	DejaDupBackendS3 * self;
	char* result = NULL;
	GConfClient* client;
	char* bucket;
	char* default_bucket;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	char* folder;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DejaDupBackendS3*) base;
	client = deja_dup_get_gconf_client ();
	bucket = gconf_client_get_string (client, DEJA_DUP_S3_BUCKET_KEY, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (client);
		return NULL;
	}
	default_bucket = deja_dup_backend_s3_get_default_bucket (self);
	if (bucket == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = _vala_strcmp0 (bucket, "") == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (g_str_has_prefix (bucket, "deja-dup-auto-")) {
			_tmp2_ = !g_str_has_prefix (bucket, default_bucket);
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		char* _tmp3_;
		bucket = (_tmp3_ = g_strdup (default_bucket), _g_free0 (bucket), _tmp3_);
		gconf_client_set_string (client, DEJA_DUP_S3_BUCKET_KEY, bucket, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (default_bucket);
			_g_free0 (bucket);
			_g_object_unref0 (client);
			return NULL;
		}
	}
	folder = gconf_client_get_string (client, DEJA_DUP_S3_FOLDER_KEY, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (default_bucket);
		_g_free0 (bucket);
		_g_object_unref0 (client);
		return NULL;
	}
	if (folder != NULL) {
		_tmp4_ = _vala_strcmp0 (folder, "") != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		if (g_utf8_get_char (g_utf8_offset_to_pointer (folder, 0)) != '/') {
			char* _tmp5_;
			bucket = (_tmp5_ = g_strdup_printf ("%s/%s", bucket, folder), _g_free0 (bucket), _tmp5_);
		} else {
			char* _tmp6_;
			bucket = (_tmp6_ = g_strdup_printf ("%s%s", bucket, folder), _g_free0 (bucket), _tmp6_);
		}
	}
	result = g_strdup_printf ("s3+http://%s", bucket);
	_g_free0 (folder);
	_g_free0 (default_bucket);
	_g_free0 (bucket);
	_g_object_unref0 (client);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gboolean deja_dup_backend_s3_bump_bucket (DejaDupBackendS3* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GConfClient* client;
		char* bucket;
		gint bits_length1;
		gint _bits_size_;
		char** _tmp2_;
		char** _tmp1_;
		char** bits;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		client = _g_object_ref0 (gconf_client_get_default ());
		bucket = gconf_client_get_string (client, DEJA_DUP_S3_BUCKET_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (client);
			goto __catch8_g_error;
		}
		if (_vala_strcmp0 (bucket, "deja-dup") == 0) {
			char* _tmp0_;
			bucket = (_tmp0_ = deja_dup_backend_s3_get_default_bucket (self), _g_free0 (bucket), _tmp0_);
			gconf_client_set_string (client, DEJA_DUP_S3_BUCKET_KEY, bucket, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (bucket);
				_g_object_unref0 (client);
				goto __catch8_g_error;
			}
			result = TRUE;
			_g_free0 (bucket);
			_g_object_unref0 (client);
			return result;
		}
		if (!g_str_has_prefix (bucket, "deja-dup-auto-")) {
			result = FALSE;
			_g_free0 (bucket);
			_g_object_unref0 (client);
			return result;
		}
		bits = (_tmp2_ = _tmp1_ = g_strsplit (bucket, "-", 0), bits_length1 = _vala_array_length (_tmp1_), _bits_size_ = bits_length1, _tmp2_);
		if (bits == NULL) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = bits[0] == NULL;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = bits[1] == NULL;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = bits[2] == NULL;
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = bits[3] == NULL;
		}
		if (_tmp3_) {
			result = FALSE;
			bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (bucket);
			_g_object_unref0 (client);
			return result;
		}
		if (bits[4] == NULL) {
			char* _tmp7_;
			bucket = (_tmp7_ = g_strconcat (bucket, "-2", NULL), _g_free0 (bucket), _tmp7_);
		} else {
			glong num;
			char* _tmp8_;
			char* _tmp9_;
			num = strtol (bits[4], NULL, 0);
			bits[4] = (_tmp8_ = g_strdup_printf ("%li", num + 1), _g_free0 (bits[4]), _tmp8_);
			bucket = (_tmp9_ = g_strjoinv ("-", bits), _g_free0 (bucket), _tmp9_);
		}
		gconf_client_set_string (client, DEJA_DUP_S3_BUCKET_KEY, bucket, &_inner_error_);
		if (_inner_error_ != NULL) {
			bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (bucket);
			_g_object_unref0 (client);
			goto __catch8_g_error;
		}
		result = TRUE;
		bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (bucket);
		_g_object_unref0 (client);
		return result;
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			result = FALSE;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally8:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
}


static char* deja_dup_backend_s3_real_get_location_pretty (DejaDupBackend* base, GError** error) {
	DejaDupBackendS3 * self;
	char* result = NULL;
	GConfClient* client;
	char* folder;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DejaDupBackendS3*) base;
	client = deja_dup_get_gconf_client ();
	folder = gconf_client_get_string (client, DEJA_DUP_S3_FOLDER_KEY, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (client);
		return NULL;
	}
	if (folder == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (folder, "") == 0;
	}
	if (_tmp0_) {
		char* _tmp1_;
		folder = (_tmp1_ = g_strdup ("/"), _g_free0 (folder), _tmp1_);
	}
	result = g_strdup_printf (_ ("%s on Amazon S3"), folder);
	_g_free0 (folder);
	_g_object_unref0 (client);
	return result;
}


static void deja_dup_backend_s3_real_get_envp_data_free (gpointer _data) {
	DejaDupBackendS3GetEnvpData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (DejaDupBackendS3GetEnvpData, data);
}


static void deja_dup_backend_s3_real_get_envp (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendS3 * self;
	DejaDupBackendS3GetEnvpData* _data_;
	self = (DejaDupBackendS3*) base;
	_data_ = g_slice_new0 (DejaDupBackendS3GetEnvpData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_s3_real_get_envp);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_s3_real_get_envp_data_free);
	_data_->self = g_object_ref (self);
	deja_dup_backend_s3_real_get_envp_co (_data_);
}


static void deja_dup_backend_s3_real_get_envp_finish (DejaDupBackend* base, GAsyncResult* _res_, GError** error) {
	DejaDupBackendS3GetEnvpData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_backend_s3_get_envp_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendS3GetEnvpData* data;
	data = _user_data_;
	data->_res_ = _res_;
	deja_dup_backend_s3_real_get_envp_co (data);
}


static void _deja_dup_backend_s3_found_password_gnome_keyring_operation_get_list_callback (GnomeKeyringResult _result_, GList* list, gpointer self) {
	deja_dup_backend_s3_found_password (self, _result_, list);
}


static gboolean deja_dup_backend_s3_real_get_envp_co (DejaDupBackendS3GetEnvpData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->client = deja_dup_get_gconf_client ();
	data->_tmp0_ = gconf_client_get_string (data->client, DEJA_DUP_S3_ID_KEY, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->client);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->self->priv->gconf_id = (data->_tmp1_ = data->_tmp0_, _g_free0 (data->self->priv->gconf_id), data->_tmp1_);
	if (data->self->priv->gconf_id == NULL) {
		data->_tmp2_ = "";
	} else {
		data->_tmp2_ = data->self->priv->gconf_id;
	}
	data->self->priv->id = (data->_tmp3_ = g_strdup (data->_tmp2_), _g_free0 (data->self->priv->id), data->_tmp3_);
	if (_vala_strcmp0 (data->self->priv->id, "") != 0) {
		data->_tmp4_ = data->self->priv->secret_key != NULL;
	} else {
		data->_tmp4_ = FALSE;
	}
	if (data->_tmp4_) {
		deja_dup_backend_s3_got_secret_key (data->self);
		_g_object_unref0 (data->client);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	if (_vala_strcmp0 (data->self->priv->id, "") != 0) {
		data->self->priv->secret_key = (data->_tmp5_ = NULL, _g_free0 (data->self->priv->secret_key), data->_tmp5_);
		gnome_keyring_find_network_password (data->self->priv->id, NULL, DEJA_DUP_S3_SERVER, NULL, "https", NULL, (guint32) 0, _deja_dup_backend_s3_found_password_gnome_keyring_operation_get_list_callback, g_object_ref (data->self), g_object_unref);
	} else {
		deja_dup_backend_s3_ask_password (data->self);
	}
	_g_object_unref0 (data->client);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void deja_dup_backend_s3_found_password (DejaDupBackendS3* self, GnomeKeyringResult _result_, GList* list) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (_result_ == GNOME_KEYRING_RESULT_OK) {
		_tmp0_ = list != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char* _tmp1_;
		self->priv->secret_key = (_tmp1_ = g_strdup (((GnomeKeyringNetworkPasswordData*) list->data)->password), _g_free0 (self->priv->secret_key), _tmp1_);
		deja_dup_backend_s3_got_secret_key (self);
	} else {
		deja_dup_backend_s3_ask_password (self);
	}
}


static void deja_dup_backend_s3_save_password_callback (DejaDupBackendS3* self, GnomeKeyringResult _result_, guint32 val) {
	g_return_if_fail (self != NULL);
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static void _deja_dup_backend_s3_save_password_callback_gnome_keyring_operation_get_int_callback (GnomeKeyringResult _result_, guint32 val, gpointer self) {
	deja_dup_backend_s3_save_password_callback (self, _result_, val);
}


static void deja_dup_backend_s3_got_password_reply (DejaDupBackendS3* self, GMountOperation* mount_op, GMountOperationResult _result_) {
	char* _tmp1_;
	char* _tmp2_;
	GPasswordSave remember;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount_op != NULL);
	if (_result_ != G_MOUNT_OPERATION_HANDLED) {
		GList* _tmp0_;
		g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", FALSE, _tmp0_ = NULL, _ ("Permission denied"));
		__g_list_free_g_free0 (_tmp0_);
		return;
	}
	self->priv->id = (_tmp1_ = g_strdup (g_mount_operation_get_username (mount_op)), _g_free0 (self->priv->id), _tmp1_);
	self->priv->secret_key = (_tmp2_ = g_strdup (g_mount_operation_get_password (mount_op)), _g_free0 (self->priv->secret_key), _tmp2_);
	remember = g_mount_operation_get_password_save (mount_op);
	if (remember != G_PASSWORD_SAVE_NEVER) {
		const char* _tmp3_;
		char* where;
		_tmp3_ = NULL;
		if (remember == G_PASSWORD_SAVE_FOR_SESSION) {
			_tmp3_ = "session";
		} else {
			_tmp3_ = GNOME_KEYRING_DEFAULT;
		}
		where = g_strdup (_tmp3_);
		gnome_keyring_set_network_password (where, self->priv->id, NULL, DEJA_DUP_S3_SERVER, NULL, "https", NULL, (guint32) 0, self->priv->secret_key, _deja_dup_backend_s3_save_password_callback_gnome_keyring_operation_get_int_callback, g_object_ref (self), g_object_unref);
		_g_free0 (where);
	}
	deja_dup_backend_s3_got_secret_key (self);
}


static void _deja_dup_backend_s3_got_password_reply_g_mount_operation_reply (GMountOperation* _sender, GMountOperationResult _result_, gpointer self) {
	deja_dup_backend_s3_got_password_reply (self, _sender, _result_);
}


static void deja_dup_backend_s3_ask_password (DejaDupBackendS3* self) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_object_set ((GObject*) deja_dup_backend_get_mount_op ((DejaDupBackend*) self), "label_help", _tmp0_ = g_strdup_printf (_ ("You can sign up for an Amazon S3 account <a href=\"%s\">online</a>."), "http://aws.amazon.com/s3/"), NULL);
	_g_free0 (_tmp0_);
	g_object_set ((GObject*) deja_dup_backend_get_mount_op ((DejaDupBackend*) self), "label_username", _ ("_Access key ID:"), NULL);
	g_object_set ((GObject*) deja_dup_backend_get_mount_op ((DejaDupBackend*) self), "label_password", _ ("_Secret access key:"), NULL);
	g_object_set ((GObject*) deja_dup_backend_get_mount_op ((DejaDupBackend*) self), "label_show_password", _ ("S_how secret access key"), NULL);
	g_object_set ((GObject*) deja_dup_backend_get_mount_op ((DejaDupBackend*) self), "label_remember_password", _ ("_Remember secret access key"), NULL);
	g_signal_connect_object (deja_dup_backend_get_mount_op ((DejaDupBackend*) self), "reply", (GCallback) _deja_dup_backend_s3_got_password_reply_g_mount_operation_reply, self, 0);
	g_signal_emit_by_name (deja_dup_backend_get_mount_op ((DejaDupBackend*) self), "ask-password", _ ("Enter Amazon S3 access key"), self->priv->id, "", (G_ASK_PASSWORD_NEED_PASSWORD | G_ASK_PASSWORD_NEED_USERNAME) | G_ASK_PASSWORD_SAVING_SUPPORTED);
}


static void deja_dup_backend_s3_got_secret_key (DejaDupBackendS3* self) {
	GConfClient* client;
	GList* envp;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	client = deja_dup_get_gconf_client ();
	if (_vala_strcmp0 (self->priv->id, self->priv->gconf_id) != 0) {
		{
			gconf_client_set_string (client, DEJA_DUP_S3_ID_KEY, self->priv->id, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch9_g_error;
			}
		}
		goto __finally9;
		__catch9_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("BackendS3.vala:215: %s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally9:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (client);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	envp = NULL;
	envp = g_list_append (envp, g_strdup_printf ("AWS_ACCESS_KEY_ID=%s", self->priv->id));
	envp = g_list_append (envp, g_strdup_printf ("AWS_SECRET_ACCESS_KEY=%s", self->priv->secret_key));
	g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", TRUE, envp, NULL);
	__g_list_free_g_free0 (envp);
	_g_object_unref0 (client);
}


DejaDupBackendS3* deja_dup_backend_s3_construct (GType object_type) {
	DejaDupBackendS3 * self;
	self = (DejaDupBackendS3*) deja_dup_backend_construct (object_type);
	return self;
}


DejaDupBackendS3* deja_dup_backend_s3_new (void) {
	return deja_dup_backend_s3_construct (DEJA_DUP_TYPE_BACKEND_S3);
}


static void deja_dup_backend_s3_class_init (DejaDupBackendS3Class * klass) {
	deja_dup_backend_s3_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupBackendS3Private));
	DEJA_DUP_BACKEND_CLASS (klass)->clone = deja_dup_backend_s3_real_clone;
	DEJA_DUP_BACKEND_CLASS (klass)->add_argv = deja_dup_backend_s3_real_add_argv;
	DEJA_DUP_BACKEND_CLASS (klass)->is_native = deja_dup_backend_s3_real_is_native;
	DEJA_DUP_BACKEND_CLASS (klass)->is_ready = deja_dup_backend_s3_real_is_ready;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location = deja_dup_backend_s3_real_get_location;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location_pretty = deja_dup_backend_s3_real_get_location_pretty;
	DEJA_DUP_BACKEND_CLASS (klass)->get_envp = deja_dup_backend_s3_real_get_envp;
	DEJA_DUP_BACKEND_CLASS (klass)->get_envp_finish = deja_dup_backend_s3_real_get_envp_finish;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_backend_s3_finalize;
}


static void deja_dup_backend_s3_instance_init (DejaDupBackendS3 * self) {
	self->priv = DEJA_DUP_BACKEND_S3_GET_PRIVATE (self);
}


static void deja_dup_backend_s3_finalize (GObject* obj) {
	DejaDupBackendS3 * self;
	self = DEJA_DUP_BACKEND_S3 (obj);
	_g_free0 (self->priv->gconf_id);
	_g_free0 (self->priv->id);
	_g_free0 (self->priv->secret_key);
	G_OBJECT_CLASS (deja_dup_backend_s3_parent_class)->finalize (obj);
}


GType deja_dup_backend_s3_get_type (void) {
	static volatile gsize deja_dup_backend_s3_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_backend_s3_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendS3Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_s3_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendS3), 0, (GInstanceInitFunc) deja_dup_backend_s3_instance_init, NULL };
		GType deja_dup_backend_s3_type_id;
		deja_dup_backend_s3_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND, "DejaDupBackendS3", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_backend_s3_type_id__volatile, deja_dup_backend_s3_type_id);
	}
	return deja_dup_backend_s3_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




