/* BackendFile.c generated by valac 0.10.0, the Vala compiler
 * generated from BackendFile.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008–2010 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gconf/gconf-client.h>
#include <glib/gi18n-lib.h>


#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;
typedef struct _DejaDupBackendPrivate DejaDupBackendPrivate;

#define DEJA_DUP_OPERATION_TYPE_MODE (deja_dup_operation_mode_get_type ())

#define DEJA_DUP_TYPE_BACKEND_FILE (deja_dup_backend_file_get_type ())
#define DEJA_DUP_BACKEND_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_FILE, DejaDupBackendFile))
#define DEJA_DUP_BACKEND_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_FILE, DejaDupBackendFileClass))
#define DEJA_DUP_IS_BACKEND_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_FILE))
#define DEJA_DUP_IS_BACKEND_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_FILE))
#define DEJA_DUP_BACKEND_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_FILE, DejaDupBackendFileClass))

typedef struct _DejaDupBackendFile DejaDupBackendFile;
typedef struct _DejaDupBackendFileClass DejaDupBackendFileClass;
typedef struct _DejaDupBackendFilePrivate DejaDupBackendFilePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DEJA_DUP_TYPE_DUPLICITY_INFO (deja_dup_duplicity_info_get_type ())
#define DEJA_DUP_DUPLICITY_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfo))
#define DEJA_DUP_DUPLICITY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoClass))
#define DEJA_DUP_IS_DUPLICITY_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO))
#define DEJA_DUP_IS_DUPLICITY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY_INFO))
#define DEJA_DUP_DUPLICITY_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoClass))

typedef struct _DejaDupDuplicityInfo DejaDupDuplicityInfo;
typedef struct _DejaDupDuplicityInfoClass DejaDupDuplicityInfoClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DEJA_DUP_TYPE_NETWORK (deja_dup_network_get_type ())
#define DEJA_DUP_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetwork))
#define DEJA_DUP_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))
#define DEJA_DUP_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))

typedef struct _DejaDupNetwork DejaDupNetwork;
typedef struct _DejaDupNetworkClass DejaDupNetworkClass;
typedef struct _DejaDupBackendFileCheckForVolumeInfoData DejaDupBackendFileCheckForVolumeInfoData;
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))
typedef struct _DejaDupBackendFileGetEnvpData DejaDupBackendFileGetEnvpData;
typedef struct _DejaDupBackendFileMountFileData DejaDupBackendFileMountFileData;
typedef struct _DejaDupBackendFileMountRemoteData DejaDupBackendFileMountRemoteData;
typedef struct _DejaDupBackendFileMountVolumeData DejaDupBackendFileMountVolumeData;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _DejaDupBackendFileWaitForVolumeData DejaDupBackendFileWaitForVolumeData;
typedef struct _DejaDupBackendFileGetSpaceData DejaDupBackendFileGetSpaceData;

typedef enum  {
	DEJA_DUP_OPERATION_MODE_INVALID,
	DEJA_DUP_OPERATION_MODE_BACKUP,
	DEJA_DUP_OPERATION_MODE_RESTORE,
	DEJA_DUP_OPERATION_MODE_STATUS,
	DEJA_DUP_OPERATION_MODE_LIST
} DejaDupOperationMode;

struct _DejaDupBackend {
	GObject parent_instance;
	DejaDupBackendPrivate * priv;
};

struct _DejaDupBackendClass {
	GObjectClass parent_class;
	gboolean (*is_native) (DejaDupBackend* self);
	GIcon* (*get_icon) (DejaDupBackend* self);
	char* (*get_location) (DejaDupBackend* self, GError** error);
	char* (*get_location_pretty) (DejaDupBackend* self, GError** error);
	gboolean (*is_ready) (DejaDupBackend* self, char** when);
	void (*get_envp) (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_envp_finish) (DejaDupBackend* self, GAsyncResult* _res_, GError** error);
	void (*get_space) (DejaDupBackend* self, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint64 (*get_space_finish) (DejaDupBackend* self, GAsyncResult* _res_);
	void (*add_argv) (DejaDupBackend* self, DejaDupOperationMode mode, GList** argv);
	DejaDupBackend* (*clone) (DejaDupBackend* self);
};

struct _DejaDupBackendFile {
	DejaDupBackend parent_instance;
	DejaDupBackendFilePrivate * priv;
};

struct _DejaDupBackendFileClass {
	DejaDupBackendClass parent_class;
};

typedef enum  {
	DEJA_DUP_BACKUP_ERROR_BAD_CONFIG,
	DEJA_DUP_BACKUP_ERROR_ALREADY_RUNNING
} DejaDupBackupError;
#define DEJA_DUP_BACKUP_ERROR deja_dup_backup_error_quark ()
struct _DejaDupBackendFileCheckForVolumeInfoData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GFile* file;
	GConfClient* client;
	GMount* mount;
	GMount* _tmp0_;
	GMount* _tmp1_;
	GError * e;
	GVolume* volume;
	char* uuid;
	gboolean _tmp2_;
	char* relpath;
	char* _tmp3_;
	GError * _inner_error_;
};

struct _DejaDupBackendFileGetEnvpData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	GList* _tmp0_;
	GError * e;
	GError * _inner_error_;
};

struct _DejaDupBackendFileMountFileData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	gboolean success;
	GConfClient* client;
	char* type;
	gboolean _tmp0_;
	GFile* file;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GFile* gfile;
	GList* _tmp4_;
	GError * _inner_error_;
};

struct _DejaDupBackendFileMountRemoteData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	gboolean result;
	GFile* file;
	GMount* mount;
	GError * e;
	gboolean _tmp0_;
	GError * _inner_error_;
};

struct _DejaDupBackendFileMountVolumeData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	gboolean result;
	GConfClient* client;
	char* uuid;
	GVolume* vol;
	GMount* mount;
	gboolean rv;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	DejaDupBackendFile * self;
	GMainLoop* loop;
};

struct _DejaDupBackendFileWaitForVolumeData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	char* uuid;
	GVolume* result;
	GVolume* vol;
	char* name;
	char* _tmp0_;
	GVolumeMonitor* mon;
	GVolume* _tmp1_;
	Block1Data* _data1_;
	GError * _inner_error_;
};

struct _DejaDupBackendFileGetSpaceData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	gboolean free;
	guint64 result;
	const char* _tmp0_;
	char* attr;
	GFile* file;
	GFileInfo* info;
	guint64 space;
	GError * e;
	GError * _inner_error_;
};


extern GConfClient* deja_dup_client;
static gpointer deja_dup_backend_file_parent_class = NULL;

#define DEJA_DUP_FILE_ROOT_KEY "/apps/deja-dup/file"
#define DEJA_DUP_FILE_TYPE_KEY "/apps/deja-dup/file/type"
#define DEJA_DUP_FILE_PATH_KEY "/apps/deja-dup/file/path"
#define DEJA_DUP_FILE_RELPATH_KEY "/apps/deja-dup/file/relpath"
#define DEJA_DUP_FILE_UUID_KEY "/apps/deja-dup/file/uuid"
#define DEJA_DUP_FILE_NAME_KEY "/apps/deja-dup/file/name"
#define DEJA_DUP_FILE_SHORT_NAME_KEY "/apps/deja-dup/file/short_name"
#define DEJA_DUP_FILE_ICON_KEY "/apps/deja-dup/file/icon"
GType deja_dup_backend_get_type (void) G_GNUC_CONST;
GType deja_dup_operation_mode_get_type (void) G_GNUC_CONST;
GType deja_dup_backend_file_get_type (void) G_GNUC_CONST;
enum  {
	DEJA_DUP_BACKEND_FILE_DUMMY_PROPERTY
};
static DejaDupBackend* deja_dup_backend_file_real_clone (DejaDupBackend* base);
DejaDupBackendFile* deja_dup_backend_file_new (void);
DejaDupBackendFile* deja_dup_backend_file_construct (GType object_type);
static GFile* deja_dup_backend_file_get_file_from_gconf (GError** error);
GConfClient* deja_dup_get_gconf_client (void);
static GVolume* deja_dup_backend_file_find_volume_by_uuid (const char* uuid);
static char* deja_dup_backend_file_real_get_location (DejaDupBackend* base, GError** error);
GType deja_dup_duplicity_info_get_type (void) G_GNUC_CONST;
DejaDupDuplicityInfo* deja_dup_duplicity_info_get_default (void);
gboolean deja_dup_duplicity_info_get_has_native_gio (DejaDupDuplicityInfo* self);
GQuark deja_dup_backup_error_quark (void);
static char* deja_dup_backend_file_real_get_location_pretty (DejaDupBackend* base, GError** error);
char* deja_dup_get_file_desc (GFile* file);
static gboolean deja_dup_backend_file_real_is_native (DejaDupBackend* base);
static gboolean deja_dup_backend_file_real_is_ready (DejaDupBackend* base, char** when);
GType deja_dup_network_get_type (void) G_GNUC_CONST;
DejaDupNetwork* deja_dup_network_get (void);
gboolean deja_dup_network_get_connected (DejaDupNetwork* self);
static GIcon* deja_dup_backend_file_real_get_icon (DejaDupBackend* base);
static void deja_dup_backend_file_real_add_argv (DejaDupBackend* base, DejaDupOperationMode mode, GList** argv);
static void deja_dup_backend_file_check_for_volume_info_data_free (gpointer _data);
static void deja_dup_backend_file_check_for_volume_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void deja_dup_backend_file_check_for_volume_info (GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_backend_file_check_for_volume_info_finish (GAsyncResult* _res_, GError** error);
static gboolean deja_dup_backend_file_check_for_volume_info_co (DejaDupBackendFileCheckForVolumeInfoData* data);
static void deja_dup_backend_file_update_volume_info (GVolume* volume, GError** error);
static void deja_dup_backend_file_real_get_envp_data_free (gpointer _data);
static void deja_dup_backend_file_real_get_envp (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_backend_file_get_envp_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean deja_dup_backend_file_real_get_envp_co (DejaDupBackendFileGetEnvpData* data);
static void deja_dup_backend_file_mount_file (DejaDupBackendFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_backend_file_mount_file_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error);
static void _g_list_free_g_free (GList* self);
static void deja_dup_backend_file_mount_file_data_free (gpointer _data);
static void deja_dup_backend_file_mount_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean deja_dup_backend_file_mount_file_co (DejaDupBackendFileMountFileData* data);
static void deja_dup_backend_file_mount_volume (DejaDupBackendFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_file_mount_volume_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error);
static void deja_dup_backend_file_mount_remote (DejaDupBackendFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_file_mount_remote_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error);
static void deja_dup_backend_file_mount_remote_data_free (gpointer _data);
static void deja_dup_backend_file_mount_remote_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean deja_dup_backend_file_mount_remote_co (DejaDupBackendFileMountRemoteData* data);
GMountOperation* deja_dup_backend_get_mount_op (DejaDupBackend* self);
static void deja_dup_backend_file_mount_volume_data_free (gpointer _data);
static void deja_dup_backend_file_mount_volume_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean deja_dup_backend_file_mount_volume_co (DejaDupBackendFileMountVolumeData* data);
static void deja_dup_backend_file_wait_for_volume (DejaDupBackendFile* self, const char* uuid, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GVolume* deja_dup_backend_file_wait_for_volume_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error);
static void _g_list_free_g_object_unref (GList* self);
static void deja_dup_backend_file_wait_for_volume_data_free (gpointer _data);
static void deja_dup_backend_file_wait_for_volume_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean deja_dup_backend_file_wait_for_volume_co (DejaDupBackendFileWaitForVolumeData* data);
static void _lambda11_ (GVolumeMonitor* m, GVolume* v, Block1Data* _data1_);
static void __lambda11__g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void deja_dup_backend_file_real_get_space_data_free (gpointer _data);
static void deja_dup_backend_file_real_get_space (DejaDupBackend* base, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_backend_file_get_space_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean deja_dup_backend_file_real_get_space_co (DejaDupBackendFileGetSpaceData* data);
#define DEJA_DUP_BACKEND_INFINITE_SPACE G_MAXUINT64
DejaDupBackend* deja_dup_backend_construct (GType object_type);
static int _vala_strcmp0 (const char * str1, const char * str2);



static DejaDupBackend* deja_dup_backend_file_real_clone (DejaDupBackend* base) {
	DejaDupBackendFile * self;
	DejaDupBackend* result = NULL;
	self = (DejaDupBackendFile*) base;
	result = (DejaDupBackend*) deja_dup_backend_file_new ();
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GFile* deja_dup_backend_file_get_file_from_gconf (GError** error) {
	GFile* result = NULL;
	GConfClient* client;
	char* type;
	GError * _inner_error_ = NULL;
	client = deja_dup_get_gconf_client ();
	type = gconf_client_get_string (client, DEJA_DUP_FILE_TYPE_KEY, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (client);
		return NULL;
	}
	if (_vala_strcmp0 (type, "volume") == 0) {
		char* path;
		char* uuid;
		GVolume* vol;
		GMount* mount;
		GFile* root;
		path = gconf_client_get_string (client, DEJA_DUP_FILE_RELPATH_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (type);
			_g_object_unref0 (client);
			return NULL;
		}
		uuid = gconf_client_get_string (client, DEJA_DUP_FILE_UUID_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (path);
			_g_free0 (type);
			_g_object_unref0 (client);
			return NULL;
		}
		vol = deja_dup_backend_file_find_volume_by_uuid (uuid);
		if (vol == NULL) {
			result = NULL;
			_g_object_unref0 (vol);
			_g_free0 (uuid);
			_g_free0 (path);
			_g_free0 (type);
			_g_object_unref0 (client);
			return result;
		}
		mount = _g_object_ref0 (g_volume_get_mount (vol));
		if (mount == NULL) {
			result = NULL;
			_g_object_unref0 (mount);
			_g_object_unref0 (vol);
			_g_free0 (uuid);
			_g_free0 (path);
			_g_free0 (type);
			_g_object_unref0 (client);
			return result;
		}
		root = _g_object_ref0 (g_mount_get_root (mount));
		if (path != NULL) {
			result = g_file_get_child (root, path);
			_g_object_unref0 (root);
			_g_object_unref0 (mount);
			_g_object_unref0 (vol);
			_g_free0 (uuid);
			_g_free0 (path);
			_g_free0 (type);
			_g_object_unref0 (client);
			return result;
		} else {
			result = root;
			_g_object_unref0 (mount);
			_g_object_unref0 (vol);
			_g_free0 (uuid);
			_g_free0 (path);
			_g_free0 (type);
			_g_object_unref0 (client);
			return result;
		}
		_g_object_unref0 (root);
		_g_object_unref0 (mount);
		_g_object_unref0 (vol);
		_g_free0 (uuid);
		_g_free0 (path);
	} else {
		char* path;
		path = gconf_client_get_string (client, DEJA_DUP_FILE_PATH_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (type);
			_g_object_unref0 (client);
			return NULL;
		}
		result = _g_object_ref0 (g_file_parse_name (path));
		_g_free0 (path);
		_g_free0 (type);
		_g_object_unref0 (client);
		return result;
	}
	_g_free0 (type);
	_g_object_unref0 (client);
}


static char* deja_dup_backend_file_real_get_location (DejaDupBackend* base, GError** error) {
	DejaDupBackendFile * self;
	char* result = NULL;
	GFile* file;
	DejaDupDuplicityInfo* _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (DejaDupBackendFile*) base;
	file = deja_dup_backend_file_get_file_from_gconf (&_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if ((_tmp1_ = deja_dup_duplicity_info_get_has_native_gio (_tmp0_ = deja_dup_duplicity_info_get_default ()), _g_object_unref0 (_tmp0_), _tmp1_)) {
		result = g_file_get_uri (file);
		_g_object_unref0 (file);
		return result;
	} else {
		char* _tmp2_;
		gboolean _tmp3_;
		char* _tmp4_;
		char* _tmp5_;
		if ((_tmp3_ = (_tmp2_ = g_file_get_path (file)) == NULL, _g_free0 (_tmp2_), _tmp3_)) {
			_inner_error_ = g_error_new_literal (DEJA_DUP_BACKUP_ERROR, DEJA_DUP_BACKUP_ERROR_BAD_CONFIG, _ ("GVFS FUSE is not installed"));
			{
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (file);
				return NULL;
			}
		}
		result = (_tmp5_ = g_strconcat ("file://", _tmp4_ = g_file_get_path (file), NULL), _g_free0 (_tmp4_), _tmp5_);
		_g_object_unref0 (file);
		return result;
	}
	_g_object_unref0 (file);
}


static char* deja_dup_backend_file_real_get_location_pretty (DejaDupBackend* base, GError** error) {
	DejaDupBackendFile * self;
	char* result = NULL;
	GConfClient* client;
	char* type;
	GError * _inner_error_ = NULL;
	self = (DejaDupBackendFile*) base;
	client = deja_dup_get_gconf_client ();
	type = gconf_client_get_string (client, DEJA_DUP_FILE_TYPE_KEY, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (client);
		return NULL;
	}
	if (_vala_strcmp0 (type, "volume") == 0) {
		char* path;
		char* name;
		path = gconf_client_get_string (client, DEJA_DUP_FILE_RELPATH_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (type);
			_g_object_unref0 (client);
			return NULL;
		}
		name = gconf_client_get_string (client, DEJA_DUP_FILE_SHORT_NAME_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (path);
			_g_free0 (type);
			_g_object_unref0 (client);
			return NULL;
		}
		result = g_strdup_printf (_ ("%1$s on %2$s"), path, name);
		_g_free0 (name);
		_g_free0 (path);
		_g_free0 (type);
		_g_object_unref0 (client);
		return result;
	} else {
		GFile* file;
		file = deja_dup_backend_file_get_file_from_gconf (&_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (type);
			_g_object_unref0 (client);
			return NULL;
		}
		result = deja_dup_get_file_desc (file);
		_g_object_unref0 (file);
		_g_free0 (type);
		_g_object_unref0 (client);
		return result;
	}
	_g_free0 (type);
	_g_object_unref0 (client);
}


static gboolean deja_dup_backend_file_real_is_native (DejaDupBackend* base) {
	DejaDupBackendFile * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (DejaDupBackendFile*) base;
	{
		GConfClient* client;
		char* type;
		GFile* file;
		client = deja_dup_get_gconf_client ();
		type = gconf_client_get_string (client, DEJA_DUP_FILE_TYPE_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (client);
			goto __catch0_g_error;
		}
		if (_vala_strcmp0 (type, "volume") == 0) {
			result = TRUE;
			_g_free0 (type);
			_g_object_unref0 (client);
			return result;
		}
		file = deja_dup_backend_file_get_file_from_gconf (&_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (type);
			_g_object_unref0 (client);
			goto __catch0_g_error;
		}
		if (file != NULL) {
			result = g_file_is_native (file);
			_g_object_unref0 (file);
			_g_free0 (type);
			_g_object_unref0 (client);
			return result;
		}
		_g_object_unref0 (file);
		_g_free0 (type);
		_g_object_unref0 (client);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("BackendFile.vala:107: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static gboolean deja_dup_backend_file_real_is_ready (DejaDupBackend* base, char** when) {
	DejaDupBackendFile * self;
	gboolean result = FALSE;
	char* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (DejaDupBackendFile*) base;
	if (when != NULL) {
		*when = NULL;
	}
	*when = (_tmp0_ = NULL, _g_free0 (*when), _tmp0_);
	{
		GFile* file;
		file = deja_dup_backend_file_get_file_from_gconf (&_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		if (file == NULL) {
			char* uuid;
			GVolume* vol;
			uuid = gconf_client_get_string (deja_dup_client, DEJA_DUP_FILE_UUID_KEY, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (file);
				goto __catch1_g_error;
			}
			vol = deja_dup_backend_file_find_volume_by_uuid (uuid);
			if (vol != NULL) {
				result = TRUE;
				_g_object_unref0 (vol);
				_g_free0 (uuid);
				_g_object_unref0 (file);
				return result;
			} else {
				GConfClient* client;
				char* name;
				char* _tmp1_;
				client = deja_dup_get_gconf_client ();
				name = gconf_client_get_string (client, DEJA_DUP_FILE_SHORT_NAME_KEY, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (client);
					_g_object_unref0 (vol);
					_g_free0 (uuid);
					_g_object_unref0 (file);
					goto __catch1_g_error;
				}
				*when = (_tmp1_ = g_strdup_printf (_ ("Backup will begin when %s becomes connected."), name), _g_free0 (*when), _tmp1_);
				result = FALSE;
				_g_free0 (name);
				_g_object_unref0 (client);
				_g_object_unref0 (vol);
				_g_free0 (uuid);
				_g_object_unref0 (file);
				return result;
			}
			_g_object_unref0 (vol);
			_g_free0 (uuid);
		} else {
			if (g_file_is_native (file)) {
				result = TRUE;
				_g_object_unref0 (file);
				return result;
			} else {
				char* _tmp2_;
				DejaDupNetwork* _tmp3_;
				gboolean _tmp4_;
				*when = (_tmp2_ = g_strdup (_ ("Backup will begin when a network connection becomes available.")), _g_free0 (*when), _tmp2_);
				result = (_tmp4_ = deja_dup_network_get_connected (_tmp3_ = deja_dup_network_get ()), _g_object_unref0 (_tmp3_), _tmp4_);
				_g_object_unref0 (file);
				return result;
			}
		}
		_g_object_unref0 (file);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("BackendFile.vala:137: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static GIcon* deja_dup_backend_file_real_get_icon (DejaDupBackend* base) {
	DejaDupBackendFile * self;
	GIcon* result = NULL;
	GError * _inner_error_ = NULL;
	self = (DejaDupBackendFile*) base;
	{
		GConfClient* client;
		char* type;
		client = deja_dup_get_gconf_client ();
		type = gconf_client_get_string (client, DEJA_DUP_FILE_TYPE_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (client);
			goto __catch2_g_error;
		}
		if (_vala_strcmp0 (type, "volume") == 0) {
			char* icon_str;
			GIcon* _tmp0_;
			icon_str = gconf_client_get_string (client, DEJA_DUP_FILE_ICON_KEY, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (type);
				_g_object_unref0 (client);
				goto __catch2_g_error;
			}
			_tmp0_ = g_icon_new_for_string (icon_str, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (icon_str);
				_g_free0 (type);
				_g_object_unref0 (client);
				goto __catch2_g_error;
			}
			result = _g_object_ref0 (_tmp0_);
			_g_free0 (icon_str);
			_g_free0 (type);
			_g_object_unref0 (client);
			return result;
		} else {
			GFile* file;
			GFileInfo* info;
			file = deja_dup_backend_file_get_file_from_gconf (&_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (type);
				_g_object_unref0 (client);
				goto __catch2_g_error;
			}
			info = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_ICON, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (file);
				_g_free0 (type);
				_g_object_unref0 (client);
				goto __catch2_g_error;
			}
			result = _g_object_ref0 (g_file_info_get_icon (info));
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			_g_free0 (type);
			_g_object_unref0 (client);
			return result;
		}
		_g_free0 (type);
		_g_object_unref0 (client);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("BackendFile.vala:159: %s\n", e->message);
			result = NULL;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally2:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void deja_dup_backend_file_real_add_argv (DejaDupBackend* base, DejaDupOperationMode mode, GList** argv) {
	DejaDupBackendFile * self;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DejaDupBackendFile*) base;
	if (mode == DEJA_DUP_OPERATION_MODE_BACKUP) {
		{
			GFile* file;
			gboolean _tmp0_ = FALSE;
			file = deja_dup_backend_file_get_file_from_gconf (&_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
			if (file != NULL) {
				_tmp0_ = g_file_is_native (file);
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				char* _tmp1_;
				*argv = g_list_prepend (*argv, g_strdup_printf ("--exclude=%s", _tmp1_ = g_file_get_path (file)));
				_g_free0 (_tmp1_);
			}
			_g_object_unref0 (file);
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("BackendFile.vala:174: %s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally3:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (mode == DEJA_DUP_OPERATION_MODE_INVALID) {
		DejaDupDuplicityInfo* _tmp3_;
		_tmp2_ = deja_dup_duplicity_info_get_has_native_gio (_tmp3_ = deja_dup_duplicity_info_get_default ());
		_g_object_unref0 (_tmp3_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		*argv = g_list_prepend (*argv, g_strdup ("--gio"));
	}
}


static void deja_dup_backend_file_check_for_volume_info_data_free (gpointer _data) {
	DejaDupBackendFileCheckForVolumeInfoData* data;
	data = _data;
	_g_object_unref0 (data->file);
	g_slice_free (DejaDupBackendFileCheckForVolumeInfoData, data);
}


void deja_dup_backend_file_check_for_volume_info (GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFileCheckForVolumeInfoData* _data_;
	_data_ = g_slice_new0 (DejaDupBackendFileCheckForVolumeInfoData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, deja_dup_backend_file_check_for_volume_info);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_check_for_volume_info_data_free);
	_data_->file = _g_object_ref0 (file);
	deja_dup_backend_file_check_for_volume_info_co (_data_);
}


void deja_dup_backend_file_check_for_volume_info_finish (GAsyncResult* _res_, GError** error) {
	DejaDupBackendFileCheckForVolumeInfoData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_backend_file_check_for_volume_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileCheckForVolumeInfoData* data;
	data = _user_data_;
	data->_res_ = _res_;
	deja_dup_backend_file_check_for_volume_info_co (data);
}


static gboolean deja_dup_backend_file_check_for_volume_info_co (DejaDupBackendFileCheckForVolumeInfoData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 1:
		goto _state_1;
	}
	_state_0:
	data->client = deja_dup_get_gconf_client ();
	if (!g_file_is_native (data->file)) {
		gconf_client_set_string (data->client, DEJA_DUP_FILE_TYPE_KEY, "normal", &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->client);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		_g_object_unref0 (data->client);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	if (!g_file_query_exists (data->file, NULL)) {
		_g_object_unref0 (data->client);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->mount = NULL;
	{
		data->_state_ = 1;
		g_file_find_enclosing_mount_async (data->file, G_PRIORITY_DEFAULT, NULL, deja_dup_backend_file_check_for_volume_info_ready, data);
		return FALSE;
		_state_1:
		data->_tmp0_ = g_file_find_enclosing_mount_finish (data->file, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		data->mount = (data->_tmp1_ = data->_tmp0_, _g_object_unref0 (data->mount), data->_tmp1_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			_g_error_free0 (data->e);
		}
	}
	__finally4:
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->mount);
		_g_object_unref0 (data->client);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	if (data->mount == NULL) {
		gconf_client_set_string (data->client, DEJA_DUP_FILE_TYPE_KEY, "normal", &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->mount);
			_g_object_unref0 (data->client);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		_g_object_unref0 (data->mount);
		_g_object_unref0 (data->client);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->volume = _g_object_ref0 (g_mount_get_volume (data->mount));
	if (data->volume == NULL) {
		_g_object_unref0 (data->volume);
		_g_object_unref0 (data->mount);
		_g_object_unref0 (data->client);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->uuid = g_strdup (g_volume_get_identifier (data->volume, G_VOLUME_IDENTIFIER_KIND_UUID));
	if (data->uuid == NULL) {
		data->_tmp2_ = TRUE;
	} else {
		data->_tmp2_ = _vala_strcmp0 (data->uuid, "") == 0;
	}
	if (data->_tmp2_) {
		_g_free0 (data->uuid);
		_g_object_unref0 (data->volume);
		_g_object_unref0 (data->mount);
		_g_object_unref0 (data->client);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->relpath = g_file_get_relative_path (g_mount_get_root (data->mount), data->file);
	if (data->relpath == NULL) {
		data->relpath = (data->_tmp3_ = g_strdup (""), _g_free0 (data->relpath), data->_tmp3_);
	}
	gconf_client_set_string (data->client, DEJA_DUP_FILE_UUID_KEY, data->uuid, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_free0 (data->relpath);
		_g_free0 (data->uuid);
		_g_object_unref0 (data->volume);
		_g_object_unref0 (data->mount);
		_g_object_unref0 (data->client);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	gconf_client_set_string (data->client, DEJA_DUP_FILE_RELPATH_KEY, data->relpath, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_free0 (data->relpath);
		_g_free0 (data->uuid);
		_g_object_unref0 (data->volume);
		_g_object_unref0 (data->mount);
		_g_object_unref0 (data->client);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	gconf_client_set_string (data->client, DEJA_DUP_FILE_TYPE_KEY, "volume", &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_free0 (data->relpath);
		_g_free0 (data->uuid);
		_g_object_unref0 (data->volume);
		_g_object_unref0 (data->mount);
		_g_object_unref0 (data->client);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	deja_dup_backend_file_update_volume_info (data->volume, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_free0 (data->relpath);
		_g_free0 (data->uuid);
		_g_object_unref0 (data->volume);
		_g_object_unref0 (data->mount);
		_g_object_unref0 (data->client);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	_g_free0 (data->relpath);
	_g_free0 (data->uuid);
	_g_object_unref0 (data->volume);
	_g_object_unref0 (data->mount);
	_g_object_unref0 (data->client);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void deja_dup_backend_file_update_volume_info (GVolume* volume, GError** error) {
	GConfClient* client;
	char* name;
	gboolean _tmp0_ = FALSE;
	char* short_name;
	GDrive* drive;
	GIcon* icon;
	char* icon_str;
	GMount* mount;
	GError * _inner_error_ = NULL;
	g_return_if_fail (volume != NULL);
	client = deja_dup_get_gconf_client ();
	name = g_strdup (g_volume_get_name (volume));
	if (name == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (name, "") == 0;
	}
	if (_tmp0_) {
		_g_free0 (name);
		_g_object_unref0 (client);
		return;
	}
	short_name = g_strdup (name);
	drive = _g_object_ref0 (g_volume_get_drive (volume));
	if (drive != NULL) {
		char* drive_name;
		gboolean _tmp1_ = FALSE;
		drive_name = g_strdup (g_drive_get_name (drive));
		if (drive_name != NULL) {
			_tmp1_ = _vala_strcmp0 (drive_name, "") != 0;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			char* _tmp2_;
			name = (_tmp2_ = g_strdup_printf ("%s: %s", drive_name, name), _g_free0 (name), _tmp2_);
		}
		_g_free0 (drive_name);
	}
	icon = _g_object_ref0 (g_volume_get_icon (volume));
	icon_str = NULL;
	if (icon != NULL) {
		char* _tmp3_;
		icon_str = (_tmp3_ = g_icon_to_string (icon), _g_free0 (icon_str), _tmp3_);
	}
	gconf_client_set_string (client, DEJA_DUP_FILE_NAME_KEY, name, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (icon_str);
		_g_object_unref0 (icon);
		_g_object_unref0 (drive);
		_g_free0 (short_name);
		_g_free0 (name);
		_g_object_unref0 (client);
		return;
	}
	gconf_client_set_string (client, DEJA_DUP_FILE_SHORT_NAME_KEY, short_name, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (icon_str);
		_g_object_unref0 (icon);
		_g_object_unref0 (drive);
		_g_free0 (short_name);
		_g_free0 (name);
		_g_object_unref0 (client);
		return;
	}
	gconf_client_set_string (client, DEJA_DUP_FILE_ICON_KEY, icon_str, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (icon_str);
		_g_object_unref0 (icon);
		_g_object_unref0 (drive);
		_g_free0 (short_name);
		_g_free0 (name);
		_g_object_unref0 (client);
		return;
	}
	mount = _g_object_ref0 (g_volume_get_mount (volume));
	if (mount != NULL) {
		char* path;
		path = gconf_client_get_string (client, DEJA_DUP_FILE_RELPATH_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (mount);
			_g_free0 (icon_str);
			_g_object_unref0 (icon);
			_g_object_unref0 (drive);
			_g_free0 (short_name);
			_g_free0 (name);
			_g_object_unref0 (client);
			return;
		}
		if (path != NULL) {
			GFile* _tmp4_;
			char* _tmp5_;
			path = (_tmp5_ = g_file_get_parse_name (_tmp4_ = g_file_get_child (g_mount_get_root (mount), path)), _g_free0 (path), _tmp5_);
			_g_object_unref0 (_tmp4_);
		}
		gconf_client_set_string (client, DEJA_DUP_FILE_PATH_KEY, path, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (path);
			_g_object_unref0 (mount);
			_g_free0 (icon_str);
			_g_object_unref0 (icon);
			_g_object_unref0 (drive);
			_g_free0 (short_name);
			_g_free0 (name);
			_g_object_unref0 (client);
			return;
		}
		_g_free0 (path);
	}
	_g_object_unref0 (mount);
	_g_free0 (icon_str);
	_g_object_unref0 (icon);
	_g_object_unref0 (drive);
	_g_free0 (short_name);
	_g_free0 (name);
	_g_object_unref0 (client);
}


static void deja_dup_backend_file_real_get_envp_data_free (gpointer _data) {
	DejaDupBackendFileGetEnvpData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (DejaDupBackendFileGetEnvpData, data);
}


static void deja_dup_backend_file_real_get_envp (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFile * self;
	DejaDupBackendFileGetEnvpData* _data_;
	self = (DejaDupBackendFile*) base;
	_data_ = g_slice_new0 (DejaDupBackendFileGetEnvpData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_real_get_envp);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_real_get_envp_data_free);
	_data_->self = g_object_ref (self);
	deja_dup_backend_file_real_get_envp_co (_data_);
}


static void deja_dup_backend_file_real_get_envp_finish (DejaDupBackend* base, GAsyncResult* _res_, GError** error) {
	DejaDupBackendFileGetEnvpData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_backend_file_get_envp_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileGetEnvpData* data;
	data = _user_data_;
	data->_res_ = _res_;
	deja_dup_backend_file_real_get_envp_co (data);
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static gboolean deja_dup_backend_file_real_get_envp_co (DejaDupBackendFileGetEnvpData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 2:
		goto _state_2;
	}
	_state_0:
	{
		data->_state_ = 2;
		deja_dup_backend_file_mount_file (data->self, deja_dup_backend_file_get_envp_ready, data);
		return FALSE;
		_state_2:
		deja_dup_backend_file_mount_file_finish (data->self, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			g_signal_emit_by_name ((DejaDupBackend*) data->self, "envp-ready", FALSE, data->_tmp0_ = NULL, data->e->message);
			__g_list_free_g_free0 (data->_tmp0_);
			_g_error_free0 (data->e);
		}
	}
	__finally5:
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void deja_dup_backend_file_mount_file_data_free (gpointer _data) {
	DejaDupBackendFileMountFileData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (DejaDupBackendFileMountFileData, data);
}


static void deja_dup_backend_file_mount_file (DejaDupBackendFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFileMountFileData* _data_;
	_data_ = g_slice_new0 (DejaDupBackendFileMountFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_mount_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_mount_file_data_free);
	_data_->self = g_object_ref (self);
	deja_dup_backend_file_mount_file_co (_data_);
}


static void deja_dup_backend_file_mount_file_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error) {
	DejaDupBackendFileMountFileData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_backend_file_mount_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileMountFileData* data;
	data = _user_data_;
	data->_res_ = _res_;
	deja_dup_backend_file_mount_file_co (data);
}


static gboolean deja_dup_backend_file_mount_file_co (DejaDupBackendFileMountFileData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
	}
	_state_0:
	g_object_ref ((GObject*) data->self);
	data->success = TRUE;
	data->client = deja_dup_get_gconf_client ();
	data->type = gconf_client_get_string (data->client, DEJA_DUP_FILE_TYPE_KEY, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->client);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	if (_vala_strcmp0 (data->type, "volume") == 0) {
		data->_state_ = 3;
		deja_dup_backend_file_mount_volume (data->self, deja_dup_backend_file_mount_file_ready, data);
		return FALSE;
		_state_3:
		data->_tmp0_ = deja_dup_backend_file_mount_volume_finish (data->self, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->type);
			_g_object_unref0 (data->client);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->success = data->_tmp0_;
	} else {
		if (_vala_strcmp0 (data->type, "normal") == 0) {
			data->file = deja_dup_backend_file_get_file_from_gconf (&data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_free0 (data->type);
				_g_object_unref0 (data->client);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			if (!g_file_is_native (data->file)) {
				data->_state_ = 4;
				deja_dup_backend_file_mount_remote (data->self, deja_dup_backend_file_mount_file_ready, data);
				return FALSE;
				_state_4:
				data->_tmp1_ = deja_dup_backend_file_mount_remote_finish (data->self, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->file);
					_g_free0 (data->type);
					_g_object_unref0 (data->client);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
				data->success = data->_tmp1_;
			}
			_g_object_unref0 (data->file);
		}
	}
	if (_vala_strcmp0 (data->type, "volume") != 0) {
		data->_tmp3_ = _vala_strcmp0 (data->type, "normal") != 0;
	} else {
		data->_tmp3_ = FALSE;
	}
	if (data->_tmp3_) {
		data->_tmp2_ = data->success;
	} else {
		data->_tmp2_ = FALSE;
	}
	if (data->_tmp2_) {
		data->gfile = deja_dup_backend_file_get_file_from_gconf (&data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->type);
			_g_object_unref0 (data->client);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->_state_ = 5;
		deja_dup_backend_file_check_for_volume_info (data->gfile, deja_dup_backend_file_mount_file_ready, data);
		return FALSE;
		_state_5:
		deja_dup_backend_file_check_for_volume_info_finish (data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->gfile);
			_g_free0 (data->type);
			_g_object_unref0 (data->client);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		_g_object_unref0 (data->gfile);
	}
	g_signal_emit_by_name ((DejaDupBackend*) data->self, "envp-ready", data->success, data->_tmp4_ = NULL, NULL);
	__g_list_free_g_free0 (data->_tmp4_);
	g_object_unref ((GObject*) data->self);
	_g_free0 (data->type);
	_g_object_unref0 (data->client);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void deja_dup_backend_file_mount_remote_data_free (gpointer _data) {
	DejaDupBackendFileMountRemoteData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (DejaDupBackendFileMountRemoteData, data);
}


static void deja_dup_backend_file_mount_remote (DejaDupBackendFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFileMountRemoteData* _data_;
	_data_ = g_slice_new0 (DejaDupBackendFileMountRemoteData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_mount_remote);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_mount_remote_data_free);
	_data_->self = g_object_ref (self);
	deja_dup_backend_file_mount_remote_co (_data_);
}


static gboolean deja_dup_backend_file_mount_remote_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	DejaDupBackendFileMountRemoteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void deja_dup_backend_file_mount_remote_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileMountRemoteData* data;
	data = _user_data_;
	data->_res_ = _res_;
	deja_dup_backend_file_mount_remote_co (data);
}


static gboolean deja_dup_backend_file_mount_remote_co (DejaDupBackendFileMountRemoteData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
	}
	_state_0:
	data->file = deja_dup_backend_file_get_file_from_gconf (&data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		data->_state_ = 6;
		g_file_find_enclosing_mount_async (data->file, G_PRIORITY_DEFAULT, NULL, deja_dup_backend_file_mount_remote_ready, data);
		return FALSE;
		_state_6:
		data->mount = g_file_find_enclosing_mount_finish (data->file, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		if (data->mount != NULL) {
			data->result = TRUE;
			_g_object_unref0 (data->mount);
			_g_object_unref0 (data->file);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		_g_object_unref0 (data->mount);
	}
	goto __finally6;
	__catch6_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			_g_error_free0 (data->e);
		}
	}
	__finally6:
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->file);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->_state_ = 7;
	g_file_mount_enclosing_volume (data->file, G_MOUNT_MOUNT_NONE, deja_dup_backend_get_mount_op ((DejaDupBackend*) data->self), NULL, deja_dup_backend_file_mount_remote_ready, data);
	return FALSE;
	_state_7:
	data->_tmp0_ = g_file_mount_enclosing_volume_finish (data->file, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->file);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->result = data->_tmp0_;
	_g_object_unref0 (data->file);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->file);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void deja_dup_backend_file_mount_volume_data_free (gpointer _data) {
	DejaDupBackendFileMountVolumeData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (DejaDupBackendFileMountVolumeData, data);
}


static void deja_dup_backend_file_mount_volume (DejaDupBackendFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFileMountVolumeData* _data_;
	_data_ = g_slice_new0 (DejaDupBackendFileMountVolumeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_mount_volume);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_mount_volume_data_free);
	_data_->self = g_object_ref (self);
	deja_dup_backend_file_mount_volume_co (_data_);
}


static gboolean deja_dup_backend_file_mount_volume_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	DejaDupBackendFileMountVolumeData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void deja_dup_backend_file_mount_volume_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileMountVolumeData* data;
	data = _user_data_;
	data->_res_ = _res_;
	deja_dup_backend_file_mount_volume_co (data);
}


static gboolean deja_dup_backend_file_mount_volume_co (DejaDupBackendFileMountVolumeData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 8:
		goto _state_8;
		case 9:
		goto _state_9;
	}
	_state_0:
	data->client = deja_dup_get_gconf_client ();
	data->uuid = gconf_client_get_string (data->client, DEJA_DUP_FILE_UUID_KEY, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->client);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->_state_ = 8;
	deja_dup_backend_file_wait_for_volume (data->self, data->uuid, deja_dup_backend_file_mount_volume_ready, data);
	return FALSE;
	_state_8:
	data->vol = deja_dup_backend_file_wait_for_volume_finish (data->self, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_free0 (data->uuid);
		_g_object_unref0 (data->client);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->mount = _g_object_ref0 (g_volume_get_mount (data->vol));
	if (data->mount != NULL) {
		deja_dup_backend_file_update_volume_info (data->vol, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->mount);
			_g_object_unref0 (data->vol);
			_g_free0 (data->uuid);
			_g_object_unref0 (data->client);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->result = TRUE;
		_g_object_unref0 (data->mount);
		_g_object_unref0 (data->vol);
		_g_free0 (data->uuid);
		_g_object_unref0 (data->client);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->_state_ = 9;
	g_volume_mount (data->vol, G_MOUNT_MOUNT_NONE, deja_dup_backend_get_mount_op ((DejaDupBackend*) data->self), NULL, deja_dup_backend_file_mount_volume_ready, data);
	return FALSE;
	_state_9:
	data->rv = g_volume_mount_finish (data->vol, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->mount);
		_g_object_unref0 (data->vol);
		_g_free0 (data->uuid);
		_g_object_unref0 (data->client);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	if (data->rv) {
		deja_dup_backend_file_update_volume_info (data->vol, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->mount);
			_g_object_unref0 (data->vol);
			_g_free0 (data->uuid);
			_g_object_unref0 (data->client);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
	}
	data->result = data->rv;
	_g_object_unref0 (data->mount);
	_g_object_unref0 (data->vol);
	_g_free0 (data->uuid);
	_g_object_unref0 (data->client);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->mount);
	_g_object_unref0 (data->vol);
	_g_free0 (data->uuid);
	_g_object_unref0 (data->client);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static GVolume* deja_dup_backend_file_find_volume_by_uuid (const char* uuid) {
	GVolume* result = NULL;
	GVolumeMonitor* mon;
	GList* vols;
	g_return_val_if_fail (uuid != NULL, NULL);
	mon = g_volume_monitor_get ();
	g_object_ref ((GObject*) mon);
	vols = g_volume_monitor_get_volumes (mon);
	{
		GList* v_collection;
		GList* v_it;
		v_collection = vols;
		for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
			GVolume* v;
			v = _g_object_ref0 ((GVolume*) v_it->data);
			{
				if (_vala_strcmp0 (g_volume_get_identifier (v, G_VOLUME_IDENTIFIER_KIND_UUID), uuid) == 0) {
					result = v;
					__g_list_free_g_object_unref0 (vols);
					_g_object_unref0 (mon);
					return result;
				}
				_g_object_unref0 (v);
			}
		}
	}
	result = NULL;
	__g_list_free_g_object_unref0 (vols);
	_g_object_unref0 (mon);
	return result;
}


static void deja_dup_backend_file_wait_for_volume_data_free (gpointer _data) {
	DejaDupBackendFileWaitForVolumeData* data;
	data = _data;
	_g_free0 (data->uuid);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (DejaDupBackendFileWaitForVolumeData, data);
}


static void deja_dup_backend_file_wait_for_volume (DejaDupBackendFile* self, const char* uuid, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFileWaitForVolumeData* _data_;
	_data_ = g_slice_new0 (DejaDupBackendFileWaitForVolumeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_wait_for_volume);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_wait_for_volume_data_free);
	_data_->self = g_object_ref (self);
	_data_->uuid = g_strdup (uuid);
	deja_dup_backend_file_wait_for_volume_co (_data_);
}


static GVolume* deja_dup_backend_file_wait_for_volume_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error) {
	GVolume* result;
	DejaDupBackendFileWaitForVolumeData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void deja_dup_backend_file_wait_for_volume_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileWaitForVolumeData* data;
	data = _user_data_;
	data->_res_ = _res_;
	deja_dup_backend_file_wait_for_volume_co (data);
}


static void _lambda11_ (GVolumeMonitor* m, GVolume* v, Block1Data* _data1_) {
	DejaDupBackendFile * self;
	self = _data1_->self;
	g_return_if_fail (m != NULL);
	g_return_if_fail (v != NULL);
	g_main_loop_quit (_data1_->loop);
}


static void __lambda11__g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	_lambda11_ (_sender, volume, self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean deja_dup_backend_file_wait_for_volume_co (DejaDupBackendFileWaitForVolumeData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 10:
		goto _state_10;
	}
	_state_0:
	data->vol = deja_dup_backend_file_find_volume_by_uuid (data->uuid);
	if (data->vol == NULL) {
		data->_data1_ = g_slice_new0 (Block1Data);
		data->_data1_->_ref_count_ = 1;
		data->_data1_->self = g_object_ref (data->self);
		data->name = gconf_client_get_string (deja_dup_client, DEJA_DUP_FILE_NAME_KEY, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			block1_data_unref (data->_data1_);
			_g_object_unref0 (data->vol);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		g_signal_emit_by_name ((DejaDupBackend*) data->self, "pause-op", _ ("Backup location not available"), data->_tmp0_ = g_strdup_printf (_ ("Waiting for ‘%s’ to become connected…"), data->name));
		_g_free0 (data->_tmp0_);
		data->_data1_->loop = g_main_loop_new (NULL, FALSE);
		data->mon = g_volume_monitor_get ();
		g_object_ref ((GObject*) data->mon);
		g_signal_connect_data (data->mon, "volume-added", (GCallback) __lambda11__g_volume_monitor_volume_added, block1_data_ref (data->_data1_), (GClosureNotify) block1_data_unref, 0);
		g_main_loop_run (data->_data1_->loop);
		data->_state_ = 10;
		deja_dup_backend_file_wait_for_volume (data->self, data->uuid, deja_dup_backend_file_wait_for_volume_ready, data);
		return FALSE;
		_state_10:
		data->_tmp1_ = deja_dup_backend_file_wait_for_volume_finish (data->self, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->mon);
			_g_free0 (data->name);
			block1_data_unref (data->_data1_);
			_g_object_unref0 (data->vol);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->result = data->_tmp1_;
		_g_object_unref0 (data->mon);
		_g_free0 (data->name);
		block1_data_unref (data->_data1_);
		_g_object_unref0 (data->vol);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_object_unref0 (data->mon);
		_g_free0 (data->name);
		block1_data_unref (data->_data1_);
	}
	data->result = data->vol;
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->vol);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void deja_dup_backend_file_real_get_space_data_free (gpointer _data) {
	DejaDupBackendFileGetSpaceData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (DejaDupBackendFileGetSpaceData, data);
}


static void deja_dup_backend_file_real_get_space (DejaDupBackend* base, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFile * self;
	DejaDupBackendFileGetSpaceData* _data_;
	self = (DejaDupBackendFile*) base;
	_data_ = g_slice_new0 (DejaDupBackendFileGetSpaceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_real_get_space);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_real_get_space_data_free);
	_data_->self = g_object_ref (self);
	_data_->free = free;
	deja_dup_backend_file_real_get_space_co (_data_);
}


static guint64 deja_dup_backend_file_real_get_space_finish (DejaDupBackend* base, GAsyncResult* _res_) {
	guint64 result;
	DejaDupBackendFileGetSpaceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void deja_dup_backend_file_get_space_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileGetSpaceData* data;
	data = _user_data_;
	data->_res_ = _res_;
	deja_dup_backend_file_real_get_space_co (data);
}


static gboolean deja_dup_backend_file_real_get_space_co (DejaDupBackendFileGetSpaceData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 11:
		goto _state_11;
	}
	_state_0:
	if (data->free) {
		data->_tmp0_ = G_FILE_ATTRIBUTE_FILESYSTEM_FREE;
	} else {
		data->_tmp0_ = G_FILE_ATTRIBUTE_FILESYSTEM_SIZE;
	}
	data->attr = g_strdup (data->_tmp0_);
	{
		data->file = deja_dup_backend_file_get_file_from_gconf (&data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		data->_state_ = 11;
		g_file_query_filesystem_info_async (data->file, data->attr, G_PRIORITY_DEFAULT, NULL, deja_dup_backend_file_get_space_ready, data);
		return FALSE;
		_state_11:
		data->info = _g_object_ref0 (g_file_query_filesystem_info_finish (data->file, data->_res_, &data->_inner_error_));
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->file);
			goto __catch7_g_error;
		}
		data->space = g_file_info_get_attribute_uint64 (data->info, data->attr);
		if (data->space == DEJA_DUP_BACKEND_INFINITE_SPACE) {
			data->result = data->space - 1;
			_g_object_unref0 (data->info);
			_g_object_unref0 (data->file);
			_g_free0 (data->attr);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			data->result = data->space;
			_g_object_unref0 (data->info);
			_g_object_unref0 (data->file);
			_g_free0 (data->attr);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		_g_object_unref0 (data->info);
		_g_object_unref0 (data->file);
	}
	goto __finally7;
	__catch7_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			g_warning ("BackendFile.vala:378: %s\n", data->e->message);
			data->result = DEJA_DUP_BACKEND_INFINITE_SPACE;
			_g_error_free0 (data->e);
			_g_free0 (data->attr);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_error_free0 (data->e);
		}
	}
	__finally7:
	{
		_g_free0 (data->attr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_free0 (data->attr);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


DejaDupBackendFile* deja_dup_backend_file_construct (GType object_type) {
	DejaDupBackendFile * self;
	self = (DejaDupBackendFile*) deja_dup_backend_construct (object_type);
	return self;
}


DejaDupBackendFile* deja_dup_backend_file_new (void) {
	return deja_dup_backend_file_construct (DEJA_DUP_TYPE_BACKEND_FILE);
}


static void deja_dup_backend_file_class_init (DejaDupBackendFileClass * klass) {
	deja_dup_backend_file_parent_class = g_type_class_peek_parent (klass);
	DEJA_DUP_BACKEND_CLASS (klass)->clone = deja_dup_backend_file_real_clone;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location = deja_dup_backend_file_real_get_location;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location_pretty = deja_dup_backend_file_real_get_location_pretty;
	DEJA_DUP_BACKEND_CLASS (klass)->is_native = deja_dup_backend_file_real_is_native;
	DEJA_DUP_BACKEND_CLASS (klass)->is_ready = deja_dup_backend_file_real_is_ready;
	DEJA_DUP_BACKEND_CLASS (klass)->get_icon = deja_dup_backend_file_real_get_icon;
	DEJA_DUP_BACKEND_CLASS (klass)->add_argv = deja_dup_backend_file_real_add_argv;
	DEJA_DUP_BACKEND_CLASS (klass)->get_envp = deja_dup_backend_file_real_get_envp;
	DEJA_DUP_BACKEND_CLASS (klass)->get_envp_finish = deja_dup_backend_file_real_get_envp_finish;
	DEJA_DUP_BACKEND_CLASS (klass)->get_space = deja_dup_backend_file_real_get_space;
	DEJA_DUP_BACKEND_CLASS (klass)->get_space_finish = deja_dup_backend_file_real_get_space_finish;
}


static void deja_dup_backend_file_instance_init (DejaDupBackendFile * self) {
}


GType deja_dup_backend_file_get_type (void) {
	static volatile gsize deja_dup_backend_file_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_backend_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendFile), 0, (GInstanceInitFunc) deja_dup_backend_file_instance_init, NULL };
		GType deja_dup_backend_file_type_id;
		deja_dup_backend_file_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND, "DejaDupBackendFile", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_backend_file_type_id__volatile, deja_dup_backend_file_type_id);
	}
	return deja_dup_backend_file_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




