#ifndef __set_h__
#define __set_h__


#include <stdbool.h>
#include <stdio.h>
#include <string.h>
#include <sys/select.h>


typedef fd_set Set;
extern const Set empty_set;

#define EMPTY_SET -1

#define clear_set(set) FD_ZERO(set)
#define add_element(set,element) FD_SET(element,set)
#define remove_element(set,element) FD_CLR(element,set)
#define contains_element(set,element) FD_ISSET(element,set)
#define equals(left,right) (memcmp(left,right,sizeof*left)==0)
#define is_empty(set) equals(set,&empty_set)

void print_set( const Set* set);
void read_set( Set* set, FILE* file);
void add_set( Set* left, const Set* right);
int remove_first_element( Set* set);
bool intersects( const Set* left, const Set* right);
int first_intersection( const Set* left, const Set* right);


#endif
