/**
 * DFA driven grammar.
 * @author Shaun Jackman <sdj@sfu.ca>
 * @copyright Copyright 2004 Shaun Jackman
 */


#include <stdio.h>
#include "grammar.h"
#include "dfa.h"
#include "nfa.h"
#include "regex.h"


/** Prints this grammar. */
void
print_grammar( Grammar* grammar)
{
	int i;
	for( i = 0; i < grammar->count; i++)
		printf( "%s\n", grammar->tokens[i]);
	print_dfa( &grammar->dfa);
}


/** Reads a grammar from the specified file. */
void
read_grammar( Grammar* grammar, FILE* file)
{
	NFA nfa;
	clear_nfa( &nfa);
	for( grammar->count = 0; grammar->count < DEFINITIONS;
			grammar->count++) {
		RegEx* regex;
		if( fscanf( file, "%s ",
					grammar->tokens[grammar->count]) != 1)
			break;
		regex = parse_regex( file);
		compile_regex( &nfa, regex, grammar->count);
		destroy_regex( regex);
	}
	compile_nfa( &grammar->dfa, &nfa);
}
