# Debreaper
# copyright (c) 2007 Josselin Mouette
# Licensed under the GPL (v2 only)

import sys
sys.path.append("/usr/share/reportbug")
import reportbug

bug_version = reportbug.VERSION_NUMBER

def lookup_package (path):
  (foundfile, packages) = reportbug.find_package_for (path)
  # If there is ever more than one package, pick the first
  try:
    package = iter(packages).next()
  except StopIteration:
    return None

  return reportbug.get_package_status(package)

def generate_report (package, pkgversion, depends, recommends, path, gdbout):
  depinfo=""
  if (depends or recommends):
    depinfo = (reportbug.get_dependency_info(package, depends) +
               reportbug.get_dependency_info(package, recommends, "recommends"))

  return reportbug.generate_blank_report (package, pkgversion, 'important', None, depinfo, '', path, body="*** Please describe what you were doing when the application crashed ***\n\n"+gdbout)

