# debpartial-mirror - partial debian mirror package tool
# (c) 2004 Otavio Salvador <otavio@debian.org>, Henrique Vilela <jacare@ucpel.tche.br>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
# $Id$

# Store in a tree, all know packages.
#
# needed param is in fallowing format:
#  { localfile1 [ filter1, filter2 ], ...}
#

import re
import sys

import Package

class RemotePackages:
    def __init__(self, needed, removes, getSuggests, getRecomends, getProvides):
        print 'Processing remote packages ...'
        
        self.__getSuggests = getSuggests
        self.__getRecomends = getRecomends
        self.__getProvides = getProvides
        self.__remote_packages = {}
        self.__selected_packages = {}
        self.__provided_or_replaced_packages = {}

        for filename in needed.keys():
            try:
                f = file(filename,'r')
            except IOError, msg:
                print msg
                sys.exit(1)

            for line in f.readlines():
                line = line[:-1] # remove the <newline>

                field = line.split(':',1)[0]
                if field != '' and (field == 'Description' or field[0] == ' '): continue
                if field == '':
                    if not self.__remote_packages.has_key(filename):
                        self.__remote_packages[filename] = {}
                    self.__remote_packages[filename][p.getName()] = p
                else:
                    value = line.split(':',1)[1][1:]
            
                if field == "Package":
                    p = Package.Package(value)
                elif field == "Depends" or field == "Pre-Depends":
                    for d in re.split('\ *\([^\)]+\)\ *[,|]?\ *|\ *,\ *|\ *\|\ *', value):
                        if d == "": continue
                        p.addDepend(d)
                elif field == "Suggests":
                    for s in re.split('\ *\([^\)]+\)\ *[,|]?\ *|\ *,\ *|\ *\|\ *', value):
                        if s == "": continue
                        p.addSuggest(s)
                elif field == "Recomends":
                    for r in re.split('\ *\([^\)]+\)\ *[,|]?\ *|\ *,\ *|\ *\|\ *', value):
                        if r == "": continue
                        p.addRecomend(r)
                elif field == "Provides" or field == "Replaces": 
                    for r in re.split('\ *\([^\)]+\)\ *[,|]?\ *|\ *,\ *|\ *\|\ *', value):
                        if r == "": continue
                        if not self.__provided_or_replaced_packages.has_key(r):
                            self.__provided_or_replaced_packages[r] = []
                        self.__provided_or_replaced_packages[r].append(p)
                        p.addProvide(r)
                elif field == "Section":  p.setSection(value)
                elif field == "Priority": p.setPriority(value)
                elif field == "Filename": p.setFilename(value)
                elif field == "MD5sum": p.setMD5sum(value)
                elif field == "Version": p.setVersion(value)

            f.close()

        # select the needed packages
        for filename in self.__remote_packages:
            for package_name in self.__remote_packages[filename]:
                if package_name not in removes[filename]:
                    self.__selectPackage(package_name, filename, needed[filename])
            
    def __selectPackage(self, name, filename, rules, getAll = True):
        if self.__selected_packages.has_key(filename):
            if self.__selected_packages[filename].has_key(name):
                return True
        else:
            self.__selected_packages[filename] = {}

        if self.__check(name, filename, rules):
            self.__selected_packages[filename][name] = self.__remote_packages[filename][name]
            
            for d in self.__remote_packages[filename][name].getDepends():
                if self.__remote_packages[filename].has_key(d):
                    self.__selectPackage(d, filename, [{'section': '*', 'priority': '*', 'package': '*'}], False)
                if self.__getProvides and self.__provided_or_replaced_packages.has_key(d):
                    for p in self.__provided_or_replaced_packages[d]:
                        self.__selectPackage(p.getName(), filename, [{'section': '*', 'priority': '*', 'package': '*'}], True)

            if getAll:
                if self.__getSuggests:
                    for s in self.__remote_packages[filename][name].getSuggests():
                        self.__selectPackage(s, filename, [{'section': '*', 'priority': '*', 'package': '*'}], False)

                if self.__getRecomends:
                    for r in self.__remote_packages[filename][name].getRecomends():
                        self.__selectPackage(r, filename, [{'section': '*', 'priority': '*', 'package': '*'}], False)
                    
            return True
        else:
            return False

    # Check if we should add this package
    def __check(self, name, filename, rules):
        if self.__remote_packages[filename].has_key(name):
            for rule in rules:
                if rule['section'] == '*' or rule['section'] == self.__remote_packages[filename][name].getSection():
                    if rule['priority'] == '*' or rule['priority'] == self.__remote_packages[filename][name].getPriority():
                        if rule['package'] == '*' or rule['package'] == name:
                            return True
        return False
        
    def printAll(self):
        for filename in self.__remote_packages:
            print filename
            for package_name in self.__remote_packages[filename]:
                self.__remote_packages[filename][package_name].printAll()

    def printPackage(self, name):
        self.__remote_packages[name].printAll()

    def getSelectedPackages(self):
        return self.__selected_packages
