package com.tildemh.debbuggtk;

import com.tildemh.debbug.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;
import java.util.LinkedList;

/**
 * Container for displaying comments of bug reports, allowing the user o cycle
 * between reports.
 *
 * <p>There is much scope for improvement - noticing duplicate reports; showing
 * a tree of subjects; syntax highlighting; creating more links; ...
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: CommentViewer.java,v 1.7 2002/12/23 15:23:16 mark Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class CommentViewer extends VBox{
	
	private LinkedList comments;
	private Integer current = new Integer(1);

	private Label top;

	private Button first;
	private Button prev;
	private Button next;
	private Button last;
	private TextBuffer tb;
	
	
	/**
	 */
	public CommentViewer(Bug bug){
		super(false, 10);
		init();
		setBug(bug);
	}
	/**
	 */
	public CommentViewer(){
		super(false, 10);
		init();
	}

	private void init(){		
		String toplbl = new String("No comments to view.");
		top = new Label(toplbl);
		top.setJustification(Justification.LEFT);
		packStart(top, false, true, 0);

		tb = new TextBuffer();
		TextView tv = new TextView( tb );
		ScrolledWindow tf = new ScrolledWindow( new Adjustment(0, 0, 100, 2, 10, 10), new Adjustment(0, 0, 100, 2, 10, 10));
		tf.setPolicy(PolicyType.AUTOMATIC, PolicyType.AUTOMATIC);
		tf.add(tv);
		packStart(tf, true, true, 0);

		HButtonBox bbox = new HButtonBox();
		bbox.setLayout( ButtonBoxStyle.END );
		packStart( bbox, false, false, 0 );

		// todo: l10n
		first = new Button("<<");
		prev = new Button("<");
		next = new Button(">");
		last = new Button(">>");

//		first.addListener( changePage( 0) );
		prev.addListener( changePage( -1 ) );
		next.addListener( changePage( 1 ) );

		bbox.packStart(first);
		bbox.packStart(prev);
		bbox.packStart(next);
		bbox.packStart(last);

		first.setSensitive(false);
		prev.setSensitive(false);
		next.setSensitive(false);
		last.setSensitive(false);
	}
	
	/**
	 */
	public void setBug(Bug bug){
		current = new Integer(1);
		comments = bug.getComments();
		String txt = ((BugComment) comments.get(current.intValue() - 1)).toString();
		tb.setText(txt );
//		last.addListener( changePage(  0 ) );
		updateButtonVisibility();
	}
	
	/**
	 */
	private ButtonListener changePage(int offset){
			final int off = offset;
		return new ButtonListener(){
			public void buttonEvent( ButtonEvent event){
				if (event.isOfType( ButtonEvent.Type.CLICK )){
					int page = current.intValue() + off;
					if(page >=1 && page <= comments.size()){
						current = new Integer( page );
						String txt = ((BugComment) comments.get(current.intValue() - 1)).toString();
						tb.setText(txt );
						updateButtonVisibility();
					}else{
						// do nothing??
					}
				}
			}
		};
	}

	/**
	 * Updates the shaded status of the butons, depending on which comment is
	 * currontly being displayed, and how many are available for display.
	 */
	private void updateButtonVisibility(){
		first.setSensitive( current.intValue() > 1 );
		prev.setSensitive( current.intValue() > 1 );
		next.setSensitive( current.intValue() < comments.size() );
		last.setSensitive( current.intValue() < comments.size() );
		top.setText( "Comment "+current+" of "+comments.size()+"." );
	}
}
