package com.tildemh.debbuggtk;


import org.gnu.gtk.*;
import org.gnu.gnome.*;
import org.gnu.glib.*;
import org.gnu.glade.*;
import java.io.*;
import org.gnu.gtk.event.*;
import java.util.LinkedList;

/**
 * <p>Window for editing the columns to be displayed in the ListingReport and
 * the position of those columns.
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: ListingColumnEditor.java,v 1.8 2004/04/21 20:20:05 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class ListingColumnEditor implements CellRendererToggleListener{
	
	private ListingReport listingReport;
	private LinkedList columns;

	private TreeView view;

	private org.gnu.gtk.Window app;
	/**
	 * @param listingReport the report on which this form will act.
	 */
	public ListingColumnEditor(ListingReport listingReport, LinkedList columns) {
		this.listingReport = listingReport;
		this.columns = columns;
		WindowIcon.setDefaultIcon(DebbugGtk.ICON);
		
		String filename = DebbugGtk.GLADE_XML_DIR+"listingcols.glade";
		LibGlade glade = null;
		try {

			glade = new LibGlade(filename, this, null);
			app = (Window) glade.getWidget("listingColumnSelector");
			view = (TreeView) glade.getWidget("treeView");

			populateView();
			app.showAll();
		} catch (GladeXMLException e) {
			System.err.println("Error parsing glade XML file." + e);
		} catch (FileNotFoundException e) {
			System.err.println("Glade XML file not found.");
		} catch (IOException e) {
			System.err.println("Error reading glade XML file.");
		}

	}

	private TreeViewColumn colVisible = new TreeViewColumn();
	private TreeViewColumn colTitle = new TreeViewColumn();
	private TreeViewColumn colExample = new TreeViewColumn();

	private ListStore model;
	private DataColumnBoolean dataVisible =  new DataColumnBoolean();
	private DataColumnString dataTitle = new DataColumnString();
	private DataColumnString dataExample = new DataColumnString();
	private DataColumnObject dataColumn = new DataColumnObject();
	
	private void populateView(){
		model = new ListStore( new DataColumn[] {dataVisible, dataTitle, dataExample, dataColumn});
		view.setModel( model );

		// not sure how to catch drag and drop reordering, so just disable it
		// for now.
		view.setReorderable( false );
		
		colVisible.setTitle("Visible");
		CellRendererToggle visiRend = new CellRendererToggle();
		visiRend.setUserEditable(true);
		visiRend.addListener( (CellRendererToggleListener) this );
		colVisible.packStart(visiRend, true);
		colVisible.addAttributeMapping(visiRend, CellRendererToggle.Attribute.ACTIVE, dataVisible);
		colVisible.setResizable(true);
		colVisible.setReorderable(true);
		
		colTitle.setTitle("Column");
		CellRendererText titleRend = new CellRendererText();
		colTitle.packStart(titleRend, true);
		colTitle.addAttributeMapping(titleRend, CellRendererText.Attribute.TEXT, dataTitle);
		colTitle.setResizable(true);
		colTitle.setReorderable(true);
		
		colExample.setTitle("Example");
		CellRendererText exRend = new CellRendererText();
		colExample.packStart(exRend, true);
		colExample.addAttributeMapping(exRend, CellRendererText.Attribute.TEXT, dataExample);
		colExample.setResizable(true);
		colExample.setReorderable(true);

		view.appendColumn(colVisible);
		view.appendColumn(colTitle);
		view.appendColumn(colExample);
		view.showAll();

		for(int i = 0; i < columns.size(); i++){
			ListingColumn listingCol = (ListingColumn) columns.get(i);
			TreeIter iter = model.appendRow();
			model.setValue( iter, dataVisible, listingCol.getVisible() );
			model.setValue( iter, dataTitle, listingCol.getTitle() );
			model.setValue( iter, dataExample, listingCol.getExample() );
			model.setValue( iter, dataColumn, listingCol );
		}

		app.showAll();
	}

	/**
	 * Regenerates the columns linked list and sends it to the listingReport to
	 * be displayed
	 */
	private void setCols(){
		LinkedList columns2 = new LinkedList();
		TreeIter iter = model.getFirstIter();
		while (iter != null){
			ListingColumn listingCol = (ListingColumn) model.getValue( iter, dataColumn );
			columns2.addLast( listingCol );
			iter = iter.getNextIter(  );
		}
		listingReport.changeColumns(columns2);
		columns = columns2;
	}

	/**
	 * Events from the toggle buttons
	 */
	public void cellRendererToggleEvent(CellRendererToggleEvent event){
		TreeIter iter = model.getIter( event.getPath() );
		ListingColumn listingCol = (ListingColumn) model.getValue( iter, dataColumn );
		listingCol.setVisible( !listingCol.getVisible() );
		model.setValue( iter, dataVisible, listingCol.getVisible() );
		setCols();
	}

	/////////////////////////////////////////////////////////////////////////////////
	// Events from libglade
	
	public void close(){
		app.hide();
	}
	public void revert(){
		// NYI
	}
	public void moveUp(){
		TreeIter iter = model.getFirstIter();
		if (view.getSelection().getSelected(iter)){
			// at top - do nothing;
			return;
		}
		iter = iter.getNextIter();
		// previous iter - this one will be inserted after it.
		TreeIter prev = model.getFirstIter();
		while (iter != null){
			if (view.getSelection().getSelected(iter)){
				// move it up
				ListingColumn listingCol = (ListingColumn) model.getValue( iter, dataColumn );

				model.removeRow	(iter);
				TreeIter newIter = model.insertRowBefore( prev );
				model.setValue(newIter,  dataVisible, listingCol.getVisible() );
				model.setValue( newIter, dataTitle, listingCol.getTitle() );
				model.setValue( newIter, dataExample, listingCol.getExample() );
				model.setValue( newIter, dataColumn, listingCol );
				view.getSelection().select( newIter );
				setCols();
				return;
			}
			// else try the next place
			prev = prev.getNextIter();
			iter = iter.getNextIter();
		}
		System.err.println("End of list reached before finding selected item");

	}
	public void moveDown(){
		TreeIter iter = model.getFirstIter();
		TreeIter next = model.getFirstIter();
		next = next.getNextIter();
		while (next != null){
			if (view.getSelection().getSelected(iter)){
				// move it up
				ListingColumn listingCol = (ListingColumn) model.getValue( iter, dataColumn );
				model.removeRow	(iter);
				TreeIter newIter = model.insertRowAfter( next );
				model.setValue(newIter,  dataVisible, listingCol.getVisible() );
				model.setValue( newIter, dataTitle, listingCol.getTitle() );
				model.setValue( newIter, dataExample, listingCol.getExample() );
				model.setValue( newIter, dataColumn, listingCol );
				view.getSelection().select( newIter );
				setCols();
				return;
			}
			// else try the next place
			next = next.getNextIter();
			iter = iter.getNextIter();
		}
	}

}
