package com.tildemh.debbuggtk;

import org.gnu.gnome.About;
import org.gnu.gtk.event.LifeCycleEvent;
import org.gnu.gtk.event.LifeCycleListener;
import org.gnu.gtk.*;

/**
 * Static fields and methods for the debbuggtk suite of applications
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: DebbugGtk.java,v 1.29 2004/06/22 09:54:21 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class DebbugGtk{

	public static final String VERSION = /*VERSION*/"cvs"/*VERSION*/; // I have tools to update this
	public static final String IMGDIR = "/usr/share/pixmaps/debbuggtk/";
	public static final String ICON = IMGDIR + "debbuggtk.png";
	public static boolean DEBUG = false;
	public static String GLADE_XML_DIR="/usr/share/debbuggtk/ui/";

	static{
		if (VERSION.equals("cvs")){
			GLADE_XML_DIR="/home/mh/dev/jdebbug/debbuggtk/src/ui/";
		}else{
			DEBUG=false;
		}
	}

	public static void helpAbout() {
		String title = "debbuggtk";
		String license = "http://www.tildemh.com/sw/debbuggtk/";
		String comments = "Graphical Debian Bug Tracking Tools";
		String[] authors = new String[] { "Mark Howard <mh@debian.org>", "", "Help Wanted - Please email for details"};
		String[] documenters = { "Mark Howard <mh@debian.org>", "", "More help wanted - please email"};
		String translator = "None yet - Please email me for details";
		About about = new About(title, DebbugGtk.VERSION, license, comments, authors, documenters, translator, new org.gnu.gdk.Pixbuf( DebbugGtk.ICON ) );
		about.setPosition( WindowPosition.CENTER_ALWAYS );
		about.showAll();
	}

	private static int windowCount = 0;

	public static void newWindow(){
		windowCount++;
	}
	public static void closeWindow(){
		windowCount--;
		if (windowCount <= 0){
			ExitWarning.run();
		}
	}

	public static LifeCycleListener lifeCycleListener = new LifeCycleListener() {
			public void lifeCycleEvent(LifeCycleEvent event) {
				//ignore
			}
			public boolean lifeCycleQuery(LifeCycleEvent event ){
				if (event.isOfType(LifeCycleEvent.Type.DELETE) ){
					System.err.println("Delete event - returning true");
					DebbugGtk.closeWindow();
					return false;
				}else{
					System.err.println("Destroy event - returning false");
					 event.isOfType(LifeCycleEvent.Type.DESTROY);
					 return false;
				}
			}
		};


	private DebbugGtk(){ // no instantiation 
	}
}
