/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * server_socket.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: server_socket.h,v 1.1 2003/06/01 15:06:31 ericprev Exp $
*/

#ifndef __SERVER_SOCKET_H__
#define __SERVER_SOCKET_H__

typedef enum
{
	SE_CNX_CREATED,				/* very first step = server_entry was created */
} SE_CNX_STEP;

typedef struct
{
	/* low level */
	int socket_fd;
	GByteArray *incoming_bytes;			/* partially arrived blocs */
	GByteArray *outgoing_bytes;			/* queue of bytes to send */

	/* high level */
	GPtrArray *incoming_packets;			/* fully received blocs. Each pointer is a GByteArray */

	/* status */
	SE_CNX_STEP current_step;
} SERVER_ENTRY;

/******************************************************/
/* add a new socket connected to a hub to the handler */
/******************************************************/
void add_server_socket(int socket_fd);

#endif
