/*!

\if MANPAGES
\page dcmqridx Register a DICOM image file in an image database index file
\else
\page dcmqridx dcmqridx: Register a DICOM image file in an image database index file
\endif

\section dcmqridx_synopsis SYNOPSIS

\verbatim
dcmqridx [options] index-out [dcmfile-in...]
\endverbatim

\section dcmqridx_description DESCRIPTION

The \b dcmqridx utility registers DICOM image files in the database index file
used by the \b dcmqrscp and \b dcmqrti applications.  No image files are copied.
\b dcmqridx can also list the contents of the database index file.

\section dcmqridx_parameters PARAMETERS
\verbatim
index-out   storage area for the index file (directory)

dcmfile-in  DICOM image file to be registered in the index file
\endverbatim

\section dcmqridx_options OPTIONS

\verbatim
  -h   --help
         print this help text and exit

       --version
         print version information and exit

       --arguments
         print expanded command line arguments

  -q   --quiet
         quiet mode, print no warnings and errors

  -v   --verbose
         verbose mode, print processing details

  -d   --debug
         debug mode, print debug information

  -ll  --log-level  [l]evel: string constant
         (fatal, error, warn, info, debug, trace)
         use level l for the logger

  -lc  --log-config  [f]ilename: string
         use config file f for the logger

  -p   --print
         list contents of database index file

  -n   --not-new
         set instance reviewed status to 'not new'
\endverbatim

\section dcmqridx_notes NOTES

\b dcmqridx attempts to add a reference to the database index file for each
image-file provided on the command line.

\b dcmqridx disables the database back-end quota system so that no image files
will be deleted.

\section dcmqridx_logging LOGGING

The level of logging output of the various command line tools and underlying
libraries can be specified by the user.  By default, only errors and warnings
are written to the standard error stream.  Using option \e --verbose also
informational messages like processing details are reported.  Option
\e --debug can be used to get more details on the internal activity, e.g. for
debugging purposes.  Other logging levels can be selected using option
\e --log-level.  In \e --quiet mode only fatal errors are reported.  In such
very severe error events, the application will usually terminate.  For more
details on the different logging levels, see documentation of module "oflog".

In case the logging output should be written to file (optionally with logfile
rotation), to syslog (Unix) or the event log (Windows) option \e --log-config
can be used.  This configuration file also allows for directing only certain
messages to a particular output stream and for filtering certain messages
based on the module or application where they are generated.  An example
configuration file is provided in <em>\<etcdir\>/logger.cfg</em>.

\section dcmqridx_command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behavior conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator unless they appear between two
quotation marks) prior to any further evaluation.  Please note that a command
file cannot contain another command file.  This simple but effective approach
allows one to summarize common combinations of options/parameters and avoids
longish and confusing command lines (an example is provided in file
<em>\<datadir\>/dumppat.txt</em>).

\section dcmqridx_environment ENVIRONMENT

The \b dcmqridx utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<datadir\>/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behavior should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  On Windows systems,
a semicolon (";") is used as a separator.  The data dictionary code will
attempt to load each file specified in the \e DCMDICTPATH environment variable.
It is an error if no data dictionary can be loaded.

\section dcmqridx_see_also SEE ALSO

<b>dcmqrscp</b>(1), <b>dcmqrti</b>(1)

\section dcmqridx_copyright COPYRIGHT

Copyright (C) 1993-2023 by OFFIS e.V., Escherweg 2, 26121 Oldenburg, Germany.

*/
