/*!

\if MANPAGES
\page dcmodify Modify DICOM files
\else
\page dcmodify dcmodify: Modify DICOM files
\endif

\section synopsis SYNOPSIS

\verbatim
dcmodify [options] [dcmfile-in...]
\endverbatim

\section description DESCRIPTION

\b dcmodify is a tool that allows to modify, insert and delete tags in DICOM
files.  Sequences and tags with a value multiplicity > 1 are also supported.
Currently \b dcmodify is not able to remove or insert single items.
Metaheader information and a tags VR can't be modified directly through
\b dcmodify, too.
In addition to tag modifications, \b dcmodify makes available some input
options - forcing \b dcmodify to handle its input files as the user specifies -
and output options to control the output format of the resulting files.

In case multiple modifications have to be performed, \b dcmodify does the
modifications in the same order as they appear on the command line.  Please
note that \b dcmodify does not check whether a given value matches its
value representation (VR).  Usually, an error message is printed but generally
the user should take care of the right VR usage.

If \b dcmodify doesn't know the tag it should insert, then the tags VR is set to
UN and an empty value. Please insert these tags into the dictionary to
avoid this.

\b dcmodify is able to work with so-called tag paths to describe tags in
sequences.  The syntax is

\verbatim
  {sequence[item-no].}*element
\endverbatim
\if MANPAGES
.fi
\endif

where 'sequence' is a sequence tag like (0008,1111) or a dictionary name for a
tag.  'item-no' describes the item number to be accessed (counting from zero).
'element' defines the target tag to work on.  You can either specify the tag
directly as (0010,0010) or through the dictionary name PatientsName.  The '*'
denotes that you can repeat sequence statements to access deeper levels in
DICOM files (see EXAMPLES section).

There are some issues concerning modifications of private tags (see PRIVATE
TAGS section) and for changing UIDs (CHANGING UIDs section).

\section parameters PARAMETERS

\verbatim
dcmfile-in  DICOM input filename(s) to be modified
\endverbatim

\section options OPTIONS

\subsection general_options general options
\verbatim
  -h   --help
         print this help text and exit

       --version
         print version information and exit

  -d   --debug
         debug mode, print debug information

  -v   --verbose
         verbose mode, print verbose output

  -ie  --ignore-errors
         continue with file, if modify error occurs
\endverbatim

\subsection input_options input options
\verbatim
input file format:

  +f   --read-file
         read file format or data set (default)

  +fo  --read-file-only
         read file format only

  -f   --read-dataset
         read data set without file meta information

input transfer syntax:

  -t=  --read-xfer-auto
         use TS recognition (default)

  -td  --read-xfer-detect
         ignore TS specified in the file meta header

  -te  --read-xfer-little
         read with explicit VR little endian TS

  -tb  --read-xfer-big
         read with explicit VR big endian TS

  -ti  --read-xfer-implicit
         read with implicit VR little endian TS

parsing of odd-length attributes:

  +ao  --accept-odd-length
         accept odd length attributes (default)

  +ae  --assume-even-length
         assume real length is one byte larger

automatic data correction:

  +dc  --enable-correction
         enable automatic data correction (default)

  -dc  --disable-correction
         disable automatic data correction

bitstream format of deflated input:

  +bd  --bitstream-deflated
         expect deflated bitstream (default)

  +bz  --bitstream-zlib
         expect deflated zlib bitstream
\endverbatim


\subsection processing_options processing opitons
\verbatim
insert mode options:

  -i   --insert-tag  "tag-path=value"
         insert (or overwrite) tag at position t
         with value v

modify mode options:

  -m   --modify-tag  "[t]ag-path=[v]alue"
         modify tag at position t to value v

  -ma  --modify-all-tags  "[t]ag=[v]value"
         modify ALL matching tags t in file to value v

erase mode options:

  -e   --erase-tag  "[t]ag-path"
         erase tag at position t

  -ea  --erase-all-tags  "[t]ag"
         erase ALL matching tags t in file

uid options:

  -gst  --gen-stud-uid
          generate new Study Instance UID

  -gse  --gen-ser-uid
          generate new Series Instance UID

  -gin  --gen-inst-uid
          generate new SOP Instance UID

  -nmu  --no-meta-uid
          don't update metaheader UIDs
          UIDs in the metaheader won't be changed,
          if related UIDs in dataset are modified
          via options -m, -i or -ma
\endverbatim

\subsection output_options output options
\verbatim
output file format:

  +F   --write-file
         write file format (default)

  -F   --write-dataset
         write data set without file meta information

output transfer syntax:

  +t=  --write-xfer-same
         write with same TS as input (default)

  +te  --write-xfer-little
         write with explicit VR little endian TS

  +tb  --write-xfer-big
         write with explicit VR big endian TS

  +ti  --write-xfer-implicit
         write with implicit VR little endian TS

post-1993 value representations:

  +u   --enable-new-vr
         enable support for new VRs (UN/UT) (default)

  -u   --disable-new-vr
         disable support for new VRs, convert to OB

group length encoding:

  +g=  --group-length-recalc
         recalculate group lengths if present (default)

  +g   --group-length-create
         always write with group length elements

  -g   --group-length-remove
         always write without group length elements

length encoding in sequences and items:

  +le  --length-explicit
         write with explicit lengths (default)

  -le  --length-undefined
         write with undefined lengths

data set trailing padding (not with --write-dataset):

  -p=  --padding-retain
         do not change padding (default if not --write-dataset)

  -p   --padding-off
         no padding (implicit if --write-dataset)

  +p   --padding-create  [f]ile-pad [i]tem-pad: integer
         align file on multiple of f bytes and items on
         multiple of i bytes
\endverbatim

\section private_tags PRIVATE TAGS

There are some points you've got to consider when working with private tags.
The insertion or modification of a reservation tag (gggg,00xx) should always
work.

\subsection insertions_subsection insertions

If you wish to insert a private tag (not a reservation with gggg,00xx), be sure,
that you've listed it in your dictionary (see dcmdata/docs/datadict.txt for
details). If it's not listed, \b dcmodify will insert it with VR=UN and empty
value. Please note, that the usage of option '-u' will change the VR from UN
to OB when saving.

If you've got your private tag in the dictionary, \b dcmodify acts as follows:
When it finds a reservation in the tags enclosing dataset, whose private
creator matches, insertion is done with the VR found in dictionary and the
value, you entered at commandline. But if the private creator doesn't match
the one found in dictionary, \b dcmodify inserts the tag with VR Unknown (UN)
and an empty value.

\subsection modifications_subsection modifications

If you modify a private tags value, \b dcmodify won't check its VR against the
dictionary. So please be careful to enter only values, that match the
tags VR.

If you wish to change a private tags value \e and VR, because you just added
this tag to your dictionary e.g., you can delete it with \b dcmodify and
re-insert it. Then \b dcmodify uses your dicitionary entry to determine the
right VR (also see subsection insertions).

\subsection deletions deletions

When you use \b dcmodify to delete a private reservation tag, please note, that
\b dcmodify won't touch the private tags that are under this reservation. The
user is forced to handle the consistence between reservations and their
pending private tags.

For deletion of private non-reservation tags there are no special issues.

\section changing_uids CHANGING UIDs

\b dcmodify will automatically correct 'Media Storage SOP Class UID' and
'Media Storage SOP Instance UID' in the metaheader, if you make changes to the
related tags in the dataset ('SOP Class UID' and 'SOP Instance UID') via
insert or modify mode options. You can disable this behaviour by using the
'-nmu option.

If you generate new UID's with '-gst', '-gse' or '-gin', this will only affect
the UID you choosed to generate. So if you use '-gst' to generate a new
'Study Instance UID', then 'Series Instance UID' and 'SOP Instance UID'
will not be affected! This gives you the possibility to generate each value
seperately. Normally you would also modify the 'underlying' UIDs. As a
disadvantage of this flexibility, the user has to assure, that when creating
'new' dicom files with new UIDs with \b dcmodify, other UIDs have to be updated
by the user as necessary.

When choosing the '-gin' option, the related metaheader tag
('Media Storage SOP Instance UID') is updated automatically. This behaviour
can not be disabled.

\section examples EXAMPLES

\verbatim
-i  --insert-tag:

      dcmodify -i "(0010,0010)=A Name" file.dcm
      Inserts the PatientsName tag into 'file.dcm' at 1st level.
      If tag already exists, -i will overwrite it!  If you want to
      insert an element with value multiplicity > 1 (e.g. 4) you
      can do this with: dcmodify -i "(0018,1310)=1\\2\\3\\4"

      dcmodify -i "(0008,1111)[0].PatientsName=Another Name" *.dcm
      Inserts PatientsName tag into the first item of sequence
      (0008,1111).  Note that the use of wildcards for files is
      possible.  You can specify longer tag paths, too (e.g.
      "(0008,1111)[0].(0008,1111)[1].(0010,0010)=A Third One").

-m  --modify-tag:
      dcmodify -m "(0010,0010)=A Name" file.dcm
      Changes tag (0010,0010) on 1st level to "A Name".

      This option also allows longer tag paths as demonstrated
      above for -i.

-ma --modify-all-tags:
      dcmodify -ma "(0010,0010)=New Name" file.dcm
      Does the same as -m but works on all matching tags found in
      'file.dcm'.  Therefore, it searches the whole dataset including
      sequences for tag (0010,0010) and changes them to "New Name"

-e  --erase-tag:
      dcmodify -e "(0010,0010)" *.dcm
      Erases tag (0010,0010) in all *.dcm files at 1st level.
      Note: You can also erase whole sequences by using this
      option with a sequence tag, but in this version it's not
      possible to delete a single item in a sequence.

      This option also allows longer tag paths as demonstrated
      above for -i.

-ea --erase-all-tags:
      dcmodify -ea "(0010,0010)" *.dcm
      Same as -e, but also searches in sequences and items.

-gst --gen-stud-uid:
     dcmodify -gst file.dcm
     This generates a new value for the StudyInstanceUID
     (0020,000d). Other UIDs are not modified!

-gse --gen-ser-uid:
     dcmodify -gse file.dcm
     This generates a new value for the SeriesInstanceUID
     (0020,000e). Other UIDs are not modified!

-gin --gen-inst-uid:
     dcmodify -gin file.dcm
     This command generates a new value for the SOPInstanceUID
     (0008,0018). The corresponding MediaStorageSOPInstanceUID
     (0002,0003) is adjustet to the new value automatically.
     Please note, that it's not possible to avoid this
     metaheader update via the -nmu option.

-nmu --no-meta-uid:
     dcmodify -m "SOPInstanceUID=[UID]" -nmu *.dcm
     This will modify the SOPInstanceUID to the given [UID],
     but -nmu avoids, that dcmodify adjusts the
     MediaStorageSOPInstanceUID in the metaheader, too.
\endverbatim

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator) prior to any further
evaluation.  Please note that a command file cannot contain another command
file.  This simple but effective approach allows to summarize common
combinations of options/parameters and avoids longish and confusing command
lines (an example is provided in file <em>share/data/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b dcmodify utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<PREFIX\>/lib/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  The data dictionary
code will attempt to load each file specified in the \e DCMDICTPATH
environment variable.  It is an error if no data dictionary can be loaded.

\section copyright COPYRIGHT

Copyright (C) 2003-2005 by Kuratorium OFFIS e.V., Escherweg 2, 26121 Oldenburg,
Germany.

*/
