/*!

\if MANPAGES
\page dcmsign Sign and Verify DICOM Files
\else
\page dcmsign dcmsign: Sign and Verify DICOM Files
\endif

\section synopsis SYNOPSIS

\verbatim
dcmsign [options] dcmfile-in [dcmfile-out]
\endverbatim

\section description DESCRIPTION

The \b dcmsign utility reads a DICOM file (\e dicomfile-in), performs a digital
signature operation and, if any modification has taken place, writes the DICOM
object to an output file (\e dicomfile-out).

Five digital signature operations are supported:

\li verification of all signatures in the DICOM file
\li creation of a new digital signature located in the main dataset,
\li creation of a new digital signature in an item of a sequence embedded
    within the dataset,
\li removal of a single digital signature from the DICOM file, and
\li removal of all digital signatures from the DICOM file.

\section parameters PARAMETERS

\verbatim
dcmfile-in   DICOM input filename to be processed

dcmfile-out  DICOM output filename
\endverbatim

\section options OPTIONS

\subsection general_options general options
\verbatim
  -h    --help
          print this help text and exit

        --version
          print version information and exit

  -v    --verbose
          verbose mode, print processing details

  -d    --debug
          debug mode, print debug information
\endverbatim

\subsection input_options input options
\verbatim
input file format:

  +f    --read-file
          read file format or data set (default)

  -f    --read-dataset
          read data set without file meta information

input transfer syntax (only with --read-dataset):

  -t=   --read-xfer-auto
          use TS recognition (default)

  -te   --read-xfer-little
          read with explicit VR little endian TS

  -tb   --read-xfer-big
          read with explicit VR big endian TS

  -ti   --read-xfer-implicit
          read with implicit VR little endian TS
\endverbatim

\subsection signature_commands signature commands
\verbatim
        --verify
          verify all signatures (default)

  +s    --sign  private key file, certificate file: string
          create signature in main object

  +si   --sign-item  keyfile, certfile, item location: string
          create signature in sequence item

  +r    --remove  signature UID: string
          remove signature

  +ra   --remove-all
          remove all signatures from data set
\endverbatim

\subsection sco signature creation options (only with --sign or --sign-item):
\verbatim
private key password options:

  +ps   --std-passwd
          prompt user to type password on stdin (default)

  +pw   --use-passwd  [p]assword: string
          use specified password

  -pw   --null-passwd
          use empty string as password

key and certificate file format options:

  -pem  --pem-keys
          read keys/certificates as PEM file (default)

  -der  --der-keys
          read keys/certificates as DER file

digital signature profile options:

  -pf   --profile-none
          don't enforce any signature profile (default)

  +pb   --profile-base
          enforce base RSA signature profile

  +pc   --profile-creator
          enforce creator RSA signature profile

  +pa   --profile-auth
          enforce authorization signature profile

MAC algorithm options:

  +mr   --mac-ripemd160
          use RIPEMD 160 (default)

  +ms   --mac-sha1
          use SHA-1

  +mm   --mac-md5
          use MD 5

tag selection options:

  -t    --tag
          tag: "xxxx,xxxx" or a data dictionary name
          sign only specified tag
          this option can be specified multiple times

  -tf   --tag-file  filename: string
          read list of tags from text file
\endverbatim

\subsection output_options output options
\verbatim
output transfer syntax:

  +t=   --write-xfer-same
          write with same TS as input (default)

  +te   --write-xfer-little
          write with explicit VR little endian TS

  +tb   --write-xfer-big
          write with explicit VR big endian TS

  +ti   --write-xfer-implicit
          write with implicit VR little endian TS

length encoding in sequences and items:

  +e    --length-explicit
          write with explicit lengths (default)

  -e    --length-undefined
          write with undefined lengths
\endverbatim

\section notes NOTES

\subsection files_and_parameters Files and Parameters

The \b dcmsign utility reads and writes a number of files and file formats
which are described in this section.

Public Key Certificates are expected in X.509v3 format, either with PEM or DER
encoding. The dcmsign utility currently supports RSA and DSA public keys,
although only RSA keys are defines in the Security Profiles of the DICOM
standard.

Private Keys are expected in PEM or DER encoding. PEM is recommended (and
default) because this allows to keep private keys in encrypted form. Command
line options control the behaviour of \b dcmsign when an encrypted PEM key is
opened (see above).  In general it is not recommended to specify the encryption
password in the command line because the command line may be visible to other
processes in the system, e.g. "ps -ef".

The list of data elements to sign can either be read from a file or specified
on the command line or both (in this case the keys are combined).

On the command line, attribute keys are specified as

\verbatim
--tag "gggg,eeee"  where gggg and eeee are the hexadecimal group
                   and element numbers
--tag "Name"       where 'Name' is a symbolic attribute name from
                   the DICOM dictionary (see below).
\endverbatim
\if MANPAGES
.fi
\endif

When attribute tags are read from file with the \e --tag-file option, a plain
text file of max. 64 kbyte is expected.  Tags within the file are either
symbolic names from the data dictionary or have the format (gggg,eeee) (with
braces).  Tags are separated by one or more whitespace characters.

The \e --sign-item operation requires a location string that describes in which
sequence item a signature is to be created.  The location string has the
following format:

\verbatim
SequenceName[index].SequenceName[index].SequenceName[index](...)
\endverbatim
\if MANPAGES
.fi
\endif

where SequenceName is either a symbolic attribute name from the data dictionary
or a numeric tag in the format (gggg,eeee) and index is an unsigned decimal
integer for the item number, starting with zero for the first item in a
sequence.  As an example, the following location string

\verbatim
ReferencedSeriesSequence[0].ReferencedImageSequence[1]
\endverbatim
\if MANPAGES
.fi
\endif

would cause a digital signature to be created in the second item of the
ReferencedImageSequence (0008,1140) which is located in the first item of the
ReferencedSeriesSequence (0008,1115) which is located in the main DICOM
dataset.

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator) prior to any further
evaluation.  Please note that a command file cannot contain another command
file.  This simple but effective approach allows to summarize common
combinations of options/parameters and avoids longish and confusing command
lines (an example is provided in file <em>share/data/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b dcmsign utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<PREFIX\>/lib/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  The data dictionary
code will attempt to load each file specified in the \e DCMDICTPATH
environment variable.  It is an error if no data dictionary can be loaded.

\section copyright COPYRIGHT

Copyright (C) 2000-2004 by Kuratorium OFFIS e.V., Escherweg 2, 26121 Oldenburg,
Germany.

*/