<?php
/*
 * $Id: class.htmlWorkOrderDetail.inc.php,v 1.3.2.1.2.9 2003/05/07 06:01:20 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('wo');

class htmlWorkOrderDetail
{
	function Show($jcn, $seq, $editTimeCardID = 0, $forDelete = false)
	{
		global $dcl_info;

		if ($jcn < 1 || $seq < 1)
		{
			printf(STR_WO_BADJCNSEQERR, 'ShowWorkOrderDetail');
			return;
		}

		$objWorkOrder = CreateObject('dcl.dbWorkorders');
		$objWorkOrder->Connect();
		if ($objWorkOrder->Load($jcn, $seq) == -1)
		{
			print('<center><h4>');
			printf(STR_WO_NOTFOUNDERR, $jcn, $seq);
			print('</h4></center>');
			return;
		}

		$Template = CreateTemplate(array('hForm' => 'htmlWorkordersDetail.tpl'));
		$Template->set_block('hForm', 'delete', 'hDelete');
		$Template->set_block('hForm', 'action', 'hAction');
		$Template->set_block('hForm', 'notes', 'hNotes');
		$Template->set_block('hForm', 'hasattachments', 'hHasattachments');
		$Template->set_block('hForm', 'attachments', 'hAttachments');
		$Template->set_block('hForm', 'project', 'hProject');
		$Template->set_block('hForm', 'closedby', 'hClosedby');
		$Template->set_block('hForm', 'secaccount', 'hSecaccount');
		$Template->set_block('hForm', 'singleaccount', 'hSingleaccount');
		$Template->set_block('hForm', 'accounts', 'hAccounts');
		$Template->set_var('hDelete', '');
		$Template->set_var('hAction', '');
		$Template->set_var('hNotes', '');
		$Template->set_var('hHasattachments', '');
		$Template->set_var('hAttachments', '');
		$Template->set_var('hProject', '');
		$Template->set_var('hClosedby', '');
		$Template->set_var('hSecaccount', '');
		$Template->set_var('hSingleaccount', '');
		$Template->set_var('hAccounts', '');
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('VAL_WIKITYPE', 2); // DCL_ENTITY_WORKORDER

		// Labels
		$Template->set_var('TXT_DETAILTITLE', sprintf(STR_WO_DETAILTITLE, $objWorkOrder->jcn, $objWorkOrder->seq, $objWorkOrder->summary));
		$Template->set_var('TXT_DELETE', STR_CMMN_DELETE);
		$Template->set_var('TXT_CANCEL', STR_CMMN_CANCEL);
		$Template->set_var('TXT_RESPONSIBLE', STR_WO_RESPONSIBLE);
		$Template->set_var('TXT_PRIORITY', STR_WO_PRIORITY);
		$Template->set_var('TXT_SEVERITY', STR_WO_SEVERITY);
		$Template->set_var('TXT_DEADLINE', STR_WO_DEADLINE);
		$Template->set_var('TXT_PRODUCT', STR_WO_PRODUCT);
		$Template->set_var('TXT_REVISION', STR_WO_REVISION);
		$Template->set_var('TXT_ESTSTART', STR_WO_ESTSTART);
		$Template->set_var('TXT_START', STR_WO_START);
		$Template->set_var('TXT_ESTEND', STR_WO_ESTEND);
		$Template->set_var('TXT_ESTHOURS', STR_WO_ESTHOURS);
		$Template->set_var('TXT_ACTHOURS', STR_WO_ACTHOURS);
		$Template->set_var('TXT_ETCHOURS', STR_WO_ETCHOURS);
		$Template->set_var('TXT_OPENBY', STR_WO_OPENBY);
		$Template->set_var('TXT_ON', STR_WO_ON);
		$Template->set_var('TXT_STATUS', STR_WO_STATUS);
		$Template->set_var('TXT_LASTACTION', STR_WO_LASTACTION);
		$Template->set_var('TXT_CLOSEBY', STR_WO_CLOSEBY);
		$Template->set_var('TXT_ACCOUNT', STR_WO_ACCOUNT);
		$Template->set_var('TXT_CONTACT', STR_WO_CONTACT);
		$Template->set_var('TXT_CONTACTPHONE', STR_WO_CONTACTPHONE);
		$Template->set_var('TXT_NOTES', STR_WO_NOTES);
		$Template->set_var('TXT_DESCRIPTION', STR_WO_DESCRIPTION);
		$Template->set_var('TXT_PROJECT', STR_WO_PROJECT);
		$Template->set_var('TXT_MODULE', STR_CMMN_MODULE);
		$Template->set_var('TXT_TYPE', STR_WO_TYPE);
		$Template->set_var('TXT_ATTACHMENTS', STR_WO_ATTACHMENTS);
		$Template->set_var('TXT_SECONDARYACCOUNTS', 'Accounts');

		if ($forDelete && $editTimeCardID == 0)
			$Template->parse('hDelete', 'delete');
		else
		{
			$obj = CreateObject('dcl.htmlWorkorders');
			$Template->set_var('CMB_ACTION',
				$obj->GetActionCombo('tasfepxw', true, $objWorkOrder->jcn, $objWorkOrder->seq, false));
			$Template->set_var('TXT_GO', STR_CMMN_GO);
			$Template->set_var('VAL_WATCHTYPE', '3');
			$Template->parse('hAction', 'action');
		}

		// Data
		$objPersonnel = CreateObject('dcl.dbPersonnel');
		$objPersonnel->Connect($objWorkOrder->conn);
		$objPersonnel->Load($objWorkOrder->responsible);
		$objPriority = CreateObject('dcl.dbPriorities');
		$objPriority->Connect($objWorkOrder->conn);
		$objPriority->Load($objWorkOrder->priority);
		$objSeverity = CreateObject('dcl.dbSeverities');
		$objSeverity->Connect($objWorkOrder->conn);
		$objSeverity->Load($objWorkOrder->severity);
		$objProduct = CreateObject('dcl.dbProducts');
		$objProduct->Connect($objWorkOrder->conn);
		$objProduct->Load($objWorkOrder->product);
		$objStatus = CreateObject('dcl.dbStatuses');
		$objStatus->Connect($objWorkOrder->conn);
		$objStatus->Load($objWorkOrder->status);
		$objModule = CreateObject('dcl.dbProductModules');
		$objModule->Connect($objWorkOrder->conn);
		if ($objWorkOrder->module_id > 0)
			$objModule->Load($objWorkOrder->module_id);

		$objType = CreateObject('dcl.dbWorkOrderType');
		$objType->Connect($objWorkOrder->conn);
		$objType->Load($objWorkOrder->wo_type_id);

		$Template->set_var('VAL_JCN', $objWorkOrder->jcn);
		$Template->set_var('VAL_SEQ', $objWorkOrder->seq);
		$Template->set_var('VAL_RESPONSIBLE', htmlspecialchars($objPersonnel->short));
		$Template->set_var('VAL_PRIORITY', htmlspecialchars($objPriority->name));
		$Template->set_var('VAL_SEVERITY', htmlspecialchars($objSeverity->name));
		$Template->set_var('VAL_DEADLINEON', htmlspecialchars($objWorkOrder->deadlineon));
		$Template->set_var('VAL_PRODUCT', htmlspecialchars($objProduct->name));
		$Template->set_var('VAL_TYPE', htmlspecialchars($objType->type_name));

		if ($objWorkOrder->module_id > 0)
			$Template->set_var('VAL_MODULE', htmlspecialchars($objModule->module_name));
		else
			$Template->set_var('VAL_MODULE', '');

		$Template->set_var('VAL_REVISION', htmlspecialchars($objWorkOrder->revision));
		$Template->set_var('VAL_ESTSTARTON', $objWorkOrder->eststarton);
		$Template->set_var('VAL_STARTON', $objWorkOrder->starton);
		$Template->set_var('VAL_ESTENDON', $objWorkOrder->estendon);
		$Template->set_var('VAL_ESTHOURS', $objWorkOrder->esthours);
		$Template->set_var('VAL_TOTALHOURS', $objWorkOrder->totalhours);
		$Template->set_var('VAL_ETCHOURS', $objWorkOrder->etchours);

		if ($objWorkOrder->createby != $objPersonnel->id)
			$objPersonnel->Load($objWorkOrder->createby);
		$Template->set_var('VAL_CREATEBY', htmlspecialchars($objPersonnel->short));
		$Template->set_var('VAL_CREATEDON', $objWorkOrder->createdon);
		$Template->set_var('VAL_STATUS', htmlspecialchars($objStatus->name));
		$Template->set_var('VAL_STATUSON', $objWorkOrder->statuson);
		$Template->set_var('VAL_LASTACTIONON', $objWorkOrder->lastactionon);
		if ($objStatus->GetStatusType($objWorkOrder->status) == 2)
		{
			if ($objWorkOrder->closedby != $objPersonnel->id)
				$objPersonnel->Load($objWorkOrder->closedby);
			$Template->set_var('VAL_CLOSEDBY', htmlspecialchars($objPersonnel->short));
			$Template->set_var('VAL_CLOSEDON', $objWorkOrder->closedon);
			$Template->parse('hClosedby', 'closedby');
		}

		$Template->set_var('VAL_CONTACT', htmlspecialchars($objWorkOrder->contact));
		$Template->set_var('VAL_CONTACTPHONE', htmlspecialchars(FormatPhone($objWorkOrder->contactphone)));
		$Template->set_var('VAL_NOTES', CreateLinkedText(nl2br(htmlspecialchars($objWorkOrder->notes))));
		$Template->set_var('VAL_DESCRIPTION', CreateLinkedText(nl2br(htmlspecialchars($objWorkOrder->description))));

		// Only print notes if, like, someone made them
		if ($objWorkOrder->notes != '')
			$Template->parse('hNotes', 'notes');

		// Accounts + secondary accounts
		$o = CreateObject('dcl.dbWorkOrderAccount');
		$o->Connect();

		$txt = '';
		if ($o->Load($objWorkOrder->jcn, $objWorkOrder->seq) != -1)
		{
			do
			{
				$o->GetRow();
				$Template->set_var('VAL_ACCOUNT', $o->account_name);
				$Template->parse('hAccounts', 'accounts', true);
			}
			while ($o->next_record());

			// Show the accounts if associated
			if ($dcl_info['DCL_WO_SECONDARY_ACCOUNTS_ENABLED'] == 'Y')
				$Template->parse('hSecaccount', 'secaccount');
			else
				$Template->parse('hSingleaccount', 'singleaccount');
		}

		// Project
		$objPM = CreateObject('dcl.dbProjectmap');
		$objPM->Connect($objWorkOrder->conn);
		if ($objPM->LoadByWO($objWorkOrder->jcn, $objWorkOrder->seq) != -1)
		{
			$objDBPrj = CreateObject('dcl.dbProjects');
			$objDBPrj->Connect($objWorkOrder->conn);

			$project_path = explode(',', $objDBPrj->GetProjectParents($objPM->projectid, true));
			$project_link = '';

			while (list($key, $project_id) = each($project_path))
			{
				$objDBPrj->Load($project_id);
				if ($project_link != '')
					$project_link = '&nbsp;/&nbsp;' . $project_link;

				$project_link = sprintf('<a class="adark" href="%s">%s</a>', menuLink('', 'menuAction=boProjects.viewproject&project=' . $objDBPrj->projectid), htmlspecialchars($objDBPrj->name)) . $project_link;
			}

			$Template->set_var('VAL_PROJECT', $project_link);
			$Template->parse('hProject', 'project');
		}

		$attachPath = $dcl_info['DCL_FILE_PATH'] . '/attachments/wo/' . substr($jcn, -1) . "/$jcn/$seq/";

		$hasAttachments = false;
		if ($hDir = @opendir($attachPath))
		{
			$linkName = '[X]';

			while ($fileName = @readdir($hDir))
			{
				if (is_file($attachPath . $fileName) && is_readable($attachPath . $fileName))
				{
					$hasAttachments = true;
					$line = '';
					if ($GLOBALS['SEC'] >= $dcl_info['DCL_ASSIGN_WO'])
					{
						$line = '<a class="adark" href="';
						$line .= menuLink('', 'menuAction=boWorkorders.deleteattachment&filename=' . rawurlencode($fileName) . "&jcn=$jcn&seq=$seq");
						$line .= "\">$linkName</a>&nbsp;";
					}

					$line .= '<a class="adark" href="';
					$line .= menuLink('', 'menuAction=htmlWorkOrderDetail.Download&filename=' . rawurlencode($fileName) . "&jcn=$jcn&seq=$seq");
					$line .= '">' . htmlspecialchars($fileName) . '</a>&nbsp;(' . filesize($attachPath . $fileName) . ' ' . STR_CMMN_BYTES . ')';

					$Template->set_var('VAL_ATTACHMENTS', $line);
					$Template->parse('hAttachments', 'attachments', true);
				}
			}
		}

		if ($hasAttachments)
			$Template->parse('hHasattachments', 'hasattachments');

		$objTimeCards = CreateObject('dcl.htmlTimeCards');
		$Template->set_var('VAL_TIMECARDS', $objTimeCards->GetTimeCards($objWorkOrder->jcn, $objWorkOrder->seq, $editTimeCardID, $forDelete));

		$Template->pparse('out', 'hForm');
	}

	function Download()
	{
		global $dcl_info;

		// TODO: Security check
		$o = CreateObject('dcl.boFile');
		$o->iType = ATTACHMENT_WORKORDER;
		$o->iKey1 = $GLOBALS['jcn'];
		$o->iKey2 = $GLOBALS['seq'];
		$o->sFileName = $GLOBALS['filename'];
		$o->sRoot = $dcl_info['DCL_FILE_PATH'] . '/attachments';
		$o->Download();
	}
}
?>
