CREATE TABLE accounts (
	id int NOT NULL identity(1,1),
	short varchar(25) NOT NULL,
	name varchar(50) NOT NULL,
	add1 varchar(30),
	add2 varchar(30),
	city varchar(50),
	state char(2),
	zip varchar(11),
	contact varchar(50),
	voice varchar(10),
	fax varchar(10),
	data1 varchar(10),
	data2 varchar(10),
	notes text,
	active char(1) not null default 'Y',
	PRIMARY KEY (id)
)
GO

CREATE TABLE actions (
	id int NOT NULL identity(1,1),
	short varchar(10) NOT NULL,
	name varchar(20) NOT NULL,
	active char(1) not null default 'Y',
	PRIMARY KEY (id)
)
GO


INSERT INTO actions VALUES('DBG', 'Debug', 'Y')
GO
INSERT INTO actions VALUES('RES', 'Research', 'Y')
GO
INSERT INTO actions VALUES('DOC', 'Document', 'Y')
GO
INSERT INTO actions VALUES('TST', 'Testing', 'Y')
GO
INSERT INTO actions VALUES('DES', 'Design', 'Y')
GO
INSERT INTO actions VALUES('IMP', 'Implementation', 'Y')
GO
INSERT INTO actions VALUES('CORR', 'Correction', 'Y')
GO


CREATE TABLE departments (
	id int NOT NULL identity(1,1),
	short varchar(10) NOT NULL,
	name varchar(30) NOT NULL,
	active char(1) not null default 'Y',
	PRIMARY KEY (id)
)
GO

CREATE TABLE jcn (
	id int NOT NULL identity(1,1),
	PRIMARY KEY (id)
)
GO

CREATE TABLE personnel (
	id int NOT NULL identity(1,1),
	short varchar(10) NOT NULL,
	lastname varchar(25),
	firstname varchar(20),
	reportto int,
	department int,
	pwd varchar(50),
	security int,
	email varchar(80),
	active char(1) not null default 'Y',
	PRIMARY KEY (id),
)
GO

create unique index short_idx on personnel(short)
GO


INSERT INTO personnel VALUES('sa', 'Administrator', '', '0', '0', 'c12e01f2a13ff5587e1e9e4aedb8242d', '9', '', 'Y')
GO

CREATE TABLE priorities (
	id int NOT NULL identity(1,1),
	short varchar(10) NOT NULL,
	name varchar(20) NOT NULL,
	weight int DEFAULT '0' NOT NULL,
	active char(1) not null default 'Y',
	PRIMARY KEY (id)
)
GO


CREATE TABLE products (
	id int NOT NULL identity(1,1),
	short varchar(10) NOT NULL,
	name varchar(50) NOT NULL,
	reportto int,
	active char(1) not null default 'Y',
	ticketsto int not null default '0',
	wosetid int not null default '0',
	tcksetid int not null default '0',
	PRIMARY KEY (id)
)
GO


CREATE TABLE severities (
	id int NOT NULL identity(1,1),
	short varchar(10) NOT NULL,
	name varchar(20) NOT NULL,
	weight int DEFAULT '0' NOT NULL,
	active char(1) not null default 'Y',
	PRIMARY KEY (id)
)
GO

CREATE TABLE statuses (
	id int NOT NULL identity(1,1),
	short varchar(10) NOT NULL,
	name varchar(20) NOT NULL,
	active char(1) not null default 'Y',
	dcl_status_type int not null default '1',
	PRIMARY KEY (id)
)
GO


INSERT INTO statuses VALUES('OP', 'Open', 'Y', 1)
GO
INSERT INTO statuses VALUES('CL', 'Closed', 'Y', 2)
GO
INSERT INTO statuses VALUES('DF', 'Deferred', 'Y', 3)
GO
INSERT INTO statuses VALUES('UA', 'Unassigned', 'Y', 1)
GO


CREATE TABLE timecards (
	id int NOT NULL identity(1,1),
	jcn int DEFAULT '0' NOT NULL,
	seq int DEFAULT '0' NOT NULL,
	actionon varchar(8) NOT NULL,
	inputon varchar(14),
	actionby int DEFAULT '0' NOT NULL,
	status int DEFAULT '0' NOT NULL,
	action int DEFAULT '0' NOT NULL,
	hours float DEFAULT '0.00' NOT NULL,
	summary varchar(100) NOT NULL,
	description text NOT NULL,
	revision varchar(20) NOT NULL,
	reassign_from_id int null,
	reassign_to_id int null,
	PRIMARY KEY (id)
)
GO

CREATE TABLE workorders (
	jcn int DEFAULT '0' NOT NULL,
	seq int DEFAULT '0' NOT NULL,
	product int DEFAULT '0' NOT NULL,
	account int,
	createby int DEFAULT '0' NOT NULL,
	createdon varchar(14),
	closedby int,
	closedon varchar(8),
	status int DEFAULT '0' NOT NULL,
	statuson varchar(14),
	lastactionon varchar(14),
	deadlineon varchar(8),
	eststarton varchar(8),
	estendon varchar(8),
	starton varchar(8),
	esthours float,
	totalhours float,
	priority int DEFAULT '0' NOT NULL,
	severity int DEFAULT '0' NOT NULL,
	contact varchar(50),
	contactphone varchar(10),
	summary varchar(100) NOT NULL,
	notes text,
	description text NOT NULL,
	responsible int DEFAULT '0' NOT NULL,
	revision varchar(20),
	publicview int,
	oid int NOT NULL identity(1,1),
	etchours float,
	module_id int,
	PRIMARY KEY (oid)
)
GO

CREATE TABLE dcl_projects (
	projectid int NOT NULL identity(1,1),
	name varchar(100) unique NOT NULL,
	reportto int DEFAULT '0' NOT NULL,
	createdby int DEFAULT '0' NOT NULL,
	createdon varchar(14),
	projectdeadline varchar(8),
	description text NOT NULL,
	status int DEFAULT '0' NOT NULL,
	lastactivity varchar(14),
	finalclose varchar(14),
	parentprojectid int default('0') not null,
	PRIMARY KEY (projectid)
)
GO


CREATE TABLE projectmap (
	projectid int NOT NULL,
	jcn int DEFAULT '0' NOT NULL,
	seq int DEFAULT '0' NOT NULL,
	PRIMARY KEY (projectid,jcn,seq)
)
GO

CREATE TABLE watches (
	watchid int NOT NULL identity(1,1),
	typeid int DEFAULT '0' NOT NULL,
	whatid1 int DEFAULT '0' NOT NULL,
	whatid2 int DEFAULT '0' NOT NULL,
	whoid int DEFAULT '0' NOT NULL,
	actions int DEFAULT '0' NOT NULL,
	PRIMARY KEY (watchid)
)
GO
CREATE TABLE tickets (
	ticketid int identity(1,1) NOT NULL,
	product int NOT NULL,
	account int,
	createdby int NOT NULL,
	createdon varchar(14)  NOT NULL,
	responsible int NOT NULL,
	closedby int,
	closedon varchar(14),
	status int NOT NULL,
	statuson varchar(14) NOT NULL,
	lastactionon varchar(14),
	priority int NOT NULL,
	type int NOT NULL,
	contact varchar(80),
	contactphone varchar(20),
	issue text NOT NULL,
	version varchar(20),
	summary varchar(100),
	seconds int not null default '0',
	contactemail varchar(100),
	module_id int,
	PRIMARY KEY (ticketid)
)
GO

CREATE TABLE ticketresolutions (
	resid int identity(1,1) NOT NULL,
	ticketid int NOT NULL,
	loggedby int NOT NULL,
	loggedon varchar(14)  NOT NULL,
	status int NOT NULL,
	resolution text NOT NULL,
	startedon varchar(14) NOT NULL,
	PRIMARY KEY (resid)
)
GO

CREATE TABLE faq (
	faqid int identity(1,1) NOT NULL,
	name varchar(80) NOT NULL,
	createby int,
	createon varchar(14)  NOT NULL,
	modifyby int,
	modifyon varchar(14),
	active char(1) DEFAULT 'Y' NOT NULL,
	description text,
	PRIMARY KEY (faqid)
)
GO

CREATE TABLE faqtopics (
	topicid int identity(1,1) NOT NULL,
	seq int NOT NULL,
	faqid int NOT NULL,
	name varchar(80) NOT NULL,
	description text NOT NULL,
	createby int,
	createon varchar(14)  NOT NULL,
	modifyby int,
	modifyon varchar(14),
	active char(1) DEFAULT 'Y' NOT NULL,
	PRIMARY KEY (topicid)
)
GO

CREATE TABLE faqquestions (
	questionid int identity(1,1) NOT NULL,
	seq int NOT NULL,
	topicid int NOT NULL,
	questiontext text NOT NULL,
	createby int,
	createon varchar(14)  NOT NULL,
	modifyby int,
	modifyon varchar(14),
	active char(1) DEFAULT 'Y' NOT NULL,
	PRIMARY KEY (questionid)
)
GO

CREATE TABLE faqanswers (
	answerid int identity(1,1) NOT NULL,
	questionid int NOT NULL,
	answertext text NOT NULL,
	createby int NOT NULL,
	createon varchar(14)  NOT NULL,
	modifyby int,
	modifyon varchar(14),
	active char(1) DEFAULT 'Y' NOT NULL,
	PRIMARY KEY (answerid)
)
GO

CREATE TABLE views (
	viewid int identity(1,1) NOT NULL,
	whoid int NOT NULL,
	name varchar(100) NOT NULL,
	ispublic char(1) DEFAULT 'N' NOT NULL,
	viewurl text NOT NULL,
	tablename varchar(30) not null,
	PRIMARY KEY(viewid)
)
GO


CREATE TABLE attributesets (
	id int identity(1,1) NOT NULL,
	short varchar(20) NOT NULL,
	name varchar(100) NOT NULL,
	active char(1) NOT NULL DEFAULT 'Y'
)
GO

INSERT INTO attributesets(short,name,active) VALUES ('WO', 'Work Orders', 'Y')
GO
INSERT INTO attributesets(short,name,active) VALUES ('TCK', 'Tickets', 'Y')
GO

CREATE TABLE attributesetsmap (
	setid int NOT NULL,
	typeid int NOT NULL,
	keyid int NOT NULL,
	weight int NOT NULL
)
GO

INSERT INTO attributesetsmap SELECT 1, 1, id, 1 FROM actions
GO
INSERT INTO attributesetsmap SELECT 1, 2, id, weight FROM priorities
GO
INSERT INTO attributesetsmap SELECT 1, 3, id, weight FROM severities
GO
INSERT INTO attributesetsmap SELECT 1, 4, id, 1 FROM statuses
GO

INSERT INTO attributesetsmap SELECT 2, 1, id, 1 FROM actions
GO
INSERT INTO attributesetsmap SELECT 2, 2, id, weight FROM priorities
GO
INSERT INTO attributesetsmap SELECT 2, 3, id, weight FROM severities
GO
INSERT INTO attributesetsmap SELECT 2, 4, id, 1 FROM statuses
GO
CREATE TABLE dcl_config (
	dcl_config_name varchar(50) NOT NULL,
	dcl_config_field varchar(30) NOT NULL,
	dcl_config_int int,
	dcl_config_double float,
	dcl_config_date varchar(8),
	dcl_config_datetime varchar(14),
	dcl_config_varchar varchar(255),
	PRIMARY KEY (dcl_config_name)
)
GO

CREATE TABLE dcl_chklst (
	dcl_chklst_id int NOT NULL identity(1,1),
	dcl_chklst_tpl_id int NOT NULL,
	dcl_chklst_summary varchar(255) NOT NULL,
	dcl_chklst_createby int NOT NULL,
	dcl_chklst_createon varchar(14) NOT NULL,
	dcl_chklst_modifyby int,
	dcl_chklst_modifyon varchar(14),
	dcl_chklst_status varchar(255),
	PRIMARY KEY (dcl_chklst_id)
)
GO

CREATE TABLE dcl_chklst_tpl (
	dcl_chklst_tpl_id int NOT NULL identity(1,1),
	dcl_chklst_tpl_name varchar(255) NOT NULL,
	dcl_chklst_tpl_active char(1) DEFAULT 'Y' NOT NULL,
	PRIMARY KEY (dcl_chklst_tpl_id)
)
GO

CREATE TABLE dcl_product_module(
	product_module_id int Not Null identity(1, 1),
	product_id int Not Null,
	module_name varchar(50) Not Null,
	active char(1) Not Null,
	PRIMARY KEY (product_module_id)
)
GO

INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_VERSION','dcl_config_varchar',NULL,NULL,NULL,NULL,'0.9.2')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_DATE_FORMAT','dcl_config_varchar',NULL,NULL,NULL,NULL,'m/d/Y')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_DATE_FORMAT_DB','dcl_config_varchar',NULL,NULL,NULL,NULL,'Ymd')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_TIMESTAMP_FORMAT_DB','dcl_config_varchar',NULL,NULL,NULL,NULL,'YmdHis')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_TIMESTAMP_FORMAT','dcl_config_varchar',NULL,NULL,NULL,NULL,'m/d/Y H:i:s')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_MAX_UPLOAD_FILE_SIZE','dcl_config_int',1048576,NULL,NULL,NULL,NULL)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_DEFAULT_LANGUAGE','dcl_config_varchar',NULL,NULL,NULL,NULL,'en')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_PRIVATE_KEY','dcl_config_varchar',NULL,NULL,NULL,NULL,'IloveDCL')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_ROOT','dcl_config_varchar',NULL,NULL,NULL,NULL,'http://localhost/dcl/')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_ADD_USER','dcl_config_int',9,NULL,NULL,NULL,NULL)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_DEL_WO','dcl_config_int',8,NULL,NULL,NULL,NULL)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_MOD_WO','dcl_config_int',7,NULL,NULL,NULL,NULL)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_ASSIGN_WO','dcl_config_int',5,NULL,NULL,NULL,NULL)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_ADD_WO','dcl_config_int',3,NULL,NULL,NULL,NULL)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_HAVE_WO','dcl_config_int',4,NULL,NULL,NULL,NULL)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_CHG_PWD','dcl_config_int',2,NULL,NULL,NULL,NULL)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_DEF_STATUS_ASSIGN_WO','dcl_config_int',1,NULL,NULL,NULL,NULL)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_DEF_STATUS_UNASSIGN_WO','dcl_config_int',4,NULL,NULL,NULL,NULL)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_DEF_PRIORITY','dcl_config_int',1,NULL,NULL,NULL,NULL)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_DEF_SEVERITY','dcl_config_int',2,NULL,NULL,NULL,NULL)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_AUTO_DATE','dcl_config_varchar',NULL,NULL,NULL,NULL,'Y')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_TIME_CARD_ORDER','dcl_config_varchar',NULL,NULL,NULL,NULL,'ASC')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_PROJECT_XML_TEMPLATES','dcl_config_varchar',NULL,NULL,NULL,NULL,'N')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_GD_TYPE','dcl_config_varchar',NULL,NULL,NULL,NULL,'png')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_CQQ_PERCENT','dcl_config_int',0,NULL,NULL,NULL,NULL)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_CQQ_FROM','dcl_config_varchar',NULL,NULL,NULL,NULL,'Somebody <someone@somewhere.org>')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_CQQ_SUBJECT','dcl_config_varchar',NULL,NULL,NULL,NULL,'Thank You For Calling')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_CQQ_TEMPLATE','dcl_config_varchar',NULL,NULL,NULL,NULL,'cqqmail.tpl')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_DEF_TEMPLATE_SET','dcl_config_varchar',NULL,NULL,NULL,NULL,'default')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_COLOR_LIGHT','dcl_config_varchar',NULL,NULL,NULL,NULL,'#eeeef8')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_COLOR_DARK','dcl_config_varchar',NULL,NULL,NULL,NULL,'#737b9c')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_SMTP_SERVER','dcl_config_varchar',NULL,NULL,NULL,NULL,'localhost')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_SMTP_ENABLED','dcl_config_varchar',NULL,NULL,NULL,NULL,'Y')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_SMTP_PORT','dcl_config_int',25,NULL,NULL,NULL,NULL)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) VALUES ('DCL_SMTP_TIMEOUT','dcl_config_int',30,NULL,NULL,NULL,NULL)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_PROJECT_BROWSE_PARENTS_ONLY', 'dcl_config_varchar', 'N')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_PROJECT_INCLUDE_PARENT_STATS', 'dcl_config_varchar', 'N')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_PROJECT_INCLUDE_CHILD_STATS', 'dcl_config_varchar', 'Y')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_FILE_PATH', 'dcl_config_varchar', '.')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) VALUES ('DCL_HTML_TITLE', 'dcl_config_varchar', 'Double Choco Latte - Copyright (C) 1998-2001 Michael L. Dean and Tim R. Norman')
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_DEFAULT_PROJECT_STATUS', 'dcl_config_int', 1)
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) VALUES ('DCL_DEFAULT_TICKET_STATUS', 'dcl_config_int', 1)
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_ENABLED', 'dcl_config_varchar', 'N')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_AUTORESPOND', 'dcl_config_varchar', 'N')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_REPLY', 'dcl_config_varchar', 'N')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_AUTORESPONSE_EMAIL', 'dcl_config_varchar', 'nobody@localhost')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_FILE_PATH', 'dcl_config_varchar', '/tmp')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_STATUS', 'dcl_config_int', 0)
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_PRIORITY', 'dcl_config_int', 0)
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_SEVERITY', 'dcl_config_int', 0)
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_ACCOUNT', 'dcl_config_int', 0)
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_REPLY_LOGGED_BY', 'dcl_config_int', 0)
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_SMTP_DEFAULT_EMAIL', 'dcl_config_varchar', 'nobody@localhost')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WO_NOTIFICATION_HTML', 'dcl_config_varchar', 'N')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WO_EMAIL_TEMPLATE', 'dcl_config_varchar', 'notify_wo_en.tpl')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_TCK_NOTIFICATION_HTML', 'dcl_config_varchar', 'N')
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_TCK_EMAIL_TEMPLATE', 'dcl_config_varchar', 'notify_tck_en.tpl')
GO

create table dcl_status_type (
	dcl_status_type_id int not null primary key,
	dcl_status_type_name varchar(50) not null
)
GO

insert into dcl_status_type values (1, 'Open')
insert into dcl_status_type values (2, 'Completed')
insert into dcl_status_type values (3, 'Deferred')
GO
