<?php
	/**************************************************************************\
	* Double Choco Latte                                                       *
	* http://dcl.sourceforge.net/                                              *
	* This application written by Michael Dean <mdean@users.sourceforge.net>   *
	* --------------------------------------------                             *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/

	/* $Id: index.php,v 1.2.2.1.2.1 2002/11/11 04:17:22 mdean Exp $ */

if (file_exists('../header.inc.php'))
{
	$phpgw_info['flags'] = array(
			'currentapp' => 'dcl',
			'noheader'   => True,
			'nonavbar'   => True
		);
	include('../header.inc.php');

	$phpgw->common->phpgw_header();
	echo parse_navbar();

	$obj = createobject('dcl.htmlMyDCL');
	$obj->show();

	$phpgw->common->phpgw_footer();
}
else
{
	include('inc/config.php');
	include('inc/class.Template.inc.php');

	function GetLangCombo($sName = 'LANG', $sDefault = '')
	{
		$a = array(
				'en' => 'English',
				'fr' => 'French',
				'de' => 'German',
				'it' => 'Italian',
				'es' => 'Spanish',
				'sl' => 'Slovenina',
				'sv' => 'Swedish'
			);

		$retVal = '<select name="' . $sName . '">';
		reset($a);
		while (list($key, $val) = each($a))
		{
			$retVal .= '<option value="' . $key . '"';
			if ($key == $sDefault)
				$retVal .= ' selected';

			$retVal .= '>' . $val . '</option>';
		}

		$retVal .= '</select>';

		return $retVal;
	}

	function GetDomainCombo()
	{
		global $dcl_domain_info;

		if (count($dcl_domain_info) > 1)
		{
			$retVal = '<select name="DOMAIN">';
			reset($dcl_domain_info);
			while (list($key, $val) = each($dcl_domain_info))
				$retVal .= '<option value="' . $key . '">' . $val['name'] . '</option>';

			$retVal .= '</select>';
		}
		else
			$retVal = '<input type="hidden" name="DOMAIN" value="default">' . $dcl_domain_info['default']['name'];

		return $retVal;
	}

	$t = new Template;
	$t->set_file(array('hForm' => 'templates/' . $dcl_info['DCL_DEF_TEMPLATE_SET'] . '/login.tpl'));
	$t->set_block('hForm', 'error', 'hError');
	$t->set_var('hError', '');
	if (IsSet($GLOBALS['cd']))
	{
		switch ($GLOBALS['cd'])
		{
			case 1:
				$t->set_var('VAL_ERROR', 'Invalid login or password');
				break;
			case 2:
				$t->set_var('VAL_ERROR', 'Could not verify session');
				break;
			case 3:
				$t->set_var('VAL_ERROR', 'Could not connect to database');
				break;
			default:
				$t->set_var('VAL_ERROR', 'Unknown error');
		}

		$t->parse('hError', 'error');
	}

	$t->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
	$t->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
	$t->set_var('TXT_TITLE', 'Double Choco Latte Login');
	$t->set_var('TXT_LOGIN', 'Login and Have a Double!');
	$t->set_var('TXT_USER', 'User');
	$t->set_var('TXT_PASSWORD', 'Password');
	$t->set_var('TXT_USERINTERFACE', 'User Interface');
	$t->set_var('TXT_DROPDOWN', 'Drop Down Menus (JavaScript)');
	$t->set_var('TXT_TREE', 'Tree (JavaScript/Frames)');
	$t->set_var('TXT_STATIC', 'Static (No JavaScript/Frames)');
	$t->set_var('TXT_DOMAIN', 'Domain');
	$t->set_var('TXT_LANGUAGE', 'Language');
	$t->set_var('BTN_LOGIN', 'Login');
	$t->set_var('BTN_CLEAR', 'Clear');
	$t->set_var('CMB_LANGUAGE', GetLangCombo());
	$t->set_var('CMB_DOMAIN', GetDomainCombo());

	if (IsSet($GLOBALS['refer_to']))
		$t->set_var('HIDDEN_VARS', sprintf('<input type="hidden" name="refer_to" value="%s">', urldecode($GLOBALS['refer_to'])));
	else
		$t->set_var('HIDDEN_VARS', '');

	for ($i = 0; $i < 3; $i++)
		$t->set_var("SELECTED_$i", '');

	if (IsSet($DCLTYPEMENU))
		$t->set_var("SELECTED_$DCLTYPEMENU", ' selected');

	$t->pparse('out', 'hForm');
}
?>
