<?php
/*
 * $Id: class.reportPersonnelActivity.inc.php,v 1.2.4.1 2002/08/18 04:17:47 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('wost');

class reportPersonnelActivity
{
	function getparameters($needHdr = true)
	{
		global $dcl_info;

		if ($needHdr == true)
			commonHeader();

		$objPersonnel = CreateObject('dcl.htmlPersonnel');

		$Template = CreateTemplate(array('hForm' => 'htmlPersonnelActivity.tpl'));

		$Template->set_var('VAL_JSDATEFORMAT', GetJSDateFormat());
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('TXT_TITLE', STR_WOST_PERSONNELACTIVITY);
		$Template->set_var('TXT_GENERATEREPORTFOR', STR_WOST_GENERATEREPORTFOR);
		$Template->set_var('TXT_DATERANGE', STR_WOST_DATERANGE);

		$Template->set_var('TXT_BEGINNING', STR_WOST_BEGIN);
		$Template->set_var('TXT_ENDING', STR_WOST_ENDING);
		$Template->set_var('BTN_EXECUTE', STR_CMMN_GO);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('CMB_RESPONSIBLE', $objPersonnel->GetCombo($GLOBALS['DCLID'], 'responsible', 'lastfirst', 0, false));

		if (IsSet($GLOBALS['begindate']))
			$Template->set_var('VAL_BEGINDATE', $GLOBALS['begindate']);
		else
			$Template->set_var('VAL_BEGINDATE', '');

		if (IsSet($GLOBALS['enddate']))
			$Template->set_var('VAL_ENDDATE', $GLOBALS['enddate']);
		else
			$Template->set_var('VAL_ENDDATE', '');

		$Template->pparse('out', 'hForm');			
	}

	function execute()
	{
		commonHeader();

		if ($GLOBALS['begindate'] == '' || $GLOBALS['enddate'] == '')
		{
			print('<center>');
			PrintWithChocoFont(STR_WOST_DATEERR);
			print('</center><p>');
			$this->GetParameters(false);
			return;
		}

		$objP = CreateObject('dcl.dbPersonnel');
		$objS = CreateObject('dcl.dbStatuses');
		$objPr = CreateObject('dcl.dbPriorities');
		$objSe = CreateObject('dcl.dbSeverities');
		$objW = CreateObject('dcl.dbWorkorders');
		$objT = CreateObject('dcl.dbTimeCards');
		$objDB = new dclDB;

		$objP->Connect();
		$objS->Connect($objP->conn);
		$objPr->Connect($objP->conn);
		$objSe->Connect($objP->conn);
		$objW->Connect($objP->conn);
		$objT->Connect($objP->conn);
		$objDB->Connect($objP->conn);

		$objP->Load($GLOBALS['responsible']);

		$query = 'select jcn,seq,hours from timecards where actionby=' . $GLOBALS['responsible'];
		$query .= ' and actionon between ' . $objDB->DisplayToSQL($GLOBALS['begindate']) . ' and ' . $objDB->DisplayToSQL($GLOBALS['enddate']);
		$query .= ' order by jcn,seq';

		if ($objDB->Query($query) != -1)
		{
			if ($objDB->next_record())
			{
				$lastJCN = 0;
				$lastSeq = 0;
				$arrayIndex = -1;
				$count = 0;
				$totalEstHours = 0.0;
				$totalAppliedHours = 0.0;
				$totalEtcHours = 0.0;
				$totalTimeHours = 0.0;
				do
				{
					$thisJCN = $objDB->f('jcn');
					$thisSeq = $objDB->f('seq');

					// Skip multiple time cards                        
					if ($thisJCN != $lastJCN || $thisSeq != $lastSeq)
					{
						$arrayIndex++;
						$objW->Load($thisJCN, $thisSeq);
						$objS->Load($objW->status);
						$objPr->Load($objW->priority);
						$objSe->Load($objW->severity);
						
						$reportArray[$arrayIndex][0] = '[<a class="adark" href="main.php?menuAction=boWorkorders.viewjcn&jcn=' . $thisJCN . '&seq=' . $thisSeq . '">' . $thisJCN . '-' . $thisSeq . '</a>] ' . $objW->summary;
						$reportArray[$arrayIndex][1] = $objS->short;
						$reportArray[$arrayIndex][2] = $objPr->short;
						$reportArray[$arrayIndex][3] = $objSe->short;
						$reportArray[$arrayIndex][4] = $objW->esthours;
						$reportArray[$arrayIndex][5] = $objW->etchours;
						$reportArray[$arrayIndex][6] = $objW->totalhours;
						$reportArray[$arrayIndex][7] = $objW->eststarton;
						$reportArray[$arrayIndex][8] = $objW->estendon;
						$reportArray[$arrayIndex][9] = $objW->starton;
						$reportArray[$arrayIndex][10] = $objW->closedon;
						$reportArray[$arrayIndex][11] = $objDB->f('hours');
						$ouHours = -($objW->esthours - $objW->totalhours);
						$diffHours = $ouHours;
						if ($diffHours < 0)
							$diffHours = -$diffHours;

						$ouPct = 0.0;
						$sign = '';
						if ($objW->esthours > 0)
						{
							$ouPct = $diffHours / $objW->esthours * 100;
							if ($objW->esthours > $objW->totalhours && $objW->esthours > 0)
								$sign = '-';
							else if ($objW->totalhours > $objW->esthours && $objW->totalhours > 0)
									$sign = '+';
						}

						$reportArray[$arrayIndex][12] = sprintf('%s%0.2f&nbsp;(%s%0.2f%%)', $sign, abs($ouHours), $sign, abs($ouPct));

						settype($reportArray[$arrayIndex][4], 'double');
						settype($reportArray[$arrayIndex][5], 'double');
						settype($reportArray[$arrayIndex][6], 'double');
						settype($reportArray[$arrayIndex][11], 'double');

						$totalEstHours += $reportArray[$arrayIndex][4];
						$totalAppliedHours += $reportArray[$arrayIndex][6];
						$totalEtcHours += $reportArray[$arrayIndex][5];

						$lastJCN = $thisJCN;
						$lastSeq = $thisSeq;
					}
					else
					{
						$reportArray[$arrayIndex][11] += $objDB->f('hours');
					}

					$totalTimeHours += $objDB->f('hours');
					$count++;
				}
				while ($objDB->next_record());

				$arrayIndex++;
				$reportArray[$arrayIndex][0] = '<b>Totals</b>';
				$reportArray[$arrayIndex][1] = '';
				$reportArray[$arrayIndex][2] = '';
				$reportArray[$arrayIndex][3] = '';
				$reportArray[$arrayIndex][4] = $totalEstHours;
				$reportArray[$arrayIndex][5] = $totalEtcHours;
				$reportArray[$arrayIndex][6] = $totalAppliedHours;
				$reportArray[$arrayIndex][7] = '';
				$reportArray[$arrayIndex][8] = '';
				$reportArray[$arrayIndex][9] = '';
				$reportArray[$arrayIndex][10] = '';
				$reportArray[$arrayIndex][11] = $totalTimeHours;
				$ouHours = -($totalEstHours - $totalAppliedHours);
				$diffHours = $ouHours;
				if ($diffHours < 0)
					$diffHours = -$diffHours;

				$ouPct = 0.0;
				$sign = '';
				if ($totalEstHours > 0)
				{
					$ouPct = $diffHours / $totalEstHours * 100;
					if ($totalEstHours > $totalAppliedHours && $totalEstHours > 0)
						$sign = '-';
					else if ($totalAppliedHours > $totalEstHours && $totalAppliedHours > 0)
							$sign = '+';
				}

				$reportArray[$arrayIndex][12] = sprintf('%s%0.2f&nbsp;(%s%0.2f%%)', $sign, abs($ouHours), $sign, abs($ouPct));
				$nameArray = array(
						STR_WOST_SUMMARY, 
						STR_WOST_STATUSABB, 
						STR_WOST_PRIORITYABB, 
						STR_WOST_SEVERITYABB, 
						STR_WOST_BUDGET, 
						STR_WOST_ETC, 
						STR_WOST_TODATE, 
						STR_WOST_ESTSTART, 
						STR_WOST_ESTEND, 
						STR_WOST_START, 
						STR_WOST_END, 
						STR_WOST_TIME, 
						'+&nbsp;/&nbsp;-'
					);
				PrintArrayAsChocoTable($nameArray, $reportArray, sprintf(STR_WOST_ACTIVITYTITLE, $objP->firstNameLast, $GLOBALS['begindate'], $GLOBALS['enddate']));
			}
			else
			{
				print('<center>');
				PrintWithChocoFont(STR_WOST_NOACTIVITY);
				print('</center>');
			}
		}
		else
			print(STR_WOST_QUERYERR);
	}
}
?>
