<?php
/*
 * $Id: class.jsAttributesets.inc.php,v 1.2.4.1 2002/10/22 00:32:08 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

// Generate JavaScript for attribute sets
class jsAttributesets
{
	var $bActions;
	var $bPriorities;
	var $bSeverities;
	var $bStatuses;
	var $bModules;
	var $forWhat;
	var $db;
	var $arrSets;

	function jsAttributesets()
	{
		$this->bActions = false;
		$this->bPriorities = false;
		$this->bSeverities = false;
		$this->bStatuses = false;
		$this->bModules = false;
		$this->forWhat = 'wo'; // tck for tickets - change from calling function
		$this->arrSets = array();
	}

	function _buildSelectArray($table)
	{
		switch($table)
		{
			case 'actions':
				$typeid = 1;
				break;
			case 'priorities':
				$typeid = 2;
				break;
			case 'severities':
				$typeid = 3;
				break;
			case 'statuses':
				$typeid = 4;
				break;
		}

		printf("var a%d=new Array();\n", $typeid);
		$this->db->Query("SELECT id,name FROM $table WHERE active='Y' ORDER BY name");
		while ($this->db->next_record())
		{
			printf("a%d[%d]='%s';\n", $typeid, $this->db->f(0), $this->db->f(1));
		}
	}
	
	function _buildModuleArray()
	{
		$this->db->Query('SELECT product_module_id, product_id, module_name, active From dcl_product_module Order By product_id, module_name');
		print("var iCurr=0;\nvar pm=new Array();\n");
		if ($this->db->next_record())
		{
			$iCurrIdx = -1;
			do
			{
				if ($iCurrIdx != $this->db->f(1))
				{
					$iCurrIdx = $this->db->f(1);
					printf("pm[%d]=new Array();\n", $iCurrIdx);
				}

				printf("iCurr=pm[%d].length;\n", $iCurrIdx);
				printf("pm[%d][iCurr]=new Array();\n", $iCurrIdx, $iCurrIdx);
				printf("pm[%d][iCurr][0]=%d;\n", $iCurrIdx, $this->db->f(0));
				printf("pm[%d][iCurr][1]='%s';\n", $iCurrIdx, $this->db->f(2));
				printf("pm[%d][iCurr][2]='%s';\n", $iCurrIdx, $this->db->f(3));
			}
			while ($this->db->next_record());
		}
	}

	function _buildMapArray($table)
	{
		switch($table)
		{
			case 'actions':
				$typeid = 1;
				$order = 'b.name';
				break;
			case 'priorities':
				$typeid = 2;
				$order = 'a.weight';
				break;
			case 'severities':
				$typeid = 3;
				$order = 'a.weight';
				break;
			case 'statuses':
				$typeid = 4;
				$order = 'b.name';
				break;
		}

		$field = $this->forWhat . 'setid';

		print("\nvar m$typeid=new Array();\n");

		reset($this->arrSets);
		while (list($setid, $junk) = each($this->arrSets))
		{
			$query = "SELECT a.keyid FROM attributesetsmap a, $table b WHERE ";
			$query .= "a.setid=$setid AND a.typeid=$typeid AND b.id=a.keyid ORDER BY $order";
			$this->db->Query($query);
			$prevID = -1;
			while ($this->db->next_record())
			{
				if ($prevID != $setid)
				{
					printf("m%d[%d]=new Array();\n", $typeid, $setid);
					$prevID = $setid;
				}
				printf("m%d[%d][m%d[%d].length]=%d;\n", $typeid, $setid, $typeid, $setid, $this->db->f(0));
			}
		}
	}

	function _buildProductSetArray()
	{
		$field = $this->forWhat . 'setid';
		$query = "SELECT id,$field FROM products ORDER BY id";
		$this->db->Query($query);

		print("\nvar p = new Array();\n");
		while ($this->db->next_record())
		{
			$id = $this->db->f(0);
			$setid = $this->db->f(1);

			// Save unique set ids
			if (!IsSet($this->arrSets[$setid]))
				$this->arrSets[$setid] = 1;

			printf("p[%d]=%d;\n", $id, $setid);
		}
	}

	function _buildChgFunction($table)
	{
		$err = '';
		switch($table)
		{
			case 'actions':
				$typeid = 1;
				$ctrl = 'action';
				break;
			case 'priorities':
				$typeid = 2;
				$ctrl = 'priority';
				break;
			case 'severities':
				$typeid = 3;
				if ($this->forWhat == 'wo')
					$ctrl = 'severity';
				else
					$ctrl = 'type';
				break;
			case 'statuses':
				$typeid = 4;
				$ctrl = 'status';
				break;
		}

		printf("function chg%s(f){\n", $ctrl);
		print(" var a=f.elements[\"product\"].options[f.elements[\"product\"].selectedIndex].value;\n");
		print(" var c=f.elements[\"$ctrl\"];\n");
		print(" if (!c) return;\n");
		print(" var j=c.options[c.selectedIndex].value;\n"); // Save selected index just in case
		print(" c.length=1;\n"); // Keep the "Select One" option
		printf(" if(m%d[p[a]]){\n", $typeid);
		printf("  for(var i=0;i<m%d[p[a]].length;i++){\n", $typeid);
		print("    var o=new Option();\n");
		printf("    o.value=m%d[p[a]][i];\n", $typeid);
		printf("    o.text=a%d[m%d[p[a]][i]];\n", $typeid, $typeid);
		print("    o.selected=(j==o.value);\n");
		print("    c.options[c.length]=o;\n");
		print("  }\n");
		print(" }\n");
		if ($typeid == 2)
			print(" if (c.length==1) alert('" . STR_CMMN_NOPRIORITIESFORPRODUCT . "');\n");
		else
			print(" if (c.length==1) alert('" . STR_CMMN_NOSEVERITIESFORPRODUCT . "');\n");
		print("}\n");

	}

	function _buildChgModuleFunction()
	{
		$err = '';

		print("function chgModule(f){\n");
		print(" var a=f.elements['product'].options[f.elements['product'].selectedIndex].value;\n");
		print(" var c=f.elements['module_id'];\n");
		print(" if (!c) return;\n");
		print(" var j=c.options[c.selectedIndex].value;\n"); // Save selected index just in case
		print(" c.length=1;\n"); // Keep the "Select One" option
		print(" if(pm[a]){\n");
		print("  for(var i=0;i<pm[a].length;i++){\n");
		print("    var o=new Option();\n");
		print("    o.value=pm[a][i][0];\n");
		print("    o.text=pm[a][i][1];\n");
		print("    o.selected=(j==o.value);\n");
		print("    c.options[c.length]=o;\n");
		print("  }\n");
		print(" }\n");
		print("}\n");
	}

	function DisplayAttributeScript()
	{
		if (!$this->bActions && !$this->bPriorities && !$this->bSeverities && !$this->bStatuses)
			return;

		$this->db = CreateObject('dcl.dbActions'); // Just for data access - doesn't matter which
		$this->db->Connect();

		print("<script language=\"JavaScript1.2\">\n");

		$calls = '';

		// Must be called first to build unique array of sets
		$this->_buildProductSetArray();

		if ($this->bActions)
		{
			$this->_buildSelectArray('actions');
			$this->_buildMapArray('actions');
			$this->_buildChgFunction('actions');
			$calls .= " chgaction(f);\n";
		}

		if ($this->bPriorities)
		{
			$this->_buildSelectArray('priorities');
			$this->_buildMapArray('priorities');
			$this->_buildChgFunction('priorities');
			$calls .= " chgpriority(f);\n";
		}

		if ($this->bSeverities)
		{
			$this->_buildSelectArray('severities');
			$this->_buildMapArray('severities');
			$this->_buildChgFunction('severities');
			if ($this->forWhat == 'wo')
				$calls .= " chgseverity(f);\n";
			else
				$calls .= " chgtype(f);\n";
		}

		if ($this->bStatuses)
		{
			$this->_buildSelectArray('statuses');
			$this->_buildMapArray('statuses');
			$this->_buildChgFunction('statuses');
			$calls .= " chgstatus(f);\n";
		}

		if ($this->bModules)
		{
			$this->_buildModuleArray();
			$this->_buildChgModuleFunction();
			$calls .= " chgModule(f);\n";
		}

		print("function productSelChange(f){\n");
		print(" var c=f.elements[\"product\"];\n");
		print(" if(c.options[c.selectedIndex].value<1)return;\n");
		print($calls);
		print("}\n");

		print('</script>');
	}
}
?>
