<?php
/*
 * $Id: class.htmlWOSearches.inc.php,v 1.2.4.4 2002/12/02 02:38:01 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('wo');

class htmlWOSearches
{		
	function Show()
	{
		global $dcl_info;

		$objPersonnel = CreateObject('dcl.htmlPersonnel');
		$objProducts = CreateObject('dcl.htmlProducts');
		$objPriorities = CreateObject('dcl.htmlPriorities');
		$objSeverities = CreateObject('dcl.htmlSeverities');
		$objAccounts = CreateObject('dcl.htmlAccounts');
		$objStatuses = CreateObject('dcl.htmlStatuses');

		$Template = CreateTemplate(array('hForm' => 'htmlWorkOrderSearch.tpl'));
		$Template->set_block('hForm', 'acols', 'hAcols');
		$Template->set_block('hForm', 'columnlist', 'hColumnlist');

		$Template->set_var('hAcols', '');
		$Template->set_var('hColumnlist', '');

		$Template->set_var('VAL_JSDATEFORMAT', GetJSDateFormat());
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);

		$Template->set_var('BTN_SEARCH', STR_CMMN_SEARCH);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('BTN_COL', STR_CMMN_COL);
		$Template->set_var('BTN_GRP', STR_CMMN_GRP);
		$Template->set_var('BTN_ORD', STR_CMMN_SRT);
		$Template->set_var('BTN_RM', STR_CMMN_RM);
		$Template->set_var('BTN_UP', STR_CMMN_UP);
		$Template->set_var('BTN_DN', STR_CMMN_DN);

		$Template->set_var('TXT_TITLE', STR_WO_SEARCHTITLE . '&nbsp;' . GetHelpLink());
		$Template->set_var('TXT_RESPONSIBLE', STR_WO_RESPONSIBLE);
		$Template->set_var('TXT_OPENBY', STR_WO_OPENBY);
		$Template->set_var('TXT_CLOSEBY', STR_WO_CLOSEBY);
		$Template->set_var('TXT_PRODUCT', STR_WO_PRODUCT);
		$Template->set_var('TXT_PRIORITY', STR_WO_PRIORITY);
		$Template->set_var('TXT_SEVERITY', STR_WO_SEVERITY);
		$Template->set_var('TXT_ACCOUNT', STR_WO_ACCOUNT);
		$Template->set_var('TXT_STATUS', STR_WO_STATUS);
		$Template->set_var('TXT_OPENEDON', STR_WO_OPENEDON);
		$Template->set_var('TXT_CLOSEDON', STR_WO_CLOSEDON);
		$Template->set_var('TXT_STATUSON', STR_WO_STATUSON);
		$Template->set_var('TXT_LASTACTION', STR_WO_LASTACTION);
		$Template->set_var('TXT_DEADLINE', STR_WO_DEADLINE);
		$Template->set_var('TXT_ESTSTART', STR_WO_ESTSTART);
		$Template->set_var('TXT_ESTEND', STR_WO_ESTEND);
		$Template->set_var('TXT_START', STR_WO_START);
		$Template->set_var('TXT_SUMMARY', STR_WO_SUMMARY);
		$Template->set_var('TXT_NOTES', STR_WO_NOTES);
		$Template->set_var('TXT_DESCRIPTION', STR_WO_DESCRIPTION);
		$Template->set_var('TXT_FROM', STR_CMMN_FROM);
		$Template->set_var('TXT_TO', STR_CMMN_TO);
		$Template->set_var('TXT_REPORTOPTIONS', STR_WO_REPORTOPTIONS);
		$Template->set_var('TXT_REPORTTITLE', STR_CMMN_TITLE);
		$Template->set_var('TXT_STYLE', STR_CMMN_STYLE);
		$Template->set_var('TXT_AVAILABLECOLUMNS', STR_CMMN_AVAILCOLS);
		$Template->set_var('TXT_SHOWCOLUMNS', STR_CMMN_SHOWCOLS);
		$Template->set_var('TXT_GROUPING', STR_CMMN_GROUPING);
		$Template->set_var('TXT_SORTING', STR_CMMN_SORTING);

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_HAVE_WO'])
		{
			$Template->set_var('CHK_RESPONSIBLE', ' checked');
			$Template->set_var('CHK_CREATEBY', '');
		}
		else
		{
			$Template->set_var('CHK_CREATEBY', ' checked');
			$Template->set_var('CHK_RESPONSIBLE', '');
		}

		$Template->set_var('CMB_PERSONNEL', $objPersonnel->GetCombo($GLOBALS['DCLID'], 'personnel', 'lastfirst', 8, false));

		$Template->set_var('CMB_PRODUCTS', $objProducts->GetCombo(0, 'product', 'name', 0, 8, false));
		$Template->set_var('CMB_PRIORITIES', $objPriorities->GetCombo(0, 'priority', 'name', 8, false));
		$Template->set_var('CMB_SEVERITIES', $objSeverities->GetCombo(0, 'severity', 'name', 8, false));
		$Template->set_var('CMB_ACCOUNTS', $objAccounts->GetCombo(0, 'account', 'name', 8, false));
		$Template->set_var('CMB_STATUSES', $objStatuses->GetCombo(1, 'status', 'name', 8));

		$aFewDaysAgo = mktime(0, 0, 0, date('m'), date('d') - 3, date('Y'));
		$Template->set_var('VAL_DATEFROM', date($dcl_info['DCL_DATE_FORMAT'], $aFewDaysAgo));
		$Template->set_var('VAL_DATETO', date($dcl_info['DCL_DATE_FORMAT']));

		$aCols = array(
				'dcl_product_module.module_name' => 'Module*',
				'dcl_projects.name' => STR_WO_PROJECT,
				'accounts.name' => STR_WO_ACCOUNT,
				'createdby.short' => STR_WO_OPENBY,
				'createdon' => STR_WO_OPENEDON,
				'closedby.short' => STR_WO_CLOSEBY,
				'closedon' => STR_WO_CLOSEDON,
				'statuson' => STR_WO_STATUSON,
				'lastactionon' => STR_WO_LASTACTION,
				'deadlineon' => STR_WO_DEADLINE,
				'eststarton' => STR_WO_ESTSTART,
				'estendon' => STR_WO_ESTEND,
				'starton' => STR_WO_START,
				'esthours' => STR_WO_ESTHOURS,
				'etchours' => STR_WO_ETCHOURS,
				'totalhours' => STR_WO_ACTHOURS,
				'priorities.name' => STR_WO_PRIORITY,
				'severities.name' => STR_WO_SEVERITY,
				'revision' => STR_WO_REVISION,
				'contact' => STR_WO_CONTACT,
				'contactphone' => STR_WO_CONTACTPHONE,
				'notes' => STR_WO_NOTES,
				'description' => STR_WO_DESCRIPTION
			);

		while (list($val, $text) = each($aCols))
		{
			$Template->set_var('VAL_ACOLSVALUE', htmlspecialchars($val));
			$Template->set_var('VAL_ACOLSTEXT', htmlspecialchars($text));
			$Template->parse('hAcols', 'acols', true);
		}

		$aShow = array(
				'jcn' => STR_WO_JCN,
				'seq' => STR_WO_SEQ,
				'responsible.short' => STR_WO_RESPONSIBLE,
				'products.name' => STR_WO_PRODUCT,
				'statuses.name' => STR_WO_STATUS,
				'summary' => STR_WO_SUMMARY
			);

		while (list($val, $text) = each($aShow))
		{
			$Template->set_var('VAL_COLSVALUE', htmlspecialchars($val));
			$Template->set_var('VAL_COLSTEXT', htmlspecialchars($text));
			$Template->parse('hColumnlist', 'columnlist', true);
		}

		$Template->pparse('out', 'hForm');			
	}

	function my()
	{
		$t = CreateTemplate(array('hForm' => 'htmlMyWorkorderSearches.tpl'));

		$t->set_var('TXT_TITLE', STR_WO_MYWOSEARCHES);
		$t->set_var('FORM_ACTION', menuLink());
		$t->set_var('TXT_WOID', STR_WO_JCN);
		$t->set_var('TXT_SEQ', STR_WO_SEQ);
		$t->set_var('TXT_FIND', STR_CMMN_FIND);
		$t->set_var('TXT_VIEW', STR_CMMN_VIEW);
		$t->set_var('COLOR_DARK', $GLOBALS['dcl_info']['DCL_COLOR_DARK']);
		$t->set_var('COLOR_LIGHT',$GLOBALS['dcl_info']['DCL_COLOR_LIGHT']);

		$obj = CreateObject('dcl.htmlViews');
		$t->set_var('CMB_VIEWS', $obj->GetCombo(0, 'viewid', 0, true, 'workorders'));

		$t->pparse('out', 'hForm');
	}
}
?>
