<?php
/*
 * $Id: class.htmlView.inc.php,v 1.4.2.2.2.3 2002/10/30 21:39:57 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('vw');

class htmlView
{
	var $oCallback;
	var $sCallback;
	var $sFilterCallback;
	var $sColumnTitle;
	var $bColumnSort;
	var $bShowPager;
	var $sPagingMenuAction;

	function htmlView()
	{
		$this->oCallback = null;
		$this->sCallback = '';
		$this->sFilterCallback = '';
		$this->sColumnTitle = '';
		$this->bColumnSort = true;
		$this->bShowPager = true;
		$this->sPagingMenuAction = 'boViews.page';
	}

	function SetCallback($o, $sCallback = '', $sFilterCallback = '')
	{
		if (!is_object($o) || ($sCallback == '' && $sFilterCallback == ''))
		{
			$o = NULL;
			$sCallback = '';
			$sFilterCallback = '';
			return;
		}

		$this->oCallback = $o;
		$this->sCallback = $sCallback;
		$this->sFilterCallback = $sFilterCallback;
	}

	function Render($objView)
	{
		global $dcl_info;

		if (!is_object($objView))
		{
			print('[htmlView::RenderReport] ' . STR_VW_VIEWOBJECTNOTPASSED);
			return;
		}

		// check to see if we have the method specified
		if (!is_object($this->oCallback) || ($this->sCallback == '' && $this->sFilterCallback == ''))
		{
			$this->oCallback = null;
		}

		$whatObject = $this->GetClassNameForTable($objView->table);
		if ($whatObject == '')
			return;

		$objDB = CreateObject('dcl.' . $whatObject);
		$objDB->Connect();
		$bNext = false;
		$bPrev = false;
		$sForm = '';
		$result = 0;

		if ($objView->numrows > 0 || $objView->startrow > 0)
		{
			$url = $objView->GetURL();
			$sForm = $this->GetPagerFormElements($objView, $bPrev, $bNext);
			$result = $objDB->LimitQuery($objView->GetSQL(), $objView->startrow, $objView->numrows);
		}
		else
			$result = $objDB->Query($objView->GetSQL());

		if ($result == -1)
		{
			print('<center><h4>');
			printf(STR_VW_QUERYERR, $thisQuery);
			print('</h4></center>');
			return;
		}

		if (!$objDB->next_record())
		{
			printf('<center><h4>%s</h4></center>', STR_VW_NOMATCHES);
			return;
		}
?>
<style type="text/css">
th.heading {
 background-color: #CCCCCC;
}
</style>
<?php
		$this->JSToggle();

		if ($objView->title != '')
		{
			print('<center><h2>' . $objView->title . '</h2></center>');
		}

		print('<center>');
		if ($this->bShowPager && ($bNext || $bPrev))
		{
			print('<form method="post" action="' . menuLink() . '">');
			print($sForm);
			print('</form>');
		}
		if (is_object($this->oCallback) && $this->sFilterCallback != '')
		{
			$code = '$this->oCallback->' . $this->sFilterCallback . '($sForm);';
			eval($code);
		}
		if ($objView->table == 'tickets' || $objView->table == 'workorders')
		{
			print('<form method="post" action="' . menuLink() . '">');
			print($this->GetOptionsCombo($objView));
			print($objView->GetForm());
			print('<input type="submit" value="' . STR_CMMN_GO . '">');
		}

		$groups = array();
		$bNeedsHeader = true;
		$row = 0;

		print('<table border="0">');

		do // next_record already called to check for matches
		{
			if (count($objView->groups) > 0)
			{
				// Grouping the report, so check and display headings as needed
				$extraCols = 1;
				if ($GLOBALS['SEC'] >= $dcl_info['DCL_HAVE_WO'])
					$extraCols++;
				for ($i = 0; $i < count($objView->groups); $i++)
				{
					if (!IsSet($groups[$i]) || $groups[$i] != $objDB->f($i))
					{
						printf('<tr><th align="left" colspan="%d"', count($objView->columns) + $extraCols);
						if ($i == 0)
							print(' class="heading"');

						print('>');

						if ($i > 0)
							print(str_repeat('&nbsp;&nbsp;', $i));

						if ($i == 0 && $objDB->f($i) == '')
							print('&nbsp;');
						else
							printf('<font size="+1">%s</font>', htmlentities($objDB->f($i)));

						if ($i < (count($objView->groups) - 1))
						{
							for ($j = $i + 1; $j < count($objView->groups); $j++)
								unset($groups[$j]);
						}

						print('</th></tr>');

						$groups[$i] = $objDB->f($i);
						$bNeedsHeader = true;
					}
				}
			}

			if ($bNeedsHeader)
			{
				print('<tr>');

				if (count($objView->groups) > 0)
					print('<td>' . str_repeat('&nbsp;&nbsp;', count($objView->groups) + 1) . '</td>');

				if ($GLOBALS['SEC'] >= $dcl_info['DCL_HAVE_WO'] && $objView->table == 'workorders')
					print('<td class="header"><input type="checkbox" name="group_check" onclick="javascript: toggle(this);"></td>');

				for ($i = count($objView->groups); $i < (count($objView->groups) + count($objView->columns)); $i++)
				{
					if (count($objView->columnhdrs) > 0)
						$sHdr = $objView->columnhdrs[$i];
					else
						$sHdr = $objDB->GetFieldName($i);

					if ($this->bColumnSort)
					{
						$objView->ClearDef('order');
						$objView->AddDef('order', $objView->columns[$i - count($objView->groups)], '');

						$link = sprintf('<a class="agreyb" href="%s">%s</a>',
								menuLink('', 'menuAction=htmlView.execurl&' . $objView->GetURL()),
								$sHdr);
					}
					else
						$link = $sHdr;

					print("<th style=\"border-bottom: 2px solid black;\" align=\"left\">$link</th>");
				}

				// If there's a call back, output the column name for it
				if (is_object($this->oCallback))
				{
					print('<th style="border-bottom: 2px solid black;" align="left">' . $this->sColumnTitle . '</th>');
				}

				print('</tr>');
				$bNeedsHeader = false;
				$row = 0;
			}

			if (++$row % 2 == 0)
				print('<tr bgcolor="' . $dcl_info['DCL_COLOR_LIGHT'] . '">');
			else
				print('<tr>');

			if (count($objView->groups) > 0)
				print('<td bgcolor="#FFFFFF">' . str_repeat('&nbsp;&nbsp;', count($objView->groups) + 1) . '</td>');

			if ($GLOBALS['SEC'] >= $dcl_info['DCL_HAVE_WO'])
			{
				switch ($objView->table)
				{
					case 'workorders':
						printf('<td><input type="checkbox" name="selected[]" value="%d.%d"></td>',
							$objDB->f('jcn'),
							$objDB->f('seq'));
						break;
					case 'tickets__notused':
						printf('<td><input type="checkbox" name="selected[]" value="%d"></td>',
							$objDB->f('ticketid'));
						break;
				}
			}

			for ($i = count($objView->groups); $i < count($objView->columns) + count($objView->groups); $i++)
			{
				print('<td>');
				if (($objView->table == 'workorders' && ($objDB->GetFieldName($i) == 'jcn' || $objDB->GetFieldName($i) == 'seq')) || 
						($objView->table == 'tickets' && $objDB->GetFieldName($i) == 'ticketid'))
				{
					printf('<a class="agrey" style="text-decoration: underline;" href="');
					switch ($objView->table)
					{
						case 'workorders':
							print(menuLink('', sprintf('menuAction=boWorkorders.viewjcn&jcn=%d&seq=%d',
										$objDB->f('jcn'),
										$objDB->f('seq'))));
							break;
						case 'tickets':
							print(menuLink('', sprintf('menuAction=boTickets.view&ticketid=%d',
										$objDB->f('ticketid'))));
							break;
					}
					print('">');
				}

				if ($objView->table == 'tickets' && $objDB->GetFieldName($i) == 'seconds')
				{
					print($objDB->GetHoursText());
				}
				else
				{
					$str = $objDB->f($i);
					if ($str == '')
						print('&nbsp;');
					else
						print($objDB->f($i));
				}

				if (($objView->table == 'workorders' && ($objDB->GetFieldName($i) == 'jcn' || $objDB->GetFieldName($i) == 'seq')) || 
						($objView->table == 'tickets' && $objDB->GetFieldName($i) == 'ticketid'))
					print('</a>');

				print('</td>');
			}

			if (is_object($this->oCallback))
			{
				$code = '$this->oCallback->' . $this->sCallback . '($objDB->Record);';
				eval($code);
			}

			print('</tr>');
		}
		while ($objDB->next_record());

		print('</form></table>');
	}

	function GetOptionsCombo($objView)
	{
		global $dcl_info;

		$cmb = '<select name="menuAction">';
		$cmb .= sprintf('<option value="%s">%s</option>', 'boViews.add', STR_VW_SAVESEARCH);
		$cmb .= sprintf('<option value="%s">%s</option>', 'boViews.export', STR_VW_EXPORTRESULTS);
		switch ($objView->table)
		{
			case 'workorders':
				$cmb .= sprintf('<option value="%s">%s</option>', 'boWorkorders.batchdetail', 'Batch Detail');
				if ($GLOBALS['SEC'] >= $dcl_info['DCL_HAVE_WO'])
					$cmb .= sprintf('<option value="%s">%s</option>', 'boTimecards.batchadd', STR_VW_BATCHTIMECARD);
				break;
		}
		$cmb .= '</select>';
		return $cmb;
	}

	function GetPagerFormElements($oView, &$bPrev, &$bNext)
	{
		$oDB = new dclDB;
		$oDB->Connect();
		if ($oDB->Query($oView->GetSQL(true)) == -1)
		{
			print('<center><h4>');
			printf(STR_VW_QUERYERR, $thisQuery);
			print('</h4></center>');
			return;
		}
		$oDB->next_record();
		$count = $oDB->f(0);
		$oDB->FreeResult();

		$bNext = (($oView->startrow + $oView->numrows) < $count);
		$bPrev = ($oView->startrow > 0);

		$str = '';
		if ($this->sPagingMenuAction != '')
			$str = GetHiddenVar('menuAction', $this->sPagingMenuAction);
		if ($count <= $oView->numrows)
			return $str;

		$str .= $oView->GetForm();
		$str .= GetHiddenVar('startrow', $oView->startrow);
		$str .= GetHiddenVar('numrows', $oView->numrows);
		if ($bPrev)
			$str .= '<input type="submit" name="btnNav" value="&lt;&lt;">&nbsp;';
		$str .= '<b>Page ' . strval(($oView->startrow / $oView->numrows) + 1);
		if ($count % $oView->numrows == 0)
			$str .= ' of ' . strval($count / $oView->numrows) . '</b>';
		else
			$str .= ' of ' . strval(ceil($count / $oView->numrows)) . '</b>';
		if ($bNext)
			$str .= '&nbsp;<input type="submit" name="btnNav" value="&gt;&gt;">';

		return $str;
	}

	function GetClassNameForTable($sTable)
	{
		$whatObject = '';
		switch ($sTable)
		{
			case 'tickets':
			case 'workorders':
				$whatObject = 'db' . ucfirst($sTable);
				break;
			case 'dcl_projects':
				$whatObject = 'dbProjects';
				break;
			case 'dcl_chklst':
				$whatObject = 'dbChklst';
				break;
			case 'dcl_chklst_tpl':
				$whatObject = 'dbChklstTpl';
				break;
			case 'dcl_product_module':
				$whatObject = 'dbProductModules';
				break;
			default:
				printf(STR_VW_UNKNOWNTABLE, $sTable);
				return '';
		}

		return $whatObject;
	}

	function JSToggle()
	{
?>
<script language="JavaScript">
function toggle(btnSender)
{
 var bChk = btnSender.checked;
 var bOK = false;
 var e=btnSender.form.elements;
 for (var i=0;i<e.length;i++){
	if (!bOK && e[i] == btnSender)
		bOK = true;
	else if (bOK && (e[i].type != "checkbox" || e[i].name == "group_check"))
		return;
	else if (bOK && e[i].type == "checkbox")
		e[i].checked = bChk;
 }
}
</script>
<?php
	}

	function execurl()
	{
		commonHeader();

		$obj = CreateObject('dcl.boView');
		$obj->SetFromURL();

		$this->Render($obj);
	}
}
?>
