<?php
/*
 * $Id: class.htmlTimeCards.inc.php,v 1.3.2.1.2.1 2003/01/29 05:20:49 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('tc');
LoadStringResource('wo');

class htmlTimeCards
{
	function GetActionLinks($include, $enclose, $id, $dark)
	{
		global $dcl_info;

		$link = '';
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_MOD_WO'] && ereg('m', $include))
			$link .= GetLink(STR_TC_MODIFY, '', menuLink('', "menuAction=boTimecards.modify&id=$id"));

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_DEL_WO'] && ereg('x', $include))
		{
			if ($link != '')
				$link .= '|&nbsp;';

			$link .= GetLink(STR_TC_DELETE, '', menuLink('', "menuAction=boTimecards.delete&id=$id"));
		}

		return $link;
	}

	function ShowBatchWO()
	{
		global $dcl_info;

		$objWO = CreateObject('dcl.dbWorkorders');
		$objWO->Connect();
		$query = 'select a.jcn, a.seq, b.short, c.name, a.summary from workorders a, personnel b, statuses c ';
		$query .= 'where a.responsible=b.id and a.status=c.id and (';
		reset($GLOBALS['selected']);
		$bFirst = true;
		while (list($key, $jcnseq) = each($GLOBALS['selected']))
		{
			list($jcn, $seq) = explode('.', $jcnseq);
			if ($bFirst)
				$bFirst = false;
			else
				$query .= ' or ';
			$query .= "(a.jcn=$jcn and a.seq=$seq)";
		}
		$query .= ')';
		$objWO->Query($query);
		if ($objWO->next_record())
		{
			print('<table border="0" width="100%"><tr>');
			$columnhdrs = array(STR_WO_JCN, STR_WO_SEQ, STR_WO_RESPONSIBLE, STR_WO_STATUS, STR_WO_SUMMARY);
			for ($i = 0; $i < count($columnhdrs); $i++)
				print('<th style="border-bottom: 2px solid black;" align="left">' . $columnhdrs[$i] . '</th>');

			print('</tr>');
			$row = 0;

			do
			{
				if (++$row % 2 == 0)
					print('<tr bgcolor="' . $dcl_info['DCL_COLOR_LIGHT'] . '">');
				else
					print('<tr>');

				for ($i = 0; $i < $objWO->NumFields(); $i++)
				{
					print('<td>');
					$str = $objWO->f($i);
					if ($str == '')
						print('&nbsp;');
					else
						print($objWO->f($i));

					print('</td>');
				}

				print('</tr>');
			}
			while ($objWO->next_record());

			print('</table>');
		}
	}

	function GetTimeCards($jcn, $seq, $editID = 0, $forDelete = false)
	{
		global $dcl_info;

		$retVal = '';

		$objTimeCard = CreateObject('dcl.dbTimeCards');
		$objTimeCard->Connect();

		if ($objTimeCard->GetTimeCards($jcn, $seq) != -1)
		{
			$objPersonnel = CreateObject('dcl.dbPersonnel');
			$objPersonnel->Connect($objTimeCard->conn);
			$objStatus = CreateObject('dcl.dbStatuses');
			$objStatus->Connect($objTimeCard->conn);
			$objAction = CreateObject('dcl.dbActions');
			$objAction->Connect($objTimeCard->conn);

			$Template = CreateTemplate(array('hForm' => 'htmlTimeCardDetail.tpl'));
			$Template->set_block('hForm', 'nodelete', 'hNodelete');
			$Template->set_block('hForm', 'delete', 'hDelete');
			$Template->set_block('hForm', 'reassign', 'hReassign');

			$Template->set_var('hNodelete', '');
			$Template->set_var('hDelete', '');
			$Template->set_var('hReassign', '');

			$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
			$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
			$Template->set_var('BTN_DELETE', STR_CMMN_DELETE);
			$Template->set_var('BTN_CANCEL', STR_CMMN_CANCEL);
			$Template->set_var('VAL_FORMACTION', menuLink());

			$Template->set_var('TXT_STATUS', STR_TC_STATUS);
			$Template->set_var('TXT_VERSION', STR_TC_VERSION);
			$Template->set_var('TXT_ACTION', STR_TC_ACTION);
			$Template->set_var('TXT_HOURS', STR_TC_HOURS);
			$Template->set_var('TXT_DESCRIPTION', STR_TC_DESCRIPTION);
			$Template->set_var('TXT_REASSIGN', STR_CMMN_REASSIGN);
			$Template->set_var('TXT_TO', STR_CMMN_TO);
			$Template->set_var('TXT_INPUTON', 'Input On*');

			while ($objTimeCard->next_record())
			{
				$objTimeCard->GetRow();
				if (!$forDelete && $editID == $objTimeCard->id)
				{
					$retVal .= '<tr><th align="left" colspan="2">';
					$oTCF = CreateObject('dcl.htmlTimeCardForm');
					$retVal .= $oTCF->GetForm($objTimeCard->jcn, $objTimeCard->seq, $objTimeCard);
					$retVal .= '</th></tr>';
				}
				else
				{
					$objPersonnel->Load($objTimeCard->actionby);

					$Template->set_var('TXT_TITLE',
						sprintf(STR_TC_ACTIONTITLE,
							htmlspecialchars($objPersonnel->short),
							$objTimeCard->actionon,
							htmlspecialchars($objTimeCard->summary)));

					if ($objTimeCard->reassign_from_id > 0)
					{
						$objPersonnel->Load($objTimeCard->reassign_from_id);
						$Template->set_var('VAL_REASSIGNFROM', $objPersonnel->short);
					}

					if ($objTimeCard->reassign_to_id > 0)
					{
						$objPersonnel->Load($objTimeCard->reassign_to_id);
						$Template->set_var('VAL_REASSIGNTO', $objPersonnel->short);
					}

					if ($objTimeCard->reassign_from_id > 0 || $objTimeCard->reassign_to_id > 0)
						$Template->parse('hReassign', 'reassign');

					$Template->set_var('VAL_TIMECARDID', $objTimeCard->id);
					if (!$forDelete || $editID == 0)
					{
						$Template->set_var('LNK_OPTIONS', $this->GetActionLinks('mx', true, $objTimeCard->id, false));
						$Template->parse('hNodelete', 'nodelete');
					}
					else
						$Template->parse('hDelete', 'delete');

					$objStatus->Load($objTimeCard->status);
					$objAction->Load($objTimeCard->action);

					$Template->set_var('VAL_STATUS', htmlspecialchars($objStatus->name));
					$Template->set_var('VAL_REVISION', htmlspecialchars($objTimeCard->revision));
					$Template->set_var('VAL_ACTION', htmlspecialchars($objAction->name));
					$Template->set_var('VAL_HOURS', $objTimeCard->hours);
					$Template->set_var('VAL_DESCRIPTION', CreateLinkedText(nl2br(htmlspecialchars($objTimeCard->description))));
					$Template->set_var('VAL_INPUTON', $objTimeCard->inputon);

					$retVal .= $Template->parse('out', 'hForm');
				}
			}
		}

		return $retVal;
	}
}
?>
