<?php
/*
 * $Id: class.htmlTicketDetail.inc.php,v 1.3.2.1.2.2 2002/10/22 00:32:08 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('tck');

class htmlTicketDetail
{
	function Show($obj, $editResID = 0, $forDelete = false)
	{
		global $dcl_info;

		if (!is_object($obj))
		{
			print('A dbTickets object was not passed to htmlTicketDetail::Show()!');
			return;
		}

		$Template = CreateTemplate(array('hForm' => 'htmlTicketDetail.tpl'));

		$Template->set_block('hForm', 'delete', 'hDelete');
		$Template->set_block('hForm', 'action', 'hAction');
		$Template->set_block('hForm', 'closed', 'hClosed');
		$Template->set_block('hForm', 'attachments', 'hAttachments');

		$Template->set_var('hDelete', '');
		$Template->set_var('hAction', '');
		$Template->set_var('hClosed', '');
		$Template->set_var('hAttachments', '');

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('TXT_TITLE', sprintf(STR_TCK_TITLE, $obj->ticketid));
		$Template->set_var('BTN_DELETE', STR_CMMN_DELETE);
		$Template->set_var('BTN_CANCEL', STR_CMMN_CANCEL);
		$Template->set_var('VAL_TICKETID', $obj->ticketid);
		$Template->set_var('TXT_RESPONSIBLE', STR_TCK_RESPONSIBLE);
		$Template->set_var('TXT_PRIORITY', STR_TCK_PRIORITY);
		$Template->set_var('TXT_TYPE', STR_TCK_TYPE);
		$Template->set_var('TXT_PRODUCT', STR_TCK_PRODUCT);
		$Template->set_var('TXT_VERSION', STR_TCK_VERSION);
		$Template->set_var('TXT_TIME', STR_TCK_APPROXTIME);
		$Template->set_var('TXT_ACCOUNT', STR_TCK_ACCOUNT);
		$Template->set_var('TXT_CONTACT', STR_TCK_CONTACT);
		$Template->set_var('TXT_CONTACTPHONE', STR_TCK_CONTACTPHONE);
		$Template->set_var('TXT_CONTACTEMAIL', STR_TCK_CONTACTEMAIL);
		$Template->set_var('TXT_SUMMARY', STR_TCK_SUMMARY);
		$Template->set_var('TXT_ISSUE', STR_TCK_ISSUE);
		$Template->set_var('TXT_ON', STR_CMMN_ON);
		$Template->set_var('TXT_OPENEDBY', STR_TCK_OPENEDBY);
		$Template->set_var('TXT_LASTACTIONON', STR_TCK_LASTACTIONON);
		$Template->set_var('TXT_CLOSEDBY', STR_TCK_CLOSEDBY);
		$Template->set_var('TXT_ATTACHMENTS', STR_TCK_ATTACHMENTS);
		$Template->set_var('TXT_BYTES', STR_CMMN_BYTES);
		$Template->set_var('TXT_STATUS', STR_TCK_STATUS);
		$Template->set_var('TXT_MODULE', 'Module*');

		if ($forDelete && $editResID == 0)
		{
			$Template->parse('hDelete', 'delete');
		}
		else
		{
			$objH = CreateObject('dcl.htmlTickets');
			$Template->set_var('CMB_ACTION', $objH->GetActionCombo('tafexcw', true, $obj->ticketid, false));
			$Template->set_var('TXT_GO', STR_CMMN_GO);
			$Template->set_var('VAL_WATCHTYPE', '5');
			$Template->parse('hAction', 'action');
		}

		$objPersonnel = CreateObject('dcl.dbPersonnel');
		$objPersonnel->Connect($obj->conn);

		$objPersonnel->Load($obj->responsible);
		$Template->set_var('VAL_RESPONSIBLE', htmlspecialchars($objPersonnel->short));			
		$objPersonnel->Load($obj->createdby);
		$Template->set_var('VAL_CREATEDBY', htmlspecialchars($objPersonnel->short));

		$objPriority = CreateObject('dcl.dbPriorities');
		$objPriority->Connect($obj->conn);
		$objPriority->Load($obj->priority);
		$Template->set_var('VAL_PRIORITY', htmlspecialchars($objPriority->name));

		$objSeverity = CreateObject('dcl.dbSeverities');
		$objSeverity->Connect($obj->conn);
		$objSeverity->Load($obj->type);
		$Template->set_var('VAL_TYPE', htmlspecialchars($objSeverity->name));

		$objProduct = CreateObject('dcl.dbProducts');
		$objProduct->Connect($obj->conn);
		$objProduct->Load($obj->product);
		$Template->set_var('VAL_PRODUCT', htmlspecialchars($objProduct->name));

		if ($obj->module_id > 0)
		{
			$objModule = CreateObject('dcl.dbProductModules');
			$objModule->Connect($obj->conn);
			$objModule->Load($obj->module_id);
			$Template->set_var('VAL_MODULE', htmlspecialchars($objModule->module_name));
		}
		else
			$Template->set_var('VAL_MODULE', '');

		$objAccount = CreateObject('dcl.dbAccounts');
		$objAccount->Connect($obj->conn);
		$objAccount->Load($obj->account);
		$Template->set_var('VAL_ACCOUNT', htmlspecialchars($objAccount->name));

		$objStatus = CreateObject('dcl.dbStatuses');
		$objStatus->Connect($obj->conn);
		$objStatus->Load($obj->status);
		$Template->set_var('VAL_STATUS', htmlspecialchars($objStatus->name));

		$Template->set_var('VAL_VERSION', htmlspecialchars($obj->version));			
		$Template->set_var('VAL_HOURSTEXT', $obj->GetHoursText());
		$Template->set_var('VAL_CONTACT', htmlspecialchars($obj->contact));
		$Template->set_var('VAL_CONTACTPHONE', htmlspecialchars($obj->contactphone));
		$Template->set_var('VAL_CONTACTEMAIL', htmlspecialchars($obj->contactemail));
		$Template->set_var('VAL_CREATEDON', $obj->createdon);
		$Template->set_var('VAL_STATUSON', $obj->statuson);
		$Template->set_var('VAL_LASTACTIONON', $obj->lastactionon);
		$Template->set_var('VAL_SUMMARY', CreateLinkedText(nl2br(htmlspecialchars($obj->summary))));
		$Template->set_var('VAL_ISSUE', CreateLinkedText(nl2br(htmlspecialchars($obj->issue))));

		if ($objStatus->GetStatusType($obj->status) == 2)
		{
			$objPersonnel->Load($obj->closedby);
			$Template->set_var('VAL_CLOSEDBY', htmlspecialchars($objPersonnel->short));
			$Template->set_var('VAL_CLOSEDON', $obj->closedon);
			$Template->parse('hClosed', 'closed');
		}

		$attachPath = $dcl_info['DCL_FILE_PATH'] . '/attachments/tck/' . substr($obj->ticketid, -1) . '/' . $obj->ticketid . '/';
		if ($hDir = @opendir($attachPath))
		{
			$startedNewCell = false;
			$hasAttachments = false;
			while ($fileName = @readdir($hDir))
			{
				if (is_file($attachPath . $fileName) && is_readable($attachPath . $fileName))
				{
					if ($GLOBALS['SEC'] >= $dcl_info['DCL_ASSIGN_WO'])
					{
						$href = menuLink('', 'menuAction=boTickets.deleteattachment&filename=' . rawurlencode($fileName) . '&ticketid=' . $obj->ticketid);
						$link = '<a class="adark" href="' . $href . '">[ ' . STR_CMMN_DELETE . ' ]</a>&nbsp;';
						$Template->set_var('LNK_DELETEATTACHMENT', $link);
					}
					else
						$Template->set_var('LNK_DELETEATTACHMENT', '');

					$Template->set_var('VAL_FILELINK', menuLink('', 'menuAction=htmlTicketDetail.Download&filename=' . rawurlencode($fileName) . '&ticketid=' . $obj->ticketid));
					$Template->set_var('VAL_FILENAME', htmlspecialchars($fileName));
					$Template->set_var('VAL_FILESIZE', filesize($attachPath . $fileName));

					$Template->parse('hAttachments', 'attachments', true);
				}
			}
		}

           // Get resolutions
		$objTR = CreateObject('dcl.htmlTicketresolutions');
		$Template->set_var('TPL_RESOLUTIONS', $objTR->GetResolutions($obj->ticketid));

		$Template->pparse('out', 'hForm');
	}

	function Download()
	{
		global $dcl_info;

		// TODO: Security check
		$o = CreateObject('dcl.boFile');
		$o->iType = ATTACHMENT_TICKET;
		$o->iKey1 = $GLOBALS['ticketid'];
		$o->sFileName = $GLOBALS['filename'];
		$o->sRoot = $dcl_info['DCL_FILE_PATH'] . '/attachments';
		$o->Download();
	}
}
?>
