<?php
/*
 * $Id: class.dbWorkorders.inc.php,v 1.2.4.1 2002/10/22 00:32:08 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');
class dbWorkorders extends dclDB
{
	var $jcn;
	var $seq;
	var $product;
	var $account;
	var $createby;
	var $createdon;
	var $closedby;
	var $closedon;
	var $status;
	var $statuson;
	var $lastactionon;
	var $deadlineon;
	var $eststarton;
	var $estendon;
	var $starton;
	var $esthours;
	var $totalhours;
	var $priority;
	var $severity;
	var $contact;
	var $contactphone;
	var $summary;
	var $notes;
	var $description;
	var $responsible;
	var $revision;
	var $publicview;
	var $notifycreateby;
	var $notifyproductlead;
	var $notifyresponsible;
	var $etchours;
	var $module_id;

	function dbWorkorders()
	{
           // Table Fields
		$this->fieldArray = array('jcn', 'seq', 'product', 'account', 'createby', 'createdon', 'closedby', 
				'closedon', 'status', 'statuson', 'lastactionon', 'deadlineon', 'eststarton', 
				'estendon', 'starton', 'esthours', 'totalhours', 'priority', 'severity', 
				'contact', 'contactphone', 'summary', 'notes', 'description', 'responsible', 
				'revision', 'publicview', 'etchours', 'module_id');

           // Foreign Keys
		$this->foreignKeys = array();

		$this->cacheEnabled = false;
		$this->dclDB();
	}

	function Add()
	{
		global $dcl_info;

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

           // Fill in the blanks if this is a stripped down workorder input
           // by someone who cannot assign it due to insufficient security
		if ($GLOBALS['SEC'] < $dcl_info['DCL_ASSIGN_WO'])
		{
			if ($this->responsible == 0)
			{
				$objProduct = CreateObject('dcl.dbProducts');
				$objProduct->Connect($this->conn);
				$objProduct->Load($this->product);
				$this->responsible = $objProduct->reportto;
				$this->status = $dcl_info['DCL_DEF_STATUS_UNASSIGN_WO'];
			}
			else
			{
				$this->status = $dcl_info['DCL_DEF_STATUS_ASSIGN_WO'];
			}

			$this->esthours = 0.0;
			$tomorrow = mktime(0, 0, 0, date('m'), date('d') + 1, date('Y'));
			$this->deadlineon = date($dcl_info['DCL_DATE_FORMAT'], $tomorrow);
			$this->eststarton = date($dcl_info['DCL_DATE_FORMAT'], $tomorrow);
			$this->estendon = date($dcl_info['DCL_DATE_FORMAT'], $tomorrow);
			$this->severity = $dcl_info['DCL_DEF_SEVERITY'];
			$this->priority = $dcl_info['DCL_DEF_PRIORITY'];
		}
		else
		{
			$this->status = $dcl_info['DCL_DEF_STATUS_ASSIGN_WO'];
		}

		$idSQL = $this->GetNewIDSQLForTable('workorders');
		$query  = 'INSERT INTO workorders ';
		$query .= '(jcn,seq,product,account,createby,';
		$query .= 'createdon,status,statuson,deadlineon,';
		$query .= 'eststarton,estendon,esthours,totalhours,priority,';
		$query .= 'severity,contact,contactphone,summary,';
		$query .= 'notes,description,responsible,revision,etchours, module_id';
		$query .= ') VALUES (';

		if (IsSet($this->jcn) && $this->jcn > 0)
			$query .= $this->jcn . ',' . $this->GetSeqSQL($this->jcn) . ',';
		else
			$query .= $idSQL . ',1,';

		$query .= $this->product . ',' . $this->account . ',';
		$query .= $this->createby . ',' . $this->GetDateSQL() . ',' . $this->status . ',' . $this->GetDateSQL() . ',' . $this->DisplayToSQL($this->deadlineon) . ',';
		$query .= $this->DisplayToSQL($this->eststarton) . ',' . $this->DisplayToSQL($this->estendon) . ',' . $this->esthours . ',0.0,';
		$query .= $this->priority . ',' . $this->severity . ',\'' . $this->DBAddSlashes($this->contact) . '\',\'';
		$query .= $this->DBAddSlashes($this->contactphone) . '\',\'' . $this->DBAddSlashes($this->summary);
		$query .= '\',\'' . $this->DBAddSlashes($this->notes) . '\',\'';
		$query .= $this->DBAddSlashes($this->description) . '\','.$this->responsible . ',\'';
		$query .= $this->DBAddSlashes($this->revision) . '\',' . $this->esthours;
		if ($this->module_id > 0)
			$query .= ',' . $this->module_id;
		else
			$query .= ',NULL';

		$query .= ')';

		if ($this->Insert($query) == -1)
		{
			printf(STR_DB_WORKORDERINSERTERR, $query);
		}
		else
		{
			$this->Query('SELECT * FROM workorders WHERE oid=' . $this->oid);
			if ($this->next_record())
				$this->GetRow();
			else
				printf(STR_DB_WORKORDERBYOIDERR, $this->oid);
		}
	}

	function Edit()
	{
		$query = 'UPDATE workorders SET ';
		$query .= 'product=' . $this->product;
		$query .= ',account=' . $this->account;

		// MySQL likes to reset the timestamp field if it is not specified during edits
		$query .= ',createdon=' . $this->DisplayToSQL($this->createdon);

		if ($this->closedby != 0)
		{
			$query .= ',closedby=' . $this->closedby;
			$query .= ',closedon=' . $this->DisplayToSQL($this->closedon);
		}
		else
			$query .= ',closedon=null';
		$query .= ',status=' . $this->status;
		$query .= ',statuson=' . $this->DisplayToSQL($this->statuson);
		if ($this->lastactionon != '')
			$query .= ',lastactionon=' . $this->DisplayToSQL($this->lastactionon);
		else
			$query .= ',lastactionon=' . $this->emptyTimestamp;
		$query .= ',deadlineon=' . $this->DisplayToSQL($this->deadlineon);
		$query .= ',eststarton=' . $this->DisplayToSQL($this->eststarton);
		$query .= ',estendon=' . $this->DisplayToSQL($this->estendon);
		if ($this->starton != '')
			$query .= ',starton=' . $this->DisplayToSQL($this->starton);
		$query .= ',esthours=' . $this->esthours;
		$query .= ',totalhours=' . $this->totalhours;
		$query .= ',priority=' . $this->priority;
		$query .= ',severity=' . $this->severity;
		$query .= ',contact=\'' . $this->DBAddSlashes($this->contact) . '\'';
		$query .= ',contactphone=\'' . $this->DBAddSlashes($this->contactphone);
		$query .= '\',summary=\'' . $this->DBAddSlashes($this->summary) . '\'';
		$query .= ',notes=\'' . $this->DBAddSlashes($this->notes);
		$query .= '\',description=\'' . $this->DBAddSlashes($this->description) . '\'';
		$query .= ',responsible=' . $this->responsible;
		$query .= ',revision=\'' . $this->DBAddSlashes($this->revision) . '\'';
		$query .= ',etchours=' . $this->etchours;
		$query .= ',module_id=';
		if ($this->module_id > 0)
			$query .= $this->module_id;
		else
			$query .= 'NULL';

           /* Not implemented yet - or never will be
		$query .= ',publicview=' . $this->publicview;
		$query .= ',notifycreateby=' . $this->notifycreateby;
           $query .= ',notifyproductlead=' . $this->notifyproductlead;
		$query .= ',notifyresponsible=' . $this->notifyresponsible;
		*/
		$query .= ' WHERE jcn=' . $this->jcn . ' AND seq=' . $this->seq;

		$this->Execute($query);
	}

	function Delete()
	{
           // Should have been unmapped from any projects in a bo

		$this->BeginTransaction();
           // Bye, bye time cards!
		$query = 'DELETE FROM timecards WHERE jcn=' . $this->jcn . ' AND seq=' . $this->seq;
		$this->Execute($query);

           // And you! Clear off!
		$query = 'DELETE FROM workorders WHERE jcn=' . $this->jcn . ' AND seq=' . $this->seq;
		$this->Execute($query);
		$this->EndTransaction();
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		$this->jcn = $this->f('jcn');
		$this->seq = $this->f('seq');
		$this->product = $this->f('product');
		$this->account = $this->f('account');
		$this->createby = $this->f('createby');
		$this->createdon = $this->FormatTimeStampForDisplay($this->f('createdon'));
		$this->closedby = $this->f('closedby');
		$this->closedon = $this->FormatDateForDisplay($this->f('closedon'));
		$this->status = $this->f('status');
		$this->statuson = $this->FormatTimeStampForDisplay($this->f('statuson'));
		$this->lastactionon = $this->FormatTimeStampForDisplay($this->f('lastactionon'));
		$this->deadlineon = $this->FormatDateForDisplay($this->f('deadlineon'));
		$this->eststarton = $this->FormatDateForDisplay($this->f('eststarton'));
		$this->estendon = $this->FormatDateForDisplay($this->f('estendon'));
		$this->starton = $this->FormatDateForDisplay($this->f('starton'));
		$this->esthours = $this->f('esthours');
		$this->totalhours = $this->f('totalhours');
		$this->priority = $this->f('priority');
		$this->severity = $this->f('severity');
		$this->contact = $this->f('contact');
		$this->contactphone = $this->f('contactphone');
		$this->summary = $this->f('summary');
		$this->notes = $this->f('notes');
		$this->description = $this->f('description');
		$this->responsible = $this->f('responsible');
		$this->revision = $this->f('revision');
		$this->publicview = $this->f('publicview');
		$this->etchours = $this->f('etchours');
		$this->module_id = $this->f('module_id');
	}

	function Load($jcn, $seq)
	{
		$this->Clear();

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = "SELECT * FROM workorders WHERE jcn=$jcn AND seq=$seq";
		if (!$this->Query($sql))
			return -1;

		if (!$this->next_record())
			return -1;

		return $this->GetRow();
	}

	function Clear()
	{
		$this->jcn = 0;
		$this->seq = 0;
		$this->product = 0;
		$this->account = 0;
		$this->createby = 0;
		$this->createdon = '';
		$this->closedby = 0;
		$this->closedon = '';
		$this->status = 0;
		$this->statuson = '';
		$this->lastactionon = '';
		$this->deadlineon = '';
		$this->eststarton = '';
		$this->estendon = '';
		$this->starton = '';
		$this->esthours = 0.0;
		$this->totalhours = 0.0;
		$this->priority = 0;
		$this->severity = 0;
		$this->contact = '';
		$this->contactphone = '';
		$this->summary = '';
		$this->notes = '';
		$this->description = '';
		$this->responsible = 0;
		$this->revision = '';
		$this->publicview = FALSE;
		$this->etchours = 0.0;
		$this->module_id = 0;
	}

	function IsInAProject()
	{
		$obj = new dclDB;
		$obj->Connect();
		if ($obj->Query('SELECT count(*) FROM projectmap WHERE jcn=' . $this->jcn . ' and seq in (0,' . $this->seq . ')') == -1)
			return false;

		$obj->next_record();
		return ($obj->f(0) > 0);
	}
}
?>
