<?php
/*
 * $Id: class.boTickets.inc.php,v 1.10.2.2.2.4 2003/01/29 05:43:10 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('bo');
LoadStringResource('tck');

class boTickets
{
	function search()
	{
		commonHeader();

		$obj = CreateObject('dcl.htmlTicketSearches');
		$obj->DisplaySearchForm();
	}

	function add()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.htmlTicketForm');
		$obj->Show();
	}

	function dbadd()
	{
		global $dcl_info;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbTickets');
		$obj->Connect();

		$obj->InitFromGlobals();
		$obj->createdby = $GLOBALS['DCLID'];

		// If responsible is set, InitFromGlobals would have fetched it above
		// If not set, get the ticket lead for the product
		if (!IsSet($GLOBALS['responsible']))
		{
			$objProduct = CreateObject('dcl.dbProducts');
			$objProduct->Connect($obj->conn);
			$objProduct->Load($obj->product);
			$obj->responsible = $objProduct->ticketsto;
		}

		$obj->statuson = date($dcl_info['DCL_TIMESTAMP_FORMAT']);

		if ($GLOBALS['resolution'] != '')
			$obj->lastactionon = date($dcl_info['DCL_TIMESTAMP_FORMAT']);

		$oStatus = CreateObject('dcl.dbStatuses');
		if ($oStatus->GetStatusType($obj->status) == 2)
		{
			$obj->closedby = $GLOBALS['DCLID'];
			$obj->closedon = date($dcl_info['DCL_TIMESTAMP_FORMAT']);
		}

		$obj->seconds = 0;
		$obj->Add();

		if ($GLOBALS['resolution'] != '')
		{
			$objR = CreateObject('dcl.dbTicketresolutions');
			$objR->Connect($obj->conn);
			$objR->InitFromGlobals();
			$objR->loggedby = $GLOBALS['DCLID'];
			$objR->loggedon = date($dcl_info['DCL_TIMESTAMP_FORMAT']);
			$objR->ticketid = $obj->ticketid;
			$objR->Add();

			$start = new DCLTimestamp;
			$start->SetFromDisplay($objR->startedon);

			$end = new DCLTimestamp;
			$end->SetFromDisplay($objR->loggedon);

			$obj->seconds += ($end->time - $start->time);
			$obj->Edit();
		}

		$notify = '4,1';
		if ($oStatus->GetStatusType($obj->status) == 2)
			$notify .= ',2,3';

		$objWatch = CreateObject('dcl.boWatches');
		$objWatch->sendTicketNotification($obj, $notify);

		$objTR = CreateObject('dcl.boTicketresolutions');
		$objTR->sendCustomerResponseEmail($obj);

		$objH = CreateObject('dcl.htmlTicketDetail');
		$objH->Show($obj);
	}

	// THANKS: Michael Brader
	function copyToWO()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbTickets');
		$obj->Connect();
		$obj->Load($GLOBALS['ticketid']);

		$objHWO = CreateObject('dcl.htmlWorkOrderForm');
		$objHWO->Show(0, '', $obj);
	}

	function modify()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_MOD_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbTickets');
		$obj->Connect();
		$obj->Load($GLOBALS['ticketid']);

		$objF = CreateObject('dcl.htmlTicketForm');
		$objF->Show($obj);

		$objH = CreateObject('dcl.htmlTicketDetail');
		$objH->Show($obj);
	}

	function dbmodify()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_MOD_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbTickets');
		$obj->Connect();
		$obj->Load($GLOBALS['ticketid']);

		$obj->product = $GLOBALS['product'];
		$obj->module_id = $GLOBALS['module_id'];
		$obj->account = $GLOBALS['account'];
		$obj->priority = $GLOBALS['priority'];
		$obj->type = $GLOBALS['type'];

		$obj->summary = $obj->GPCStripSlashes($GLOBALS['summary']);
		$obj->version = $obj->GPCStripSlashes($GLOBALS['version']);
		$obj->contact = $obj->GPCStripSlashes($GLOBALS['contact']);
		$obj->issue = $obj->GPCStripSlashes($GLOBALS['issue']);
		$obj->contactphone = $obj->GPCStripSlashes($GLOBALS['contactphone']);
		$obj->contactemail = $obj->GPCStripSlashes($GLOBALS['contactemail']);

		$oldResponsible = $obj->responsible;
		if (!IsSet($GLOBALS['responsible']))
		{
			$objProduct = CreateObject('dcl.dbProducts');
			$objProduct->Connect($obj->conn);
			$objProduct->Load($obj->product);
			$obj->responsible = $objProduct->ticketsto;
		}
		else
			$obj->responsible = $GLOBALS['responsible'];

		$obj->Edit();

		if ($oldResponsible != $obj->responsible && $obj->responsible != $GLOBALS['DCLID'])
			$this->SendNewMailMsg($obj);

		$objH = CreateObject('dcl.htmlTicketDetail');
		$objH->Show($obj);
	}

	function delete()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_DEL_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbTickets');
		$obj->Connect();
		$obj->Load($GLOBALS['ticketid']);

		$objH = CreateObject('dcl.htmlTicketDetail');
		$objH->Show($obj, 0, true);
	}

	function dbdelete()
	{
		global $dcl_info;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_DEL_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbTickets');
		$obj->Connect();
		$obj->ticketid = $GLOBALS['ticketid'];

		$obj->Delete();

		// Remove all attachments
		$attachPath = $dcl_info['DCL_FILE_PATH'] . '/attachments/tck/' . substr($GLOBALS['ticketid'], -1) . '/' . $GLOBALS['ticketid'] . '/';
		if ($hDir = @opendir($attachPath))
		{
			while ($fileName = @readdir($hDir))
			{
				if (is_file($attachPath . $fileName) && is_readable($attachPath . $fileName))
					unlink($attachPath . $fileName);
			}

			@closedir($hDir);
		}

		print('<center>');
		PrintWithChocoFont(sprintf(STR_BO_TICKETDELETED, $GLOBALS['ticketid']));
		print('</center>');

		$objMy = CreateObject('dcl.htmlMyDCL');
		$objMy->showMy();
	}

	function view()
	{
		commonHeader();

		$objTicket = CreateObject('dcl.dbTickets');
		$objTicket->Connect();

		if ($objTicket->Load($GLOBALS['ticketid']) != -1)
		{
			$objHT = CreateObject('dcl.htmlTicketDetail');
			$objHT->Show($objTicket);
		}
		else
		{
			print('<center><h3>');
			printf(STR_TCK_COULDNOTFIND, $GLOBALS['ticketid']);
			print('</h3></center>');
			$objMy = CreateObject('dcl.htmlMyDCL');
			$objMy->showMy();
		}
	}

	function graph()
	{
		commonHeader();

		// GD is required, so short-circuit if not installed
		if (!extension_loaded('gd'))
		{
			print('<center>');
			PrintWithChocoFont(STR_BO_GRAPHNEEDSGD);
			print('</center>');
			return;
		}

		$obj = CreateObject('dcl.htmlTickets');
		$obj->DisplayGraphForm();
	}

	function showgraph()
	{
		commonHeader();

		// GD is required, so short-circuit if not installed
		if (!extension_loaded('gd'))
		{
			print('<center>');
			PrintWithChocoFont(STR_BO_GRAPHNEEDSGD);
			print('</center>');
			return;
		}

		$objG = CreateObject('dcl.boGraph');
		$obj = CreateObject('dcl.dbTickets');
		$obj->Connect();
		$beginDate = new DCLTimestamp;
		$endDate = new DCLTimestamp;
		$testDate = new DCLTimestamp;

		$endDate->SetFromDisplay($GLOBALS['dateFrom'] . ' 23:59:59');
		$beginDate->SetFromDisplay($GLOBALS['dateFrom'] . ' 00:00:00');
		$beginDate->time -= (($GLOBALS["days"] - 1) * 86400);
		$query = 'SELECT createdon,closedon FROM tickets WHERE ';
		$query .= '(createdon between ' . $obj->DisplayToSQL($beginDate->ToDisplay());
		$query .= ' AND ' . $obj->DisplayToSQL($endDate->ToDisplay());
		$query .= ') OR (closedon between ' . $obj->DisplayToSQL($beginDate->ToDisplay());
		$query .= ' AND ' . $obj->DisplayToSQL($endDate->ToDisplay()) . ')';
		$obj->Query($query);

		$objG->data[0] = array(); // Open
		$objG->data[1] = array(); // Closed

		$daysBack = array();
		$testDate->time = $beginDate->time;
		for ($i = 0; $i < $GLOBALS['days']; $i++)
		{
			$daysBack[$i] = $testDate->time;
			// Set the relevant object properties while we're at it
			$objG->line_captions_x[$i] = date('m/d', $testDate->time);
			$objG->data[0][$i] = 0;
			$objG->data[1][$i] = 0;

			$testDate->time += 86400;
		}

		while ($obj->next_record())
		{
			for ($y = 0; $y < 2; $y++)
			{
				$testDate->SetFromDB($obj->f($y));
				$j = $GLOBALS['days'] - 1;
				while ($j >= 0)
				{
					if ($testDate->time >= $daysBack[$j])
					{
						if (!IsSet($objG->data[$y][$j]))
							$objG->data[$y][$j] = 0;
						$objG->data[$y][$j]++;
						break;
					}

					$j--;
				}
			}
		}

		$objG->title = STR_BO_GRAPHTITLE;
		$objG->caption_y = STR_BO_GRAPHCAPTIONY;
		$objG->caption_x = STR_BO_GRAPHCAPTIONX;
		$objG->num_lines_y = 15;
		$objG->num_lines_x = $GLOBALS['days'];
		$objG->colors = array('red', 'blue');

		print('<center>');
		echo '<img border="0" src="', menuLink('', 'menuAction=boGraph.Show&' . $objG->ToURL()), '">';
		print('</center>');
	}

	function reassign()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$objTicket = CreateObject('dcl.dbTickets');
		$objTicket->Connect();
		$objTicket->Load($GLOBALS['ticketid']);

		$obj = CreateObject('dcl.htmlTickets');
		$obj->PrintReassignForm($objTicket);

		$objHT = CreateObject('dcl.htmlTicketDetail');
		$objHT->Show($objTicket);
	}

	function dbreassign()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbTickets');
		$obj->Connect();
		$obj->Load($GLOBALS['ticketid']);
		if ($obj->responsible != $GLOBALS['responsible'] ||
				$obj->priority != $GLOBALS['priority'] ||
				$obj->type != $GLOBALS['type'])
		{
			$obj->responsible = $GLOBALS['responsible'];
			$obj->priority = $GLOBALS['priority'];
			$obj->type = $GLOBALS['type'];
			$obj->Edit();
			if ($obj->responsible != $GLOBALS['DCLID'])
				$this->SendNewMailMsg($obj);
		}

		$objHT = CreateObject('dcl.htmlTicketDetail');
		$objHT->Show($obj);
	}

	function upload()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		$objTicket = CreateObject('dcl.dbTickets');
		$objTicket->Connect();
		$objTicket->Load($GLOBALS['ticketid']);

		$obj = CreateObject('dcl.htmlTickets');
		$obj->ShowUploadFileForm($objTicket);

		$objD = CreateObject('dcl.htmlTicketDetail');
		$objD->Show($objTicket);
	}

	function doupload()
	{
		global $dcl_info, $HTTP_POST_VARS, $HTTP_GET_VARS, $HTTP_COOKIE_VARS;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		if (IsSet($GLOBALS['userfile']))
		{
			if ((IsSet($HTTP_POST_VARS['userfile']) && $HTTP_POST_VARS['userfile'] == $GLOBALS['userfile']) ||
				(IsSet($HTTP_GET_VARS['userfile']) && $HTTP_GET_VARS['userfile'] == $GLOBALS['userfile']) ||
				(IsSet($HTTP_COOKIE_VARS['userfile']) && $HTTP_COOKIE_VARS['userfile'] == $GLOBALS['userfile']))
			{
				return PrintPermissionDenied();
			}
		}

		if ($GLOBALS['userfile'] != 'none')
		{
			$o = CreateObject('dcl.boFile');
			$o->iType = ATTACHMENT_TICKET;
			$o->iKey1 = $GLOBALS['ticketid'];
			$o->sFileName = $GLOBALS['userfile_name'];
			$o->sTempFileName = $GLOBALS['userfile'];
			$o->sRoot = $dcl_info['DCL_FILE_PATH'] . '/attachments';
			$o->Upload();
		}

		$objTicket = CreateObject('dcl.dbTickets');
		$objTicket->Connect();
		$objTicket->Load($GLOBALS['ticketid']);

		$obj = CreateObject('dcl.htmlTicketDetail');
		$obj->Show($objTicket);
	}

	function deleteattachment()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$objTicket = CreateObject('dcl.dbTickets');
		$objTicket->Connect();
		$objTicket->Load($GLOBALS['ticketid']);

		$obj = CreateObject('dcl.htmlTickets');
		$obj->ShowDeleteAttachmentYesNo($GLOBALS['ticketid'], $GLOBALS['filename']);

		$objD = CreateObject('dcl.htmlTicketDetail');
		$objD->Show($objTicket);
	}

	function dodeleteattachment()
	{
		global $dcl_info;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$attachPath = $dcl_info['DCL_FILE_PATH'] . '/attachments/tck/' . substr($GLOBALS['ticketid'], -1) . '/' . $GLOBALS['ticketid'] . '/';
		if (is_file($attachPath . $GLOBALS['filename']) && is_readable($attachPath . $GLOBALS['filename']))
			unlink($attachPath . $GLOBALS['filename']);

		$objTicket = CreateObject('dcl.dbTickets');
		$objTicket->Connect();
		$objTicket->Load($GLOBALS['ticketid']);

		$obj = CreateObject('dcl.htmlTicketDetail');
		$obj->Show($objTicket);
	}

	function dbsearch()
	{
		commonHeader();

		global $responsible, $createdby, $closedby, $personnel, $product;
		global $type, $priority, $status, $account;
		global $createdon, $closedon, $statuson, $lastactionon;
		global $dateFrom, $dateTo;
		global $searchText, $columns, $groups, $order, $columnhdrs;

		if (strlen($columnhdrs) > 0)
			$columnhdrs = explode(',', $columnhdrs);
		else
			$columnhdrs = array();

		if (strlen($columns) > 0)
			$columns = explode(',', $columns);
		else
			$columns = array();

		if (strlen($groups) > 0)
			$groups = explode(',', $groups);
		else
			$groups = array();

		if (strlen($order) > 0)
			$order = explode(',', $order);
		else
			$order = array();

		$objView = CreateObject('dcl.boView');
		$objView->table = 'tickets';

		if (count($personnel) > 0)
		{
			$fieldList = array('responsible', 'createdby', 'closedby');
			while (list($key, $field) = each($fieldList))
			{
				if ($$field == '1')
					$objView->AddDef('filter', $field, $personnel);
			}
		}

		$fieldList = array('product', 'priority', 'type', 'account', 'status');
		while (list($key, $field) = each($fieldList))
		{
			if (count($$field) > 0)
				$objView->AddDef('filter', $field, $$field);
		}

		if ($dateFrom != '' || $dateTo != '')
		{
			if ($dateFrom != '')
				$dateFrom .= ' 00:00:00';

			if ($dateTo != '')
				$dateTo .= ' 23:59:59';

			$fieldList = array('createdon', 'closedon', 'statuson', 'lastactionon');

			while (list($key, $field) = each($fieldList))
			{
				if ($$field == '1')
					$objView->AddDef('filterdate', $field, array($dateFrom, $dateTo));
			}
		}

		if ($searchText != '')
		{
			$objView->AddDef('filterlike', 'issue', $searchText);
			$objView->AddDef('filterlike', 'summary', $searchText);
			$objView->AddDef('filterlike', 'tickets.contact', $searchText);
			$objView->AddDef('filterlike', 'contactphone', $searchText);
			$objView->AddDef('filterlike', 'contactemail', $searchText);
		}

		if (count($columns) > 0)
			$objView->AddDef('columns', '', $columns);
		else
			$objView->AddDef('columns', '',
				array('ticketid', 'responsible', 'product', 'account', 'status', 'contact', 'contactphone', 'summary'));

		if (count($groups) > 0)
			$objView->AddDef('groups', '', $groups);

		if (count($columnhdrs) > 0)
			$objView->AddDef('columnhdrs', '', $columnhdrs);

		if (count($order) > 0)
			$objView->AddDef('order', '', $order);
		else
			$objView->AddDef('order', '', array('ticketid'));


		$objView->style = 'report';

		if ($GLOBALS['title'] != '')
		{
			$o = CreateObject('dcl.dbPersonnel');
			$objView->title = $o->GPCStripSlashes($GLOBALS['title']);
		}
		else
			$objView->title = STR_TCK_TICKETSEARCHRESULTS;

		$obj = CreateObject('dcl.htmlView');
		$obj->Render($objView);
	}

	function SendNewMailMsg($obj)
	{
		global $dcl_info;

		if ($dcl_info['DCL_SMTP_ENABLED'] != 'Y' || !is_object($obj))
			return;

		$objPersonnel = CreateObject('dcl.dbPersonnel');
		$objPersonnel->Connect();
		$objPersonnel2 = CreateObject('dcl.dbPersonnel');
		$objPersonnel2->Connect($objPersonnel->conn);

		$mailFrom = '';
		if ($objPersonnel->Load($GLOBALS['DCLID']) != -1)
			$mailFrom = 'From: ' . $objPersonnel->firstNameLast . ' <' . $objPersonnel->email . '>';

		if ($objPersonnel->Load($obj->responsible) == -1)
			return;

		if ($objPersonnel2->Load($obj->createdby) == -1)
			return;

		if ($objPersonnel->email == '')
			return;

		$mailMsg = STR_BO_TICKETMAILMSG . phpCrLf . phpCrLf;
		$mailMsg .= STR_TCK_TICKET . ': ' . $obj->ticketid . phpCrLf;
		$mailMsg .= STR_TCK_OPENEDBY . ': ' . $objPersonnel2->lastNameFirst . phpCrLf;

		$objProduct = CreateObject('dcl.dbProducts');
		$objProduct->Connect($objPersonnel->conn);
		$objProduct->Load($obj->product);
		$mailMsg .= STR_TCK_PRODUCT . ': ' . $objProduct->name . phpCrLf;

		$mailSubj = sprintf('[%d] %s', $obj->ticketid, $objProduct->name);

		if ($this->account > 0)
		{
			$objAccount = CreateObject('dcl.dbAccounts');
			$objAccount->Connect($objPersonnel->conn);
			$objAccount->Load($obj->account);
			$mailMsg .= STR_TCK_ACCOUNT . ': ' . $objAccount->name . phpCrLf;
			$mailSubj .= ':' . $objAccount->name;
		}

		$mailMsg .= STR_TCK_CONTACT . ': ' . $obj->contact . phpCrLf . phpCrLf;
		$mailSubj .= ':' . $objAccount->contact;
		$link = $dcl_info['DCL_ROOT'] . 'main.php?menuAction=boTickets.view&ticketid=' . $obj->ticketid;
		$mailMsg .= sprintf(STR_BO_SEEDETAILAT, $link);
		$mailMsg .= phpCrLf . phpCrLf . STR_TCK_EMAILSIG;

		$oMail = CreateObject('dcl.boSMTP');
		$oMail->to = $objPersonnel->email;
		$oMail->from = $GLOBALS['USEREMAIL'];
		$oMail->subject = $mailSubj;
		$oMail->body = $mailMsg;
		$oMail->Send();

		print('<p><center>');
		PrintWithChocoFont(sprintf(STR_BO_MAILSENT, $objPersonnel->email));
		print('</center><p>');
	}

	function showmy()
	{
		commonHeader();
		$obj = CreateObject('dcl.htmlTickets');
		$obj->my(0);
	}
}
?>
