<?php
/*
 * $Id: class.boProjects.inc.php,v 1.4.2.1.2.4 2003/01/29 05:57:19 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('bo');
LoadStringResource('prj');

class boProjects
{
	function newproject()
	{
		global $dcl_info;

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ASSIGN_WO'])
		{
			commonHeader();
			$obj = CreateObject('dcl.htmlProjectsform');
			$obj->Show();
		}
		else
			PrintPermissionDenied();
	}

	function dbnewproject()
	{
		global $dcl_info;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$objProject = CreateObject('dcl.dbProjects');
		$objProject->Connect();
		if ($objProject->Exists($GLOBALS['name']))
		{
			print('<center>');
			PrintWithChocoFont(sprintf(STR_PRJ_ALREADYEXISTS, $GLOBALS['name']));
			print('</center>');
			return;
		}

		$objProject->InitFromGlobals();
		$objProject->createdby = $GLOBALS['DCLID'];
		$objProject->status = $dcl_info['DCL_DEFAULT_PROJECT_STATUS'];
		$objProject->Add();
		if ($dcl_info['DCL_PROJECT_XML_TEMPLATES'] == 'Y' && $GLOBALS['template'] != "0")
		{
               // user selected a template, so we must generate workorders
			$objXMLProject = CreateObject('dcl.xmlProjects');
			$params = explode('&', $GLOBALS['encodedparams']);
			$selectedParams = array();
			while (list($key,$param) = each($params))
			{
				list($key, $val) = split('=', $param);
				$selectedParams[$key] = $val;
			}
			$objXMLProject->createProjectFromTemplate($objProject->projectid, $GLOBALS['template'], $GLOBALS['projectdeadline'], $selectedParams);
		}

		if ($objProject->reportto != $GLOBALS['DCLID'])
			$this->SendNewMailMsg($objProject);

		$objHTMLProject = CreateObject('dcl.htmlProjectsdetail');
		$objHTMLProject->Show($objProject->projectid, 0, 0);
	}

	function search()
	{
		commonHeader();
		$objHTMLProjects = CreateObject('dcl.htmlProjects');
		$objHTMLProjects->DisplaySearchForm();
	}

	function addtoproject()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$objPM = CreateObject('dcl.dbProjectmap');
		$objPM->Connect();
		$objPM->Query('select * from projectmap where (jcn=' . $GLOBALS['jcn'] . " and seq=" . $GLOBALS['seq'] . ') or (jcn=' . $GLOBALS['jcn'] . ' and seq=0)');
		if ($objPM->next_record())
		{
			$objPM->GetRow();
			$objHTMLProjects = CreateObject('dcl.htmlProjectsdetail');
			$objHTMLProjects->Show($objPM->projectid, 0, 0);
		}
		else
		{
			$objHTMLProjectmap = CreateObject('dcl.htmlProjectmap');
			$objHTMLProjectmap->ChooseProjectForJCN($GLOBALS['jcn'], $GLOBALS['seq']);
		}
	}

	function dbaddtoproject()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$objPM = CreateObject('dcl.dbProjectmap');
		$objPM->Connect();
		$objPM->InitFromGlobals();
		if (IsSet($GLOBALS['addall']) && $GLOBALS['addall'] == '1')
		{
			$objPM->seq = 0;
               // Be sure all other entries for this JCN are deleted so they move to this project
			$objPM->Delete();
		}
		$objPM->Add();

		$objHTMLProjects = CreateObject('dcl.htmlProjectsdetail');
		$objHTMLProjects->Show($objPM->projectid, 0, 0);
	}

	function viewproject()
	{
		commonHeader();
		if ($GLOBALS['project'] > 0)
		{
			$obj = CreateObject('dcl.htmlProjectsdetail');
			if (!IsSet($GLOBALS['wostatus']))
				$GLOBALS['wostatus'] = 0;

			if (!IsSet($GLOBALS['woresponsible']))
				$GLOBALS['woresponsible'] = 0;

			$obj->show($GLOBALS['project'], $GLOBALS['wostatus'], $GLOBALS['woresponsible']);
		}
	}

	function showtree()
	{
		commonHeader();
		if ($GLOBALS['project'] > 0)
		{
			$obj = CreateObject('dcl.htmlProjectsdetail');
			if (!IsSet($GLOBALS['wostatus']))
				$GLOBALS['wostatus'] = 0;

			if (!IsSet($GLOBALS['woresponsible']))
				$GLOBALS['woresponsible'] = 0;

			$obj->showtree($GLOBALS['project'], $GLOBALS['wostatus'], $GLOBALS['woresponsible']);
		}
	}

	function modify()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbProjects');
		$obj->Connect();
		$obj->Load($GLOBALS['projectid']);
		$objHTML = CreateObject('dcl.htmlProjectsform');
		$objHTML->Show($obj);
	}

	function dbmodify()
	{
		global $dcl_info;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbProjects');
		$obj->Connect();
		if ($obj->Load($GLOBALS['projectid']) != -1)
		{
			$oStatus = CreateObject('dcl.dbStatuses');
			if ($oStatus->GetStatusType($GLOBALS['status']) == 2 && $oStatus->GetStatusType($obj->status) != 2)
			{
				// moving to closed
				$obj->finalclose = date($dcl_info['DCL_DATE_FORMAT']);
			}
			elseif ($oStatus->GetStatusType($GLOBALS['status']) != 2 && $oStatus->GetStatusType($obj->status) == 2)
			{
				// reopened
				$obj->finalclose = '';
			}

			$obj->InitFromGlobals();
			$objHTML = CreateObject('dcl.htmlProjectsdetail');
			if ($obj->parentprojectid > 0)
			{
				if (!$obj->ParentIsNotChild($obj->projectid, $obj->parentprojectid))
				{
					commonHeader();
					print('<center>');
					PrintWithChocoFont(STR_BO_PARENTISCHILD);
					print('</center><p>');
					$objHTML->ShowEntryForm($obj);
					return;
				}
			}
			$obj->Edit();
			$objHTML->Show($obj->projectid, 0, 0);
		}
		else
		{
			$o = CreateObject('dcl.htmlProjects');
			$o->show();
		}
	}

	function delete()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbProjects');
		$obj->Connect();
		$obj->Load($GLOBALS['projectid']);
		ShowDeleteYesNo('Project', 'boProjects.dbdelete', $obj->projectid, $obj->name, false, 'projectid');
	}

	function dbdelete()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbProjects');
		$obj->Connect();
		$obj->projectid = $GLOBALS['projectid'];
		$obj->Delete();

		// Wipe out any watches anyone may have had
		$oWatch = CreateObject('dcl.dbWatches');
		$oWatch->DeleteByObjectID(2, $obj->projectid);

		// Browse around some more
		$objHTMLProjects = CreateObject('dcl.htmlProjects');
		$objHTMLProjects->DisplaySearchForm();
	}

	function unmap()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbProjectmap');
		$obj->Connect();
		$query = sprintf('SELECT * FROM projectmap WHERE jcn=%d AND seq in (0,%d)',
				$GLOBALS['jcn'], $GLOBALS['seq']);
		$obj->Query($query);
		$projectid = 0;
		if ($obj->next_record())
		{
			$obj->GetRow();
			$projectid = $obj->projectid;
		}

		$this->dbunmap($GLOBALS['jcn'], $GLOBALS['seq']);

		$objPrj = CreateObject('dcl.htmlProjectsdetail');
		$objPrj->Show($projectid, 0, 0);
	}

	// Only intended to be called as a utility function - no UI output unless needed
	function dbunmap($jcn, $seq, $unmapseqonly = false, $allforjcn = false)
	{
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbProjectmap');
		$obj->Connect();

		// Check to see if we are mapped as implicit seq or explicit seq
		$query = "SELECT * FROM projectmap WHERE jcn=$jcn";
		if ($allforjcn == false)
		{
			$query .= ' AND ';
			if ($unmapseqonly)
				$query .= "seq=$seq";
			else
				$query .= "seq in (0,$seq)";
		}

		$obj->Query($query);
		if ($obj->next_record())
		{
			if ($allforjcn == true)
			{
				do
				{
					$obj->GetRow();
					$obj->Delete();
				}
				while ($obj->next_record());
			}
			else
			{
				$obj->GetRow();

				// Remove the mapping here
				$obj->Delete();
				if ($obj->seq == 0)
				{
					// It was implicitly mapped - explicitly relink all but this seq
					$objWO = CreateObject('dcl.dbWorkorders');
					$objWO->Connect($obj->conn);
					$objWO->Query("SELECT * FROM workorders WHERE jcn=$jcn AND seq != $seq");
					while ($objWO->next_record())
					{
						$obj->seq = $objWO->f('seq');
						$obj->Add();
					}
				}
			}
		}
	}

	function upload()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.htmlProjects');
		$obj->ShowUploadFileForm($GLOBALS['projectid']);
		echo '<p>';
		$objHTML = CreateObject('dcl.htmlProjectsdetail');
		$objHTML->Show($GLOBALS['projectid'], 0, 0);
	}

	function doupload()
	{
		global $dcl_info, $HTTP_POST_VARS, $HTTP_GET_VARS, $HTTP_COOKIE_VARS;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		if (IsSet($GLOBALS['userfile']))
		{
			if ((IsSet($HTTP_POST_VARS['userfile']) && $HTTP_POST_VARS['userfile'] == $GLOBALS['userfile']) ||
				(IsSet($HTTP_GET_VARS['userfile']) && $HTTP_GET_VARS['userfile'] == $GLOBALS['userfile']) ||
				(IsSet($HTTP_COOKIE_VARS['userfile']) && $HTTP_COOKIE_VARS['userfile'] == $GLOBALS['userfile']))
			{
				return PrintPermissionDenied();
			}
		}


		if ($GLOBALS['userfile'] != 'none')
		{
			$o = CreateObject('dcl.boFile');
			$o->iType = ATTACHMENT_PROJECT;
			$o->iKey1 = $GLOBALS['projectid'];
			$o->sFileName = $GLOBALS['userfile_name'];
			$o->sTempFileName = $GLOBALS['userfile'];
			$o->sRoot = $dcl_info['DCL_FILE_PATH'] . '/attachments';
			$o->Upload();
		}

		$objHTML = CreateObject('dcl.htmlProjectsdetail');
		$objHTML->Show($GLOBALS['projectid'], 0, 0);
	}

	function deleteattachment()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.htmlProjects');
		$obj->ShowDeleteAttachmentYesNo($GLOBALS['projectid'], $GLOBALS['filename']);
		echo '<p>';
		$objHTML = CreateObject('dcl.htmlProjectsdetail');
		$objHTML->Show($GLOBALS['projectid'], 0, 0);
	}

	function dodeleteattachment()
	{
		global $dcl_info;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$attachPath = $dcl_info['DCL_FILE_PATH'] . '/attachments/prj/' . substr($GLOBALS['projectid'], -1) . '/' . $GLOBALS['projectid'] . '/';
		if (is_file($attachPath . $GLOBALS['filename']) && is_readable($attachPath . $GLOBALS['filename']))
			unlink($attachPath . $GLOBALS['filename']);

		$objHTML = CreateObject('dcl.htmlProjectsdetail');
		$objHTML->Show($GLOBALS['projectid'], 0, 0);
	}

	function showmy()
	{
		commonHeader();
		$obj = CreateObject('dcl.htmlProjects');
		$obj->my(0);
	}
	
	function batchMove($aSource)
	{
		if (!is_array($aSource) || !isset($aSource['selected']) || !is_array($aSource['selected']))
			return;

		$oDB = new dclDB;
		$oDB->Connect();
		$oDB->BeginTransaction();

		$objPM = CreateObject('dcl.dbProjectmap');
		$objPM->Connect();
		$objPM->projectid = $aSource['projectid'];

		reset($aSource['selected']);
		while (list($key, $val) = each($aSource['selected']))
		{
			list($woid, $seq) = explode('.', $val);
			$this->dbunmap($woid, $seq, true, false);
			$objPM->jcn = $woid;
			$objPM->seq = $seq;
			$objPM->Add();
		}

		
		$oDB->EndTransaction();
	}

	function SendNewMailMsg($obj)
	{
		global $dcl_info;

		if ($dcl_info['DCL_SMTP_ENABLED'] != 'Y')
			return;

		if (!is_object($obj))
			return PrintPermissionDenied();

		$objPersonnel = CreateObject('dcl.dbPersonnel');
		$objPersonnel->Connect($obj->conn);
		if ($objPersonnel->Load($obj->reportto) == -1)
			return;
		if ($objPersonnel->email == '')
			return;

		$mailMsg = STR_BO_PROJECTMAILMSG . phpCrLf . phpCrLf;
		$mailMsg .= STR_PRJ_PROJECT . ': ' . $obj->name . phpCrLf;
		if ($obj->projectdeadline != '')
			$mailMsg .= STR_PRJ_DEADLINE . ': ' . $obj->projectdeadline . phpCrLf;

		$mailMsg .= STR_PRJ_DESCRIPTION . ': ' . $obj->description;
		$mailMsg .= phpCrLf . phpCrLf . STR_PRJ_EMAILSIG;

		$oMail = CreateObject('dcl.boSMTP');
		$oMail->to = $objPersonnel->email;
		$oMail->from = $GLOBALS['USEREMAIL'];
		$oMail->subject = sprintf(STR_PRJ_EMAILSUBJECT, $obj->name);
		$oMail->body = $mailMsg;
		$oMail->Send();

		print('<P><CENTER>');
		PrintWithChocoFont(sprintf(STR_BO_MAILSENT, $objPersonnel->email));
		print('</CENTER><P>');
	}
}
?>
