/*
$Id: timed_out_string.h,v 2.1 2003/03/07 16:07:54 ericprev Exp $
*/
#ifndef __TIMED_OUT_STRING_H__
#define __TIMED_OUT_STRING_H__

/******************************************************************/
/* load and save current tos entries from/into the given filename */
/******************************************************************/
void load_tos_data(char *filename);
void save_tos_data(char *filename);

/****************************************************/
/* add a new timed_out entry to the timed_out array */
/********************************************************************************/
/* input: key= it is a non uniq value used to create group of timed_out entries */
/*        duration= number of seconds before the expiration of the entry.       */
/*        ptr1= pointer on an array of bytes to store.                          */
/*        len1= number of bytes inside ptr1                                     */
/*        ptr2, len2= same as ptr1,len1                                         */
/* ptr1 and/or ptr2 can be NULL.                                                */
/********************************************************************************/
void add_tos_entry(const unsigned long key, const time_t duration, const char *ptr1, const int len1, const char *ptr2, const int len2);

/*****************************************************************************************/
/* add a new timed_out entry to the timed_out array, 1st value will be uniq in the array */
/*****************************************************************************************/
/* input: key= it is a non uniq value used to create group of timed_out entries */
/*        duration= number of seconds before the expiration of the entry.       */
/*        ptr1= pointer on an array of bytes to store.                          */
/*        len1= number of bytes inside ptr1                                     */
/*        ptr2, len2= same as ptr1,len1                                         */
/* ptr1 and/or ptr2 can be NULL.                                                */
/********************************************************************************/
void add_tos_entry_v1_uniq(const unsigned long key, const time_t duration, const char *ptr1, const int len1, const char *ptr2, const int len2);

/************************/
/* get the wanted entry */
/************************************************************/
/* input: key= key to find                                  */
/*        ptr= array to find                                */
/*        len= ptr array length                             */
/*        *out_ptr, *out_len= copy of the returned address. */
/*        content of out_ptr must be freed using free()     */
/* each entry of the tos is a triplet (key,ptr1,ptr2)       */
/* if side==0, this function returns in *out_ptr the first x*/
/* matching (key,ptr,x). If side==1, it is for (key,x,ptr)  */
/************************************************************/
/* output: ==0 not found, ==1, ok                 */
/*   on success, *out_ptr and *out_len are filled */
/**************************************************/
int get_tos_entry(const unsigned long key, const char *ptr, const int len, int side, char **out_ptr, int *out_len);

/*******************************************************************/
/* call the given function for each tos entry having the given key */
/***********************************************************************/
/* if the called function returns a value !=0, the scan is interrupted */
/***********************************************************************/
void scan_all_tos_entry(const unsigned long key, int (*fnc)(const time_t timeout, const char *ptr1, const int len1, const char *ptr2, const int len2, void *xtra),void *xtra);

/***************************/
/* delete the wanted entry */
/************************************************************/
/* input: key= key to find                                  */
/*        ptr= array to find                                */
/*        len= ptr array length                             */
/* each entry of the tos is a triplet (key,ptr1,ptr2)       */
/* if side==0, this function returns in *out_ptr the first x*/
/* matching (key,ptr,x). If side==1, it is for (key,x,ptr)  */
/************************************************************/
void delete_this_tos_entry(const unsigned long key, const char *ptr, const int len, int side);

/******************************************************************/
/* search and remove all tos having the same key as the given one */
/******************************************************************/
/* input: key= key to find                                  */
/************************************************************/
void delete_all_same_key(const unsigned long key, GString **dest_base, const char *sender);

/******************************************/
/* scan tos array to find expired entries */
/******************************************/
void timeout_tos(void);

void	gui_ban_list(const unsigned long key);

#endif
