/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * plugin.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: plugin.h,v 2.0 2003/01/30 12:50:45 eric Exp $
*/

#ifndef __PLUGIN_H__
#define __PLUGIN_H__

/*************************************************************************************/
/* load the plugin having the given name. The plugin must be in the plugin directory */
/**********************************************************************************************/
/* input: plugin_name= the name of the plugin                                                 */
/*        output= an allocated GString. Information and error messages will be appended to it */
/**********************************************************************************************/
void plugin_start(char *plugin_name, GString *output);

/********************************************/
/* unload the plugin having the given name. */
/**********************************************************************************************/
/* input: plugin_name= the name of the plugin                                                 */
/*        output= an allocated GString. Information and error messages will be appended to it */
/**********************************************************************************************/
void plugin_stop(char *plugin_name, GString *output);

/**********************************************************************************************/
/* if the plugin directory is defined and contains a file named AUTOSTART, all plugins having */
/* their name in this file are loaded.                                                        */
/**********************************************************************************************/
void load_all_autostart_plugin(void);

/**************************************************************************/
/* send event to plugin (same prototype as perl and python event handler) */
/**************************************************************************/
void send_evt_to_plugin(const char *evt_name, const char *evt_emitter, int nb_args, ...);

#endif
