/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * md5.c: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: md5.c,v 2.2 2003/02/25 14:44:39 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <openssl/md5.h>
#include <ctype.h>
#include <glib.h>

#include "common_defines.h"

#if MD5_DIGEST_LENGTH - MD_BLOC_SIZE 
error "Fatal error, MD_BLOC_SIZE has not the same value as MD5_DIGEST_LENGTH"
#endif

/****************************************/
/* compute the MD5sum of the given bloc */
/**************************************************************************************************/
/* md_array is an array of MD_BLOC_SIZE bytes which will contain the MD5sum of the content of tbl */
/**************************************************************************************************/
void do_md5(guint8 *tbl, int tbl_len, guint8 *md_array)
{
	MD5(tbl,tbl_len,md_array);
}

/*
-------------------------
-------------------------
*/

static guint8 ascii1_to_hex(unsigned char v)
{
	if((v>='0')&&(v<='9'))
		return v-'0';
	else
		return toupper(v)-'A'+10;
}

/******************************************/
/* convert 2 ascii hexdigit into 1 guint8 */
/******************************************/
static guint8 ascii2_to_bin1(unsigned char *asc)
{
	return ((ascii1_to_hex(asc[0]))<<4)|(ascii1_to_hex(asc[1]));
}

/**************************************************************************/
/* convert a MD_BLOC_SIZE ID from its ascii version to its binary version */
/**************************************************************************/
void id_ascii_to_bin(unsigned char *asc_id, guint8 *bin_id)
{
	int i;

	for(i=0;i<MD_BLOC_SIZE;i++)
	{
		bin_id[i]=ascii2_to_bin1(asc_id+2*i);
	}
}

/********************************************************************/
/* append the ASCII version of a binary array to the given g_string */
/********************************************************************/
void append_MD_to_str(GString *dest_base, const guint8 *id, const int len)
{
	int i;

	for(i=0;i<len;i++)
	{
		g_string_sprintfa(dest_base,"%02X",((unsigned int)(id[i]))&255);
	}
}

/*
-------------------------
-------------------------
*/

