/*
$Id: edb_warper.h,v 2.2 2003/02/16 10:57:00 eric Exp $
*/
#ifndef __HASH_SYM_H__
#define __HASH_SYM_H__

/******** DEFINE FOR FLAG  ********/
#define RCV_REGLE 0x00000001
#define RCV_SR    0x00000002
/* ***************    ***********  */
#include <glib.h>
 typedef struct s_db_sym
 {
   char			*name;
   char			*str_value;
   int			int_value;
   int			float_value;
   int			type;
   struct s_db_sym	*next;
   //time_t	start_time;
   /*
     autre param
   */
 }t_db_sym;

t_db_sym**      init_symbol_db_table(void);
const t_db_sym* get_const_db_sym(const char *str, const t_db_sym **table);
t_db_sym*       get_db_sym(const char *str, t_db_sym **table);
int		put_db_sym(const char *str, t_db_sym **table);
int		del_db_sym(const char *str, t_db_sym **table);
int		db_sym_explore_const(int (*fnc)(const t_db_sym*), const t_db_sym **table);
int		db_sym_explore(int (*fnc)(t_db_sym*), t_db_sym **table);
int		dump_db_table(const char *filename, const t_db_sym **table);
int		hash_db_table_len(const t_db_sym **table);
int		free_db_sym(t_db_sym *ptr);
t_db_sym	**load_db_table(const char *filename);
char		*e_db_str_get(t_db_sym **conf_file, const char *key);
char		*e_db_type_get(t_db_sym **table,const char *key);
int		e_db_str_set(t_db_sym **conf_file, const char *key, const char *value); // ret 0 if ok
int		e_db_int_get(t_db_sym **conf_file, const char *key, int *val);// ret 0 if ok
int		e_db_int_set(t_db_sym **conf_file, const char *key, int val);// ret 0 if ok

int		e_db_float_get(t_db_sym **conf_file, const char *key, float *val);// ret 0 if ok
int		e_db_float_set(t_db_sym **conf_file, const char *key, float val);// ret 0 if ok

int		e_db_flush(void);
t_db_sym	**e_db_open(const char *filename);
int		e_db_close(t_db_sym **conf_file);// empty fnc
int		e_db_data_del(t_db_sym **table, char *kn);
char		**e_db_dump_key_list(t_db_sym **table,int *nb_ret);

#endif /* __HASH_SYM_H__*/
