#! /usr/bin/perl
#
# $Id: help.pl,v 1.2 2003/06/22 14:43:18 blusseau Exp $

package help;

use strict;

my %commands=();

main::add_hook ("globalchat",\&help_commands);

my $help_trigger=($main::GLOBAL_VARS{help_trigger}) ? $main::GLOBAL_VARS{help_trigger} : '-(command(s)?|help)';

# print "Help Trigger:[$help_trigger]\n";

sub help_commands {
	
	my (undef,$nick,$msg) = @_; # evt_array not need

	if ($msg=~ /^$help_trigger(?:\s+(.+))?$/i) {
		$msg=~s/^$help_trigger\s*//io;
		if ($msg) {
			# help with args
			my $command=$msg;
			my $found=0;
			foreach my $privilege (('N','O')) {	
				if (defined $commands{$privilege}{$command}) {
					dchub::send_to_named_user($nick,"<Hub-Security> "._("Usage:")." ".$commands{$privilege}{$command}{Usage}."|");
					$found=1;
				}
			}
			unless ($found) {
				dchub::send_to_named_user($nick, "<Hub-Security> ".sprintf(_("No help for %s command"),$command).".|");
			}
		} else {
			# find the longest string for a beautiful display
			my $max_length=0;
			foreach my $privilege (('N','O')) {
				if (defined $commands{$privilege}) {
					foreach my $command(keys %{$commands{$privilege}}) {
						my $cmd_len = length($commands{$privilege}{$command}{Usage});
						$max_length=$cmd_len if ($cmd_len > $max_length);
					}
				}
			}
			$max_length+=8; # add the place for at least a tab
			my $help;
			if ($commands{N}) {
				$help.="\x0D\x0A*****    "._("Global chat commands")."    *****\x0D\x0A";
				foreach my $command(sort(keys %{$commands{N}})) {
					my $usage=$commands{N}{$command}{Usage};
					$help.=$usage;
					$help.="\t" x int(($max_length-length($usage))/8).': '.$commands{N}{$command}{Desc}."\x0D\x0A";
				}
			}
			if ($commands{O}) {
				$help.="\x0D\x0A***** "._("Operator ONLY Commands")." *****\x0D\x0A";
				foreach my $command(sort(keys %{$commands{O}})) {
					my $usage=$commands{O}{$command}{Usage};
					$help.=$usage;
					$help.="\t" x int(($max_length-length($usage))/8).': '.$commands{O}{$command}{Desc}."\x0D\x0A";
				}
			}
			# show all available commands
			if ($help) {
				dchub::send_pchat_msg("Hub-Security", $nick, "$help|");
			} else {
				dchub::send_to_named_user($nick, "<Hub-Security> "._("No help available").".|");	
			}
		}
	}
}

sub add_help_description($$;$) {
	my ($command,$desc,$privilege)=@_;
	if ($privilege) {
		$privilege=uc($privilege);
	} else {
		$privilege='N';	
	}
	$commands{$privilege}{$command}{Desc}=$desc;
	$commands{$privilege}{$command}{Usage}=$command unless (defined $commands{$privilege}{$command}{Usage});
}
*main::add_help_description=\&add_help_description; # export the function

sub add_help_usage($$;$) {
	my ($command,$usage,$privilege)=@_;
	if ($privilege) {
		$privilege=uc($privilege);
	} else {
		$privilege='N';	
	}
	$commands{$privilege}{$command}{Usage}=$usage;
}
*main::add_help_usage=\&add_help_usage; # export the function

# Return the usage for a command
sub help_usage($) {
	my $search_command=shift;
	my $usage;
	foreach my $privilege (('N','O')) {
		if (defined $commands{$privilege}) {
			foreach my $command(keys %{$commands{$privilege}}) {
				if ($command eq $search_command) {
					$usage=_("Usage:")." ".$commands{$privilege}{$command}{Usage};
					last;
				}
			}
		}
	}
	return $usage;
}
*main::help_usage=\&help_usage; # export the function

print "Perl: Help "._("module loaded").".\n";
