/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * pluginT.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: dchub_plugin_api.h,v 2.1 2003/04/05 05:13:22 ericprev Exp $
*/

#ifndef __DCHUB_PLUGIN_API_H__
#define __DCHUB_PLUGIN_API_H__

#ifndef PLUGIN_TYPEDEF_DEFINED
/* include this typedef only if the include is not used from dchub */
/* else it will conflict with dchub typedef */
typedef struct plugin PLUGIN;
#endif

typedef struct
{
	const char *varname;
	const char *varvalue;
} PLUGIN_PARAM;

/***************************************************/
/* this is the prototype of a plugin event handler */
/* param is an array of PLUGIN_PARAM (read only)   */
/* the same varnames as scripts are defined.       */
/***************************************************/
typedef void (*PLUGIN_EVENT_FUNCTION)(const GArray *param);

/***********************************************************************************/
/* unregister the given (event,fnc) couple from the event list of the given plugin */
/***********************************************************************************/
void unregister_dchub_plugin_event(PLUGIN *plug, char *evt_name, PLUGIN_EVENT_FUNCTION fnc);

/*******************************************************************************/
/* register the given (event,fnc) couple to the event list of the given plugin */
/*******************************************************************************/
void register_dchub_plugin_event(PLUGIN *plug, char *evt_name,  PLUGIN_EVENT_FUNCTION fnc);


/*************************************************************************/
/* this is a set of well known functions provided to scripting languages */
/*************************************************************************/

/*******************************/
/* send a DC command to a user */
/*******************************/
void plugin_send_to_named_user(const char *nickname, char *string);

/**********************************/
/* send a DC command to all users */
/**********************************/
void plugin_send_to_all_users(char *string);

/*************************************/
/* send a message on the public chat */
/*************************************/
void plugin_send_gchat_msg(const char *sender_nickname, char *string);

/************************************/
/* send a message on a private chat */
/************************************/
void plugin_send_pchat_msg(const char *sender_nickname, const char *dest_nickname, char *string);

/*********************/
/* disconnect a user */
/*********************/
void plugin_disconnect(const char *nickname);

/***************/
/* kick a user */
/***************/
void plugin_kick(const char *nickname);

/********************************/
/* nickname connection duration */
/********************************/
/* output: -1=not found */
/************************/
int plugin_nick_duration(const char *nickname);

/******************************************/
/* get the type of account used by a user */
/******************************************/
char plugin_nick_type(const char *nickname);

/**********************************/
/* get hub shared size and #users */
/**********************************/
void plugin_get_hub_user_start(guint64 *shared_size, unsigned int *nb_users);

/*************************************************/
/* return max number of users allowed on the hub */
/*************************************************/
int get_max_users(void);

#endif

