/***************************************************************************
                          dcfilebrowser.h  -  description
                             -------------------
    begin                : Fre Nov 29 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCFILEBROWSER_H
#define DCFILEBROWSER_H

#include <qwidget.h>
#include <qlistview.h>
#include <qpixmap.h>

#include <dcfiletool.h>

#include <dclib/dcos.h>
#include <dclib/core/cxml.h>

#include <DCDialogFileBrowser.h>

/**
  *@author Mathias Kster
  */

class DCFileItem {
public:
	/** construtor */
	DCFileItem() {};
	/** destructor */
	virtual ~DCFileItem() {};

	/** */
	QString m_sName;
	/** */
	QString m_sSize;
	/** */
	QString m_sTTH;
};

class DCFileBrowserListItem : public QListViewItem {
public:
	/** construtor */
	DCFileBrowserListItem( QListView * parent ) : QListViewItem(parent) {};
	/** construtor */
	DCFileBrowserListItem( QListViewItem * parent ) : QListViewItem(parent) {};

	/** destructor */
	virtual ~DCFileBrowserListItem() {};

	/** */
	QPtrList<DCFileItem> m_pFileList;
};


class DCFileBrowser : public DCDialogFileBrowser  {
Q_OBJECT

public: 
	/** construtor */
	DCFileBrowser( QWidget* parent=0, const char *name=0, int wflags=0, bool viewonly=FALSE );
	/** destructor */
	virtual ~DCFileBrowser();

	/** */
	void InitDocument();
	/** */
	void InitTree( QString nick, QString hubname, QString hubhost, QString type, QString filename, QString list );
	/** */
	void InitTXTTree( QListViewItem * item );
	/** */
	void InitXMLTree( QListViewItem * item );
	/** */
	void ParseXMLTree( CXml * xml, xmlNodePtr node, QListViewItem * item );
	/** */
	void LoadFileList( QString s );

private:
	/** */
	void CreateMenu( QListViewItem * item, bool direntry );
	/** */
	QString CreateRemotePath( QListViewItem * item );
	/** */
	int selectedItems( QListView * list, QPtrList<QListViewItem> & lst );

	/** */
	void DownloadFile( QString rootPath, QString localPath, QString localName, QString remotePath, QString remoteName, ulonglong size );
	/** */
	void DownloadPath( QString rootPath, QString localPath, QString localName, QListViewItem * item );

	/** */
	void AddFile( QListViewItem * item, DCFileItem * fileitem );
	/** */
	void AddDirectory( QListViewItem * item, QString name );
	/** */
	void ClearView();
	
	/** */
	QString m_sNick;
	/** */
	QString m_sHubName;
	/** */
	QString m_sHubHost;
	/** */
	QString m_sList;
	/** */
	QString m_sType;
	/** */
	DCFileTool m_FileTool;
	/** */
	QTextCodec * m_pCodec;
	/** */
	QString m_sFileName;
	/** */
	ulonglong m_nShareSize;
	/** */
	ulonglong m_nFileCount;
	/** */
	QPixmap m_FolderPixmap;

private slots:
	/** */
	void slotRightButtonClickedDirectory( QListViewItem *, const QPoint &, int );
	/** */
	void slotRightButtonClickedFiles( QListViewItem *, const QPoint &, int );
	/** */
	void slotCurrentChangedDirectory();
	/** */
	void slotExpandedDirectory( QListViewItem * );
	/** */
	void slotCollapsedDirectory( QListViewItem * );
	/** */
	void slotFileOpen();
	/** */
	void slotFileSave();
	/** */
	void slotCodecChange( const QString & );
};

#endif
