/***************************************************************************
                          dcconnectionmanager.h  -  description
                             -------------------
    begin                : Mon Oct 1 2001
    copyright            : (C) 2001-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCCONNECTIONMANAGER_H
#define DCCONNECTIONMANAGER_H

/**
  *@author Mathias Kster
  */

#include <qtimer.h>

#include <DCDialogConnectionManager.h>

#include <dcconfig.h>

#include <dclib/core/cbytearray.h>
#include <dclib/core/cstringlist.h>
#include <dclib/cconnectionmanager.h>

class DCClient;
class QStringList;
class QListView;
class QWorkspace;
class CHttp;

class DCConnectionManager : public DCDialogConnectionManager, public CConnectionManager {
Q_OBJECT

public:
	/** construtor */
	DCConnectionManager(QWidget* parent, const char *name, int wflags);
	/** destructor */
	virtual ~DCConnectionManager();

	/** */
	void InitDocument();
	/** */
	void DeInitDocument();
	
	/** */
	void AutoConnect();
	/** */
	void Connect( CString hubname, CString server, bool sslconnect = FALSE );

	/** */
	void OPKick( QString hubname, QString hubhost, QString nick, QString message );
	/** */
	void OPForceMove( QString hubname, QString hubhost, QString nick, QString message, QString host );

	/** */
	void OpenPrivateChat( QString hubname, QString hubhost, QString nick );
	/** */
	void CloseAllChats();
	/** */
	void DisconnectAllClients();
	/** */
	void CloseDisconnectedHubs();

	/** overridden so that the columns are resized on show() */
	virtual void show();

	/** callback function */
	virtual int DC_CallBack( CObject * );

protected:
	/** resize the ListView columns */
	void ResizeListViewColumn();

	/** event filter */
	virtual bool eventFilter( QObject * object, QEvent * event );
	/** close event handler */
	virtual void closeEvent( QCloseEvent * ) { };

private:
	/** */
	int selectedItems( QListView * list, QPtrList<QListViewItem> & lst );

	/** */
	QTimer m_Timer;
	/** */
	CList<CObject> * m_pMessageList;
	/** */
	QWorkspace * m_pWorkspace;

private slots:
	/** */
	void timerDone();
};

/** */
extern DCConnectionManager * g_pConnectionManager;

#endif
