/***************************************************************************
                          dcconfig.cpp  -  description
                             -------------------
    begin                : Fri Mar 1 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>

#include <qstringlist.h>
#include <qregexp.h>
#include <qprocess.h>
#include <qsound.h>
#include <qpixmap.h>
#include <qimage.h>

#include <dclib/core/cbytearray.h>
#include <dclib/core/cstring.h>
#include <dclib/core/cthread.h>
#include <dclib/dcobject.h>
#include <dclib/core/che3.h>
#include <dclib/core/cxml.h>
#include <dclib/core/csocket.h>
#include <dclib/core/cstringlist.h>

#include <dcuserslist.h>
#include <dciconloader.h>

#include "dcconfig.h"

#include <dclib/dcos.h>

// mac stuff
#if defined(Q_OS_MACX) 
#include <CoreFoundation/CoreFoundation.h> 
#endif 

// config files
#define DCGUI_CONFIG		"dcgui.cfg"
#define DCGUI_HUBFILTER		"dchubfilter.cfg"
#define DCGUI_FRIENDLIST	"dcfriendlist.cfg"

#define XML_DCGUI_CONFIG	"dcgui"
#define XML_DCGUI_HUBFILTER	"dchubfilter"
#define XML_DCGUI_FRIENDLIST	"dcfriendlist"

#define XML_GUI				"gui"
#define XML_OPENPRIVATECHATWIN		"openprivatechatwindow"
#define XML_UNIT			"unit"
#define XML_THEME			"theme"
#define XML_LANGUAGEFILE		"languagefile"
#define XML_APP_FONT			"appfont"
#define XML_APP_WIDTH			"appwidth"
#define XML_APP_HEIGHT			"appheight"
#define XML_TV_WIDTH			"tvwidth"
#define XML_TV_HEIGHT			"tvheight"
#define XML_TV_DOCKED			"tvdocked"
#define XML_TOOLBAR			"toolbar"
#define XML_STATUSBAR			"statusbar"
#define XML_EXTERNAL_SOUND_PLAYER	"externalsoundplayer"
#define XML_EXTERNAL_PLAYER		"externalplayer"
#define XML_SOUND_FILE_CONNECT		"soundfileconnect"
#define XML_SOUND_FILE_DISCONNECT	"soundfiledisconnect"
#define XML_SOUND_FILE_SEND		"soundfilesend"
#define XML_SOUND_FILE_RECEIVE		"soundfilereceive"
#define XML_SOUND_FILE_FIRSTRECEIVE	"soundfilefirstreceive"
#define XML_SOUND_ENABLED_CONNECT	"soundenabledconnect"
#define XML_SOUND_ENABLED_DISCONNECT	"soundenableddisconnect"
#define XML_SOUND_ENABLED_SEND		"soundenabledsend"
#define XML_SOUND_ENABLED_RECEIVE	"soundenabledreceive"
#define XML_SOUND_ENABLED_FIRSTRECEIVE	"soundenabledfirstreceive"
#define XML_SOUND_DISABLED		"sounddisabled"
#define XML_SOUND_DISABLED_AWAY		"sounddisabledaway"
#define XML_TIMESTAMP_PRIVATECHAT	"timestampprivatechat"
#define XML_TIMESTAMP_HUBCHAT		"timestamphubchat"
#define XML_SHOW_STATUS_MESSAGE		"showstatusmessage"
#define XML_SHOW_TRANSFER_WIN		"showtransferwin"
#define XML_SEND_HIDE_PRIVATE_CHAT_TO_PUBLIC_CHAT "sendhideprivatechattopublicchat"
#define XML_CHAT_MESSAGE_MAX_LINES	"chatmessagemaxlines"
#define XML_DEFAULTDOWNLOADMODE		"defaultdownloadmode"
#define XML_EMOTICONS			"emoticons"
#define XML_SENDCHAT			"sendchat"
#define XML_QUERYONEXIT			"queryonexit"
#define XML_QUERYONFILEDELETE		"queryonfiledelete"
#define XML_SHOWCHATSENDBUTTON		"showchatsendbutton"
#define XML_CHATMAXPARAGRAPH		"chatmaxparagraph"
#define XML_CHATINPUTCODEC		"chatinputcodec"
#define XML_CHATOUTPUTCODEC		"chatoutputcodec"

#define XML_TV_CHUNKPERCENT		"tvchunkpercent"
#define XML_TV_FILEPERCENT		"tvfilepercent"
#define XML_TV_CHUNKSIZE		"tvchunksize"
#define XML_TV_FILESIZE			"tvfilesize"
#define XML_TV_DOWNLOADRATESINGLE	"tvdownloadratesingle"
#define XML_TV_ELAPSEDTIMESINGLE	"tvelapsedtimesingle"
#define XML_TV_DOWNLOADRATEMULTI	"tvdownloadratemulti"
#define XML_TV_ELAPSEDTIMEMULTI		"tvelapsedtimemulti"

#define XML_NAME			"name"
#define XML_ENTRY			"entry"
#define XML_SECTION			"section"
#define XML_SIZE			"size"
#define XML_POS				"pos"

#define XML_FILTER			"filter"
#define XML_FILTERNAME			"filtername"
#define XML_CONTAINS			"contains"
#define XML_USER			"user"
#define XML_SERVER			"server"
#define XML_DESCRIPTION			"description"
#define XML_USERLISTRIGHTALIGNMENT	"userlistrightalignment"
#define XML_BACKGROUNDPIXMAP		"backgroundpixmap"
#define XML_BROWSER			"browser"
#define XML_SHOWCHATINTAB		"showchatintab"
#define XML_OPENCLIENTWINDOWSMINIMIZED	"openclientwindowsminimized"

#define XML_FLOODCOUNT			"floodcount"
#define XML_FLOODOPKICK			"floodopkick"
#define XML_FLOODKICKMESSAGE		"floodkickmessage"

#define XML_LCO_ENABLELOGGING			"LCO_ENABLELOGGING"
#define XML_LCO_APPENDDATE			"LCO_APPENDDATE"
#define XML_LCO_APPENDHUBNAME			"LCO_APPENDHUBNAME"
#define XML_LCO_APPENDHUBHOST			"LCO_APPENDHUBHOST"
#define XML_LCO_DISABLEPUBLICCHAT		"LCO_DISABLEPUBLICCHAT"
#define XML_LCO_ENABLENICKNAMEFILTER		"LCO_ENABLENICKNAMEFILTER"
#define XML_LCO_NICKNAMEFILTER_ENABLELOGGING	"LCO_NICKNAMEFILTER_ENABLELOGGING"

#define XML_CC_CHATTIMESTAMP			"CC_CHATTIMESTAMP"
#define XML_CC_CHATLOCALNICK			"CC_CHATLOCALNICK"
#define XML_CC_CHATLOCALTEXT			"CC_CHATLOCALTEXT"
#define XML_CC_CHATREMOTENICK			"CC_CHATREMOTENICK"
#define XML_CC_CHATREMOTETEXT			"CC_CHATREMOTETEXT"
#define XML_CC_CHATSTATUSNICK			"CC_CHATSTATUSNICK"
#define XML_CC_CHATSTATUSTEXT			"CC_CHATSTATUSTEXT"
#define XML_CC_PUBLICCHATTIMESTAMP		"CC_PUBLICCHATTIMESTAMP"
#define XML_CC_PUBLICCHATLOCALNICK		"CC_PUBLICCHATLOCALNICK"
#define XML_CC_PUBLICCHATLOCALTEXT		"CC_PUBLICCHATLOCALTEXT"
#define XML_CC_PUBLICCHATREMOTENICK		"CC_PUBLICCHATREMOTENICK"
#define XML_CC_PUBLICCHATREMOTETEXT		"CC_PUBLICCHATREMOTETEXT"
#define XML_CC_PUBLICCHATSTATUSNICK		"CC_PUBLICCHATSTATUSNICK"
#define XML_CC_PUBLICCHATSTATUSTEXT		"CC_PUBLICCHATSTATUSTEXT"
#define XML_CC_PUBLICPRIVATECHATNICK		"CC_PUBLICPRIVATECHATNICK"
#define XML_CC_PUBLICPRIVATECHATTEXT		"CC_PUBLICPRIVATECHATTEXT"
#define XML_CC_CHATSAY				"CC_CHATSAY"
#define XML_CC_PUBLICCHATMENICK			"CC_PUBLICCHATMENICK"

#define XML_CLIENT_COLUMN_COMMENT		"clientcolumncomment"
#define XML_CLIENT_COLUMN_TAG			"clientcolumntag"
#define XML_CLIENT_COLUMN_SPEED			"clientcolumnspeed"
#define XML_CLIENT_COLUMN_EMAIL			"clientcolumnemail"
#define XML_CLIENT_COLUMN_SHARE			"clientcolumnshare"
#define XML_CLIENT_COLUMN_IP			"clientcolumnip"
#define XML_CLIENT_COLUMN_LOCKPK		"clientcolumnlockpk"
#define XML_CLIENT_COLUMN_SUPPORTS		"clientcolumnsupports"

#define XML_AUTO_AWAY_MODE		"autoawaymode"
#define XML_AUTO_AWAY_TIME		"autoawaytime"
#define XML_CHAT_SHOW_JOINS_AND_PARTS	"chatshowjoinsandparts"

#define XML_FRIEND			"friend"
#define XML_IMAGE			"image"
#define XML_SEND_IMAGE			"sendimage"
#define XML_AUTO_SEC			"autosec"
#define XML_USER_PHOTO			"userphoto"

#define XML_UNIT_AUTO	"auto"
#define XML_UNIT_BYTE	"byte"
#define XML_UNIT_KBYTE	"kbyte"
#define XML_UNIT_MBYTE	"mbyte"
#define XML_UNIT_GBYTE	"gbyte"

DCConfig * g_pConfig = 0;

DCConfig::DCConfig( CString configpath ) : CConfig(configpath)
{
	// gui defaults
	bOpenPrivateChatWindow	= TRUE;
	m_eUnit			= euAUTO;
	sTheme			= "Default";
	sLanguageFile		= "";
	sAppFont		= DEFAULT_APP_FONT;
	iAppHeight		= 480;
	iAppWidth		= 640;
	iTransferViewHeight     = 100;
	iTransferViewWidth      = 640;
	bTransferViewDocked     = TRUE;
	bToolBar		= TRUE;
	bStatusBar		= TRUE;

	sSoundFileConnect	= "";
	sSoundFileDisconnect	= "";
	sSoundFileSend		= "";
	sSoundFileReceive	= "";
	sSoundFileFirstReceive	= "";

	bSoundDisabled		= TRUE;
	bSoundDisabledAway	= TRUE;

	bSoundEnabledConnect	= TRUE;
	bSoundEnabledDisconnect	= TRUE;
	bSoundEnabledSend	= TRUE;
	bSoundEnabledReceive	= TRUE;
	bSoundEnabledFirstReceive = TRUE;

	bEnableEmoticons        = TRUE;
	bTimeStampPrivateChat	= TRUE;
	bTimeStampHubChat	= TRUE;
	bShowStatusMessage      = TRUE;
	bShowTransferWin        = FALSE;
	sSendChat		= "Enter";

	bExternalSoundPlayer	= FALSE;
	sExternalPlayer		= "";

	bTVChunkPercent         = FALSE;
	bTVFilePercent          = TRUE;
	bTVChunkSize            = FALSE;
	bTVFileSize             = TRUE;
	bTVDownloadRateSingle   = FALSE;
	bTVElapsedTimeSingle    = FALSE;
	bTVDownloadRateMulti    = TRUE;
	bTVElapsedTimeMulti     = TRUE;
	bThemeSupport           = TRUE;
	bUserListRightAlignment = TRUE;

	m_bClientColumnComment  = TRUE;
	m_bClientColumnTag      = TRUE;
	m_bClientColumnEMail    = TRUE;
	m_bClientColumnSpeed    = TRUE;
	m_bClientColumnShare    = TRUE;
	m_bClientColumnIP       = FALSE;
	m_bClientColumnLOCKPK   = FALSE;
	m_bClientColumnSUPPORTS = FALSE;

	m_bAutoAwayMode         = FALSE;
	m_nAutoAwayTime         = 300;

	m_bChatShowJoinsAndParts = FALSE;
	bSendHidePrivateChatToPublicChat = TRUE;

	m_UserIconCache = QPixmap("");
	m_nUICX = -2;
	m_nUICY = -2;

	iChatMessageMaxLines = 0;
	
	iFloodCount    = 3;
	m_bFloodOpKick = FALSE;
	
	m_pMimeSourceFactory = 0;

	pProcess = new QProcess ();

	iDefaultDownloadMode = 0;

	bQueryOnExit = FALSE;
	bQueryOnFileDelete = TRUE;
	bShowChatSendButton = TRUE;
	sBackgroundPixmap = "";
	sBrowser = "konqueror";
	bShowChatInTab = TRUE;
	m_nChatMaxParagraph = 0;
	bOpenClientWindowsMinimized = FALSE;
	m_EmoticonSettingList = 0;

	m_sChatInputCodec  = "";
	m_sChatOutputCodec = "";

	m_bLogChatOption_1 = FALSE;
	m_bLogChatOption_2 = FALSE;
	m_bLogChatOption_3 = FALSE;
	m_bLogChatOption_4 = FALSE;
	m_bLogChatOption_5 = FALSE;
	m_bLogChatOption_6 = FALSE;
	m_bLogChatOption_7 = FALSE;

	m_sChatColor_1  = "#000000";
	m_sChatColor_2  = "#000000";
	m_sChatColor_3  = "#000000";
	m_sChatColor_4  = "#000000";
	m_sChatColor_5  = "#000000";
	m_sChatColor_6  = "#000000";
	m_sChatColor_7  = "#000000";
	m_sChatColor_8  = "#000000";
	m_sChatColor_9  = "#000000";
	m_sChatColor_10 = "#000000";
	m_sChatColor_11 = "#000000";
	m_sChatColor_12 = "#000000";
	m_sChatColor_13 = "#000000";
	m_sChatColor_14 = "#000000";
	m_sChatColor_15 = "#000000";
	m_sChatColor_16 = "#000000";
	m_sChatColor_17 = "#000000";
	m_sChatColor_18 = "#000000";
	
#if defined(Q_OS_MACX) 
	CFURLRef pluginRef = CFBundleCopyBundleURL(CFBundleGetMainBundle()); 
	CFStringRef macPath = CFURLCopyFileSystemPath(pluginRef, kCFURLPOSIXPathStyle); 
	const char *pathPtr = CFStringGetCStringPtr(macPath, CFStringGetSystemEncoding()); 

	SetDatadir(pathPtr); 
#endif 

	g_pConfig = this;
}

DCConfig::~DCConfig()
{
	g_pConfig = NULL;
	
	delete pProcess;

	if ( m_pMimeSourceFactory )
	{
		QMimeSourceFactory::removeFactory(m_pMimeSourceFactory);
		delete m_pMimeSourceFactory;
	}

	if ( m_EmoticonSettingList )
	{
		delete m_EmoticonSettingList;
	}

	m_guiSettingMap.clear();

	m_EmoticonImage.reset();
}

/** */
void DCConfig::ParseDCGuiConfig( xmlNodePtr node )
{
	xmlNodePtr n1,n2,n3,n4;
	CXml xml;

	for(n1=node;n1!=0;n1=n1->next)
	{
		/* gui entrys */
		if ( xml.name(n1) == XML_GUI )
		{
			for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
			{
				if ( xml.name(n2) == XML_OPENCLIENTWINDOWSMINIMIZED )
					bOpenClientWindowsMinimized = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_OPENPRIVATECHATWIN )
					bOpenPrivateChatWindow = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_CHATMAXPARAGRAPH )
					m_nChatMaxParagraph = xml.content(n2).asLONG();
				else if ( xml.name(n2) == XML_EMOTICONS )
				        bEnableEmoticons = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_USER_PHOTO )
				        m_sUserPhotoFileName = xml.content(n2);
				else if ( xml.name(n2) == XML_TOOLBAR )
				        bToolBar = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_STATUSBAR )
					bStatusBar = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_USERLISTRIGHTALIGNMENT )
					bUserListRightAlignment = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_SHOWCHATSENDBUTTON )
					bShowChatSendButton = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_UNIT )
				{
					if ( xml.content(n2) == XML_UNIT_AUTO )
						m_eUnit = euAUTO;
					else if ( xml.content(n2) == XML_UNIT_BYTE )
						m_eUnit = euBYTE;
					else if ( xml.content(n2) == XML_UNIT_KBYTE )
						m_eUnit = euKBYTE;
					else if ( xml.content(n2) == XML_UNIT_MBYTE )
						m_eUnit = euMBYTE;
					else if ( xml.content(n2) == XML_UNIT_GBYTE )
						m_eUnit = euGBYTE;
				}
				else if ( xml.name(n2) == XML_THEME )
					sTheme = xml.content(n2);
				else if ( xml.name(n2) == XML_BACKGROUNDPIXMAP )
					sBackgroundPixmap = xml.content(n2);
				else if ( xml.name(n2) == XML_BROWSER )
					sBrowser = xml.content(n2);
				else if ( xml.name(n2) == XML_LANGUAGEFILE )
					sLanguageFile = xml.content(n2);
				else if ( xml.name(n2) == XML_APP_FONT )
					sAppFont = xml.content(n2);
				else if ( xml.name(n2) == XML_APP_WIDTH )
					iAppWidth = xml.content(n2).asINT();
				else if ( xml.name(n2) == XML_APP_HEIGHT )
					iAppHeight = xml.content(n2).asINT();
				else if ( xml.name(n2) == XML_TV_WIDTH )
					iTransferViewWidth = xml.content(n2).asINT();
				else if ( xml.name(n2) == XML_TV_HEIGHT )
					iTransferViewHeight = xml.content(n2).asINT();
				else if ( xml.name(n2) == XML_TV_DOCKED )
					bTransferViewDocked = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_SOUND_FILE_CONNECT )
					sSoundFileConnect = xml.content(n2);
				else if ( xml.name(n2) == XML_SOUND_FILE_DISCONNECT )
					sSoundFileDisconnect = xml.content(n2);
				else if ( xml.name(n2) == XML_SOUND_FILE_SEND )
					sSoundFileSend = xml.content(n2);
				else if ( xml.name(n2) == XML_SOUND_FILE_RECEIVE )
					sSoundFileReceive = xml.content(n2);
				else if ( xml.name(n2) == XML_SOUND_FILE_FIRSTRECEIVE )
					sSoundFileFirstReceive = xml.content(n2);
				else if ( xml.name(n2) == XML_EXTERNAL_SOUND_PLAYER )
					bExternalSoundPlayer = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_EXTERNAL_PLAYER )
					sExternalPlayer = xml.content(n2);
				else if ( xml.name(n2) == XML_SOUND_DISABLED )
					bSoundDisabled = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_SOUND_DISABLED_AWAY )
					bSoundDisabledAway = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_SOUND_ENABLED_CONNECT )
					bSoundEnabledConnect = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_SOUND_ENABLED_DISCONNECT )
					bSoundEnabledDisconnect = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_SOUND_ENABLED_SEND )
					bSoundEnabledSend = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_SOUND_ENABLED_RECEIVE )
					bSoundEnabledReceive = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_SOUND_ENABLED_FIRSTRECEIVE )
					bSoundEnabledFirstReceive = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_TIMESTAMP_PRIVATECHAT )
					bTimeStampPrivateChat = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_TIMESTAMP_HUBCHAT )
					bTimeStampHubChat = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_SHOW_STATUS_MESSAGE )
					bShowStatusMessage = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_SENDCHAT )
					sSendChat = xml.content(n2);
				else if ( xml.name(n2) == XML_SHOW_TRANSFER_WIN )
					bShowTransferWin = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_TV_CHUNKPERCENT )
					bTVChunkPercent = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_TV_FILEPERCENT )
					bTVFilePercent = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_TV_CHUNKSIZE )
					bTVChunkSize = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_TV_FILESIZE )
					bTVFileSize = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_TV_DOWNLOADRATESINGLE )
					bTVDownloadRateSingle = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_TV_ELAPSEDTIMESINGLE )
					bTVElapsedTimeSingle = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_TV_DOWNLOADRATEMULTI )
					bTVDownloadRateMulti = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_TV_ELAPSEDTIMEMULTI )
					bTVElapsedTimeMulti = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_SEND_HIDE_PRIVATE_CHAT_TO_PUBLIC_CHAT )
					bSendHidePrivateChatToPublicChat = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_CHAT_MESSAGE_MAX_LINES )
					iChatMessageMaxLines = xml.content(n2).asINT();
				else if ( xml.name(n2) == XML_FLOODCOUNT )
					iFloodCount = xml.content(n2).asINT();
				else if ( xml.name(n2) == XML_FLOODOPKICK )
					m_bFloodOpKick = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_DEFAULTDOWNLOADMODE )
					iDefaultDownloadMode = xml.content(n2).asINT();
				else if ( xml.name(n2) == XML_QUERYONEXIT )
					bQueryOnExit = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_QUERYONFILEDELETE )
					bQueryOnFileDelete = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_SHOWCHATINTAB )
					bShowChatInTab = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_AUTO_AWAY_MODE )
					m_bAutoAwayMode = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_AUTO_AWAY_TIME )
					m_nAutoAwayTime = xml.content(n2).asINT();
				else if ( xml.name(n2) == XML_CHAT_SHOW_JOINS_AND_PARTS )
					m_bChatShowJoinsAndParts = xml.getBoolChild(n2);
				else if ( xml.name(n2) == XML_CHATINPUTCODEC )
					m_sChatInputCodec = xml.content(n2);
				else if ( xml.name(n2) == XML_CHATOUTPUTCODEC )
					m_sChatOutputCodec = xml.content(n2);
				else if ( xml.name(n2) == "MAP" )
				{
					StringMap * map = new StringMap();

					for(n3=n2->xmlChildrenNode;n3!=0;n3=n3->next)
					{
						if ( xml.name(n3) == "KEY" )
							m_guiSettingMap[xml.content(n3).Data()] = map;
						else if ( xml.name(n3) == XML_ENTRY )
						{
							CString key="",name="";
							for(n4=n3->xmlChildrenNode;n4!=0;n4=n4->next)
							{
								if ( xml.name(n4) == "KEY" )
									key = xml.content(n4);
								else if ( xml.name(n4) == "NAME" )
									name = xml.content(n4);
							}
							(*map)[key.Data()]=name.Data();
						}
					}
				}
				else if ( xml.name(n2) == XML_LCO_ENABLELOGGING )
					SetLogChatOption( elcoENABLELOGGING, xml.getBoolChild(n2) );
				else if ( xml.name(n2) == XML_LCO_APPENDDATE )
					SetLogChatOption( elcoAPPENDDATE, xml.getBoolChild(n2) );
				else if ( xml.name(n2) == XML_LCO_APPENDHUBNAME )
					SetLogChatOption( elcoAPPENDHUBNAME, xml.getBoolChild(n2) );
				else if ( xml.name(n2) == XML_LCO_APPENDHUBHOST )
					SetLogChatOption( elcoAPPENDHUBHOST, xml.getBoolChild(n2) );
				else if ( xml.name(n2) == XML_LCO_DISABLEPUBLICCHAT )
					SetLogChatOption( elcoDISABLEPUBLICCHAT, xml.getBoolChild(n2) );
				else if ( xml.name(n2) == XML_LCO_ENABLENICKNAMEFILTER )
					SetLogChatOption( elcoENABLENICKNAMEFILTER, xml.getBoolChild(n2) );
				else if ( xml.name(n2) == XML_LCO_NICKNAMEFILTER_ENABLELOGGING )
					SetLogChatOption( elcoNICKNAMEFILTER_ENABLELOGGING, xml.getBoolChild(n2) );
				else if ( xml.name(n2) == "NICKNAMEFILTER" )
				{
					if ( xml.content(n2) != "" )
						m_pLogChatNickNameFilter.Add( new CString(xml.content(n2)) );
				}
				else if ( xml.name(n2) == XML_CC_CHATTIMESTAMP )
					SetChatColor( eccCHATTIMESTAMP, xml.content(n2) );
				else if ( xml.name(n2) == XML_CC_CHATLOCALNICK )
					SetChatColor( eccCHATLOCALNICK, xml.content(n2) );
				else if ( xml.name(n2) == XML_CC_CHATLOCALTEXT )
					SetChatColor( eccCHATLOCALTEXT, xml.content(n2) );
				else if ( xml.name(n2) == XML_CC_CHATREMOTENICK )
					SetChatColor( eccCHATREMOTENICK, xml.content(n2) );
				else if ( xml.name(n2) == XML_CC_CHATREMOTETEXT )
					SetChatColor( eccCHATREMOTETEXT, xml.content(n2) );
				else if ( xml.name(n2) == XML_CC_CHATSTATUSNICK )
					SetChatColor( eccCHATSTATUSNICK, xml.content(n2) );
				else if ( xml.name(n2) == XML_CC_CHATSTATUSTEXT )
					SetChatColor( eccCHATSTATUSTEXT, xml.content(n2) );
				else if ( xml.name(n2) == XML_CC_PUBLICCHATTIMESTAMP )
					SetChatColor( eccPUBLICCHATTIMESTAMP, xml.content(n2) );
				else if ( xml.name(n2) == XML_CC_PUBLICCHATLOCALNICK )
					SetChatColor( eccPUBLICCHATLOCALNICK, xml.content(n2) );
				else if ( xml.name(n2) == XML_CC_PUBLICCHATLOCALTEXT )
					SetChatColor( eccPUBLICCHATLOCALTEXT, xml.content(n2) );
				else if ( xml.name(n2) == XML_CC_PUBLICCHATREMOTENICK )
					SetChatColor( eccPUBLICCHATREMOTENICK, xml.content(n2) );
				else if ( xml.name(n2) == XML_CC_PUBLICCHATREMOTETEXT )
					SetChatColor( eccPUBLICCHATREMOTETEXT, xml.content(n2) );
				else if ( xml.name(n2) == XML_CC_PUBLICCHATSTATUSNICK )
					SetChatColor( eccPUBLICCHATSTATUSNICK, xml.content(n2) );
				else if ( xml.name(n2) == XML_CC_PUBLICCHATSTATUSTEXT )
					SetChatColor( eccPUBLICCHATSTATUSTEXT, xml.content(n2) );
				else if ( xml.name(n2) == XML_CC_PUBLICPRIVATECHATNICK )
					SetChatColor( eccPUBLICPRIVATECHATNICK, xml.content(n2) );
				else if ( xml.name(n2) == XML_CC_PUBLICPRIVATECHATTEXT )
					SetChatColor( eccPUBLICPRIVATECHATTEXT, xml.content(n2) );
				else if ( xml.name(n2) == XML_CC_CHATSAY )
					SetChatColor( eccCHATSAY, xml.content(n2) );
				else if ( xml.name(n2) == XML_CC_PUBLICCHATMENICK )
					SetChatColor( eccPUBLICCHATMENICK, xml.content(n2) );
				else if ( xml.name(n2) == XML_CLIENT_COLUMN_COMMENT )
					SetClientColumn( eclcCOMMENT, xml.getBoolChild(n2) );
				else if ( xml.name(n2) == XML_CLIENT_COLUMN_TAG )
					SetClientColumn( eclcTAG, xml.getBoolChild(n2) );
				else if ( xml.name(n2) == XML_CLIENT_COLUMN_SPEED )
					SetClientColumn( eclcEMAIL, xml.getBoolChild(n2) );
				else if ( xml.name(n2) == XML_CLIENT_COLUMN_EMAIL )
					SetClientColumn( eclcSPEED, xml.getBoolChild(n2) );
				else if ( xml.name(n2) == XML_CLIENT_COLUMN_SHARE )
					SetClientColumn( eclcSHARE, xml.getBoolChild(n2) );
				else if ( xml.name(n2) == XML_CLIENT_COLUMN_IP )
					SetClientColumn( eclcIP, xml.getBoolChild(n2) );
				else if ( xml.name(n2) == XML_CLIENT_COLUMN_LOCKPK )
					SetClientColumn( eclcLOCKPK, xml.getBoolChild(n2) );
				else if ( xml.name(n2) == XML_CLIENT_COLUMN_SUPPORTS )
					SetClientColumn( eclcSUPPORTS, xml.getBoolChild(n2) );
			}
		}
	}
}

/** */
int DCConfig::Load()
{
	LoadHubProfile();
	LoadDCLib();
	return LoadDCGui();
}

/** */
int DCConfig::Save()
{
	SaveDCLib();
	return SaveDCGui();
}

/** */
int DCConfig::LoadDCGui()
{
	int err = 0;
	CString s;
	xmlNodePtr node;
	CXml xml;

	// get usericons
	m_UserIcons = g_pIconLoader->GetPixmap(eiUSERICONS);

	s = sConfigPath + DCGUI_CONFIG;

	if ( xml.ParseFile(s) == TRUE )
	{
		for(node=xml.doc()->children;node!=0;node=node->next)
		{
			if ( xml.name(node) == XML_DCGUI_CONFIG )
			{
				ParseDCGuiConfig(node->xmlChildrenNode);
			}
		}
	}
	else
	{
		err = -1;
	}

	InitMimeSourceFactory();

	return err;
}

/** */
int DCConfig::SaveDCGui()
{
	int err=0;
	CString s;
	xmlDocPtr doc;
	xmlNodePtr node,node1,node2;
	CXml xml;

	doc = xmlNewDoc((const xmlChar*)"1.0");

	doc->children = xmlNewDocNode(doc,0,(const xmlChar*)XML_DCGUI_CONFIG,0);

	// gui
	node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_GUI, 0 );

	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_OPENCLIENTWINDOWSMINIMIZED, bOpenClientWindowsMinimized );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_OPENPRIVATECHATWIN, bOpenPrivateChatWindow );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_EMOTICONS, bEnableEmoticons );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_TOOLBAR, bToolBar );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_STATUSBAR, bStatusBar );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_USERLISTRIGHTALIGNMENT, bUserListRightAlignment );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_SHOWCHATSENDBUTTON, bShowChatSendButton );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_SHOWCHATINTAB, bShowChatInTab );
	xmlNewChild( node, 0, (const xmlChar*)XML_CHATMAXPARAGRAPH, (const xmlChar*) CString().setNum(m_nChatMaxParagraph).Data() );

	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_USER_PHOTO, m_sUserPhotoFileName );

	switch(m_eUnit)
	{
		case euBYTE:
			s = XML_UNIT_BYTE;
			break;
		case euKBYTE:
			s = XML_UNIT_KBYTE;
			break;
		case euMBYTE:
			s = XML_UNIT_MBYTE;
			break;
		case euGBYTE:
			s = XML_UNIT_GBYTE;
			break;
		default:
			s = XML_UNIT_AUTO;
			break;
	}

	xmlNewChild( node, 0, (const xmlChar*)XML_UNIT, (const xmlChar*)(const char*)s.Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_THEME, (const xmlChar*) xml.ToUTF8(sTheme).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_BACKGROUNDPIXMAP, (const xmlChar*) xml.ToUTF8(sBackgroundPixmap).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_BROWSER, (const xmlChar*) xml.ToUTF8(sBrowser).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_SENDCHAT, (const xmlChar*) xml.ToUTF8(sSendChat).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_LANGUAGEFILE, (const xmlChar*) xml.ToUTF8(sLanguageFile).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_APP_FONT, (const xmlChar*) xml.ToUTF8(sAppFont).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_APP_WIDTH, (const xmlChar*) CString().setNum(iAppWidth).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_APP_HEIGHT, (const xmlChar*) CString().setNum(iAppHeight).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_TV_WIDTH, (const xmlChar*) CString().setNum(iTransferViewWidth).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_TV_HEIGHT, (const xmlChar*) CString().setNum(iTransferViewHeight).Data() );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_TV_DOCKED, bTransferViewDocked );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_QUERYONEXIT, bQueryOnExit );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_QUERYONFILEDELETE, bQueryOnFileDelete );

	// sound settings
	xmlNewChild( node, 0, (const xmlChar*)XML_SOUND_FILE_CONNECT, (const xmlChar*) xml.ToUTF8(sSoundFileConnect).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_SOUND_FILE_DISCONNECT, (const xmlChar*) xml.ToUTF8(sSoundFileDisconnect).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_SOUND_FILE_SEND, (const xmlChar*) xml.ToUTF8(sSoundFileSend).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_SOUND_FILE_RECEIVE, (const xmlChar*) xml.ToUTF8(sSoundFileReceive).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_SOUND_FILE_FIRSTRECEIVE, (const xmlChar*) xml.ToUTF8(sSoundFileFirstReceive).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_EXTERNAL_PLAYER, (const xmlChar*) xml.ToUTF8(sExternalPlayer).Data() );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_SOUND_ENABLED_CONNECT, bSoundEnabledConnect );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_SOUND_ENABLED_DISCONNECT, bSoundEnabledDisconnect );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_SOUND_ENABLED_SEND, bSoundEnabledSend );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_SOUND_ENABLED_RECEIVE, bSoundEnabledReceive );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_SOUND_ENABLED_FIRSTRECEIVE, bSoundEnabledFirstReceive );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_EXTERNAL_SOUND_PLAYER, bExternalSoundPlayer );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_SOUND_DISABLED, bSoundDisabled );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_SOUND_DISABLED_AWAY, bSoundDisabledAway );

	// log settings
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_TIMESTAMP_PRIVATECHAT, bTimeStampPrivateChat );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_TIMESTAMP_HUBCHAT, bTimeStampHubChat );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_SHOW_STATUS_MESSAGE, bShowStatusMessage );

	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_LCO_ENABLELOGGING, GetLogChatOption( elcoENABLELOGGING ) );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_LCO_APPENDDATE, GetLogChatOption( elcoAPPENDDATE ) );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_LCO_APPENDHUBNAME, GetLogChatOption( elcoAPPENDHUBNAME ) );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_LCO_APPENDHUBHOST, GetLogChatOption( elcoAPPENDHUBHOST ) );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_LCO_DISABLEPUBLICCHAT, GetLogChatOption( elcoDISABLEPUBLICCHAT ) );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_LCO_ENABLENICKNAMEFILTER, GetLogChatOption( elcoENABLENICKNAMEFILTER ) );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_LCO_NICKNAMEFILTER_ENABLELOGGING, GetLogChatOption( elcoNICKNAMEFILTER_ENABLELOGGING ) );

	CString *ps = 0;

	while ( (ps=m_pLogChatNickNameFilter.Next(ps)) != 0 )
	{
		xmlNewChild( node, 0, (const xmlChar*)"NICKNAMEFILTER", (const xmlChar*) xml.ToUTF8(*ps).Data() );
	}

	// chat text codec
	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_CHATINPUTCODEC, m_sChatInputCodec );
	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_CHATOUTPUTCODEC, m_sChatOutputCodec );

	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_CC_CHATTIMESTAMP, GetChatColor(eccCHATTIMESTAMP) );
	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_CC_CHATLOCALNICK, GetChatColor(eccCHATLOCALNICK) );
	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_CC_CHATLOCALTEXT, GetChatColor(eccCHATLOCALTEXT) );
	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_CC_CHATREMOTENICK, GetChatColor(eccCHATREMOTENICK) );
	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_CC_CHATREMOTETEXT, GetChatColor(eccCHATREMOTETEXT) );
	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_CC_CHATSTATUSNICK, GetChatColor(eccCHATSTATUSNICK) );
	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_CC_CHATSTATUSTEXT, GetChatColor(eccCHATSTATUSTEXT) );
	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_CC_PUBLICCHATTIMESTAMP, GetChatColor(eccPUBLICCHATTIMESTAMP) );
	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_CC_PUBLICCHATLOCALNICK, GetChatColor(eccPUBLICCHATLOCALNICK) );
	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_CC_PUBLICCHATLOCALTEXT, GetChatColor(eccPUBLICCHATLOCALTEXT) );
	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_CC_PUBLICCHATREMOTENICK, GetChatColor(eccPUBLICCHATREMOTENICK) );
	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_CC_PUBLICCHATREMOTETEXT, GetChatColor(eccPUBLICCHATREMOTETEXT) );
	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_CC_PUBLICCHATSTATUSNICK, GetChatColor(eccPUBLICCHATSTATUSNICK) );
	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_CC_PUBLICCHATSTATUSTEXT, GetChatColor(eccPUBLICCHATSTATUSTEXT) );
	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_CC_PUBLICPRIVATECHATNICK, GetChatColor(eccPUBLICPRIVATECHATNICK) );
	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_CC_PUBLICPRIVATECHATTEXT, GetChatColor(eccPUBLICPRIVATECHATTEXT) );
	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_CC_CHATSAY, GetChatColor(eccCHATSAY) );
	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_CC_PUBLICCHATMENICK, GetChatColor(eccPUBLICCHATMENICK) );

	// transfer view settings
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_TV_CHUNKPERCENT, bTVChunkPercent );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_TV_FILEPERCENT, bTVFilePercent );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_TV_CHUNKSIZE, bTVChunkSize );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_TV_FILESIZE, bTVFileSize );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_TV_DOWNLOADRATESINGLE, bTVDownloadRateSingle );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_TV_ELAPSEDTIMESINGLE, bTVElapsedTimeSingle );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_TV_DOWNLOADRATEMULTI, bTVDownloadRateMulti );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_TV_ELAPSEDTIMEMULTI, bTVElapsedTimeMulti );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_SHOW_TRANSFER_WIN, bShowTransferWin );
	
	xmlNewChild( node, 0, (const xmlChar*)XML_FLOODCOUNT, (const xmlChar*) CString().setNum(iFloodCount).Data() );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_FLOODOPKICK, m_bFloodOpKick );

	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_SEND_HIDE_PRIVATE_CHAT_TO_PUBLIC_CHAT, bSendHidePrivateChatToPublicChat );
	xmlNewChild( node, 0, (const xmlChar*)XML_CHAT_MESSAGE_MAX_LINES, (const xmlChar*) CString().setNum(iChatMessageMaxLines).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_DEFAULTDOWNLOADMODE, (const xmlChar*) CString().setNum(iDefaultDownloadMode).Data() );

	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_AUTO_AWAY_MODE, m_bAutoAwayMode );
	xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_AUTO_AWAY_TIME, CString().setNum(m_nAutoAwayTime) );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_CHAT_SHOW_JOINS_AND_PARTS, m_bChatShowJoinsAndParts );

	// save client column settings
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_CLIENT_COLUMN_COMMENT, GetClientColumn(eclcCOMMENT) );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_CLIENT_COLUMN_TAG, GetClientColumn(eclcTAG) );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_CLIENT_COLUMN_SPEED, GetClientColumn(eclcEMAIL) );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_CLIENT_COLUMN_EMAIL, GetClientColumn(eclcSPEED) );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_CLIENT_COLUMN_SHARE, GetClientColumn(eclcSHARE) );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_CLIENT_COLUMN_IP, GetClientColumn(eclcIP) );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_CLIENT_COLUMN_LOCKPK, GetClientColumn(eclcLOCKPK) );
	xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_CLIENT_COLUMN_SUPPORTS, GetClientColumn(eclcSUPPORTS) );
	
	// save map settings
	SettingMap::Iterator it;
	StringMap::Iterator it1;

	for(it=m_guiSettingMap.begin();it!=m_guiSettingMap.end();++it)
	{
		node1 = xmlNewChild( node, 0, (const xmlChar*)"MAP", 0 );
		xmlNewChild( node1, 0, (const xmlChar*)"KEY", (const xmlChar*) xml.ToUTF8(it.key().ascii()).Data() );
		for(it1=it.data()->begin();it1!=it.data()->end();++it1)
		{
			node2 = xmlNewChild( node1, 0, (const xmlChar*)XML_ENTRY, 0 );
			xmlNewChild( node2, 0, (const xmlChar*)"KEY", (const xmlChar*) xml.ToUTF8(it1.key().ascii()).Data() );
			xmlNewChild( node2, 0, (const xmlChar*)"NAME", (const xmlChar*) xml.ToUTF8(it1.data().ascii()).Data() );
		}
	}

	// save file
	s = sConfigPath + DCGUI_CONFIG;

	if ( xmlSaveFormatFile(s.Data(),doc,1) == -1 )
	{
		err = -1;
	}

	xmlFreeDoc(doc);

	return err;
}

/** */
int DCConfig::LoadDCHubFilter( CStringList * list )
{
	CString s;
	xmlNodePtr node,n1,n2;
	CXml xml;
	DC_HubFilterObject * HubFilterObject;

	s = sConfigPath + DCGUI_HUBFILTER;

	if ( xml.ParseFile(s) == TRUE )
	{
		for(node=xml.doc()->children;node!=0;node=node->next)
		{
			if ( xml.name(node) == XML_DCGUI_HUBFILTER )
			{
				for(n1=node->xmlChildrenNode;n1!=0;n1=n1->next)
				{
					if ( xml.name(n1) == XML_FILTER )
					{
						HubFilterObject = new DC_HubFilterObject();

						for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
						{
							if ( xml.name(n2) == XML_FILTERNAME )
								HubFilterObject->m_sFilterName = xml.content(n2);
							else if ( xml.name(n2) == XML_CONTAINS )
								HubFilterObject->m_sContains = xml.content(n2);
							else if ( xml.name(n2) == XML_USER )
								HubFilterObject->m_nUser = xml.content(n2).asINT();
							else if ( xml.name(n2) == XML_NAME )
								HubFilterObject->m_bName = xml.getBoolChild(n2);
							else if ( xml.name(n2) == XML_SERVER )
								HubFilterObject->m_bServer = xml.getBoolChild(n2);
							else if ( xml.name(n2) == XML_DESCRIPTION )
								HubFilterObject->m_bDescription = xml.getBoolChild(n2);
						}

						if ( HubFilterObject->m_sFilterName != "" )
							list->Add( HubFilterObject->m_sFilterName, HubFilterObject );
						else
							delete HubFilterObject;
					}
				}
			}
		}
	}

	return 0;
}

/** */
int DCConfig::SaveDCHubFilter( CStringList * list )
{
	int err=0;
	CString s;
	xmlDocPtr doc;
	DC_HubFilterObject * HubFilterObject;
	xmlNodePtr node;
	CXml xml;

	doc = xmlNewDoc((const xmlChar*)"1.0");

	doc->children = xmlNewDocNode(doc,0,(const xmlChar*)XML_DCGUI_HUBFILTER,0);

	HubFilterObject = 0;

	while( list->Next((CObject *&)HubFilterObject) == 1 )
	{
		node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_FILTER, 0 );

		xmlNewChild( node, 0, (const xmlChar*)XML_FILTERNAME, (const xmlChar*) xml.ToUTF8(HubFilterObject->m_sFilterName).Data() );
		xmlNewChild( node, 0, (const xmlChar*)XML_CONTAINS, (const xmlChar*) xml.ToUTF8(HubFilterObject->m_sContains).Data() );
		xmlNewChild( node, 0, (const xmlChar*)XML_USER, (const xmlChar*) CString().setNum(HubFilterObject->m_nUser).Data() );
		xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_NAME, HubFilterObject->m_bName );
		xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_SERVER, HubFilterObject->m_bServer );
		xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_DESCRIPTION, HubFilterObject->m_bDescription );
	}

	// save file
	s = sConfigPath + DCGUI_HUBFILTER;

	if ( xmlSaveFormatFile(s.Data(),doc,1) == -1 )
	{
		err = -1;
	}

	xmlFreeDoc(doc);

	return err;
}

/** */
int DCConfig::LoadDCFriendList( CStringList * list )
{
	CString s;
	xmlNodePtr node,n1,n2;
	CXml xml;
	DCFriendObject * FriendObject;

	s = sConfigPath + DCGUI_FRIENDLIST;

	if ( xml.ParseFile(s) == TRUE )
	{
		for(node=xml.doc()->children;node!=0;node=node->next)
		{
			if ( xml.name(node) == XML_DCGUI_FRIENDLIST )
			{
				for(n1=node->xmlChildrenNode;n1!=0;n1=n1->next)
				{
					if ( xml.name(n1) == XML_FRIEND )
					{
						FriendObject = new DCFriendObject();

						for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
						{
							if ( xml.name(n2) == XML_NAME )
								FriendObject->m_sName = xml.content(n2);
							else if ( xml.name(n2) == XML_DESCRIPTION )
								FriendObject->m_sDescription = xml.content(n2);
							else if ( xml.name(n2) == XML_HUBNAME )
								FriendObject->m_sHubName = xml.content(n2);
							else if ( xml.name(n2) == XML_HUBHOST )
								FriendObject->m_sHubHost = xml.content(n2);
							else if ( xml.name(n2) == XML_IMAGE )
								FriendObject->m_sImageFileName = xml.content(n2);
							else if ( xml.name(n2) == XML_SEND_IMAGE )
								FriendObject->m_bSendImage = xml.content(n2).asINT();
							else if ( xml.name(n2) == XML_AUTO_SEC )
								FriendObject->m_bAutoSec = xml.content(n2).asINT();
						}

						if ( FriendObject->m_sName != "" )
							list->Add( FriendObject->m_sName, FriendObject );
						else
							delete FriendObject;
					}
				}
			}
		}
	}

	return 0;
}

/** */
int DCConfig::SaveDCFriendList( CStringList * list )
{
	int err=0;
	CString s;
	xmlDocPtr doc;
	DCFriendObject * FriendObject;
	xmlNodePtr node;
	CXml xml;

	doc = xmlNewDoc((const xmlChar*)"1.0");

	doc->children = xmlNewDocNode(doc,0,(const xmlChar*)XML_DCGUI_FRIENDLIST,0);

	FriendObject = 0;

	while( list->Next((CObject *&)FriendObject) == 1 )
	{
		node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_FRIEND, 0 );

		xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_NAME, FriendObject->m_sName );
		xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_DESCRIPTION, FriendObject->m_sDescription );
		xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_HUBNAME, FriendObject->m_sHubName );
		xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_HUBHOST, FriendObject->m_sHubHost );
		xml.xmlNewStringChild( node, 0, (const xmlChar*)XML_IMAGE, FriendObject->m_sImageFileName );
		xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_SEND_IMAGE, FriendObject->m_bSendImage );
		xml.xmlNewBoolChild( node, 0, (const xmlChar*)XML_AUTO_SEC, FriendObject->m_bAutoSec );
	}

	// save file
	s = sConfigPath + DCGUI_FRIENDLIST;

	if ( xmlSaveFormatFile(s.Data(),doc,1) == -1 )
	{
		err = -1;
	}

	xmlFreeDoc(doc);

	return err;
}

/** */
QPixmap * DCConfig::GetUserIcon( bool op, eClientMode clientmode, eUserAwayMode awaymode, eUserSpeed speed, eUserClientVersion version )
{
	int x,y;

	y = 0;

	switch(speed)
	{
		case eus288KBPS:
		case eus336KBPS:
		case eus56KBPS:
			x = 0;
			break;
		case eusISDN:
			x = 16;
			break;
		case eusSATELLITE:
			x = 32;
			break;
		case eusCABLE:
			x = 64;
			break;
		case eusDSL:
			x = 80;
			break;
		case eusLANT1:
		case eusLANT3:
			x = 96;
			break;
		default:
			x = -1;
			y = -1;
			break;
	}

	if ( (x != -1) && (y != -1) )
	{
		if ( op )
		{
			y += 16*6;
		}

		if ( awaymode == euamAWAY )
		{
			y += 16;
		}

		if ( version == eucvDCGUI )
		{
			y += 16*4;
		}

		if ( clientmode == ecmPASSIVE )
		{
			y += 16*12;
		}
	}

	if ( (x == m_nUICX) &&
	     (y == m_nUICY) )
	{
		return &m_UserIconCache;
	}

	m_nUICX = x;
	m_nUICY = y;

	if ( (x == -1) && (y == -1) )
	{
		m_UserIconCache = g_pIconLoader->GetPixmap(eiGV);
	}
	else
	{
		m_UserIconCache = m_UserIcons.copy(x,y,16,16);
        }

	return &m_UserIconCache;
}

/** */
CString DCConfig::GetSoundFile( eUserSound usersound )
{
	CString s;

	switch (usersound)
	{
		case eusCONNECT:
			s = sSoundFileConnect;
			break;
		case eusDISCONNECT:
			s = sSoundFileDisconnect;
			break;
		case eusSEND:
			s = sSoundFileSend;
			break;
		case eusRECEIVE:
			s = sSoundFileReceive;
			break;
		case eusFIRSTRECEIVE:
			s = sSoundFileFirstReceive;
			break;
		default:
			s = "";
			break;
	}

	return s;
}

/** */
void DCConfig::SetSoundFile( eUserSound usersound, CString soundfile )
{
	switch (usersound)
	{
		case eusCONNECT:
			sSoundFileConnect = soundfile;
			break;
		case eusDISCONNECT:
			sSoundFileDisconnect = soundfile;
			break;
		case eusSEND:
			sSoundFileSend = soundfile;
			break;
		case eusRECEIVE:
			sSoundFileReceive = soundfile;
			break;
		case eusFIRSTRECEIVE:
			sSoundFileFirstReceive = soundfile;
			break;
		default:
			break;
	}
}

/** */
bool DCConfig::GetSoundEnabled( eUserSound usersound )
{
	bool b;

	switch (usersound)
	{
		case eusCONNECT:
			b = bSoundEnabledConnect;
			break;
		case eusDISCONNECT:
			b = bSoundEnabledDisconnect;
			break;
		case eusSEND:
			b = bSoundEnabledSend;
			break;
		case eusRECEIVE:
			b = bSoundEnabledReceive;
			break;
		case eusFIRSTRECEIVE:
			b = bSoundEnabledFirstReceive;
			break;
		default:
			b = FALSE;
			break;
	}

	return b;
}

/** */
void DCConfig::SetSoundEnabled( eUserSound usersound, bool enabled )
{
	switch (usersound)
	{
		case eusCONNECT:
			bSoundEnabledConnect = enabled;
			break;
		case eusDISCONNECT:
			bSoundEnabledDisconnect = enabled;
			break;
		case eusSEND:
			bSoundEnabledSend = enabled;
			break;
		case eusRECEIVE:
			bSoundEnabledReceive = enabled;
			break;
		case eusFIRSTRECEIVE:
			bSoundEnabledFirstReceive = enabled;
			break;
		default:
			break;
	}
}

/** */
void DCConfig::PlaySound( eUserSound usersound )
{
	CString s = "";

	if ( bSoundDisabled == TRUE )
	{
		return;
	}

	if ( (GetAwayMode() == euamAWAY) && (bSoundDisabledAway == TRUE) )
	{
		return;
	}

	switch(usersound)
	{
		case eusCONNECT:
			if ( bSoundEnabledConnect )
				s = sSoundFileConnect;
			break;
		case eusDISCONNECT:
			if ( bSoundEnabledDisconnect )
				s = sSoundFileDisconnect;
			break;
		case eusSEND:
			if ( bSoundEnabledSend )
				s = sSoundFileSend;
			break;
		case eusRECEIVE:
			if ( bSoundEnabledReceive )
				s = sSoundFileReceive;
			break;
		case eusFIRSTRECEIVE:
			if ( bSoundEnabledFirstReceive )
				s = sSoundFileFirstReceive;
			break;
		default:
			break;
	}

	PlaySound(s);
}

/** */
void DCConfig::PlaySound( CString file )
{
	if ( file == "" )
	{
		return;
	}

	if ( bExternalSoundPlayer == FALSE )
	{
		QSound::play(file.Data());
	}
	else
	{
		if ( pProcess->isRunning() == TRUE )
		{
			pProcess->kill();
		}

		pProcess->clearArguments();

		pProcess->addArgument(sExternalPlayer.Data());
		pProcess->addArgument(file.Data());

		if ( !pProcess->start() )
		{
			printf("error start play process\n");
		}
	}
}

/** */
void DCConfig::SetTimeStamp( eTimeStamp timestamp, bool enabled )
{
	switch(timestamp)
	{
		case etsPRIVATECHAT:
			bTimeStampPrivateChat = enabled;
			break;
		case etsHUBCHAT:
			bTimeStampHubChat = enabled;
			break;
		default:
			break;
	}
}

/** */
bool DCConfig::GetTimeStamp( eTimeStamp timestamp )
{
	bool res;

	switch(timestamp)
	{
		case etsPRIVATECHAT :
			res = bTimeStampPrivateChat;
			break;
		case etsHUBCHAT:
			res = bTimeStampHubChat;
			break;
		default:
			res = FALSE;
			break;
	}

	return res;
}

/** */
bool DCConfig::GetTransferViewOptions( eTransferViewOptions e ) const
{
	switch(e)
	{
		case etvoCHUNKPERCENT:
			return bTVChunkPercent;
			break;
		case etvoFILEPERCENT:
			return bTVFilePercent;
			break;		
		case etvoCHUNKSIZE:
			return bTVChunkSize;
			break;		
		case etvoFILESIZE:
			return bTVFileSize;
			break;		
		case etvoDOWNLOADRATESINGLE:
			return bTVDownloadRateSingle;
			break;		
		case etvoELAPSEDTIMESINGLE:
			return bTVElapsedTimeSingle;
			break;		
		case etvoDOWNLOADRATEMULTI:
			return bTVDownloadRateMulti;
			break;		
		case etvoELAPSEDTIMEMULTI:
			return bTVElapsedTimeMulti;
			break;		
		default:
			return FALSE;
			break;
	}
}

/** */
void DCConfig::SetTransferViewOptions( eTransferViewOptions e, bool b )
{
  	switch(e)
	{
		case etvoCHUNKPERCENT:
			bTVChunkPercent = b;
			break;
		case etvoFILEPERCENT:
			bTVFilePercent = b;
			break;		
		case etvoCHUNKSIZE:
			bTVChunkSize = b;
			break;		
		case etvoFILESIZE:
			bTVFileSize = b;
			break;		
		case etvoDOWNLOADRATESINGLE:
			bTVDownloadRateSingle = b;
			break;		
		case etvoELAPSEDTIMESINGLE:
			bTVElapsedTimeSingle = b;
			break;		
		case etvoDOWNLOADRATEMULTI:
			bTVDownloadRateMulti = b;
			break;		
		case etvoELAPSEDTIMEMULTI:
			bTVElapsedTimeMulti = b;
			break;		
		default:
			break;
	}
}

/** */
bool DCConfig::InitMimeSourceFactory()
{
	DC_EmoticonObject * EmoticonObject;
	CString s,imagename;
	xmlNodePtr node,n1,n2;
	CXml xml;
	int id;
	bool res = FALSE;

	if ( m_pMimeSourceFactory )
	{
		QMimeSourceFactory::removeFactory(m_pMimeSourceFactory);
		delete m_pMimeSourceFactory;
		m_pMimeSourceFactory = 0;
	}

	m_EmoticonImage.reset();

	if ( m_EmoticonSettingList )
	{
		delete m_EmoticonSettingList;
	}

	m_EmoticonSettingList = new CList<DC_EmoticonObject>();

	// load emoticons
	
	// first we check if a local icon present
	s = GetConfigPath()+DIRSEPARATOR;
	
	if ( xml.ParseFile(s+"emoticons.xml") == FALSE )
	{
		// get global icons
		s = GetDatadir()+DIRSEPARATOR+"icons"+DIRSEPARATOR+"emot"+DIRSEPARATOR+"default"+DIRSEPARATOR;

		if ( xml.ParseFile(s+"emoticons.xml") == FALSE )
		{
			return res;
		}
	}

	id = 0;

	// parse the list
	for(node=xml.doc()->children;node!=0;node=node->next)
	{
		if ( xml.name(node) == "emoticons" )
		{
			for(n1=node->xmlChildrenNode;n1!=0;n1=n1->next)
			{
				if ( xml.name(n1) == "emoticon" )
				{
					EmoticonObject = new DC_EmoticonObject();

					EmoticonObject->m_Text = xml.prop(n1,"text").Data();

					for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
					{
						if ( xml.name(n2) == "source" )
						{
							EmoticonObject->left   = xml.prop(n2,"left").asINT();
							EmoticonObject->top    = xml.prop(n2,"top").asINT();
							EmoticonObject->right  = xml.prop(n2,"right").asINT();
							EmoticonObject->bottom = xml.prop(n2,"bottom").asINT();

							imagename = xml.prop(n2,"name") + ".xpm";
						}
					}

					if ( EmoticonObject->m_Text != "" )
					{
							EmoticonObject->m_nID = id;
							id++;
							m_EmoticonSettingList->Add(EmoticonObject);

//							printf("%s\n",EmoticonObject->m_Text.Data());
					}
				}
			}
		}
	}
	
	if ( m_EmoticonImage.load((s+imagename).Data()) == TRUE )
	{
		res = TRUE;
	}
	else
	{
		if ( m_EmoticonSettingList )
		{
			delete m_EmoticonSettingList;
			m_EmoticonSettingList = 0;
		}
	}

	if ( m_EmoticonSettingList )
	{
		if ( m_EmoticonSettingList->Count() > 0 )
		{
			m_pMimeSourceFactory = new QMimeSourceFactory();

			EmoticonObject = 0;

			while( (EmoticonObject=m_EmoticonSettingList->Next(EmoticonObject)) != 0 )
			{
				m_pMimeSourceFactory->setImage( ("emoticon" + CString().setNum(EmoticonObject->m_nID)).Data(), 
					m_EmoticonImage.copy(EmoticonObject->left,EmoticonObject->top,EmoticonObject->right-EmoticonObject->left,EmoticonObject->bottom-EmoticonObject->top) );
			}

			QMimeSourceFactory::addFactory(m_pMimeSourceFactory);

			res = TRUE;
		}
	}

	return res;
}

/** */
CList<DC_EmoticonObject> * DCConfig::EmoticonList()
{
	return m_EmoticonSettingList;
}

/** */
QImage & DCConfig::GetEmoticonImage()
{
	return m_EmoticonImage;
}

/** */
bool DCConfig::GetMap( CString name, StringMap *& map )
{
	bool res = TRUE;

	if ( m_guiSettingMap.find(name.Data()) == m_guiSettingMap.end() )
	{
		m_guiSettingMap[name.Data()] = new StringMap();
		res = FALSE;
	}

	map = m_guiSettingMap[name.Data()];

	return res;
}

/** */
CString DCConfig::GetChatColor( eChatColor type ) const
{
	switch (type)
	{
		case eccCHATTIMESTAMP:
			return m_sChatColor_1;
		case eccCHATLOCALNICK:
			return m_sChatColor_2;
		case eccCHATLOCALTEXT:
			return m_sChatColor_3;
		case eccCHATREMOTENICK:
			return m_sChatColor_4;
		case eccCHATREMOTETEXT:
			return m_sChatColor_5;
		case eccCHATSTATUSNICK:
			return m_sChatColor_6;
		case eccCHATSTATUSTEXT:
			return m_sChatColor_7;
		case eccPUBLICCHATTIMESTAMP:
			return m_sChatColor_8;
		case eccPUBLICCHATLOCALNICK:
			return m_sChatColor_9;
		case eccPUBLICCHATLOCALTEXT:
			return m_sChatColor_10;
		case eccPUBLICCHATREMOTENICK:
			return m_sChatColor_11;
		case eccPUBLICCHATREMOTETEXT:
			return m_sChatColor_12;
		case eccPUBLICCHATSTATUSNICK:
			return m_sChatColor_13;
		case eccPUBLICCHATSTATUSTEXT:
			return m_sChatColor_14;
		case eccPUBLICPRIVATECHATNICK:
			return m_sChatColor_15;
		case eccPUBLICPRIVATECHATTEXT:
			return m_sChatColor_16;
		case eccCHATSAY:
			return m_sChatColor_17;
		case eccPUBLICCHATMENICK:
			return m_sChatColor_18;
		default:
			break;
	}

	return "";
}

/** */
void DCConfig::SetChatColor( eChatColor type, CString s )
{
	switch (type)
	{
		case eccCHATTIMESTAMP:
			m_sChatColor_1 = s;
			break;
		case eccCHATLOCALNICK:
			m_sChatColor_2 = s;
			break;
		case eccCHATLOCALTEXT:
			m_sChatColor_3 = s;
			break;
		case eccCHATREMOTENICK:
			m_sChatColor_4 = s;
			break;
		case eccCHATREMOTETEXT:
			m_sChatColor_5 = s;
			break;
		case eccCHATSTATUSNICK:
			m_sChatColor_6 = s;
			break;
		case eccCHATSTATUSTEXT:
			m_sChatColor_7 = s;
			break;
		case eccPUBLICCHATTIMESTAMP:
			m_sChatColor_8 = s;
			break;
		case eccPUBLICCHATLOCALNICK:
			m_sChatColor_9 = s;
			break;
		case eccPUBLICCHATLOCALTEXT:
			m_sChatColor_10 = s;
			break;
		case eccPUBLICCHATREMOTENICK:
			m_sChatColor_11 = s;
			break;
		case eccPUBLICCHATREMOTETEXT:
			m_sChatColor_12 = s;
			break;
		case eccPUBLICCHATSTATUSNICK:
			m_sChatColor_13 = s;
			break;
		case eccPUBLICCHATSTATUSTEXT:
			m_sChatColor_14 = s;
			break;
		case eccPUBLICPRIVATECHATNICK:
			m_sChatColor_15 = s;
			break;
		case eccPUBLICPRIVATECHATTEXT:
			m_sChatColor_16 = s;
			break;
		case eccCHATSAY:
			m_sChatColor_17 = s;
			break;
		case eccPUBLICCHATMENICK:
			m_sChatColor_18 = s;
			break;
		default:
			break;
	}
}

/** */
void DCConfig::SetLogChatOption( eLogChatOptions elco, bool enabled )
{
	switch(elco)
	{
		case elcoENABLELOGGING:
			m_bLogChatOption_1 = enabled;
			break;
		case elcoAPPENDDATE:
			m_bLogChatOption_2 = enabled;
			break;
		case elcoAPPENDHUBNAME:
			m_bLogChatOption_3 = enabled;
			break;
		case elcoDISABLEPUBLICCHAT:
			m_bLogChatOption_4 = enabled;
			break;
		case elcoENABLENICKNAMEFILTER:
			m_bLogChatOption_5 = enabled;
			break;
		case elcoNICKNAMEFILTER_ENABLELOGGING:
			m_bLogChatOption_6 = enabled;
			break;
		case elcoAPPENDHUBHOST:
			m_bLogChatOption_7 = enabled;
			break;
		default:
			break;
	}
}

/** */
bool DCConfig::GetLogChatOption( eLogChatOptions elco )
{
	switch(elco)
	{
		case elcoENABLELOGGING:
			return m_bLogChatOption_1;
			break;
		case elcoAPPENDDATE:
			return m_bLogChatOption_2;
			break;
		case elcoAPPENDHUBNAME:
			return m_bLogChatOption_3;
			break;
		case elcoDISABLEPUBLICCHAT:
			return m_bLogChatOption_4;
			break;
		case elcoENABLENICKNAMEFILTER:
			return m_bLogChatOption_5;
			break;
		case elcoNICKNAMEFILTER_ENABLELOGGING:
			return m_bLogChatOption_6;
			break;
		case elcoAPPENDHUBHOST:
			return m_bLogChatOption_7;
			break;
		default:
			break;
	}

	return FALSE;
}

/** */
void DCConfig::SetLogChatNickNameFilter( CList<CString> * list )
{
	CString * ps = 0;

	if ( !list )
	{
		return;
	}

	m_pLogChatNickNameFilter.Clear();

	while( (ps = list->Next(ps)) != 0 )
	{
		m_pLogChatNickNameFilter.Add( new CString(*ps) );
	}
}

/** */
void DCConfig::GetLogChatNickNameFilter( CList<CString> * list )
{
	CString * ps = 0;

	if ( !list )
	{
		return;
	}

	list->Clear();

	while( (ps = m_pLogChatNickNameFilter.Next(ps)) != 0 )
	{
		list->Add( new CString(*ps) );
	}
}

/** */
bool DCConfig::CheckLogChatNickNameFilter( CString nick )
{
	CString * ps = 0;

	if ( GetLogChatOption(elcoENABLENICKNAMEFILTER) == FALSE )
	{
		return TRUE;
	}

	while( (ps = m_pLogChatNickNameFilter.Next(ps)) != 0 )
	{
		if ( *ps == nick )
		{
			if ( GetLogChatOption(elcoNICKNAMEFILTER_ENABLELOGGING) )
			{
				return TRUE;
			}
			else
			{
				return FALSE;
			}
		}
	
	}

	// nick not found
	if ( !GetLogChatOption(elcoNICKNAMEFILTER_ENABLELOGGING) )
		return TRUE;

	return FALSE;
}

/** */
CString DCConfig::GetChatTextCodec( eChatTextCodec e )
{
	switch(e)
	{
		case ectcINPUT:
			return m_sChatInputCodec;
		case ectcOUTPUT:
			return m_sChatOutputCodec;
		default:
			break;
	}

	return "";
}

/** */
void DCConfig::SetChatTextCodec( eChatTextCodec e, CString s )
{
	switch(e)
	{
		case ectcINPUT:
			m_sChatInputCodec = s;
			break;
		case ectcOUTPUT:
			m_sChatOutputCodec = s;
			break;
		default:
			break;
	}
}

/** */
bool DCConfig::GetClientColumn( eClientColumn e )
{
	switch(e)
	{
		case eclcCOMMENT:
			return m_bClientColumnComment;
			break;
		case eclcTAG:
			return m_bClientColumnTag;
			break;
		case eclcEMAIL:
			return m_bClientColumnEMail;
			break;
		case eclcSPEED:
			return m_bClientColumnSpeed;
			break;
		case eclcSHARE:
			return m_bClientColumnShare;
			break;
		case eclcIP:
			return m_bClientColumnIP;
			break;
		case eclcLOCKPK:
			return m_bClientColumnLOCKPK;
			break;
		case eclcSUPPORTS:
			return m_bClientColumnSUPPORTS;
			break;
		default:
			break;
	}

	return FALSE;
}

/** */
void DCConfig::SetClientColumn( eClientColumn e, bool b )
{
	switch(e)
	{
		case eclcCOMMENT:
			m_bClientColumnComment = b;
			break;
		case eclcTAG:
			m_bClientColumnTag = b;
			break;
		case eclcEMAIL:
			m_bClientColumnEMail = b;
			break;
		case eclcSPEED:
			m_bClientColumnSpeed = b;
			break;
		case eclcSHARE:
			m_bClientColumnShare = b;
			break;
		case eclcIP:
			m_bClientColumnIP = b;
			break;
		case eclcLOCKPK:
			m_bClientColumnLOCKPK = b;
			break;
		case eclcSUPPORTS:
			m_bClientColumnSUPPORTS = b;
			break;
		default:
			break;
	}
}
