/* Distributed Checksum Clearinghouse
 *
 * common threaded client definitions
 *
 * Copyright (c) 2004 by Rhyolite Software
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.2.66-1.12 $Revision$
 */

#ifndef CLNT_DEFS_H
#define CLNT_DEFS_H

#include "dcc_ck.h"
#include "dcc_xhdr.h"
#include "dcc_heap_debug.h"
#ifdef HAVE_PTHREAD_H
#include <pthread.h>
#else
#include <sys/pthread.h>
#endif
#ifndef DCC_WIN32
#include <sys/un.h>
#include <sys/resource.h>
#include <arpa/inet.h>
#endif



/* what to do about checksums whose counts say "spam" */
typedef enum {
    CMN_REJECT = 0,			/* tell sendmail to reject spam */
    CMN_DISCARD,			/* discard spam */
    CMN_IGNORE,				/* ignore spam reports */
} CMN_ACTION;


/* This is a wild guess of open files hidden in libraries and elsewhere.
 * Some systems such as Solaris seem to have an amazing number of them
 * Each whitelist context can involve two open files. */
#define EXTRA_FILES	(32 + NUM_CWFS*2)


/* per-recipient state */
typedef struct rcpt_st {
    struct rcpt_st *fwd;
    struct cmn_work *cwp;
    int		user_log_fd;
    off_t	log_pos_to;		/* env_To line in main log file */
    off_t	log_pos_white;
    DCC_CKS_WTGTS wtgts;
    DCC_ASK_GREY_RESULT grey_result;
    u_int	embargo_num;
    u_int	flags;
#    define	 RCPT_ST_DO_DCC	    0x0001  /* apply DCC checks for rcpt */
#    define	 RCPT_ST_GREY_OFF   0x0002  /* greylisting off */
#    define	 RCPT_ST_GREY_ON    0x0004  /* greylisting off */
#    define	 RCTP_ST_GREY_LOG_OFF 0x08  /* do not log greylist embargos */
#    define	 RCTP_ST_GREY_LOG_ON  0x10  /* do not log greylist embargos */
#    define	 RCTP_ST_LOG_ALL    0x0020
#    define	 RCPT_ST_WHITE	    0x0040  /* msg is whitelisted for rcpt */
#    define	 RCPT_ST_BLACK	    0x0080  /* msg is blacklisted */
#    define	 RCPT_ST_GREY_END   0x0100  /* end of greylist embargo */
#    define	 RCPT_ST_GREY_WHITE 0x0200  /* whitelisted for greylisting */
    char	env_to[257];		/* env_to, w/sendmail MAXNAME limit */
    char	user[257];		/* mailbox */
    DCC_SUM	env_to_sum;
    DCC_SUM	msg_sum;
    DCC_SUM	triple_sum;
    DCC_PATH	dir;			/* recipient's whitelist and logdir */
    DCC_PATH	user_log_nm;
} RCPT_ST;


/* per message state common to threaded DCC clients */
typedef struct cmn_work {
    DCC_CLNT_CTXT *dcc_ctxt;
    struct work	*wp;
    u_int	dcc_ctxt_sn;
    CMN_ACTION	action;
    u_int	xhdr_len;
    char	xhdr[sizeof(DCC_XHDR_START)+sizeof(DCC_BRAND)+1];
    char	clnt_name[MAXHOSTNAMELEN+1];	/* SMTP client */
    char	clnt_str[INET6_ADDRSTRLEN+1];
    struct in6_addr clnt_addr;
    char	helo[DCC_HELO_MAX];
    DCC_EMSG	emsg;
    DCC_PATH	log_nm;			/* log file for this message */
    int		num_rcpts;
#    define	 MAX_RCPTS 1024
    RCPT_ST	*rcpt_st, *rcpt_st_last;
    off_t	log_pos_to_first;	/* first env_To line in log file */
    off_t	log_pos_to_end;		/* end of env_To lines in log file */
    off_t	log_pos_white_first;	/* first white-list result */
    off_t	log_pos_white_last;	/* last white-list result */
    int		log_fd;			/* -1=none */
    int		log_fd2;		/* -1=none -2=stop trying */
    DCC_HEADER_BUF header;
#define CMN_WORK_ZERO tgts		/* here down cleared for each msg */
    DCC_TGTS	tgts, white_tgts, reject_tgts, deliver_tgts;
    DCC_TGTS	early_grey_tgts;	/* report to DCC if embargoed */
    DCC_TGTS	late_grey_tgts;		/* don't report to DCC if delivered */
#if MAX_LOG_SIZE > 0
    int		log_size;
#endif
    DCC_GOT_CKS	cks;
    DCC_CKS_WTGTS wtgts;
    u_int	rcpt_st_flags;		/* common values for rcpt_st->flags */
    u_char	grey_predict;
    u_int	honor;			/* DCC_HONOR_SRVR_ISSPAM etc. */
} CMN_WORK;


extern u_char grey_on;
extern u_char grey_query_only;

extern u_int dcc_ctxt_sn;		/* change X-DCC header server name */

extern RCPT_ST *rcpt_st_free;

extern u_char dcc_query_only;
extern u_char try_extra_hard;		/* 1=don't quit if DCC server dead */
extern u_char to_white_only;
extern const char *mapfile_nm;
extern const char *main_white_nm;

extern void lock_work(void);
extern void unlock_work(void);
extern void cmn_init(DCC_EMSG);
extern void cmn_create(CMN_WORK *);
extern void cmn_clear(CMN_WORK *, struct work *);
extern void rcpts_create(int);
extern void rcpts_free(CMN_WORK *, u_char);
extern RCPT_ST *rcpt_st_alloc(CMN_WORK *, u_char);
extern u_char log_start(CMN_WORK *);
extern void log_stop(CMN_WORK *);
extern void log_write(CMN_WORK *, const void *, u_int);
#define LOG_CMN_CAPTION(cwp, s) log_write(cwp, s, sizeof(s)-1)
#define LOG_CMN_EOL(cwp) LOG_CMN_CAPTION(cwp, "\n")
#define LOG_CAPTION(wp, s) LOG_CMN_CAPTION(&(wp)->cw, s)
#define LOG_EOL(wp) LOG_CAPTION(wp, "\n")
extern void log_print(CMN_WORK *, const char *, ...) PATTRIB(2,3);
extern off_t log_lseek(CMN_WORK *, int);
extern void cmn_error_msg(CMN_WORK *, const char *, ...) PATTRIB(2,3);
extern void cmn_trace_msg(CMN_WORK *, const char *, ...) PATTRIB(2,3);
extern u_char ck_dcc_ctxt(CMN_WORK *);
extern u_char ask_grey_predict(CMN_WORK *, RCPT_ST *, u_char);
extern void cmn_ask_white(CMN_WORK *, u_char);
extern int cmn_ask_dcc(CMN_WORK *, u_char);
#define USER_LOG_CAPTION(rcpt_st, s) user_log_write((rcpt_st), (s), sizeof(s)-1)
#define USER_LOG_EOL(rcpt_st) USER_LOG_CAPTION((rcpt_st), "\n")
extern u_char user_log_write(RCPT_ST *, const void *, u_int);
extern void users_process(CMN_WORK *);

/* in the threaded client such as dccifd.c or dccm.c */
extern void user_reject(CMN_WORK *, RCPT_ST *, u_char);


#endif /* CLNT_DEFS_H */
