/* Distributed Checksum Clearinghouse
 *
 * Copyright (c) 2004 by Rhyolite Software
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.2.66-1.9 $Revision$
 */

#include "srvr_defs.h"
#include "dcc_xhdr.h"


/* this is not thread safe */
char *
dcc_srvr_id2str(char *buf, u_int buf_len, DCC_SRVR_ID id_auth)
{
	switch (id_auth) {
	case DCC_ID_INVALID:
		snprintf(buf, buf_len, DCC_XHDR_ID_INVALID);
		break;
	case DCC_ID_WHITE:
		*buf = '\0';
		break;
	case DCC_ID_COMP:
		snprintf(buf, buf_len, "%s", DCC_XHDR_ID_COMP);
		break;
	default:
		if (id_auth & DCC_SRVR_ID_AUTH)
			snprintf(buf, buf_len, "auth %d",
				 id_auth & ~DCC_SRVR_ID_AUTH);
		else
			snprintf(buf, buf_len, "%d",
				 id_auth & ~DCC_SRVR_ID_AUTH);
	}
	return buf;
}
