/* Distributed Checksum Clearinghouse
 *
 * Copyright (c) 2004 by Rhyolite Software
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.2.66-1.15 $Revision$
 */

#include "dcc_defs.h"
#include "dcc_xhdr.h"

char *
dcc_type2str(char *buf, u_int buf_len,	/* put it here */
	     DCC_CK_TYPES type,		/* this type */
	     const char *sub_str,	/* sub-type for DCC_CK_SUB */
	     u_char is_db)		/* 1=database or 0=whitelist */
{
#define PCK(t) case DCC_CK_##t:					\
	STRLIMCPY(buf,buf_len,DCC_XHDR_TYPE_##t);		\
	return buf;
#define PCK2(sw,t1,t2) case DCC_CK_##t1:			\
	if (!sw)						\
		STRLIMCPY(buf,buf_len,DCC_XHDR_TYPE_##t1);	\
	else							\
		STRLIMCPY(buf,buf_len,DCC_XHDR_TYPE_##t2);	\
	return buf;

	switch (type) {
	PCK(IP)
	PCK(ENV_FROM)
	PCK(FROM)
	PCK(MESSAGE_ID)
	PCK(RECEIVED)
	PCK(BODY)
	PCK(FUZ1)
	PCK(FUZ2)
	PCK(GREY_MSG)
	PCK(GREY_TRIPLE)
	PCK(SRVR_ID)
	PCK2(is_db, ENV_TO, FLOD_PATH)
	case DCC_CK_SUB:
		if (sub_str)
			snprintf(buf, buf_len, DCC_XHDR_TYPE_SUB" %s",
				 sub_str);
		else
			snprintf(buf, buf_len, DCC_XHDR_TYPE_SUB);
		return buf;
	case DCC_CK_INVALID:
		break;
	}

	snprintf(buf, buf_len, "unknown %d", type);
	return buf;
#undef PCK
#undef PCK2
}



/* use sparingly for error messages since it is not thread safe */
const char *
dcc_type2str_err(DCC_CK_TYPES type,	/* type to convert to a string */
		 const char *sub_str,	/* sub-type for DCC_CK_SUB */
		 u_char is_db)		/* 1=database or 0=whitelist */
{
	static int bufno;
	static struct {
	    char    str[DCC_XHDR_MAX_TYPE_LEN+1];
	} bufs[4];
	char *s;

	s = bufs[bufno].str;
	bufno = (bufno+1) % DIM(bufs);

	return dcc_type2str(s, sizeof(bufs[0].str),
			    type, sub_str, is_db);
}
