/* Distributed Checksum Clearinghouse
 *
 * test dccifd via dccif()
 *
 * Copyright (c) 2004 by Rhyolite Software
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.2.66-1.6 $Revision$
 */

#include "dccif.h"
#include "dcc_clnt.h"
#include "dcc_paths.h"
#include <arpa/inet.h>

static void
usage(void)
{
	dcc_logbad(EX_USAGE,
		   "usage: [-P] [-h homedir | hostname,port] [-o opts]\n"
		   "    [-c clnt-name] [-l heLo]"
		   " [-f env_from] [-I ifile] [-O ofile]\n"
		   "    [-r rcpt1[,user1]] [-r rcpt2[,user2] [...]\n",
		   stderr);
}



int NRATTRIB
main(int argc, char **argv)
{
	DCC_EMSG emsg;
	const char *homedir;
	const char *opts;
	const struct hostent *hp;
	DCC_SOCKU su, *sup;
	const char *clnt_nm;
	const char *helo;
	const char *env_from;
	DCCIF_RCPT *rcpts, *rcpt;
	int in_body_fd, out_body_fd;
	u_char dccproc;
	char received_buf[4097];
	char received_buf2[sizeof(received_buf)];
	char *received_buf_p;
	u_char result;
	char *p, *p1, *p2;
	int i, error;

	homedir = 0;
	opts = 0;
	sup = 0;
	clnt_nm = 0;
	dccproc = 0;
	helo = 0;
	env_from = 0;
	in_body_fd = 0;
	out_body_fd = dup(1);
	rcpts = 0;

	dcc_syslog_init(0, argv[0], 0);

	while (EOF != (i = getopt(argc, argv, "Ph:o:c:l:f:I:O:r:"))) {
		switch (i) {
		case 'P':
			dccproc = 1;
			dcc_no_syslog = 1;
			break;

		case 'h':
			homedir = optarg;
			break;

		case 'o':
			/* convert commas that users like to type to blanks */
			while ((p = strchr(optarg, ',')) != 0)
				*p = ' ';
			opts = optarg;
			break;

		case 'c':
			clnt_nm = optarg;
			dcc_host_lock();
			hp = dcc_get_host(clnt_nm, 2, &error);
			if (!hp) {
				dcc_logbad(EX_USAGE,
					   "dcc_get_host(%s): %s\n", clnt_nm,
					   hstrerror(error));
			}
			dcc_host_unlock();
			dcc_mk_su(&su, hp->h_addrtype, hp->h_addr, 0);
			sup = &su;
			break;

		case 'l':
			helo = optarg;
			break;

		case 'f':
			env_from = optarg;
			break;

		case 'I':
			close(in_body_fd);
			in_body_fd = open(optarg, O_RDONLY, 0);
			if (in_body_fd < 0) {
				dcc_logbad(EX_IOERR, "open(%s): %s\n",
					optarg, strerror(errno));
				exit(1);
			}
			break;

		case 'O':
			close(out_body_fd);
			out_body_fd = open(optarg, O_WRONLY, 0666);
			if (out_body_fd < 0) {
				fprintf(stderr, "open(%s): %s\n",
					optarg, strerror(errno));
				exit(1);
			}
			break;

		case 'r':
			rcpt = malloc(sizeof(*rcpt));
			memset(rcpt, 0, sizeof(*rcpt));
			rcpt->next = rcpts;
			rcpt->addr = optarg;
			p = strchr(optarg, ',');
			if (!p) {
				rcpt->user = "";
			} else {
				*p++ = '\0';
				rcpt->user = p;
			}
			rcpt->ok = '?';
			rcpts = rcpt;
			break;

		default:
			usage();
			break;
		}
	}
	argc -= optind;
	argv += optind;
	if (argc != 0)
		usage();

	/* look for the first Received: line in the first 4 KBytes
	 * to obtain the HELO name, the SMTP client IP address, and
	 * the envelope Mail_From, and Rcpt_To values. */
	if (!dccproc) {
		received_buf_p = 0;
	} else {
		i = read(in_body_fd, received_buf, sizeof(received_buf)-1);
		if (i < 0)
			dcc_logbad(EX_IOERR, "read(input): %s",
				   ERROR_STR());
		received_buf[i] = '\0';
		received_buf_p = received_buf2;
		memcpy(received_buf_p, received_buf, i+1);

		/* this could be generalized to parse other styles of
		 * Received: headers */
		p = strstr(received_buf, "Received: ");
		if (!p)
			p = &received_buf[i];
		else
			p += STRZ("Received: ");

		/* look for HELO */
		if (strncmp(p, "from ", STRZ("from "))
		    || (p1 = strstr(p, " (")) == 0) {
			p = &received_buf[i];
		} else {
			if (!helo)
				helo = p+STRZ("from ");
			*p1++ = '\0';
			p = p1+1;
		}

		/* get IP address */
		p1 = strchr(p, ' ');
		if (!p1)
			p1 = &received_buf[i];
		p2 = strchr(p1, ']');
		if (strncmp(p1, " [", 2) || !p2) {
			p = &received_buf[i];
		} else {
			*p2++ = '\0';
			if (!clnt_nm) {
				clnt_nm = p;
				*p1 = '\0';
				dcc_host_lock();
				hp = dcc_get_host(p1+2, 2, &error);
				if (!hp) {
					dcc_logbad(EX_USAGE,
						   "dcc_get_host(%s): %s\n",
						   p1+2,
						   hstrerror(error));
				}
				dcc_host_unlock();
				dcc_mk_su(&su, hp->h_addrtype, hp->h_addr, 0);
				sup = &su;
			}
			p = p2;
		}

		/* get Rcpt_To and Mail_From values */
		p1 = strstr(p, "for <");
		p2 = p1 ? strstr(p, "> env-from <") : 0;
		if (p2) {
			*p2 = '\0';
			p2 += STRZ("> env-from <");
			if (!env_from) {
				p = strchr(p2, '>');
				if (p) {
					*p = '\0';
					env_from = p2;
				}
			}
			rcpt = malloc(sizeof(*rcpt));
			memset(rcpt, 0, sizeof(*rcpt));
			rcpt->next = rcpts;
			rcpt->addr = p1 + STRZ("for <");
			rcpt->user = "";
			rcpt->ok = '?';
			rcpts = rcpt;
		}
	}

	result = dccif(emsg,
		       out_body_fd, 0,
		       opts, sup, clnt_nm, helo, env_from,
		       rcpts,
		       in_body_fd, received_buf_p,
		       homedir);

	if (!dccproc) {
		if (!result) {
			printf("result 0: %s\n", emsg);
			exit(0);
		}
		printf("overall result = %c\n", result);
		for (rcpt = rcpts; rcpt; rcpt = rcpt->next) {
			printf("    %s %s: %c\n",
			       rcpt->addr, rcpt->user, rcpt->ok);
		}
		putchar('\n');
	}
	exit(0);
}
