
#include "DBHostConfig.hh"
#include "DBBalancerTxtConfig.hh"

int main() {

  ACE_LOG_MSG->enable_debug_messages();      

  cout << "Vamos a construir la instancia de (DBBalancerConfig) DBBalancerTxtConfig. " << endl;
  DBBalancerConfig *dbc = new DBBalancerTxtConfig("../tests/config_examples/LoadBalancerExample.conf");


  cout << "==============================================" << endl;
  cout << "El puerto READER es " << dbc->getDaemonReaderPort() << endl;
  cout << "El puerto WRITER es " << dbc->getDaemonWriterPort() << endl;
  cout << "INIT_THREADS es " << dbc->getDaemonInitThreads() << endl;
  cout << "MIN_THREADS es " << dbc->getDaemonMinThreads() << endl;
  cout << "MAX_THREADS es " << dbc->getDaemonMaxThreads() << endl;
  cout << "INIT_DB_CONNS es " << dbc->getInitDbConnections() << endl;
  cout << "MIN_DB_CONNS es " << dbc->getMinDbConnections() << endl;
  cout << "MAX_DB_CONNS es " << dbc->getMaxDbConnections() << endl;
 
  vector<DBHostConfig *> hosts = dbc->getHosts();

  cout << "Hay " << hosts.size() << " mquinas " << endl;
  for (int i=0;i<hosts.size();i++) {
    cout << "\t ****** " << endl;
    cout << "\t HOST es " << hosts[i]->getName() << endl;
    cout << "\t DB es " << hosts[i]->getDbName() << endl;
    cout << "\t ****** " << endl;
    
    

  }


 
  delete dbc;


}
