/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using Db4oUnit;
using Db4oUnit.Fixtures;

namespace Db4oUnit.Fixtures
{
	internal sealed class FixtureDecorator : ITestDecorator
	{
		private readonly object _fixture;

		private readonly FixtureVariable _provider;

		private readonly int _fixtureIndex;

		internal FixtureDecorator(FixtureVariable provider, object fixture, int fixtureIndex
			)
		{
			_fixture = fixture;
			_provider = provider;
			_fixtureIndex = fixtureIndex;
		}

		public ITest Decorate(ITest test)
		{
			string label = _provider.Label + "[" + _fixtureIndex + "]";
			if (_fixture is ILabeled)
			{
				label += ":" + ((ILabeled)_fixture).Label();
			}
			return new FixtureDecoration(test, label, _provider, _fixture);
		}
	}
}
